# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLocalPeeringGatewaysResult',
    'AwaitableGetLocalPeeringGatewaysResult',
    'get_local_peering_gateways',
    'get_local_peering_gateways_output',
]

@pulumi.output_type
class GetLocalPeeringGatewaysResult:
    """
    A collection of values returned by getLocalPeeringGateways.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, local_peering_gateways=None, vcn_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_peering_gateways and not isinstance(local_peering_gateways, list):
            raise TypeError("Expected argument 'local_peering_gateways' to be a list")
        pulumi.set(__self__, "local_peering_gateways", local_peering_gateways)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the LPG.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLocalPeeringGatewaysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localPeeringGateways")
    def local_peering_gateways(self) -> Sequence['outputs.GetLocalPeeringGatewaysLocalPeeringGatewayResult']:
        """
        The list of local_peering_gateways.
        """
        return pulumi.get(self, "local_peering_gateways")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN that uses the LPG.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetLocalPeeringGatewaysResult(GetLocalPeeringGatewaysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocalPeeringGatewaysResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            local_peering_gateways=self.local_peering_gateways,
            vcn_id=self.vcn_id)


def get_local_peering_gateways(compartment_id: Optional[builtins.str] = None,
                               filters: Optional[Sequence[Union['GetLocalPeeringGatewaysFilterArgs', 'GetLocalPeeringGatewaysFilterArgsDict']]] = None,
                               vcn_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocalPeeringGatewaysResult:
    """
    This data source provides the list of Local Peering Gateways in Oracle Cloud Infrastructure Core service.

    Lists the local peering gateways (LPGs) for the specified VCN and specified compartment.
    If the VCN ID is not provided, then the list includes the LPGs from all VCNs in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_local_peering_gateways = oci.Core.get_local_peering_gateways(compartment_id=compartment_id,
        vcn_id=test_vcn["id"])
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getLocalPeeringGateways:getLocalPeeringGateways', __args__, opts=opts, typ=GetLocalPeeringGatewaysResult).value

    return AwaitableGetLocalPeeringGatewaysResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        local_peering_gateways=pulumi.get(__ret__, 'local_peering_gateways'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))
def get_local_peering_gateways_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLocalPeeringGatewaysFilterArgs', 'GetLocalPeeringGatewaysFilterArgsDict']]]]] = None,
                                      vcn_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocalPeeringGatewaysResult]:
    """
    This data source provides the list of Local Peering Gateways in Oracle Cloud Infrastructure Core service.

    Lists the local peering gateways (LPGs) for the specified VCN and specified compartment.
    If the VCN ID is not provided, then the list includes the LPGs from all VCNs in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_local_peering_gateways = oci.Core.get_local_peering_gateways(compartment_id=compartment_id,
        vcn_id=test_vcn["id"])
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getLocalPeeringGateways:getLocalPeeringGateways', __args__, opts=opts, typ=GetLocalPeeringGatewaysResult)
    return __ret__.apply(lambda __response__: GetLocalPeeringGatewaysResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        local_peering_gateways=pulumi.get(__response__, 'local_peering_gateways'),
        vcn_id=pulumi.get(__response__, 'vcn_id')))
