# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVolumeGroupReplicaResult',
    'AwaitableGetVolumeGroupReplicaResult',
    'get_volume_group_replica',
    'get_volume_group_replica_output',
]

@pulumi.output_type
class GetVolumeGroupReplicaResult:
    """
    A collection of values returned by getVolumeGroupReplica.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, member_replicas=None, size_in_gbs=None, state=None, time_created=None, time_last_synced=None, volume_group_id=None, volume_group_replica_id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if member_replicas and not isinstance(member_replicas, list):
            raise TypeError("Expected argument 'member_replicas' to be a list")
        pulumi.set(__self__, "member_replicas", member_replicas)
        if size_in_gbs and not isinstance(size_in_gbs, str):
            raise TypeError("Expected argument 'size_in_gbs' to be a str")
        pulumi.set(__self__, "size_in_gbs", size_in_gbs)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_synced and not isinstance(time_last_synced, str):
            raise TypeError("Expected argument 'time_last_synced' to be a str")
        pulumi.set(__self__, "time_last_synced", time_last_synced)
        if volume_group_id and not isinstance(volume_group_id, str):
            raise TypeError("Expected argument 'volume_group_id' to be a str")
        pulumi.set(__self__, "volume_group_id", volume_group_id)
        if volume_group_replica_id and not isinstance(volume_group_replica_id, str):
            raise TypeError("Expected argument 'volume_group_replica_id' to be a str")
        pulumi.set(__self__, "volume_group_replica_id", volume_group_replica_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The availability domain of the volume group replica.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the volume group replica.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="memberReplicas")
    def member_replicas(self) -> Sequence['outputs.GetVolumeGroupReplicaMemberReplicaResult']:
        """
        Volume replicas within this volume group replica.
        """
        return pulumi.get(self, "member_replicas")

    @property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> builtins.str:
        """
        The aggregate size of the volume group replica in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of a volume group.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the volume group replica was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastSynced")
    def time_last_synced(self) -> builtins.str:
        """
        The date and time the volume group replica was last synced from the source volume group. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_last_synced")

    @property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> builtins.str:
        """
        The OCID of the source volume group.
        """
        return pulumi.get(self, "volume_group_id")

    @property
    @pulumi.getter(name="volumeGroupReplicaId")
    def volume_group_replica_id(self) -> builtins.str:
        return pulumi.get(self, "volume_group_replica_id")


class AwaitableGetVolumeGroupReplicaResult(GetVolumeGroupReplicaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeGroupReplicaResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            member_replicas=self.member_replicas,
            size_in_gbs=self.size_in_gbs,
            state=self.state,
            time_created=self.time_created,
            time_last_synced=self.time_last_synced,
            volume_group_id=self.volume_group_id,
            volume_group_replica_id=self.volume_group_replica_id)


def get_volume_group_replica(volume_group_replica_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeGroupReplicaResult:
    """
    This data source provides details about a specific Volume Group Replica resource in Oracle Cloud Infrastructure Core service.

    Gets information for the specified volume group replica.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_group_replica = oci.Core.get_volume_group_replica(volume_group_replica_id=test_volume_group_replica_oci_core_volume_group_replica["id"])
    ```


    :param builtins.str volume_group_replica_id: The OCID of the volume replica group.
    """
    __args__ = dict()
    __args__['volumeGroupReplicaId'] = volume_group_replica_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVolumeGroupReplica:getVolumeGroupReplica', __args__, opts=opts, typ=GetVolumeGroupReplicaResult).value

    return AwaitableGetVolumeGroupReplicaResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        member_replicas=pulumi.get(__ret__, 'member_replicas'),
        size_in_gbs=pulumi.get(__ret__, 'size_in_gbs'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_synced=pulumi.get(__ret__, 'time_last_synced'),
        volume_group_id=pulumi.get(__ret__, 'volume_group_id'),
        volume_group_replica_id=pulumi.get(__ret__, 'volume_group_replica_id'))
def get_volume_group_replica_output(volume_group_replica_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeGroupReplicaResult]:
    """
    This data source provides details about a specific Volume Group Replica resource in Oracle Cloud Infrastructure Core service.

    Gets information for the specified volume group replica.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_group_replica = oci.Core.get_volume_group_replica(volume_group_replica_id=test_volume_group_replica_oci_core_volume_group_replica["id"])
    ```


    :param builtins.str volume_group_replica_id: The OCID of the volume replica group.
    """
    __args__ = dict()
    __args__['volumeGroupReplicaId'] = volume_group_replica_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getVolumeGroupReplica:getVolumeGroupReplica', __args__, opts=opts, typ=GetVolumeGroupReplicaResult)
    return __ret__.apply(lambda __response__: GetVolumeGroupReplicaResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        member_replicas=pulumi.get(__response__, 'member_replicas'),
        size_in_gbs=pulumi.get(__response__, 'size_in_gbs'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_synced=pulumi.get(__response__, 'time_last_synced'),
        volume_group_id=pulumi.get(__response__, 'volume_group_id'),
        volume_group_replica_id=pulumi.get(__response__, 'volume_group_replica_id')))
