# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DatabaseSoftwareImageArgs', 'DatabaseSoftwareImage']

@pulumi.input_type
class DatabaseSoftwareImageArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 database_software_image_one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 database_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image_shape_family: Optional[pulumi.Input[builtins.str]] = None,
                 image_type: Optional[pulumi.Input[builtins.str]] = None,
                 ls_inventory: Optional[pulumi.Input[builtins.str]] = None,
                 patch_set: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_home_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseSoftwareImage resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the database software image  belongs in.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the database software image. The name does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] database_software_image_one_off_patches: List of one-off patches for Database Homes.
        :param pulumi.Input[builtins.str] database_version: The database version with which the database software image is to be built.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] image_shape_family: To what shape the image is meant for.
        :param pulumi.Input[builtins.str] image_type: The type of software image. Can be grid or database.
        :param pulumi.Input[builtins.str] ls_inventory: The output from the OPatch lsInventory command, which is passed as a string.
        :param pulumi.Input[builtins.str] patch_set: The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[builtins.str] source_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        if database_software_image_one_off_patches is not None:
            pulumi.set(__self__, "database_software_image_one_off_patches", database_software_image_one_off_patches)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image_shape_family is not None:
            pulumi.set(__self__, "image_shape_family", image_shape_family)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if ls_inventory is not None:
            pulumi.set(__self__, "ls_inventory", ls_inventory)
        if patch_set is not None:
            pulumi.set(__self__, "patch_set", patch_set)
        if source_db_home_id is not None:
            pulumi.set(__self__, "source_db_home_id", source_db_home_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the database software image  belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The user-friendly name for the database software image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="databaseSoftwareImageOneOffPatches")
    def database_software_image_one_off_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "database_software_image_one_off_patches")

    @database_software_image_one_off_patches.setter
    def database_software_image_one_off_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "database_software_image_one_off_patches", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database version with which the database software image is to be built.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @image_shape_family.setter
    def image_shape_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_shape_family", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of software image. Can be grid or database.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="lsInventory")
    def ls_inventory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The output from the OPatch lsInventory command, which is passed as a string.
        """
        return pulumi.get(self, "ls_inventory")

    @ls_inventory.setter
    def ls_inventory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ls_inventory", value)

    @property
    @pulumi.getter(name="patchSet")
    def patch_set(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "patch_set")

    @patch_set.setter
    def patch_set(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "patch_set", value)

    @property
    @pulumi.getter(name="sourceDbHomeId")
    def source_db_home_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_db_home_id")

    @source_db_home_id.setter
    def source_db_home_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_db_home_id", value)


@pulumi.input_type
class _DatabaseSoftwareImageState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_software_image_included_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 database_software_image_one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 database_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image_shape_family: Optional[pulumi.Input[builtins.str]] = None,
                 image_type: Optional[pulumi.Input[builtins.str]] = None,
                 included_patches_summary: Optional[pulumi.Input[builtins.str]] = None,
                 is_upgrade_supported: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 ls_inventory: Optional[pulumi.Input[builtins.str]] = None,
                 patch_set: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_home_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseSoftwareImage resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the database software image  belongs in.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] database_software_image_included_patches: List of one-off patches for Database Homes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] database_software_image_one_off_patches: List of one-off patches for Database Homes.
        :param pulumi.Input[builtins.str] database_version: The database version with which the database software image is to be built.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the database software image. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] image_shape_family: To what shape the image is meant for.
        :param pulumi.Input[builtins.str] image_type: The type of software image. Can be grid or database.
        :param pulumi.Input[builtins.str] included_patches_summary: The patches included in the image and the version of the image.
        :param pulumi.Input[builtins.bool] is_upgrade_supported: True if this Database software image is supported for Upgrade.
        :param pulumi.Input[builtins.str] lifecycle_details: Detailed message for the lifecycle state.
        :param pulumi.Input[builtins.str] ls_inventory: The output from the OPatch lsInventory command, which is passed as a string.
        :param pulumi.Input[builtins.str] patch_set: The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[builtins.str] source_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the database software image.
        :param pulumi.Input[builtins.str] time_created: The date and time the database software image was created.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if database_software_image_included_patches is not None:
            pulumi.set(__self__, "database_software_image_included_patches", database_software_image_included_patches)
        if database_software_image_one_off_patches is not None:
            pulumi.set(__self__, "database_software_image_one_off_patches", database_software_image_one_off_patches)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image_shape_family is not None:
            pulumi.set(__self__, "image_shape_family", image_shape_family)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if included_patches_summary is not None:
            pulumi.set(__self__, "included_patches_summary", included_patches_summary)
        if is_upgrade_supported is not None:
            pulumi.set(__self__, "is_upgrade_supported", is_upgrade_supported)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if ls_inventory is not None:
            pulumi.set(__self__, "ls_inventory", ls_inventory)
        if patch_set is not None:
            pulumi.set(__self__, "patch_set", patch_set)
        if source_db_home_id is not None:
            pulumi.set(__self__, "source_db_home_id", source_db_home_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the database software image  belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseSoftwareImageIncludedPatches")
    def database_software_image_included_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "database_software_image_included_patches")

    @database_software_image_included_patches.setter
    def database_software_image_included_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "database_software_image_included_patches", value)

    @property
    @pulumi.getter(name="databaseSoftwareImageOneOffPatches")
    def database_software_image_one_off_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "database_software_image_one_off_patches")

    @database_software_image_one_off_patches.setter
    def database_software_image_one_off_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "database_software_image_one_off_patches", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database version with which the database software image is to be built.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The user-friendly name for the database software image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @image_shape_family.setter
    def image_shape_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_shape_family", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of software image. Can be grid or database.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="includedPatchesSummary")
    def included_patches_summary(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The patches included in the image and the version of the image.
        """
        return pulumi.get(self, "included_patches_summary")

    @included_patches_summary.setter
    def included_patches_summary(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "included_patches_summary", value)

    @property
    @pulumi.getter(name="isUpgradeSupported")
    def is_upgrade_supported(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        True if this Database software image is supported for Upgrade.
        """
        return pulumi.get(self, "is_upgrade_supported")

    @is_upgrade_supported.setter
    def is_upgrade_supported(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_upgrade_supported", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="lsInventory")
    def ls_inventory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The output from the OPatch lsInventory command, which is passed as a string.
        """
        return pulumi.get(self, "ls_inventory")

    @ls_inventory.setter
    def ls_inventory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ls_inventory", value)

    @property
    @pulumi.getter(name="patchSet")
    def patch_set(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "patch_set")

    @patch_set.setter
    def patch_set(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "patch_set", value)

    @property
    @pulumi.getter(name="sourceDbHomeId")
    def source_db_home_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_db_home_id")

    @source_db_home_id.setter
    def source_db_home_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_db_home_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the database software image.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the database software image was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


class DatabaseSoftwareImage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_software_image_one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 database_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image_shape_family: Optional[pulumi.Input[builtins.str]] = None,
                 image_type: Optional[pulumi.Input[builtins.str]] = None,
                 ls_inventory: Optional[pulumi.Input[builtins.str]] = None,
                 patch_set: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_home_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Database Software Image resource in Oracle Cloud Infrastructure Database service.

        create database software image in the specified compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_database_software_image = oci.database.DatabaseSoftwareImage("test_database_software_image",
            compartment_id=compartment_id,
            display_name=database_software_image_display_name,
            database_software_image_one_off_patches=database_software_image_database_software_image_one_off_patches,
            database_version=database_software_image_database_version,
            defined_tags=database_software_image_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            image_shape_family=database_software_image_image_shape_family,
            image_type=database_software_image_image_type,
            ls_inventory=database_software_image_ls_inventory,
            patch_set=database_software_image_patch_set,
            source_db_home_id=test_db_home["id"])
        ```

        ## Import

        DatabaseSoftwareImages can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/databaseSoftwareImage:DatabaseSoftwareImage test_database_software_image "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the database software image  belongs in.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] database_software_image_one_off_patches: List of one-off patches for Database Homes.
        :param pulumi.Input[builtins.str] database_version: The database version with which the database software image is to be built.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the database software image. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] image_shape_family: To what shape the image is meant for.
        :param pulumi.Input[builtins.str] image_type: The type of software image. Can be grid or database.
        :param pulumi.Input[builtins.str] ls_inventory: The output from the OPatch lsInventory command, which is passed as a string.
        :param pulumi.Input[builtins.str] patch_set: The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[builtins.str] source_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseSoftwareImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Database Software Image resource in Oracle Cloud Infrastructure Database service.

        create database software image in the specified compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_database_software_image = oci.database.DatabaseSoftwareImage("test_database_software_image",
            compartment_id=compartment_id,
            display_name=database_software_image_display_name,
            database_software_image_one_off_patches=database_software_image_database_software_image_one_off_patches,
            database_version=database_software_image_database_version,
            defined_tags=database_software_image_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            image_shape_family=database_software_image_image_shape_family,
            image_type=database_software_image_image_type,
            ls_inventory=database_software_image_ls_inventory,
            patch_set=database_software_image_patch_set,
            source_db_home_id=test_db_home["id"])
        ```

        ## Import

        DatabaseSoftwareImages can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/databaseSoftwareImage:DatabaseSoftwareImage test_database_software_image "id"
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseSoftwareImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseSoftwareImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_software_image_one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 database_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image_shape_family: Optional[pulumi.Input[builtins.str]] = None,
                 image_type: Optional[pulumi.Input[builtins.str]] = None,
                 ls_inventory: Optional[pulumi.Input[builtins.str]] = None,
                 patch_set: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_home_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseSoftwareImageArgs.__new__(DatabaseSoftwareImageArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["database_software_image_one_off_patches"] = database_software_image_one_off_patches
            __props__.__dict__["database_version"] = database_version
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["image_shape_family"] = image_shape_family
            __props__.__dict__["image_type"] = image_type
            __props__.__dict__["ls_inventory"] = ls_inventory
            __props__.__dict__["patch_set"] = patch_set
            __props__.__dict__["source_db_home_id"] = source_db_home_id
            __props__.__dict__["database_software_image_included_patches"] = None
            __props__.__dict__["included_patches_summary"] = None
            __props__.__dict__["is_upgrade_supported"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(DatabaseSoftwareImage, __self__).__init__(
            'oci:Database/databaseSoftwareImage:DatabaseSoftwareImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            database_software_image_included_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            database_software_image_one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            database_version: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            image_shape_family: Optional[pulumi.Input[builtins.str]] = None,
            image_type: Optional[pulumi.Input[builtins.str]] = None,
            included_patches_summary: Optional[pulumi.Input[builtins.str]] = None,
            is_upgrade_supported: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            ls_inventory: Optional[pulumi.Input[builtins.str]] = None,
            patch_set: Optional[pulumi.Input[builtins.str]] = None,
            source_db_home_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'DatabaseSoftwareImage':
        """
        Get an existing DatabaseSoftwareImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the database software image  belongs in.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] database_software_image_included_patches: List of one-off patches for Database Homes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] database_software_image_one_off_patches: List of one-off patches for Database Homes.
        :param pulumi.Input[builtins.str] database_version: The database version with which the database software image is to be built.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the database software image. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] image_shape_family: To what shape the image is meant for.
        :param pulumi.Input[builtins.str] image_type: The type of software image. Can be grid or database.
        :param pulumi.Input[builtins.str] included_patches_summary: The patches included in the image and the version of the image.
        :param pulumi.Input[builtins.bool] is_upgrade_supported: True if this Database software image is supported for Upgrade.
        :param pulumi.Input[builtins.str] lifecycle_details: Detailed message for the lifecycle state.
        :param pulumi.Input[builtins.str] ls_inventory: The output from the OPatch lsInventory command, which is passed as a string.
        :param pulumi.Input[builtins.str] patch_set: The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[builtins.str] source_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the database software image.
        :param pulumi.Input[builtins.str] time_created: The date and time the database software image was created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseSoftwareImageState.__new__(_DatabaseSoftwareImageState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database_software_image_included_patches"] = database_software_image_included_patches
        __props__.__dict__["database_software_image_one_off_patches"] = database_software_image_one_off_patches
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["image_shape_family"] = image_shape_family
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["included_patches_summary"] = included_patches_summary
        __props__.__dict__["is_upgrade_supported"] = is_upgrade_supported
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["ls_inventory"] = ls_inventory
        __props__.__dict__["patch_set"] = patch_set
        __props__.__dict__["source_db_home_id"] = source_db_home_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return DatabaseSoftwareImage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the database software image  belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseSoftwareImageIncludedPatches")
    def database_software_image_included_patches(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "database_software_image_included_patches")

    @property
    @pulumi.getter(name="databaseSoftwareImageOneOffPatches")
    def database_software_image_one_off_patches(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "database_software_image_one_off_patches")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[builtins.str]:
        """
        The database version with which the database software image is to be built.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The user-friendly name for the database software image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> pulumi.Output[builtins.str]:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of software image. Can be grid or database.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="includedPatchesSummary")
    def included_patches_summary(self) -> pulumi.Output[builtins.str]:
        """
        The patches included in the image and the version of the image.
        """
        return pulumi.get(self, "included_patches_summary")

    @property
    @pulumi.getter(name="isUpgradeSupported")
    def is_upgrade_supported(self) -> pulumi.Output[builtins.bool]:
        """
        True if this Database software image is supported for Upgrade.
        """
        return pulumi.get(self, "is_upgrade_supported")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lsInventory")
    def ls_inventory(self) -> pulumi.Output[builtins.str]:
        """
        The output from the OPatch lsInventory command, which is passed as a string.
        """
        return pulumi.get(self, "ls_inventory")

    @property
    @pulumi.getter(name="patchSet")
    def patch_set(self) -> pulumi.Output[builtins.str]:
        """
        The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "patch_set")

    @property
    @pulumi.getter(name="sourceDbHomeId")
    def source_db_home_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_db_home_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the database software image.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the database software image was created.
        """
        return pulumi.get(self, "time_created")

