# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutonomousExadataInfrastructureResult',
    'AwaitableGetAutonomousExadataInfrastructureResult',
    'get_autonomous_exadata_infrastructure',
    'get_autonomous_exadata_infrastructure_output',
]

@pulumi.output_type
class GetAutonomousExadataInfrastructureResult:
    """
    A collection of values returned by getAutonomousExadataInfrastructure.
    """
    def __init__(__self__, autonomous_exadata_infrastructure_id=None, availability_domain=None, compartment_id=None, create_async=None, defined_tags=None, display_name=None, domain=None, freeform_tags=None, hostname=None, id=None, last_maintenance_run_id=None, license_model=None, lifecycle_details=None, maintenance_window_details=None, maintenance_windows=None, next_maintenance_run_id=None, nsg_ids=None, scan_dns_name=None, shape=None, state=None, subnet_id=None, time_created=None, zone_id=None):
        if autonomous_exadata_infrastructure_id and not isinstance(autonomous_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'autonomous_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "autonomous_exadata_infrastructure_id", autonomous_exadata_infrastructure_id)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if create_async and not isinstance(create_async, bool):
            raise TypeError("Expected argument 'create_async' to be a bool")
        pulumi.set(__self__, "create_async", create_async)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_maintenance_run_id and not isinstance(last_maintenance_run_id, str):
            raise TypeError("Expected argument 'last_maintenance_run_id' to be a str")
        pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_window_details and not isinstance(maintenance_window_details, list):
            raise TypeError("Expected argument 'maintenance_window_details' to be a list")
        pulumi.set(__self__, "maintenance_window_details", maintenance_window_details)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if next_maintenance_run_id and not isinstance(next_maintenance_run_id, str):
            raise TypeError("Expected argument 'next_maintenance_run_id' to be a str")
        pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if scan_dns_name and not isinstance(scan_dns_name, str):
            raise TypeError("Expected argument 'scan_dns_name' to be a str")
        pulumi.set(__self__, "scan_dns_name", scan_dns_name)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="autonomousExadataInfrastructureId")
    def autonomous_exadata_infrastructure_id(self) -> builtins.str:
        return pulumi.get(self, "autonomous_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="availabilityDomain")
    @_utilities.deprecated("""Autonomous Exadata Infrastructure resource is now end-of-life.Please provision cloud autonomous vm cluster instead.""")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain that the Autonomous Exadata Infrastructure is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> builtins.bool:
        return pulumi.get(self, "create_async")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The user-friendly name for the Autonomous Exadata Infrastructure.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        The domain name for the Autonomous Exadata Infrastructure.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        The host name for the Autonomous Exadata Infrastructure node.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the Autonomous Exadata Infrastructure.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> builtins.str:
        """
        The Oracle license model that applies to all databases in the Autonomous Exadata Infrastructure. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current lifecycle state of the Autonomous Exadata Infrastructure.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> Sequence['outputs.GetAutonomousExadataInfrastructureMaintenanceWindowDetailResult']:
        return pulumi.get(self, "maintenance_window_details")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetAutonomousExadataInfrastructureMaintenanceWindowResult']:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> builtins.str:
        """
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the Autonomous Exadata Infrastructure.
        """
        return pulumi.get(self, "scan_dns_name")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        The shape of the Autonomous Exadata Infrastructure. The shape determines resources to allocate to the Autonomous Exadata Infrastructure (CPU cores, memory and storage).
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the Autonomous Exadata Infrastructure.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of the subnet the Autonomous Exadata Infrastructure is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the Autonomous Exadata Infrastructure was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        The OCID of the zone the Autonomous Exadata Infrastructure is associated with.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetAutonomousExadataInfrastructureResult(GetAutonomousExadataInfrastructureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousExadataInfrastructureResult(
            autonomous_exadata_infrastructure_id=self.autonomous_exadata_infrastructure_id,
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            create_async=self.create_async,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            domain=self.domain,
            freeform_tags=self.freeform_tags,
            hostname=self.hostname,
            id=self.id,
            last_maintenance_run_id=self.last_maintenance_run_id,
            license_model=self.license_model,
            lifecycle_details=self.lifecycle_details,
            maintenance_window_details=self.maintenance_window_details,
            maintenance_windows=self.maintenance_windows,
            next_maintenance_run_id=self.next_maintenance_run_id,
            nsg_ids=self.nsg_ids,
            scan_dns_name=self.scan_dns_name,
            shape=self.shape,
            state=self.state,
            subnet_id=self.subnet_id,
            time_created=self.time_created,
            zone_id=self.zone_id)


def get_autonomous_exadata_infrastructure(autonomous_exadata_infrastructure_id: Optional[builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousExadataInfrastructureResult:
    """
    This data source provides details about a specific Autonomous Exadata Infrastructure resource in Oracle Cloud Infrastructure Database service.

    **Deprecated.** Use the [GetCloudExadataInfrastructure](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudExadataInfrastructure/GetCloudExadataInfrastructure) operation to get details of an Exadata Infrastructure resource and the [GetCloudAutonomousVmCluster](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudAutonomousVmCluster/GetCloudAutonomousVmCluster) operation to get details of an Autonomous Exadata VM cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_exadata_infrastructure = oci.Database.get_autonomous_exadata_infrastructure(autonomous_exadata_infrastructure_id=test_autonomous_exadata_infrastructure_oci_database_autonomous_exadata_infrastructure["id"])
    ```


    :param builtins.str autonomous_exadata_infrastructure_id: The Autonomous Exadata Infrastructure  [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousExadataInfrastructureId'] = autonomous_exadata_infrastructure_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousExadataInfrastructure:getAutonomousExadataInfrastructure', __args__, opts=opts, typ=GetAutonomousExadataInfrastructureResult).value

    return AwaitableGetAutonomousExadataInfrastructureResult(
        autonomous_exadata_infrastructure_id=pulumi.get(__ret__, 'autonomous_exadata_infrastructure_id'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        create_async=pulumi.get(__ret__, 'create_async'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        domain=pulumi.get(__ret__, 'domain'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        last_maintenance_run_id=pulumi.get(__ret__, 'last_maintenance_run_id'),
        license_model=pulumi.get(__ret__, 'license_model'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        maintenance_window_details=pulumi.get(__ret__, 'maintenance_window_details'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        next_maintenance_run_id=pulumi.get(__ret__, 'next_maintenance_run_id'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        scan_dns_name=pulumi.get(__ret__, 'scan_dns_name'),
        shape=pulumi.get(__ret__, 'shape'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_autonomous_exadata_infrastructure_output(autonomous_exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousExadataInfrastructureResult]:
    """
    This data source provides details about a specific Autonomous Exadata Infrastructure resource in Oracle Cloud Infrastructure Database service.

    **Deprecated.** Use the [GetCloudExadataInfrastructure](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudExadataInfrastructure/GetCloudExadataInfrastructure) operation to get details of an Exadata Infrastructure resource and the [GetCloudAutonomousVmCluster](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudAutonomousVmCluster/GetCloudAutonomousVmCluster) operation to get details of an Autonomous Exadata VM cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_exadata_infrastructure = oci.Database.get_autonomous_exadata_infrastructure(autonomous_exadata_infrastructure_id=test_autonomous_exadata_infrastructure_oci_database_autonomous_exadata_infrastructure["id"])
    ```


    :param builtins.str autonomous_exadata_infrastructure_id: The Autonomous Exadata Infrastructure  [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousExadataInfrastructureId'] = autonomous_exadata_infrastructure_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousExadataInfrastructure:getAutonomousExadataInfrastructure', __args__, opts=opts, typ=GetAutonomousExadataInfrastructureResult)
    return __ret__.apply(lambda __response__: GetAutonomousExadataInfrastructureResult(
        autonomous_exadata_infrastructure_id=pulumi.get(__response__, 'autonomous_exadata_infrastructure_id'),
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        create_async=pulumi.get(__response__, 'create_async'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        domain=pulumi.get(__response__, 'domain'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        last_maintenance_run_id=pulumi.get(__response__, 'last_maintenance_run_id'),
        license_model=pulumi.get(__response__, 'license_model'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        maintenance_window_details=pulumi.get(__response__, 'maintenance_window_details'),
        maintenance_windows=pulumi.get(__response__, 'maintenance_windows'),
        next_maintenance_run_id=pulumi.get(__response__, 'next_maintenance_run_id'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        scan_dns_name=pulumi.get(__response__, 'scan_dns_name'),
        shape=pulumi.get(__response__, 'shape'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        zone_id=pulumi.get(__response__, 'zone_id')))
