# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetScheduledActionResult',
    'AwaitableGetScheduledActionResult',
    'get_scheduled_action',
    'get_scheduled_action_output',
]

@pulumi.output_type
class GetScheduledActionResult:
    """
    A collection of values returned by getScheduledAction.
    """
    def __init__(__self__, action_members=None, action_order=None, action_params=None, action_type=None, compartment_id=None, defined_tags=None, display_name=None, estimated_time_in_mins=None, freeform_tags=None, id=None, scheduled_action_id=None, scheduling_plan_id=None, scheduling_window_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if action_members and not isinstance(action_members, list):
            raise TypeError("Expected argument 'action_members' to be a list")
        pulumi.set(__self__, "action_members", action_members)
        if action_order and not isinstance(action_order, int):
            raise TypeError("Expected argument 'action_order' to be a int")
        pulumi.set(__self__, "action_order", action_order)
        if action_params and not isinstance(action_params, dict):
            raise TypeError("Expected argument 'action_params' to be a dict")
        pulumi.set(__self__, "action_params", action_params)
        if action_type and not isinstance(action_type, str):
            raise TypeError("Expected argument 'action_type' to be a str")
        pulumi.set(__self__, "action_type", action_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if estimated_time_in_mins and not isinstance(estimated_time_in_mins, int):
            raise TypeError("Expected argument 'estimated_time_in_mins' to be a int")
        pulumi.set(__self__, "estimated_time_in_mins", estimated_time_in_mins)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scheduled_action_id and not isinstance(scheduled_action_id, str):
            raise TypeError("Expected argument 'scheduled_action_id' to be a str")
        pulumi.set(__self__, "scheduled_action_id", scheduled_action_id)
        if scheduling_plan_id and not isinstance(scheduling_plan_id, str):
            raise TypeError("Expected argument 'scheduling_plan_id' to be a str")
        pulumi.set(__self__, "scheduling_plan_id", scheduling_plan_id)
        if scheduling_window_id and not isinstance(scheduling_window_id, str):
            raise TypeError("Expected argument 'scheduling_window_id' to be a str")
        pulumi.set(__self__, "scheduling_window_id", scheduling_window_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="actionMembers")
    def action_members(self) -> Sequence['outputs.GetScheduledActionActionMemberResult']:
        """
        The list of action members in a scheduled action.
        """
        return pulumi.get(self, "action_members")

    @property
    @pulumi.getter(name="actionOrder")
    def action_order(self) -> builtins.int:
        """
        The order of the scheduled action.
        """
        return pulumi.get(self, "action_order")

    @property
    @pulumi.getter(name="actionParams")
    def action_params(self) -> Mapping[str, builtins.str]:
        """
        Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        """
        return pulumi.get(self, "action_params")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> builtins.str:
        """
        The type of the scheduled action being performed
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the Scheduled Action.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedTimeInMins")
    def estimated_time_in_mins(self) -> builtins.int:
        """
        The estimated patching time for the scheduled action.
        """
        return pulumi.get(self, "estimated_time_in_mins")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduled Action.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="scheduledActionId")
    def scheduled_action_id(self) -> builtins.str:
        return pulumi.get(self, "scheduled_action_id")

    @property
    @pulumi.getter(name="schedulingPlanId")
    def scheduling_plan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Plan.
        """
        return pulumi.get(self, "scheduling_plan_id")

    @property
    @pulumi.getter(name="schedulingWindowId")
    def scheduling_window_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Window.
        """
        return pulumi.get(self, "scheduling_window_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Scheduled Action. Valid states are CREATING, NEEDS_ATTENTION, AVAILABLE, UPDATING, FAILED, DELETING and DELETED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the Scheduled Action Resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the Scheduled Action Resource was updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetScheduledActionResult(GetScheduledActionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledActionResult(
            action_members=self.action_members,
            action_order=self.action_order,
            action_params=self.action_params,
            action_type=self.action_type,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            estimated_time_in_mins=self.estimated_time_in_mins,
            freeform_tags=self.freeform_tags,
            id=self.id,
            scheduled_action_id=self.scheduled_action_id,
            scheduling_plan_id=self.scheduling_plan_id,
            scheduling_window_id=self.scheduling_window_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_scheduled_action(scheduled_action_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledActionResult:
    """
    This data source provides details about a specific Scheduled Action resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Scheduled Action.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_action = oci.Database.get_scheduled_action(scheduled_action_id=test_scheduled_action_oci_database_scheduled_action["id"])
    ```


    :param builtins.str scheduled_action_id: The Scheduled Action [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['scheduledActionId'] = scheduled_action_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getScheduledAction:getScheduledAction', __args__, opts=opts, typ=GetScheduledActionResult).value

    return AwaitableGetScheduledActionResult(
        action_members=pulumi.get(__ret__, 'action_members'),
        action_order=pulumi.get(__ret__, 'action_order'),
        action_params=pulumi.get(__ret__, 'action_params'),
        action_type=pulumi.get(__ret__, 'action_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        estimated_time_in_mins=pulumi.get(__ret__, 'estimated_time_in_mins'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        scheduled_action_id=pulumi.get(__ret__, 'scheduled_action_id'),
        scheduling_plan_id=pulumi.get(__ret__, 'scheduling_plan_id'),
        scheduling_window_id=pulumi.get(__ret__, 'scheduling_window_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_scheduled_action_output(scheduled_action_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduledActionResult]:
    """
    This data source provides details about a specific Scheduled Action resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Scheduled Action.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_action = oci.Database.get_scheduled_action(scheduled_action_id=test_scheduled_action_oci_database_scheduled_action["id"])
    ```


    :param builtins.str scheduled_action_id: The Scheduled Action [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['scheduledActionId'] = scheduled_action_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getScheduledAction:getScheduledAction', __args__, opts=opts, typ=GetScheduledActionResult)
    return __ret__.apply(lambda __response__: GetScheduledActionResult(
        action_members=pulumi.get(__response__, 'action_members'),
        action_order=pulumi.get(__response__, 'action_order'),
        action_params=pulumi.get(__response__, 'action_params'),
        action_type=pulumi.get(__response__, 'action_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        estimated_time_in_mins=pulumi.get(__response__, 'estimated_time_in_mins'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        scheduled_action_id=pulumi.get(__response__, 'scheduled_action_id'),
        scheduling_plan_id=pulumi.get(__response__, 'scheduling_plan_id'),
        scheduling_window_id=pulumi.get(__response__, 'scheduling_window_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
