# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SchedulingPolicyArgs', 'SchedulingPolicy']

@pulumi.input_type
class SchedulingPolicyArgs:
    def __init__(__self__, *,
                 cadence: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 cadence_start_month: Optional[pulumi.Input['SchedulingPolicyCadenceStartMonthArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a SchedulingPolicy resource.
        :param pulumi.Input[builtins.str] cadence: (Updatable) The cadence period.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the Scheduling Policy. The name does not need to be unique.
        :param pulumi.Input['SchedulingPolicyCadenceStartMonthArgs'] cadence_start_month: (Updatable) Start of the month to be followed during the cadence period.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "cadence", cadence)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        if cadence_start_month is not None:
            pulumi.set(__self__, "cadence_start_month", cadence_start_month)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter
    def cadence(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The cadence period.
        """
        return pulumi.get(self, "cadence")

    @cadence.setter
    def cadence(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cadence", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The user-friendly name for the Scheduling Policy. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="cadenceStartMonth")
    def cadence_start_month(self) -> Optional[pulumi.Input['SchedulingPolicyCadenceStartMonthArgs']]:
        """
        (Updatable) Start of the month to be followed during the cadence period.
        """
        return pulumi.get(self, "cadence_start_month")

    @cadence_start_month.setter
    def cadence_start_month(self, value: Optional[pulumi.Input['SchedulingPolicyCadenceStartMonthArgs']]):
        pulumi.set(self, "cadence_start_month", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _SchedulingPolicyState:
    def __init__(__self__, *,
                 cadence: Optional[pulumi.Input[builtins.str]] = None,
                 cadence_start_month: Optional[pulumi.Input['SchedulingPolicyCadenceStartMonthArgs']] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_next_window_starts: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SchedulingPolicy resources.
        :param pulumi.Input[builtins.str] cadence: (Updatable) The cadence period.
        :param pulumi.Input['SchedulingPolicyCadenceStartMonthArgs'] cadence_start_month: (Updatable) Start of the month to be followed during the cadence period.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the Scheduling Policy. The name does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] state: The current state of the Scheduling Policy. Valid states are CREATING, NEEDS_ATTENTION, ACTIVE, UPDATING, FAILED, DELETING and DELETED.
        :param pulumi.Input[builtins.str] time_created: The date and time the Scheduling Policy was created.
        :param pulumi.Input[builtins.str] time_next_window_starts: The date and time of the next scheduling window associated with the schedulingPolicy is planned to start.
        :param pulumi.Input[builtins.str] time_updated: The last date and time that the Scheduling Policy was updated.
        """
        if cadence is not None:
            pulumi.set(__self__, "cadence", cadence)
        if cadence_start_month is not None:
            pulumi.set(__self__, "cadence_start_month", cadence_start_month)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_next_window_starts is not None:
            pulumi.set(__self__, "time_next_window_starts", time_next_window_starts)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def cadence(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The cadence period.
        """
        return pulumi.get(self, "cadence")

    @cadence.setter
    def cadence(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cadence", value)

    @property
    @pulumi.getter(name="cadenceStartMonth")
    def cadence_start_month(self) -> Optional[pulumi.Input['SchedulingPolicyCadenceStartMonthArgs']]:
        """
        (Updatable) Start of the month to be followed during the cadence period.
        """
        return pulumi.get(self, "cadence_start_month")

    @cadence_start_month.setter
    def cadence_start_month(self, value: Optional[pulumi.Input['SchedulingPolicyCadenceStartMonthArgs']]):
        pulumi.set(self, "cadence_start_month", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The user-friendly name for the Scheduling Policy. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Scheduling Policy. Valid states are CREATING, NEEDS_ATTENTION, ACTIVE, UPDATING, FAILED, DELETING and DELETED.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Scheduling Policy was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeNextWindowStarts")
    def time_next_window_starts(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the next scheduling window associated with the schedulingPolicy is planned to start.
        """
        return pulumi.get(self, "time_next_window_starts")

    @time_next_window_starts.setter
    def time_next_window_starts(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_next_window_starts", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last date and time that the Scheduling Policy was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class SchedulingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cadence: Optional[pulumi.Input[builtins.str]] = None,
                 cadence_start_month: Optional[pulumi.Input[Union['SchedulingPolicyCadenceStartMonthArgs', 'SchedulingPolicyCadenceStartMonthArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Scheduling Policy resource in Oracle Cloud Infrastructure Database service.

        Creates a Scheduling Policy resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_scheduling_policy = oci.database.SchedulingPolicy("test_scheduling_policy",
            cadence=scheduling_policy_cadence,
            compartment_id=compartment_id,
            display_name=scheduling_policy_display_name,
            cadence_start_month={
                "name": scheduling_policy_cadence_start_month_name,
            },
            defined_tags=scheduling_policy_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        SchedulingPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/schedulingPolicy:SchedulingPolicy test_scheduling_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cadence: (Updatable) The cadence period.
        :param pulumi.Input[Union['SchedulingPolicyCadenceStartMonthArgs', 'SchedulingPolicyCadenceStartMonthArgsDict']] cadence_start_month: (Updatable) Start of the month to be followed during the cadence period.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the Scheduling Policy. The name does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchedulingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Scheduling Policy resource in Oracle Cloud Infrastructure Database service.

        Creates a Scheduling Policy resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_scheduling_policy = oci.database.SchedulingPolicy("test_scheduling_policy",
            cadence=scheduling_policy_cadence,
            compartment_id=compartment_id,
            display_name=scheduling_policy_display_name,
            cadence_start_month={
                "name": scheduling_policy_cadence_start_month_name,
            },
            defined_tags=scheduling_policy_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        SchedulingPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/schedulingPolicy:SchedulingPolicy test_scheduling_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param SchedulingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchedulingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cadence: Optional[pulumi.Input[builtins.str]] = None,
                 cadence_start_month: Optional[pulumi.Input[Union['SchedulingPolicyCadenceStartMonthArgs', 'SchedulingPolicyCadenceStartMonthArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchedulingPolicyArgs.__new__(SchedulingPolicyArgs)

            if cadence is None and not opts.urn:
                raise TypeError("Missing required property 'cadence'")
            __props__.__dict__["cadence"] = cadence
            __props__.__dict__["cadence_start_month"] = cadence_start_month
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_next_window_starts"] = None
            __props__.__dict__["time_updated"] = None
        super(SchedulingPolicy, __self__).__init__(
            'oci:Database/schedulingPolicy:SchedulingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cadence: Optional[pulumi.Input[builtins.str]] = None,
            cadence_start_month: Optional[pulumi.Input[Union['SchedulingPolicyCadenceStartMonthArgs', 'SchedulingPolicyCadenceStartMonthArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_next_window_starts: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'SchedulingPolicy':
        """
        Get an existing SchedulingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cadence: (Updatable) The cadence period.
        :param pulumi.Input[Union['SchedulingPolicyCadenceStartMonthArgs', 'SchedulingPolicyCadenceStartMonthArgsDict']] cadence_start_month: (Updatable) Start of the month to be followed during the cadence period.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the Scheduling Policy. The name does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] state: The current state of the Scheduling Policy. Valid states are CREATING, NEEDS_ATTENTION, ACTIVE, UPDATING, FAILED, DELETING and DELETED.
        :param pulumi.Input[builtins.str] time_created: The date and time the Scheduling Policy was created.
        :param pulumi.Input[builtins.str] time_next_window_starts: The date and time of the next scheduling window associated with the schedulingPolicy is planned to start.
        :param pulumi.Input[builtins.str] time_updated: The last date and time that the Scheduling Policy was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SchedulingPolicyState.__new__(_SchedulingPolicyState)

        __props__.__dict__["cadence"] = cadence
        __props__.__dict__["cadence_start_month"] = cadence_start_month
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_next_window_starts"] = time_next_window_starts
        __props__.__dict__["time_updated"] = time_updated
        return SchedulingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cadence(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The cadence period.
        """
        return pulumi.get(self, "cadence")

    @property
    @pulumi.getter(name="cadenceStartMonth")
    def cadence_start_month(self) -> pulumi.Output['outputs.SchedulingPolicyCadenceStartMonth']:
        """
        (Updatable) Start of the month to be followed during the cadence period.
        """
        return pulumi.get(self, "cadence_start_month")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The user-friendly name for the Scheduling Policy. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Scheduling Policy. Valid states are CREATING, NEEDS_ATTENTION, ACTIVE, UPDATING, FAILED, DELETING and DELETED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Scheduling Policy was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeNextWindowStarts")
    def time_next_window_starts(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the next scheduling window associated with the schedulingPolicy is planned to start.
        """
        return pulumi.get(self, "time_next_window_starts")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The last date and time that the Scheduling Policy was updated.
        """
        return pulumi.get(self, "time_updated")

