# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedDatabaseResult',
    'AwaitableGetManagedDatabaseResult',
    'get_managed_database',
    'get_managed_database_output',
]

@pulumi.output_type
class GetManagedDatabaseResult:
    """
    A collection of values returned by getManagedDatabase.
    """
    def __init__(__self__, additional_details=None, compartment_id=None, database_platform_name=None, database_status=None, database_sub_type=None, database_type=None, database_version=None, db_system_id=None, dbmgmt_feature_configs=None, defined_tags=None, deployment_type=None, freeform_tags=None, id=None, is_cluster=None, managed_database_groups=None, managed_database_id=None, management_option=None, name=None, parent_container_id=None, storage_system_id=None, system_tags=None, time_created=None, workload_type=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_platform_name and not isinstance(database_platform_name, str):
            raise TypeError("Expected argument 'database_platform_name' to be a str")
        pulumi.set(__self__, "database_platform_name", database_platform_name)
        if database_status and not isinstance(database_status, str):
            raise TypeError("Expected argument 'database_status' to be a str")
        pulumi.set(__self__, "database_status", database_status)
        if database_sub_type and not isinstance(database_sub_type, str):
            raise TypeError("Expected argument 'database_sub_type' to be a str")
        pulumi.set(__self__, "database_sub_type", database_sub_type)
        if database_type and not isinstance(database_type, str):
            raise TypeError("Expected argument 'database_type' to be a str")
        pulumi.set(__self__, "database_type", database_type)
        if database_version and not isinstance(database_version, str):
            raise TypeError("Expected argument 'database_version' to be a str")
        pulumi.set(__self__, "database_version", database_version)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if dbmgmt_feature_configs and not isinstance(dbmgmt_feature_configs, list):
            raise TypeError("Expected argument 'dbmgmt_feature_configs' to be a list")
        pulumi.set(__self__, "dbmgmt_feature_configs", dbmgmt_feature_configs)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_cluster and not isinstance(is_cluster, bool):
            raise TypeError("Expected argument 'is_cluster' to be a bool")
        pulumi.set(__self__, "is_cluster", is_cluster)
        if managed_database_groups and not isinstance(managed_database_groups, list):
            raise TypeError("Expected argument 'managed_database_groups' to be a list")
        pulumi.set(__self__, "managed_database_groups", managed_database_groups)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if management_option and not isinstance(management_option, str):
            raise TypeError("Expected argument 'management_option' to be a str")
        pulumi.set(__self__, "management_option", management_option)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_container_id and not isinstance(parent_container_id, str):
            raise TypeError("Expected argument 'parent_container_id' to be a str")
        pulumi.set(__self__, "parent_container_id", parent_container_id)
        if storage_system_id and not isinstance(storage_system_id, str):
            raise TypeError("Expected argument 'storage_system_id' to be a str")
        pulumi.set(__self__, "storage_system_id", storage_system_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if workload_type and not isinstance(workload_type, str):
            raise TypeError("Expected argument 'workload_type' to be a str")
        pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, builtins.str]:
        """
        The additional details specific to a type of database defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the Managed Database Group resides.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databasePlatformName")
    def database_platform_name(self) -> Optional[builtins.str]:
        """
        The operating system of database.
        """
        return pulumi.get(self, "database_platform_name")

    @property
    @pulumi.getter(name="databaseStatus")
    def database_status(self) -> builtins.str:
        """
        The status of the Oracle Database. Indicates whether the status of the database is UP, DOWN, or UNKNOWN at the current time.
        """
        return pulumi.get(self, "database_status")

    @property
    @pulumi.getter(name="databaseSubType")
    def database_sub_type(self) -> builtins.str:
        """
        The subtype of the Oracle Database. Indicates whether the database is a Container Database, Pluggable Database, Non-container Database, Autonomous Database, or Autonomous Container Database.
        """
        return pulumi.get(self, "database_sub_type")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> builtins.str:
        """
        The type of Oracle Database installation.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> builtins.str:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that this Managed Database is part of.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbmgmtFeatureConfigs")
    def dbmgmt_feature_configs(self) -> Sequence['outputs.GetManagedDatabaseDbmgmtFeatureConfigResult']:
        """
        The list of feature configurations
        """
        return pulumi.get(self, "dbmgmt_feature_configs")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> builtins.str:
        """
        The infrastructure used to deploy the Oracle Database.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> builtins.bool:
        """
        Indicates whether the Oracle Database is part of a cluster.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter(name="managedDatabaseGroups")
    def managed_database_groups(self) -> Sequence['outputs.GetManagedDatabaseManagedDatabaseGroupResult']:
        """
        A list of Managed Database Groups that the Managed Database belongs to.
        """
        return pulumi.get(self, "managed_database_groups")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> builtins.str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter(name="managementOption")
    def management_option(self) -> builtins.str:
        """
        The management option used when enabling Database Management.
        """
        return pulumi.get(self, "management_option")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Managed Database.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentContainerId")
    def parent_container_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the parent Container Database if Managed Database is a Pluggable Database.
        """
        return pulumi.get(self, "parent_container_id")

    @property
    @pulumi.getter(name="storageSystemId")
    def storage_system_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the storage DB system.
        """
        return pulumi.get(self, "storage_system_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the Managed Database was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> builtins.str:
        """
        The workload type of the Autonomous Database.
        """
        return pulumi.get(self, "workload_type")


class AwaitableGetManagedDatabaseResult(GetManagedDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseResult(
            additional_details=self.additional_details,
            compartment_id=self.compartment_id,
            database_platform_name=self.database_platform_name,
            database_status=self.database_status,
            database_sub_type=self.database_sub_type,
            database_type=self.database_type,
            database_version=self.database_version,
            db_system_id=self.db_system_id,
            dbmgmt_feature_configs=self.dbmgmt_feature_configs,
            defined_tags=self.defined_tags,
            deployment_type=self.deployment_type,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_cluster=self.is_cluster,
            managed_database_groups=self.managed_database_groups,
            managed_database_id=self.managed_database_id,
            management_option=self.management_option,
            name=self.name,
            parent_container_id=self.parent_container_id,
            storage_system_id=self.storage_system_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            workload_type=self.workload_type)


def get_managed_database(database_platform_name: Optional[builtins.str] = None,
                         managed_database_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseResult:
    """
    This data source provides details about a specific Managed Database resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the Managed Database specified by managedDatabaseId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database = oci.DatabaseManagement.get_managed_database(managed_database_id=test_managed_database_oci_database_management_managed_database["id"])
    ```


    :param builtins.str database_platform_name: The operating system of database.
    :param builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    """
    __args__ = dict()
    __args__['databasePlatformName'] = database_platform_name
    __args__['managedDatabaseId'] = managed_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabase:getManagedDatabase', __args__, opts=opts, typ=GetManagedDatabaseResult).value

    return AwaitableGetManagedDatabaseResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_platform_name=pulumi.get(__ret__, 'database_platform_name'),
        database_status=pulumi.get(__ret__, 'database_status'),
        database_sub_type=pulumi.get(__ret__, 'database_sub_type'),
        database_type=pulumi.get(__ret__, 'database_type'),
        database_version=pulumi.get(__ret__, 'database_version'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        dbmgmt_feature_configs=pulumi.get(__ret__, 'dbmgmt_feature_configs'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        deployment_type=pulumi.get(__ret__, 'deployment_type'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_cluster=pulumi.get(__ret__, 'is_cluster'),
        managed_database_groups=pulumi.get(__ret__, 'managed_database_groups'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        management_option=pulumi.get(__ret__, 'management_option'),
        name=pulumi.get(__ret__, 'name'),
        parent_container_id=pulumi.get(__ret__, 'parent_container_id'),
        storage_system_id=pulumi.get(__ret__, 'storage_system_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        workload_type=pulumi.get(__ret__, 'workload_type'))
def get_managed_database_output(database_platform_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                managed_database_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedDatabaseResult]:
    """
    This data source provides details about a specific Managed Database resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the Managed Database specified by managedDatabaseId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database = oci.DatabaseManagement.get_managed_database(managed_database_id=test_managed_database_oci_database_management_managed_database["id"])
    ```


    :param builtins.str database_platform_name: The operating system of database.
    :param builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    """
    __args__ = dict()
    __args__['databasePlatformName'] = database_platform_name
    __args__['managedDatabaseId'] = managed_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getManagedDatabase:getManagedDatabase', __args__, opts=opts, typ=GetManagedDatabaseResult)
    return __ret__.apply(lambda __response__: GetManagedDatabaseResult(
        additional_details=pulumi.get(__response__, 'additional_details'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_platform_name=pulumi.get(__response__, 'database_platform_name'),
        database_status=pulumi.get(__response__, 'database_status'),
        database_sub_type=pulumi.get(__response__, 'database_sub_type'),
        database_type=pulumi.get(__response__, 'database_type'),
        database_version=pulumi.get(__response__, 'database_version'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        dbmgmt_feature_configs=pulumi.get(__response__, 'dbmgmt_feature_configs'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        deployment_type=pulumi.get(__response__, 'deployment_type'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_cluster=pulumi.get(__response__, 'is_cluster'),
        managed_database_groups=pulumi.get(__response__, 'managed_database_groups'),
        managed_database_id=pulumi.get(__response__, 'managed_database_id'),
        management_option=pulumi.get(__response__, 'management_option'),
        name=pulumi.get(__response__, 'name'),
        parent_container_id=pulumi.get(__response__, 'parent_container_id'),
        storage_system_id=pulumi.get(__response__, 'storage_system_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        workload_type=pulumi.get(__response__, 'workload_type')))
