# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AlertArgs', 'Alert']

@pulumi.input_type
class AlertArgs:
    def __init__(__self__, *,
                 alert_id: pulumi.Input[builtins.str],
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Alert resource.
        :param pulumi.Input[builtins.str] alert_id: The OCID of alert.
        :param pulumi.Input[builtins.str] comment: (Updatable) A comment can be entered to track the alert changes done by the user.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the alert.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] status: (Updatable) The status of the alert.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "alert_id", alert_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="alertId")
    def alert_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of alert.
        """
        return pulumi.get(self, "alert_id")

    @alert_id.setter
    def alert_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "alert_id", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A comment can be entered to track the alert changes done by the user.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment that contains the alert.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The status of the alert.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _AlertState:
    def __init__(__self__, *,
                 alert_id: Optional[pulumi.Input[builtins.str]] = None,
                 alert_policy_rule_key: Optional[pulumi.Input[builtins.str]] = None,
                 alert_policy_rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 alert_type: Optional[pulumi.Input[builtins.str]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 feature_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 operation: Optional[pulumi.Input[builtins.str]] = None,
                 operation_status: Optional[pulumi.Input[builtins.str]] = None,
                 operation_time: Optional[pulumi.Input[builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Alert resources.
        :param pulumi.Input[builtins.str] alert_id: The OCID of alert.
        :param pulumi.Input[builtins.str] alert_policy_rule_key: The key of the rule of alert policy that triggered alert.
        :param pulumi.Input[builtins.str] alert_policy_rule_name: The display name of the rule of alert policy that triggered alert.
        :param pulumi.Input[builtins.str] alert_type: Type of the alert. Indicates the Data Safe feature triggering the alert.
        :param pulumi.Input[builtins.str] comment: (Updatable) A comment can be entered to track the alert changes done by the user.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the alert.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: The description of the alert.
        :param pulumi.Input[builtins.str] display_name: The display name of the alert.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] feature_details: Map that contains maps of values. Example: `{"Operations": {"CostCenter": "42"}}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] operation: The operation (event) that triggered alert.
        :param pulumi.Input[builtins.str] operation_status: The result of the operation (event) that triggered alert.
        :param pulumi.Input[builtins.str] operation_time: Creation date and time of the operation that triggered alert, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] policy_id: The OCID of the policy that triggered alert.
        :param pulumi.Input[builtins.str] resource_name: The resource endpoint that triggered the alert.
        :param pulumi.Input[builtins.str] severity: Severity level of the alert.
        :param pulumi.Input[builtins.str] state: The current state of the alert.
        :param pulumi.Input[builtins.str] status: (Updatable) The status of the alert.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_ids: Array of OCIDs of the target database which are associated with the alert.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_names: Array of names of the target database.
        :param pulumi.Input[builtins.str] time_created: Creation date and time of the alert, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: Last date and time the alert was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        if alert_id is not None:
            pulumi.set(__self__, "alert_id", alert_id)
        if alert_policy_rule_key is not None:
            pulumi.set(__self__, "alert_policy_rule_key", alert_policy_rule_key)
        if alert_policy_rule_name is not None:
            pulumi.set(__self__, "alert_policy_rule_name", alert_policy_rule_name)
        if alert_type is not None:
            pulumi.set(__self__, "alert_type", alert_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if feature_details is not None:
            pulumi.set(__self__, "feature_details", feature_details)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if operation_status is not None:
            pulumi.set(__self__, "operation_status", operation_status)
        if operation_time is not None:
            pulumi.set(__self__, "operation_time", operation_time)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_ids is not None:
            pulumi.set(__self__, "target_ids", target_ids)
        if target_names is not None:
            pulumi.set(__self__, "target_names", target_names)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alertId")
    def alert_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of alert.
        """
        return pulumi.get(self, "alert_id")

    @alert_id.setter
    def alert_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_id", value)

    @property
    @pulumi.getter(name="alertPolicyRuleKey")
    def alert_policy_rule_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the rule of alert policy that triggered alert.
        """
        return pulumi.get(self, "alert_policy_rule_key")

    @alert_policy_rule_key.setter
    def alert_policy_rule_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_policy_rule_key", value)

    @property
    @pulumi.getter(name="alertPolicyRuleName")
    def alert_policy_rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the rule of alert policy that triggered alert.
        """
        return pulumi.get(self, "alert_policy_rule_name")

    @alert_policy_rule_name.setter
    def alert_policy_rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_policy_rule_name", value)

    @property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the alert. Indicates the Data Safe feature triggering the alert.
        """
        return pulumi.get(self, "alert_type")

    @alert_type.setter
    def alert_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_type", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A comment can be entered to track the alert changes done by the user.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment that contains the alert.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the alert.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="featureDetails")
    def feature_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map that contains maps of values. Example: `{"Operations": {"CostCenter": "42"}}`
        """
        return pulumi.get(self, "feature_details")

    @feature_details.setter
    def feature_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "feature_details", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The operation (event) that triggered alert.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter(name="operationStatus")
    def operation_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The result of the operation (event) that triggered alert.
        """
        return pulumi.get(self, "operation_status")

    @operation_status.setter
    def operation_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation_status", value)

    @property
    @pulumi.getter(name="operationTime")
    def operation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation date and time of the operation that triggered alert, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "operation_time")

    @operation_time.setter
    def operation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation_time", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the policy that triggered alert.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource endpoint that triggered the alert.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Severity level of the alert.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the alert.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The status of the alert.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Array of OCIDs of the target database which are associated with the alert.
        """
        return pulumi.get(self, "target_ids")

    @target_ids.setter
    def target_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_ids", value)

    @property
    @pulumi.getter(name="targetNames")
    def target_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Array of names of the target database.
        """
        return pulumi.get(self, "target_names")

    @target_names.setter
    def target_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_names", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation date and time of the alert, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last date and time the alert was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class Alert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_id: Optional[pulumi.Input[builtins.str]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Alert resource in Oracle Cloud Infrastructure Data Safe service.

        Updates the status of the specified alert.

        ## Import

        Alerts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/alert:Alert test_alert "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alert_id: The OCID of alert.
        :param pulumi.Input[builtins.str] comment: (Updatable) A comment can be entered to track the alert changes done by the user.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the alert.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] status: (Updatable) The status of the alert.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Alert resource in Oracle Cloud Infrastructure Data Safe service.

        Updates the status of the specified alert.

        ## Import

        Alerts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/alert:Alert test_alert "id"
        ```

        :param str resource_name: The name of the resource.
        :param AlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_id: Optional[pulumi.Input[builtins.str]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertArgs.__new__(AlertArgs)

            if alert_id is None and not opts.urn:
                raise TypeError("Missing required property 'alert_id'")
            __props__.__dict__["alert_id"] = alert_id
            __props__.__dict__["comment"] = comment
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["status"] = status
            __props__.__dict__["alert_policy_rule_key"] = None
            __props__.__dict__["alert_policy_rule_name"] = None
            __props__.__dict__["alert_type"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["feature_details"] = None
            __props__.__dict__["operation"] = None
            __props__.__dict__["operation_status"] = None
            __props__.__dict__["operation_time"] = None
            __props__.__dict__["policy_id"] = None
            __props__.__dict__["resource_name"] = None
            __props__.__dict__["severity"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_ids"] = None
            __props__.__dict__["target_names"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Alert, __self__).__init__(
            'oci:DataSafe/alert:Alert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_id: Optional[pulumi.Input[builtins.str]] = None,
            alert_policy_rule_key: Optional[pulumi.Input[builtins.str]] = None,
            alert_policy_rule_name: Optional[pulumi.Input[builtins.str]] = None,
            alert_type: Optional[pulumi.Input[builtins.str]] = None,
            comment: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            feature_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            operation: Optional[pulumi.Input[builtins.str]] = None,
            operation_status: Optional[pulumi.Input[builtins.str]] = None,
            operation_time: Optional[pulumi.Input[builtins.str]] = None,
            policy_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_name_: Optional[pulumi.Input[builtins.str]] = None,
            severity: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            target_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'Alert':
        """
        Get an existing Alert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alert_id: The OCID of alert.
        :param pulumi.Input[builtins.str] alert_policy_rule_key: The key of the rule of alert policy that triggered alert.
        :param pulumi.Input[builtins.str] alert_policy_rule_name: The display name of the rule of alert policy that triggered alert.
        :param pulumi.Input[builtins.str] alert_type: Type of the alert. Indicates the Data Safe feature triggering the alert.
        :param pulumi.Input[builtins.str] comment: (Updatable) A comment can be entered to track the alert changes done by the user.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the alert.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: The description of the alert.
        :param pulumi.Input[builtins.str] display_name: The display name of the alert.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] feature_details: Map that contains maps of values. Example: `{"Operations": {"CostCenter": "42"}}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] operation: The operation (event) that triggered alert.
        :param pulumi.Input[builtins.str] operation_status: The result of the operation (event) that triggered alert.
        :param pulumi.Input[builtins.str] operation_time: Creation date and time of the operation that triggered alert, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] policy_id: The OCID of the policy that triggered alert.
        :param pulumi.Input[builtins.str] resource_name_: The resource endpoint that triggered the alert.
        :param pulumi.Input[builtins.str] severity: Severity level of the alert.
        :param pulumi.Input[builtins.str] state: The current state of the alert.
        :param pulumi.Input[builtins.str] status: (Updatable) The status of the alert.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_ids: Array of OCIDs of the target database which are associated with the alert.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_names: Array of names of the target database.
        :param pulumi.Input[builtins.str] time_created: Creation date and time of the alert, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: Last date and time the alert was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertState.__new__(_AlertState)

        __props__.__dict__["alert_id"] = alert_id
        __props__.__dict__["alert_policy_rule_key"] = alert_policy_rule_key
        __props__.__dict__["alert_policy_rule_name"] = alert_policy_rule_name
        __props__.__dict__["alert_type"] = alert_type
        __props__.__dict__["comment"] = comment
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["feature_details"] = feature_details
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["operation"] = operation
        __props__.__dict__["operation_status"] = operation_status
        __props__.__dict__["operation_time"] = operation_time
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["severity"] = severity
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_ids"] = target_ids
        __props__.__dict__["target_names"] = target_names
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Alert(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertId")
    def alert_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of alert.
        """
        return pulumi.get(self, "alert_id")

    @property
    @pulumi.getter(name="alertPolicyRuleKey")
    def alert_policy_rule_key(self) -> pulumi.Output[builtins.str]:
        """
        The key of the rule of alert policy that triggered alert.
        """
        return pulumi.get(self, "alert_policy_rule_key")

    @property
    @pulumi.getter(name="alertPolicyRuleName")
    def alert_policy_rule_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the rule of alert policy that triggered alert.
        """
        return pulumi.get(self, "alert_policy_rule_name")

    @property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of the alert. Indicates the Data Safe feature triggering the alert.
        """
        return pulumi.get(self, "alert_type")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A comment can be entered to track the alert changes done by the user.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains the alert.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the alert.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="featureDetails")
    def feature_details(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map that contains maps of values. Example: `{"Operations": {"CostCenter": "42"}}`
        """
        return pulumi.get(self, "feature_details")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Output[builtins.str]:
        """
        The operation (event) that triggered alert.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="operationStatus")
    def operation_status(self) -> pulumi.Output[builtins.str]:
        """
        The result of the operation (event) that triggered alert.
        """
        return pulumi.get(self, "operation_status")

    @property
    @pulumi.getter(name="operationTime")
    def operation_time(self) -> pulumi.Output[builtins.str]:
        """
        Creation date and time of the operation that triggered alert, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "operation_time")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the policy that triggered alert.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[builtins.str]:
        """
        The resource endpoint that triggered the alert.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[builtins.str]:
        """
        Severity level of the alert.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the alert.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The status of the alert.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Array of OCIDs of the target database which are associated with the alert.
        """
        return pulumi.get(self, "target_ids")

    @property
    @pulumi.getter(name="targetNames")
    def target_names(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Array of names of the target database.
        """
        return pulumi.get(self, "target_names")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        Creation date and time of the alert, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        Last date and time the alert was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

