# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSensitiveDataModelSensitiveObjectsResult',
    'AwaitableGetSensitiveDataModelSensitiveObjectsResult',
    'get_sensitive_data_model_sensitive_objects',
    'get_sensitive_data_model_sensitive_objects_output',
]

@pulumi.output_type
class GetSensitiveDataModelSensitiveObjectsResult:
    """
    A collection of values returned by getSensitiveDataModelSensitiveObjects.
    """
    def __init__(__self__, filters=None, id=None, object_types=None, objects=None, schema_names=None, sensitive_data_model_id=None, sensitive_object_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if object_types and not isinstance(object_types, list):
            raise TypeError("Expected argument 'object_types' to be a list")
        pulumi.set(__self__, "object_types", object_types)
        if objects and not isinstance(objects, list):
            raise TypeError("Expected argument 'objects' to be a list")
        pulumi.set(__self__, "objects", objects)
        if schema_names and not isinstance(schema_names, list):
            raise TypeError("Expected argument 'schema_names' to be a list")
        pulumi.set(__self__, "schema_names", schema_names)
        if sensitive_data_model_id and not isinstance(sensitive_data_model_id, str):
            raise TypeError("Expected argument 'sensitive_data_model_id' to be a str")
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if sensitive_object_collections and not isinstance(sensitive_object_collections, list):
            raise TypeError("Expected argument 'sensitive_object_collections' to be a list")
        pulumi.set(__self__, "sensitive_object_collections", sensitive_object_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSensitiveDataModelSensitiveObjectsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="objectTypes")
    def object_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The type of the database object that contains the sensitive column.
        """
        return pulumi.get(self, "object_types")

    @property
    @pulumi.getter
    def objects(self) -> Optional[Sequence[builtins.str]]:
        """
        The database object that contains the sensitive column.
        """
        return pulumi.get(self, "objects")

    @property
    @pulumi.getter(name="schemaNames")
    def schema_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The database schema that contains the sensitive column.
        """
        return pulumi.get(self, "schema_names")

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> builtins.str:
        return pulumi.get(self, "sensitive_data_model_id")

    @property
    @pulumi.getter(name="sensitiveObjectCollections")
    def sensitive_object_collections(self) -> Sequence['outputs.GetSensitiveDataModelSensitiveObjectsSensitiveObjectCollectionResult']:
        """
        The list of sensitive_object_collection.
        """
        return pulumi.get(self, "sensitive_object_collections")


class AwaitableGetSensitiveDataModelSensitiveObjectsResult(GetSensitiveDataModelSensitiveObjectsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSensitiveDataModelSensitiveObjectsResult(
            filters=self.filters,
            id=self.id,
            object_types=self.object_types,
            objects=self.objects,
            schema_names=self.schema_names,
            sensitive_data_model_id=self.sensitive_data_model_id,
            sensitive_object_collections=self.sensitive_object_collections)


def get_sensitive_data_model_sensitive_objects(filters: Optional[Sequence[Union['GetSensitiveDataModelSensitiveObjectsFilterArgs', 'GetSensitiveDataModelSensitiveObjectsFilterArgsDict']]] = None,
                                               object_types: Optional[Sequence[builtins.str]] = None,
                                               objects: Optional[Sequence[builtins.str]] = None,
                                               schema_names: Optional[Sequence[builtins.str]] = None,
                                               sensitive_data_model_id: Optional[builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSensitiveDataModelSensitiveObjectsResult:
    """
    This data source provides the list of Sensitive Data Model Sensitive Objects in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of sensitive objects present in the specified sensitive data model based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_data_model_sensitive_objects = oci.DataSafe.get_sensitive_data_model_sensitive_objects(sensitive_data_model_id=test_sensitive_data_model["id"],
        objects=sensitive_data_model_sensitive_object_object,
        object_types=sensitive_data_model_sensitive_object_object_type,
        schema_names=sensitive_data_model_sensitive_object_schema_name)
    ```


    :param Sequence[builtins.str] object_types: A filter to return only items related to a specific object type.
    :param Sequence[builtins.str] objects: A filter to return only items related to a specific object name.
    :param Sequence[builtins.str] schema_names: A filter to return only items related to specific schema name.
    :param builtins.str sensitive_data_model_id: The OCID of the sensitive data model.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['objectTypes'] = object_types
    __args__['objects'] = objects
    __args__['schemaNames'] = schema_names
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSensitiveDataModelSensitiveObjects:getSensitiveDataModelSensitiveObjects', __args__, opts=opts, typ=GetSensitiveDataModelSensitiveObjectsResult).value

    return AwaitableGetSensitiveDataModelSensitiveObjectsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        object_types=pulumi.get(__ret__, 'object_types'),
        objects=pulumi.get(__ret__, 'objects'),
        schema_names=pulumi.get(__ret__, 'schema_names'),
        sensitive_data_model_id=pulumi.get(__ret__, 'sensitive_data_model_id'),
        sensitive_object_collections=pulumi.get(__ret__, 'sensitive_object_collections'))
def get_sensitive_data_model_sensitive_objects_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSensitiveDataModelSensitiveObjectsFilterArgs', 'GetSensitiveDataModelSensitiveObjectsFilterArgsDict']]]]] = None,
                                                      object_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                      objects: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                      schema_names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                      sensitive_data_model_id: Optional[pulumi.Input[builtins.str]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSensitiveDataModelSensitiveObjectsResult]:
    """
    This data source provides the list of Sensitive Data Model Sensitive Objects in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of sensitive objects present in the specified sensitive data model based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_data_model_sensitive_objects = oci.DataSafe.get_sensitive_data_model_sensitive_objects(sensitive_data_model_id=test_sensitive_data_model["id"],
        objects=sensitive_data_model_sensitive_object_object,
        object_types=sensitive_data_model_sensitive_object_object_type,
        schema_names=sensitive_data_model_sensitive_object_schema_name)
    ```


    :param Sequence[builtins.str] object_types: A filter to return only items related to a specific object type.
    :param Sequence[builtins.str] objects: A filter to return only items related to a specific object name.
    :param Sequence[builtins.str] schema_names: A filter to return only items related to specific schema name.
    :param builtins.str sensitive_data_model_id: The OCID of the sensitive data model.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['objectTypes'] = object_types
    __args__['objects'] = objects
    __args__['schemaNames'] = schema_names
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSensitiveDataModelSensitiveObjects:getSensitiveDataModelSensitiveObjects', __args__, opts=opts, typ=GetSensitiveDataModelSensitiveObjectsResult)
    return __ret__.apply(lambda __response__: GetSensitiveDataModelSensitiveObjectsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        object_types=pulumi.get(__response__, 'object_types'),
        objects=pulumi.get(__response__, 'objects'),
        schema_names=pulumi.get(__response__, 'schema_names'),
        sensitive_data_model_id=pulumi.get(__response__, 'sensitive_data_model_id'),
        sensitive_object_collections=pulumi.get(__response__, 'sensitive_object_collections')))
