# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SetSecurityAssessmentBaselineManagementArgs', 'SetSecurityAssessmentBaselineManagement']

@pulumi.input_type
class SetSecurityAssessmentBaselineManagementArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 target_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a SetSecurityAssessmentBaselineManagement resource.
        :param pulumi.Input[builtins.str] compartment_id: The compartment OCID of the target.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] target_id: The target OCID for which SA needs to be set as baseline.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The compartment OCID of the target.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[builtins.str]:
        """
        The target OCID for which SA needs to be set as baseline.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_id", value)


@pulumi.input_type
class _SetSecurityAssessmentBaselineManagementState:
    def __init__(__self__, *,
                 assessment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 security_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SetSecurityAssessmentBaselineManagement resources.
        :param pulumi.Input[builtins.str] compartment_id: The compartment OCID of the target.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] target_id: The target OCID for which SA needs to be set as baseline.
        """
        if assessment_ids is not None:
            pulumi.set(__self__, "assessment_ids", assessment_ids)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if security_assessment_id is not None:
            pulumi.set(__self__, "security_assessment_id", security_assessment_id)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="assessmentIds")
    def assessment_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "assessment_ids")

    @assessment_ids.setter
    def assessment_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "assessment_ids", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The compartment OCID of the target.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="securityAssessmentId")
    def security_assessment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "security_assessment_id")

    @security_assessment_id.setter
    def security_assessment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_assessment_id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The target OCID for which SA needs to be set as baseline.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_id", value)


class SetSecurityAssessmentBaselineManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Set Security Assessment Baseline management resource in Oracle Cloud Infrastructure Data Safe service.

        Sets the saved security assessment as the baseline in the compartment where the the specified assessment resides. The security assessment needs to be of type 'SAVED'.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_set_security_assessment_baseline_management = oci.data_safe.SetSecurityAssessmentBaselineManagement("test_set_security_assessment_baseline_management",
            target_id=test_target_database["id"],
            compartment_id=comaprtment_id)
        ```

        ## Import

        SetSecurityAssessmentBaselineManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/setSecurityAssessmentBaselineManagement:SetSecurityAssessmentBaselineManagement test_set_security_assessment_baseline_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The compartment OCID of the target.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] target_id: The target OCID for which SA needs to be set as baseline.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SetSecurityAssessmentBaselineManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Set Security Assessment Baseline management resource in Oracle Cloud Infrastructure Data Safe service.

        Sets the saved security assessment as the baseline in the compartment where the the specified assessment resides. The security assessment needs to be of type 'SAVED'.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_set_security_assessment_baseline_management = oci.data_safe.SetSecurityAssessmentBaselineManagement("test_set_security_assessment_baseline_management",
            target_id=test_target_database["id"],
            compartment_id=comaprtment_id)
        ```

        ## Import

        SetSecurityAssessmentBaselineManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/setSecurityAssessmentBaselineManagement:SetSecurityAssessmentBaselineManagement test_set_security_assessment_baseline_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param SetSecurityAssessmentBaselineManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SetSecurityAssessmentBaselineManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SetSecurityAssessmentBaselineManagementArgs.__new__(SetSecurityAssessmentBaselineManagementArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["assessment_ids"] = None
            __props__.__dict__["security_assessment_id"] = None
        super(SetSecurityAssessmentBaselineManagement, __self__).__init__(
            'oci:DataSafe/setSecurityAssessmentBaselineManagement:SetSecurityAssessmentBaselineManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assessment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            security_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
            target_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SetSecurityAssessmentBaselineManagement':
        """
        Get an existing SetSecurityAssessmentBaselineManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The compartment OCID of the target.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] target_id: The target OCID for which SA needs to be set as baseline.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SetSecurityAssessmentBaselineManagementState.__new__(_SetSecurityAssessmentBaselineManagementState)

        __props__.__dict__["assessment_ids"] = assessment_ids
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["security_assessment_id"] = security_assessment_id
        __props__.__dict__["target_id"] = target_id
        return SetSecurityAssessmentBaselineManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assessmentIds")
    def assessment_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        return pulumi.get(self, "assessment_ids")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The compartment OCID of the target.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="securityAssessmentId")
    def security_assessment_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "security_assessment_id")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[builtins.str]:
        """
        The target OCID for which SA needs to be set as baseline.
        """
        return pulumi.get(self, "target_id")

