# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMlApplicationImplementationsResult',
    'AwaitableGetMlApplicationImplementationsResult',
    'get_ml_application_implementations',
    'get_ml_application_implementations_output',
]

@pulumi.output_type
class GetMlApplicationImplementationsResult:
    """
    A collection of values returned by getMlApplicationImplementations.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, ml_application_id=None, ml_application_implementation_collections=None, ml_application_implementation_id=None, name=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ml_application_id and not isinstance(ml_application_id, str):
            raise TypeError("Expected argument 'ml_application_id' to be a str")
        pulumi.set(__self__, "ml_application_id", ml_application_id)
        if ml_application_implementation_collections and not isinstance(ml_application_implementation_collections, list):
            raise TypeError("Expected argument 'ml_application_implementation_collections' to be a list")
        pulumi.set(__self__, "ml_application_implementation_collections", ml_application_implementation_collections)
        if ml_application_implementation_id and not isinstance(ml_application_implementation_id, str):
            raise TypeError("Expected argument 'ml_application_implementation_id' to be a str")
        pulumi.set(__self__, "ml_application_implementation_id", ml_application_implementation_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment where ML Application Implementation is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMlApplicationImplementationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> Optional[builtins.str]:
        """
        The OCID of the ML Application implemented by this ML Application Implementation.
        """
        return pulumi.get(self, "ml_application_id")

    @property
    @pulumi.getter(name="mlApplicationImplementationCollections")
    def ml_application_implementation_collections(self) -> Sequence['outputs.GetMlApplicationImplementationsMlApplicationImplementationCollectionResult']:
        """
        The list of ml_application_implementation_collection.
        """
        return pulumi.get(self, "ml_application_implementation_collections")

    @property
    @pulumi.getter(name="mlApplicationImplementationId")
    def ml_application_implementation_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ml_application_implementation_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        ML Application Implementation name which is unique for given ML Application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the MlApplicationImplementation.
        """
        return pulumi.get(self, "state")


class AwaitableGetMlApplicationImplementationsResult(GetMlApplicationImplementationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMlApplicationImplementationsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            ml_application_id=self.ml_application_id,
            ml_application_implementation_collections=self.ml_application_implementation_collections,
            ml_application_implementation_id=self.ml_application_implementation_id,
            name=self.name,
            state=self.state)


def get_ml_application_implementations(compartment_id: Optional[builtins.str] = None,
                                       compartment_id_in_subtree: Optional[builtins.bool] = None,
                                       filters: Optional[Sequence[Union['GetMlApplicationImplementationsFilterArgs', 'GetMlApplicationImplementationsFilterArgsDict']]] = None,
                                       ml_application_id: Optional[builtins.str] = None,
                                       ml_application_implementation_id: Optional[builtins.str] = None,
                                       name: Optional[builtins.str] = None,
                                       state: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMlApplicationImplementationsResult:
    """
    This data source provides the list of Ml Application Implementations in Oracle Cloud Infrastructure Data Science service.

    Returns a list of MlApplicationImplementations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ml_application_implementations = oci.DataScience.get_ml_application_implementations(compartment_id=compartment_id,
        compartment_id_in_subtree=ml_application_implementation_compartment_id_in_subtree,
        ml_application_id=test_ml_application["id"],
        ml_application_implementation_id=test_ml_application_implementation["id"],
        name=ml_application_implementation_name,
        state=ml_application_implementation_state)
    ```


    :param builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.bool compartment_id_in_subtree: If it is true search must include all results from descendant compartments. Value true is allowed only if compartmentId refers to root compartment.
    :param builtins.str ml_application_id: unique MlApplication identifier
    :param builtins.str ml_application_implementation_id: unique MlApplicationImplementation identifier
    :param builtins.str name: A filter to return only resources that match the entire name given.
    :param builtins.str state: A filter to return only resources with lifecycleState matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['mlApplicationId'] = ml_application_id
    __args__['mlApplicationImplementationId'] = ml_application_implementation_id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getMlApplicationImplementations:getMlApplicationImplementations', __args__, opts=opts, typ=GetMlApplicationImplementationsResult).value

    return AwaitableGetMlApplicationImplementationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ml_application_id=pulumi.get(__ret__, 'ml_application_id'),
        ml_application_implementation_collections=pulumi.get(__ret__, 'ml_application_implementation_collections'),
        ml_application_implementation_id=pulumi.get(__ret__, 'ml_application_implementation_id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_ml_application_implementations_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                              compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMlApplicationImplementationsFilterArgs', 'GetMlApplicationImplementationsFilterArgsDict']]]]] = None,
                                              ml_application_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              ml_application_implementation_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMlApplicationImplementationsResult]:
    """
    This data source provides the list of Ml Application Implementations in Oracle Cloud Infrastructure Data Science service.

    Returns a list of MlApplicationImplementations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ml_application_implementations = oci.DataScience.get_ml_application_implementations(compartment_id=compartment_id,
        compartment_id_in_subtree=ml_application_implementation_compartment_id_in_subtree,
        ml_application_id=test_ml_application["id"],
        ml_application_implementation_id=test_ml_application_implementation["id"],
        name=ml_application_implementation_name,
        state=ml_application_implementation_state)
    ```


    :param builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.bool compartment_id_in_subtree: If it is true search must include all results from descendant compartments. Value true is allowed only if compartmentId refers to root compartment.
    :param builtins.str ml_application_id: unique MlApplication identifier
    :param builtins.str ml_application_implementation_id: unique MlApplicationImplementation identifier
    :param builtins.str name: A filter to return only resources that match the entire name given.
    :param builtins.str state: A filter to return only resources with lifecycleState matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['mlApplicationId'] = ml_application_id
    __args__['mlApplicationImplementationId'] = ml_application_implementation_id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getMlApplicationImplementations:getMlApplicationImplementations', __args__, opts=opts, typ=GetMlApplicationImplementationsResult)
    return __ret__.apply(lambda __response__: GetMlApplicationImplementationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ml_application_id=pulumi.get(__response__, 'ml_application_id'),
        ml_application_implementation_collections=pulumi.get(__response__, 'ml_application_implementation_collections'),
        ml_application_implementation_id=pulumi.get(__response__, 'ml_application_implementation_id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
