# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BuildRunArgs', 'BuildRun']

@pulumi.input_type
class BuildRunArgs:
    def __init__(__self__, *,
                 build_pipeline_id: pulumi.Input[builtins.str],
                 build_run_arguments: Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']] = None,
                 commit_info: Optional[pulumi.Input['BuildRunCommitInfoArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a BuildRun resource.
        :param pulumi.Input[builtins.str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input['BuildRunBuildRunArgumentsArgs'] build_run_arguments: Specifies list of arguments passed along with the build run.
        :param pulumi.Input['BuildRunCommitInfoArgs'] commit_info: Commit details that need to be used for the build run.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "build_pipeline_id", build_pipeline_id)
        if build_run_arguments is not None:
            pulumi.set(__self__, "build_run_arguments", build_run_arguments)
        if commit_info is not None:
            pulumi.set(__self__, "commit_info", commit_info)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @build_pipeline_id.setter
    def build_pipeline_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "build_pipeline_id", value)

    @property
    @pulumi.getter(name="buildRunArguments")
    def build_run_arguments(self) -> Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']]:
        """
        Specifies list of arguments passed along with the build run.
        """
        return pulumi.get(self, "build_run_arguments")

    @build_run_arguments.setter
    def build_run_arguments(self, value: Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']]):
        pulumi.set(self, "build_run_arguments", value)

    @property
    @pulumi.getter(name="commitInfo")
    def commit_info(self) -> Optional[pulumi.Input['BuildRunCommitInfoArgs']]:
        """
        Commit details that need to be used for the build run.
        """
        return pulumi.get(self, "commit_info")

    @commit_info.setter
    def commit_info(self, value: Optional[pulumi.Input['BuildRunCommitInfoArgs']]):
        pulumi.set(self, "commit_info", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _BuildRunState:
    def __init__(__self__, *,
                 build_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildOutputArgs']]]] = None,
                 build_pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                 build_run_arguments: Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']] = None,
                 build_run_progresses: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunProgressArgs']]]] = None,
                 build_run_sources: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunSourceArgs']]]] = None,
                 commit_info: Optional[pulumi.Input['BuildRunCommitInfoArgs']] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BuildRun resources.
        :param pulumi.Input[Sequence[pulumi.Input['BuildRunBuildOutputArgs']]] build_outputs: Outputs from the build.
        :param pulumi.Input[builtins.str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input['BuildRunBuildRunArgumentsArgs'] build_run_arguments: Specifies list of arguments passed along with the build run.
        :param pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunProgressArgs']]] build_run_progresses: The run progress details of a build run.
        :param pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunSourceArgs']]] build_run_sources: The source from which the build run is triggered.
        :param pulumi.Input['BuildRunCommitInfoArgs'] commit_info: Commit details that need to be used for the build run.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment where the build is running.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[builtins.str] project_id: The OCID of the DevOps project.
        :param pulumi.Input[builtins.str] state: The current state of the build run.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the build run was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: The time the build run was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        if build_outputs is not None:
            pulumi.set(__self__, "build_outputs", build_outputs)
        if build_pipeline_id is not None:
            pulumi.set(__self__, "build_pipeline_id", build_pipeline_id)
        if build_run_arguments is not None:
            pulumi.set(__self__, "build_run_arguments", build_run_arguments)
        if build_run_progresses is not None:
            pulumi.set(__self__, "build_run_progresses", build_run_progresses)
        if build_run_sources is not None:
            pulumi.set(__self__, "build_run_sources", build_run_sources)
        if commit_info is not None:
            pulumi.set(__self__, "commit_info", commit_info)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="buildOutputs")
    def build_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildOutputArgs']]]]:
        """
        Outputs from the build.
        """
        return pulumi.get(self, "build_outputs")

    @build_outputs.setter
    def build_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildOutputArgs']]]]):
        pulumi.set(self, "build_outputs", value)

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @build_pipeline_id.setter
    def build_pipeline_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "build_pipeline_id", value)

    @property
    @pulumi.getter(name="buildRunArguments")
    def build_run_arguments(self) -> Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']]:
        """
        Specifies list of arguments passed along with the build run.
        """
        return pulumi.get(self, "build_run_arguments")

    @build_run_arguments.setter
    def build_run_arguments(self, value: Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']]):
        pulumi.set(self, "build_run_arguments", value)

    @property
    @pulumi.getter(name="buildRunProgresses")
    def build_run_progresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunProgressArgs']]]]:
        """
        The run progress details of a build run.
        """
        return pulumi.get(self, "build_run_progresses")

    @build_run_progresses.setter
    def build_run_progresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunProgressArgs']]]]):
        pulumi.set(self, "build_run_progresses", value)

    @property
    @pulumi.getter(name="buildRunSources")
    def build_run_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunSourceArgs']]]]:
        """
        The source from which the build run is triggered.
        """
        return pulumi.get(self, "build_run_sources")

    @build_run_sources.setter
    def build_run_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunSourceArgs']]]]):
        pulumi.set(self, "build_run_sources", value)

    @property
    @pulumi.getter(name="commitInfo")
    def commit_info(self) -> Optional[pulumi.Input['BuildRunCommitInfoArgs']]:
        """
        Commit details that need to be used for the build run.
        """
        return pulumi.get(self, "commit_info")

    @commit_info.setter
    def commit_info(self, value: Optional[pulumi.Input['BuildRunCommitInfoArgs']]):
        pulumi.set(self, "commit_info", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the compartment where the build is running.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the build run.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the build run was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the build run was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class BuildRun(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                 build_run_arguments: Optional[pulumi.Input[Union['BuildRunBuildRunArgumentsArgs', 'BuildRunBuildRunArgumentsArgsDict']]] = None,
                 commit_info: Optional[pulumi.Input[Union['BuildRunCommitInfoArgs', 'BuildRunCommitInfoArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Build Run resource in Oracle Cloud Infrastructure Devops service.

        Starts a build pipeline run for a predefined build pipeline. Please ensure the completion of any work request for creation/updation of Build Pipeline before starting a Build Run.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_build_run = oci.dev_ops.BuildRun("test_build_run",
            build_pipeline_id=test_build_pipeline["id"],
            build_run_arguments={
                "items": [{
                    "name": build_run_build_run_arguments_items_name,
                    "value": build_run_build_run_arguments_items_value,
                }],
            },
            commit_info={
                "commit_hash": build_run_commit_info_commit_hash,
                "repository_branch": build_run_commit_info_repository_branch,
                "repository_url": build_run_commit_info_repository_url,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=build_run_display_name,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        BuildRuns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/buildRun:BuildRun test_build_run "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input[Union['BuildRunBuildRunArgumentsArgs', 'BuildRunBuildRunArgumentsArgsDict']] build_run_arguments: Specifies list of arguments passed along with the build run.
        :param pulumi.Input[Union['BuildRunCommitInfoArgs', 'BuildRunCommitInfoArgsDict']] commit_info: Commit details that need to be used for the build run.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BuildRunArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Build Run resource in Oracle Cloud Infrastructure Devops service.

        Starts a build pipeline run for a predefined build pipeline. Please ensure the completion of any work request for creation/updation of Build Pipeline before starting a Build Run.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_build_run = oci.dev_ops.BuildRun("test_build_run",
            build_pipeline_id=test_build_pipeline["id"],
            build_run_arguments={
                "items": [{
                    "name": build_run_build_run_arguments_items_name,
                    "value": build_run_build_run_arguments_items_value,
                }],
            },
            commit_info={
                "commit_hash": build_run_commit_info_commit_hash,
                "repository_branch": build_run_commit_info_repository_branch,
                "repository_url": build_run_commit_info_repository_url,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=build_run_display_name,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        BuildRuns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/buildRun:BuildRun test_build_run "id"
        ```

        :param str resource_name: The name of the resource.
        :param BuildRunArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BuildRunArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                 build_run_arguments: Optional[pulumi.Input[Union['BuildRunBuildRunArgumentsArgs', 'BuildRunBuildRunArgumentsArgsDict']]] = None,
                 commit_info: Optional[pulumi.Input[Union['BuildRunCommitInfoArgs', 'BuildRunCommitInfoArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BuildRunArgs.__new__(BuildRunArgs)

            if build_pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'build_pipeline_id'")
            __props__.__dict__["build_pipeline_id"] = build_pipeline_id
            __props__.__dict__["build_run_arguments"] = build_run_arguments
            __props__.__dict__["commit_info"] = commit_info
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["build_outputs"] = None
            __props__.__dict__["build_run_progresses"] = None
            __props__.__dict__["build_run_sources"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(BuildRun, __self__).__init__(
            'oci:DevOps/buildRun:BuildRun',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            build_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BuildRunBuildOutputArgs', 'BuildRunBuildOutputArgsDict']]]]] = None,
            build_pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
            build_run_arguments: Optional[pulumi.Input[Union['BuildRunBuildRunArgumentsArgs', 'BuildRunBuildRunArgumentsArgsDict']]] = None,
            build_run_progresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BuildRunBuildRunProgressArgs', 'BuildRunBuildRunProgressArgsDict']]]]] = None,
            build_run_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BuildRunBuildRunSourceArgs', 'BuildRunBuildRunSourceArgsDict']]]]] = None,
            commit_info: Optional[pulumi.Input[Union['BuildRunCommitInfoArgs', 'BuildRunCommitInfoArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'BuildRun':
        """
        Get an existing BuildRun resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BuildRunBuildOutputArgs', 'BuildRunBuildOutputArgsDict']]]] build_outputs: Outputs from the build.
        :param pulumi.Input[builtins.str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input[Union['BuildRunBuildRunArgumentsArgs', 'BuildRunBuildRunArgumentsArgsDict']] build_run_arguments: Specifies list of arguments passed along with the build run.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BuildRunBuildRunProgressArgs', 'BuildRunBuildRunProgressArgsDict']]]] build_run_progresses: The run progress details of a build run.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BuildRunBuildRunSourceArgs', 'BuildRunBuildRunSourceArgsDict']]]] build_run_sources: The source from which the build run is triggered.
        :param pulumi.Input[Union['BuildRunCommitInfoArgs', 'BuildRunCommitInfoArgsDict']] commit_info: Commit details that need to be used for the build run.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment where the build is running.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[builtins.str] project_id: The OCID of the DevOps project.
        :param pulumi.Input[builtins.str] state: The current state of the build run.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the build run was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: The time the build run was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BuildRunState.__new__(_BuildRunState)

        __props__.__dict__["build_outputs"] = build_outputs
        __props__.__dict__["build_pipeline_id"] = build_pipeline_id
        __props__.__dict__["build_run_arguments"] = build_run_arguments
        __props__.__dict__["build_run_progresses"] = build_run_progresses
        __props__.__dict__["build_run_sources"] = build_run_sources
        __props__.__dict__["commit_info"] = commit_info
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return BuildRun(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="buildOutputs")
    def build_outputs(self) -> pulumi.Output[Sequence['outputs.BuildRunBuildOutput']]:
        """
        Outputs from the build.
        """
        return pulumi.get(self, "build_outputs")

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @property
    @pulumi.getter(name="buildRunArguments")
    def build_run_arguments(self) -> pulumi.Output['outputs.BuildRunBuildRunArguments']:
        """
        Specifies list of arguments passed along with the build run.
        """
        return pulumi.get(self, "build_run_arguments")

    @property
    @pulumi.getter(name="buildRunProgresses")
    def build_run_progresses(self) -> pulumi.Output[Sequence['outputs.BuildRunBuildRunProgress']]:
        """
        The run progress details of a build run.
        """
        return pulumi.get(self, "build_run_progresses")

    @property
    @pulumi.getter(name="buildRunSources")
    def build_run_sources(self) -> pulumi.Output[Sequence['outputs.BuildRunBuildRunSource']]:
        """
        The source from which the build run is triggered.
        """
        return pulumi.get(self, "build_run_sources")

    @property
    @pulumi.getter(name="commitInfo")
    def commit_info(self) -> pulumi.Output['outputs.BuildRunCommitInfo']:
        """
        Commit details that need to be used for the build run.
        """
        return pulumi.get(self, "commit_info")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the compartment where the build is running.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the build run.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the build run was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the build run was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

