# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetShardedDatabaseResult',
    'AwaitableGetShardedDatabaseResult',
    'get_sharded_database',
    'get_sharded_database_output',
]

@pulumi.output_type
class GetShardedDatabaseResult:
    """
    A collection of values returned by getShardedDatabase.
    """
    def __init__(__self__, ca_signed_certificate=None, catalog_details=None, character_set=None, chunks=None, cluster_certificate_common_name=None, compartment_id=None, configure_gsms_trigger=None, configure_gsms_trigger_is_latest_gsm_image=None, configure_gsms_trigger_old_gsm_names=None, configure_sharding_trigger=None, connection_strings=None, db_deployment_type=None, db_version=None, db_workload=None, defined_tags=None, display_name=None, download_gsm_certificate_signing_request_trigger=None, freeform_tags=None, generate_gsm_certificate_signing_request_trigger=None, generate_wallet_password=None, generate_wallet_trigger=None, get_connection_string_trigger=None, gsms=None, id=None, lifecycle_state=None, lifecycle_state_details=None, listener_port=None, listener_port_tls=None, metadata=None, ncharacter_set=None, ons_port_local=None, ons_port_remote=None, patch_operations=None, prefix=None, private_endpoint=None, replication_factor=None, replication_method=None, replication_unit=None, shard_details=None, sharded_database_id=None, sharding_method=None, start_database_trigger=None, state=None, stop_database_trigger=None, system_tags=None, time_created=None, time_updated=None, time_zone=None, upload_signed_certificate_and_generate_wallet_trigger=None, validate_network_trigger=None):
        if ca_signed_certificate and not isinstance(ca_signed_certificate, str):
            raise TypeError("Expected argument 'ca_signed_certificate' to be a str")
        pulumi.set(__self__, "ca_signed_certificate", ca_signed_certificate)
        if catalog_details and not isinstance(catalog_details, list):
            raise TypeError("Expected argument 'catalog_details' to be a list")
        pulumi.set(__self__, "catalog_details", catalog_details)
        if character_set and not isinstance(character_set, str):
            raise TypeError("Expected argument 'character_set' to be a str")
        pulumi.set(__self__, "character_set", character_set)
        if chunks and not isinstance(chunks, int):
            raise TypeError("Expected argument 'chunks' to be a int")
        pulumi.set(__self__, "chunks", chunks)
        if cluster_certificate_common_name and not isinstance(cluster_certificate_common_name, str):
            raise TypeError("Expected argument 'cluster_certificate_common_name' to be a str")
        pulumi.set(__self__, "cluster_certificate_common_name", cluster_certificate_common_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configure_gsms_trigger and not isinstance(configure_gsms_trigger, int):
            raise TypeError("Expected argument 'configure_gsms_trigger' to be a int")
        pulumi.set(__self__, "configure_gsms_trigger", configure_gsms_trigger)
        if configure_gsms_trigger_is_latest_gsm_image and not isinstance(configure_gsms_trigger_is_latest_gsm_image, bool):
            raise TypeError("Expected argument 'configure_gsms_trigger_is_latest_gsm_image' to be a bool")
        pulumi.set(__self__, "configure_gsms_trigger_is_latest_gsm_image", configure_gsms_trigger_is_latest_gsm_image)
        if configure_gsms_trigger_old_gsm_names and not isinstance(configure_gsms_trigger_old_gsm_names, list):
            raise TypeError("Expected argument 'configure_gsms_trigger_old_gsm_names' to be a list")
        pulumi.set(__self__, "configure_gsms_trigger_old_gsm_names", configure_gsms_trigger_old_gsm_names)
        if configure_sharding_trigger and not isinstance(configure_sharding_trigger, int):
            raise TypeError("Expected argument 'configure_sharding_trigger' to be a int")
        pulumi.set(__self__, "configure_sharding_trigger", configure_sharding_trigger)
        if connection_strings and not isinstance(connection_strings, list):
            raise TypeError("Expected argument 'connection_strings' to be a list")
        pulumi.set(__self__, "connection_strings", connection_strings)
        if db_deployment_type and not isinstance(db_deployment_type, str):
            raise TypeError("Expected argument 'db_deployment_type' to be a str")
        pulumi.set(__self__, "db_deployment_type", db_deployment_type)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if db_workload and not isinstance(db_workload, str):
            raise TypeError("Expected argument 'db_workload' to be a str")
        pulumi.set(__self__, "db_workload", db_workload)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if download_gsm_certificate_signing_request_trigger and not isinstance(download_gsm_certificate_signing_request_trigger, int):
            raise TypeError("Expected argument 'download_gsm_certificate_signing_request_trigger' to be a int")
        pulumi.set(__self__, "download_gsm_certificate_signing_request_trigger", download_gsm_certificate_signing_request_trigger)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if generate_gsm_certificate_signing_request_trigger and not isinstance(generate_gsm_certificate_signing_request_trigger, int):
            raise TypeError("Expected argument 'generate_gsm_certificate_signing_request_trigger' to be a int")
        pulumi.set(__self__, "generate_gsm_certificate_signing_request_trigger", generate_gsm_certificate_signing_request_trigger)
        if generate_wallet_password and not isinstance(generate_wallet_password, str):
            raise TypeError("Expected argument 'generate_wallet_password' to be a str")
        pulumi.set(__self__, "generate_wallet_password", generate_wallet_password)
        if generate_wallet_trigger and not isinstance(generate_wallet_trigger, int):
            raise TypeError("Expected argument 'generate_wallet_trigger' to be a int")
        pulumi.set(__self__, "generate_wallet_trigger", generate_wallet_trigger)
        if get_connection_string_trigger and not isinstance(get_connection_string_trigger, int):
            raise TypeError("Expected argument 'get_connection_string_trigger' to be a int")
        pulumi.set(__self__, "get_connection_string_trigger", get_connection_string_trigger)
        if gsms and not isinstance(gsms, list):
            raise TypeError("Expected argument 'gsms' to be a list")
        pulumi.set(__self__, "gsms", gsms)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_state and not isinstance(lifecycle_state, str):
            raise TypeError("Expected argument 'lifecycle_state' to be a str")
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if lifecycle_state_details and not isinstance(lifecycle_state_details, str):
            raise TypeError("Expected argument 'lifecycle_state_details' to be a str")
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if listener_port and not isinstance(listener_port, int):
            raise TypeError("Expected argument 'listener_port' to be a int")
        pulumi.set(__self__, "listener_port", listener_port)
        if listener_port_tls and not isinstance(listener_port_tls, int):
            raise TypeError("Expected argument 'listener_port_tls' to be a int")
        pulumi.set(__self__, "listener_port_tls", listener_port_tls)
        if metadata and not isinstance(metadata, str):
            raise TypeError("Expected argument 'metadata' to be a str")
        pulumi.set(__self__, "metadata", metadata)
        if ncharacter_set and not isinstance(ncharacter_set, str):
            raise TypeError("Expected argument 'ncharacter_set' to be a str")
        pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        if ons_port_local and not isinstance(ons_port_local, int):
            raise TypeError("Expected argument 'ons_port_local' to be a int")
        pulumi.set(__self__, "ons_port_local", ons_port_local)
        if ons_port_remote and not isinstance(ons_port_remote, int):
            raise TypeError("Expected argument 'ons_port_remote' to be a int")
        pulumi.set(__self__, "ons_port_remote", ons_port_remote)
        if patch_operations and not isinstance(patch_operations, list):
            raise TypeError("Expected argument 'patch_operations' to be a list")
        pulumi.set(__self__, "patch_operations", patch_operations)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)
        if private_endpoint and not isinstance(private_endpoint, str):
            raise TypeError("Expected argument 'private_endpoint' to be a str")
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        if replication_factor and not isinstance(replication_factor, int):
            raise TypeError("Expected argument 'replication_factor' to be a int")
        pulumi.set(__self__, "replication_factor", replication_factor)
        if replication_method and not isinstance(replication_method, str):
            raise TypeError("Expected argument 'replication_method' to be a str")
        pulumi.set(__self__, "replication_method", replication_method)
        if replication_unit and not isinstance(replication_unit, int):
            raise TypeError("Expected argument 'replication_unit' to be a int")
        pulumi.set(__self__, "replication_unit", replication_unit)
        if shard_details and not isinstance(shard_details, list):
            raise TypeError("Expected argument 'shard_details' to be a list")
        pulumi.set(__self__, "shard_details", shard_details)
        if sharded_database_id and not isinstance(sharded_database_id, str):
            raise TypeError("Expected argument 'sharded_database_id' to be a str")
        pulumi.set(__self__, "sharded_database_id", sharded_database_id)
        if sharding_method and not isinstance(sharding_method, str):
            raise TypeError("Expected argument 'sharding_method' to be a str")
        pulumi.set(__self__, "sharding_method", sharding_method)
        if start_database_trigger and not isinstance(start_database_trigger, int):
            raise TypeError("Expected argument 'start_database_trigger' to be a int")
        pulumi.set(__self__, "start_database_trigger", start_database_trigger)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stop_database_trigger and not isinstance(stop_database_trigger, int):
            raise TypeError("Expected argument 'stop_database_trigger' to be a int")
        pulumi.set(__self__, "stop_database_trigger", stop_database_trigger)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)
        if upload_signed_certificate_and_generate_wallet_trigger and not isinstance(upload_signed_certificate_and_generate_wallet_trigger, int):
            raise TypeError("Expected argument 'upload_signed_certificate_and_generate_wallet_trigger' to be a int")
        pulumi.set(__self__, "upload_signed_certificate_and_generate_wallet_trigger", upload_signed_certificate_and_generate_wallet_trigger)
        if validate_network_trigger and not isinstance(validate_network_trigger, int):
            raise TypeError("Expected argument 'validate_network_trigger' to be a int")
        pulumi.set(__self__, "validate_network_trigger", validate_network_trigger)

    @property
    @pulumi.getter(name="caSignedCertificate")
    def ca_signed_certificate(self) -> builtins.str:
        return pulumi.get(self, "ca_signed_certificate")

    @property
    @pulumi.getter(name="catalogDetails")
    def catalog_details(self) -> Sequence['outputs.GetShardedDatabaseCatalogDetailResult']:
        """
        Details of ATP-D based catalogs.
        """
        return pulumi.get(self, "catalog_details")

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> builtins.str:
        """
        The character set for the database.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter
    def chunks(self) -> builtins.int:
        """
        The default number of unique chunks in a shardspace. The value of chunks must be greater than 2 times the size of the largest shardgroup in any shardspace.
        """
        return pulumi.get(self, "chunks")

    @property
    @pulumi.getter(name="clusterCertificateCommonName")
    def cluster_certificate_common_name(self) -> builtins.str:
        """
        The certificate common name used in all cloudAutonomousVmClusters for the sharded database topology. Eg. Production. All the clusters used in one sharded database topology shall have same CABundle setup. Valid characterset for clusterCertificateCommonName include uppercase or lowercase letters, numbers, hyphens, underscores, and period.
        """
        return pulumi.get(self, "cluster_certificate_common_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Identifier of the compartment in which sharded database exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configureGsmsTrigger")
    def configure_gsms_trigger(self) -> builtins.int:
        return pulumi.get(self, "configure_gsms_trigger")

    @property
    @pulumi.getter(name="configureGsmsTriggerIsLatestGsmImage")
    def configure_gsms_trigger_is_latest_gsm_image(self) -> builtins.bool:
        return pulumi.get(self, "configure_gsms_trigger_is_latest_gsm_image")

    @property
    @pulumi.getter(name="configureGsmsTriggerOldGsmNames")
    def configure_gsms_trigger_old_gsm_names(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "configure_gsms_trigger_old_gsm_names")

    @property
    @pulumi.getter(name="configureShardingTrigger")
    def configure_sharding_trigger(self) -> builtins.int:
        return pulumi.get(self, "configure_sharding_trigger")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Sequence['outputs.GetShardedDatabaseConnectionStringResult']:
        """
        Details of sharded database connection String.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter(name="dbDeploymentType")
    def db_deployment_type(self) -> builtins.str:
        """
        The database deployment type.
        """
        return pulumi.get(self, "db_deployment_type")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> builtins.str:
        """
        Oracle Database version number.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> builtins.str:
        """
        Possible workload types.
        """
        return pulumi.get(self, "db_workload")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Oracle sharded database display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="downloadGsmCertificateSigningRequestTrigger")
    def download_gsm_certificate_signing_request_trigger(self) -> builtins.int:
        return pulumi.get(self, "download_gsm_certificate_signing_request_trigger")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="generateGsmCertificateSigningRequestTrigger")
    def generate_gsm_certificate_signing_request_trigger(self) -> builtins.int:
        return pulumi.get(self, "generate_gsm_certificate_signing_request_trigger")

    @property
    @pulumi.getter(name="generateWalletPassword")
    def generate_wallet_password(self) -> builtins.str:
        return pulumi.get(self, "generate_wallet_password")

    @property
    @pulumi.getter(name="generateWalletTrigger")
    def generate_wallet_trigger(self) -> builtins.int:
        return pulumi.get(self, "generate_wallet_trigger")

    @property
    @pulumi.getter(name="getConnectionStringTrigger")
    def get_connection_string_trigger(self) -> builtins.int:
        return pulumi.get(self, "get_connection_string_trigger")

    @property
    @pulumi.getter
    def gsms(self) -> Sequence['outputs.GetShardedDatabaseGsmResult']:
        """
        Details of GSM instances for the sharded database.
        """
        return pulumi.get(self, "gsms")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Sharded Database identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> builtins.str:
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> builtins.str:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> builtins.int:
        """
        The GSM listener port number.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerPortTls")
    def listener_port_tls(self) -> builtins.int:
        """
        The TLS listener port number for sharded database.
        """
        return pulumi.get(self, "listener_port_tls")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[builtins.str]:
        """
        Additional metadata related to shard's underlying supporting resource.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> builtins.str:
        """
        The national character set for the database.
        """
        return pulumi.get(self, "ncharacter_set")

    @property
    @pulumi.getter(name="onsPortLocal")
    def ons_port_local(self) -> builtins.int:
        """
        Ons local port number.
        """
        return pulumi.get(self, "ons_port_local")

    @property
    @pulumi.getter(name="onsPortRemote")
    def ons_port_remote(self) -> builtins.int:
        """
        Ons remote port number.
        """
        return pulumi.get(self, "ons_port_remote")

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Sequence['outputs.GetShardedDatabasePatchOperationResult']:
        return pulumi.get(self, "patch_operations")

    @property
    @pulumi.getter
    def prefix(self) -> builtins.str:
        """
        Unique prefix for the sharded database.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> builtins.str:
        """
        The OCID of private endpoint being used by the sharded database.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> builtins.int:
        """
        The Replication factor for RAFT replication based sharded database. Currently supported values are 3, 5 and 7.
        """
        return pulumi.get(self, "replication_factor")

    @property
    @pulumi.getter(name="replicationMethod")
    def replication_method(self) -> builtins.str:
        """
        The Replication method for sharded database. Use RAFT for Raft replication, and DG for DataGuard. If replicationMethod is not provided, it defaults to DG.
        """
        return pulumi.get(self, "replication_method")

    @property
    @pulumi.getter(name="replicationUnit")
    def replication_unit(self) -> builtins.int:
        """
        For RAFT replication based sharded database, the value should be atleast twice the number of shards.
        """
        return pulumi.get(self, "replication_unit")

    @property
    @pulumi.getter(name="shardDetails")
    def shard_details(self) -> Sequence['outputs.GetShardedDatabaseShardDetailResult']:
        """
        Details of ATP-D based shards.
        """
        return pulumi.get(self, "shard_details")

    @property
    @pulumi.getter(name="shardedDatabaseId")
    def sharded_database_id(self) -> builtins.str:
        return pulumi.get(self, "sharded_database_id")

    @property
    @pulumi.getter(name="shardingMethod")
    def sharding_method(self) -> builtins.str:
        """
        Sharding Method.
        """
        return pulumi.get(self, "sharding_method")

    @property
    @pulumi.getter(name="startDatabaseTrigger")
    def start_database_trigger(self) -> builtins.int:
        return pulumi.get(self, "start_database_trigger")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Lifecycle states for sharded databases.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stopDatabaseTrigger")
    def stop_database_trigger(self) -> builtins.int:
        return pulumi.get(self, "stop_database_trigger")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        Timezone associated with the sharded database.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="uploadSignedCertificateAndGenerateWalletTrigger")
    def upload_signed_certificate_and_generate_wallet_trigger(self) -> builtins.int:
        return pulumi.get(self, "upload_signed_certificate_and_generate_wallet_trigger")

    @property
    @pulumi.getter(name="validateNetworkTrigger")
    def validate_network_trigger(self) -> builtins.int:
        return pulumi.get(self, "validate_network_trigger")


class AwaitableGetShardedDatabaseResult(GetShardedDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetShardedDatabaseResult(
            ca_signed_certificate=self.ca_signed_certificate,
            catalog_details=self.catalog_details,
            character_set=self.character_set,
            chunks=self.chunks,
            cluster_certificate_common_name=self.cluster_certificate_common_name,
            compartment_id=self.compartment_id,
            configure_gsms_trigger=self.configure_gsms_trigger,
            configure_gsms_trigger_is_latest_gsm_image=self.configure_gsms_trigger_is_latest_gsm_image,
            configure_gsms_trigger_old_gsm_names=self.configure_gsms_trigger_old_gsm_names,
            configure_sharding_trigger=self.configure_sharding_trigger,
            connection_strings=self.connection_strings,
            db_deployment_type=self.db_deployment_type,
            db_version=self.db_version,
            db_workload=self.db_workload,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            download_gsm_certificate_signing_request_trigger=self.download_gsm_certificate_signing_request_trigger,
            freeform_tags=self.freeform_tags,
            generate_gsm_certificate_signing_request_trigger=self.generate_gsm_certificate_signing_request_trigger,
            generate_wallet_password=self.generate_wallet_password,
            generate_wallet_trigger=self.generate_wallet_trigger,
            get_connection_string_trigger=self.get_connection_string_trigger,
            gsms=self.gsms,
            id=self.id,
            lifecycle_state=self.lifecycle_state,
            lifecycle_state_details=self.lifecycle_state_details,
            listener_port=self.listener_port,
            listener_port_tls=self.listener_port_tls,
            metadata=self.metadata,
            ncharacter_set=self.ncharacter_set,
            ons_port_local=self.ons_port_local,
            ons_port_remote=self.ons_port_remote,
            patch_operations=self.patch_operations,
            prefix=self.prefix,
            private_endpoint=self.private_endpoint,
            replication_factor=self.replication_factor,
            replication_method=self.replication_method,
            replication_unit=self.replication_unit,
            shard_details=self.shard_details,
            sharded_database_id=self.sharded_database_id,
            sharding_method=self.sharding_method,
            start_database_trigger=self.start_database_trigger,
            state=self.state,
            stop_database_trigger=self.stop_database_trigger,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            time_zone=self.time_zone,
            upload_signed_certificate_and_generate_wallet_trigger=self.upload_signed_certificate_and_generate_wallet_trigger,
            validate_network_trigger=self.validate_network_trigger)


def get_sharded_database(metadata: Optional[builtins.str] = None,
                         sharded_database_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetShardedDatabaseResult:
    """
    This data source provides details about a specific Sharded Database resource in Oracle Cloud Infrastructure Globally Distributed Database service.

    Gets the details of the Sharded database identified by given id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sharded_database = oci.GloballyDistributedDatabase.get_sharded_database(sharded_database_id=test_sharded_database_oci_globally_distributed_database_sharded_database["id"],
        metadata=sharded_database_metadata)
    ```


    :param builtins.str metadata: Comma separated names of argument corresponding to which metadata need to be retrived, namely VM_CLUSTER_INFO, ADDITIONAL_RESOURCE_INFO. An example is metadata=VM_CLUSTER_INFO,ADDITIONAL_RESOURCE_INFO.
    :param builtins.str sharded_database_id: Sharded Database identifier
    """
    __args__ = dict()
    __args__['metadata'] = metadata
    __args__['shardedDatabaseId'] = sharded_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GloballyDistributedDatabase/getShardedDatabase:getShardedDatabase', __args__, opts=opts, typ=GetShardedDatabaseResult).value

    return AwaitableGetShardedDatabaseResult(
        ca_signed_certificate=pulumi.get(__ret__, 'ca_signed_certificate'),
        catalog_details=pulumi.get(__ret__, 'catalog_details'),
        character_set=pulumi.get(__ret__, 'character_set'),
        chunks=pulumi.get(__ret__, 'chunks'),
        cluster_certificate_common_name=pulumi.get(__ret__, 'cluster_certificate_common_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configure_gsms_trigger=pulumi.get(__ret__, 'configure_gsms_trigger'),
        configure_gsms_trigger_is_latest_gsm_image=pulumi.get(__ret__, 'configure_gsms_trigger_is_latest_gsm_image'),
        configure_gsms_trigger_old_gsm_names=pulumi.get(__ret__, 'configure_gsms_trigger_old_gsm_names'),
        configure_sharding_trigger=pulumi.get(__ret__, 'configure_sharding_trigger'),
        connection_strings=pulumi.get(__ret__, 'connection_strings'),
        db_deployment_type=pulumi.get(__ret__, 'db_deployment_type'),
        db_version=pulumi.get(__ret__, 'db_version'),
        db_workload=pulumi.get(__ret__, 'db_workload'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        download_gsm_certificate_signing_request_trigger=pulumi.get(__ret__, 'download_gsm_certificate_signing_request_trigger'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        generate_gsm_certificate_signing_request_trigger=pulumi.get(__ret__, 'generate_gsm_certificate_signing_request_trigger'),
        generate_wallet_password=pulumi.get(__ret__, 'generate_wallet_password'),
        generate_wallet_trigger=pulumi.get(__ret__, 'generate_wallet_trigger'),
        get_connection_string_trigger=pulumi.get(__ret__, 'get_connection_string_trigger'),
        gsms=pulumi.get(__ret__, 'gsms'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_state=pulumi.get(__ret__, 'lifecycle_state'),
        lifecycle_state_details=pulumi.get(__ret__, 'lifecycle_state_details'),
        listener_port=pulumi.get(__ret__, 'listener_port'),
        listener_port_tls=pulumi.get(__ret__, 'listener_port_tls'),
        metadata=pulumi.get(__ret__, 'metadata'),
        ncharacter_set=pulumi.get(__ret__, 'ncharacter_set'),
        ons_port_local=pulumi.get(__ret__, 'ons_port_local'),
        ons_port_remote=pulumi.get(__ret__, 'ons_port_remote'),
        patch_operations=pulumi.get(__ret__, 'patch_operations'),
        prefix=pulumi.get(__ret__, 'prefix'),
        private_endpoint=pulumi.get(__ret__, 'private_endpoint'),
        replication_factor=pulumi.get(__ret__, 'replication_factor'),
        replication_method=pulumi.get(__ret__, 'replication_method'),
        replication_unit=pulumi.get(__ret__, 'replication_unit'),
        shard_details=pulumi.get(__ret__, 'shard_details'),
        sharded_database_id=pulumi.get(__ret__, 'sharded_database_id'),
        sharding_method=pulumi.get(__ret__, 'sharding_method'),
        start_database_trigger=pulumi.get(__ret__, 'start_database_trigger'),
        state=pulumi.get(__ret__, 'state'),
        stop_database_trigger=pulumi.get(__ret__, 'stop_database_trigger'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        time_zone=pulumi.get(__ret__, 'time_zone'),
        upload_signed_certificate_and_generate_wallet_trigger=pulumi.get(__ret__, 'upload_signed_certificate_and_generate_wallet_trigger'),
        validate_network_trigger=pulumi.get(__ret__, 'validate_network_trigger'))
def get_sharded_database_output(metadata: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                sharded_database_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetShardedDatabaseResult]:
    """
    This data source provides details about a specific Sharded Database resource in Oracle Cloud Infrastructure Globally Distributed Database service.

    Gets the details of the Sharded database identified by given id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sharded_database = oci.GloballyDistributedDatabase.get_sharded_database(sharded_database_id=test_sharded_database_oci_globally_distributed_database_sharded_database["id"],
        metadata=sharded_database_metadata)
    ```


    :param builtins.str metadata: Comma separated names of argument corresponding to which metadata need to be retrived, namely VM_CLUSTER_INFO, ADDITIONAL_RESOURCE_INFO. An example is metadata=VM_CLUSTER_INFO,ADDITIONAL_RESOURCE_INFO.
    :param builtins.str sharded_database_id: Sharded Database identifier
    """
    __args__ = dict()
    __args__['metadata'] = metadata
    __args__['shardedDatabaseId'] = sharded_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GloballyDistributedDatabase/getShardedDatabase:getShardedDatabase', __args__, opts=opts, typ=GetShardedDatabaseResult)
    return __ret__.apply(lambda __response__: GetShardedDatabaseResult(
        ca_signed_certificate=pulumi.get(__response__, 'ca_signed_certificate'),
        catalog_details=pulumi.get(__response__, 'catalog_details'),
        character_set=pulumi.get(__response__, 'character_set'),
        chunks=pulumi.get(__response__, 'chunks'),
        cluster_certificate_common_name=pulumi.get(__response__, 'cluster_certificate_common_name'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        configure_gsms_trigger=pulumi.get(__response__, 'configure_gsms_trigger'),
        configure_gsms_trigger_is_latest_gsm_image=pulumi.get(__response__, 'configure_gsms_trigger_is_latest_gsm_image'),
        configure_gsms_trigger_old_gsm_names=pulumi.get(__response__, 'configure_gsms_trigger_old_gsm_names'),
        configure_sharding_trigger=pulumi.get(__response__, 'configure_sharding_trigger'),
        connection_strings=pulumi.get(__response__, 'connection_strings'),
        db_deployment_type=pulumi.get(__response__, 'db_deployment_type'),
        db_version=pulumi.get(__response__, 'db_version'),
        db_workload=pulumi.get(__response__, 'db_workload'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        download_gsm_certificate_signing_request_trigger=pulumi.get(__response__, 'download_gsm_certificate_signing_request_trigger'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        generate_gsm_certificate_signing_request_trigger=pulumi.get(__response__, 'generate_gsm_certificate_signing_request_trigger'),
        generate_wallet_password=pulumi.get(__response__, 'generate_wallet_password'),
        generate_wallet_trigger=pulumi.get(__response__, 'generate_wallet_trigger'),
        get_connection_string_trigger=pulumi.get(__response__, 'get_connection_string_trigger'),
        gsms=pulumi.get(__response__, 'gsms'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_state=pulumi.get(__response__, 'lifecycle_state'),
        lifecycle_state_details=pulumi.get(__response__, 'lifecycle_state_details'),
        listener_port=pulumi.get(__response__, 'listener_port'),
        listener_port_tls=pulumi.get(__response__, 'listener_port_tls'),
        metadata=pulumi.get(__response__, 'metadata'),
        ncharacter_set=pulumi.get(__response__, 'ncharacter_set'),
        ons_port_local=pulumi.get(__response__, 'ons_port_local'),
        ons_port_remote=pulumi.get(__response__, 'ons_port_remote'),
        patch_operations=pulumi.get(__response__, 'patch_operations'),
        prefix=pulumi.get(__response__, 'prefix'),
        private_endpoint=pulumi.get(__response__, 'private_endpoint'),
        replication_factor=pulumi.get(__response__, 'replication_factor'),
        replication_method=pulumi.get(__response__, 'replication_method'),
        replication_unit=pulumi.get(__response__, 'replication_unit'),
        shard_details=pulumi.get(__response__, 'shard_details'),
        sharded_database_id=pulumi.get(__response__, 'sharded_database_id'),
        sharding_method=pulumi.get(__response__, 'sharding_method'),
        start_database_trigger=pulumi.get(__response__, 'start_database_trigger'),
        state=pulumi.get(__response__, 'state'),
        stop_database_trigger=pulumi.get(__response__, 'stop_database_trigger'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        time_zone=pulumi.get(__response__, 'time_zone'),
        upload_signed_certificate_and_generate_wallet_trigger=pulumi.get(__response__, 'upload_signed_certificate_and_generate_wallet_trigger'),
        validate_network_trigger=pulumi.get(__response__, 'validate_network_trigger')))
