# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsAccountRecoverySettingArgs', 'DomainsAccountRecoverySetting']

@pulumi.input_type
class DomainsAccountRecoverySettingArgs:
    def __init__(__self__, *,
                 account_recovery_setting_id: pulumi.Input[builtins.str],
                 factors: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 idcs_endpoint: pulumi.Input[builtins.str],
                 lockout_duration: pulumi.Input[builtins.int],
                 max_incorrect_attempts: pulumi.Input[builtins.int],
                 schemas: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingTagArgs']]]] = None):
        """
        The set of arguments for constructing a DomainsAccountRecoverySetting resource.
        :param pulumi.Input[builtins.str] account_recovery_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] factors: (Updatable) The account recovery factor used (for example, email, mobile number (SMS), security questions, mobile application push or TOTP) to verify the identity of the user and reset the user's password.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[builtins.int] lockout_duration: (Updatable) Indicates how many minutes to disable account recovery for the user. The default value is 30 metric minutes.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
               * idcsMinValue: 5
               * idcsMaxValue: 9999
        :param pulumi.Input[builtins.int] max_incorrect_attempts: (Updatable) Indicates the maximum number of failed account recovery attempts allowed for the user.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 99
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        pulumi.set(__self__, "account_recovery_setting_id", account_recovery_setting_id)
        pulumi.set(__self__, "factors", factors)
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "lockout_duration", lockout_duration)
        pulumi.set(__self__, "max_incorrect_attempts", max_incorrect_attempts)
        pulumi.set(__self__, "schemas", schemas)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountRecoverySettingId")
    def account_recovery_setting_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "account_recovery_setting_id")

    @account_recovery_setting_id.setter
    def account_recovery_setting_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_recovery_setting_id", value)

    @property
    @pulumi.getter
    def factors(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) The account recovery factor used (for example, email, mobile number (SMS), security questions, mobile application push or TOTP) to verify the identity of the user and reset the user's password.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "factors")

    @factors.setter
    def factors(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "factors", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="lockoutDuration")
    def lockout_duration(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) Indicates how many minutes to disable account recovery for the user. The default value is 30 metric minutes.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: integer
        * uniqueness: none
        * idcsMinValue: 5
        * idcsMaxValue: 9999
        """
        return pulumi.get(self, "lockout_duration")

    @lockout_duration.setter
    def lockout_duration(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "lockout_duration", value)

    @property
    @pulumi.getter(name="maxIncorrectAttempts")
    def max_incorrect_attempts(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) Indicates the maximum number of failed account recovery attempts allowed for the user.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: integer
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 99
        """
        return pulumi.get(self, "max_incorrect_attempts")

    @max_incorrect_attempts.setter
    def max_incorrect_attempts(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_incorrect_attempts", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DomainsAccountRecoverySettingState:
    def __init__(__self__, *,
                 account_recovery_setting_id: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 factors: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 lockout_duration: Optional[pulumi.Input[builtins.int]] = None,
                 max_incorrect_attempts: Optional[pulumi.Input[builtins.int]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingMetaArgs']]]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainsAccountRecoverySetting resources.
        :param pulumi.Input[builtins.str] account_recovery_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] factors: (Updatable) The account recovery factor used (for example, email, mobile number (SMS), security questions, mobile application push or TOTP) to verify the identity of the user and reset the user's password.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.int] lockout_duration: (Updatable) Indicates how many minutes to disable account recovery for the user. The default value is 30 metric minutes.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
               * idcsMinValue: 5
               * idcsMaxValue: 9999
        :param pulumi.Input[builtins.int] max_incorrect_attempts: (Updatable) Indicates the maximum number of failed account recovery attempts allowed for the user.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 99
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if account_recovery_setting_id is not None:
            pulumi.set(__self__, "account_recovery_setting_id", account_recovery_setting_id)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if factors is not None:
            pulumi.set(__self__, "factors", factors)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if lockout_duration is not None:
            pulumi.set(__self__, "lockout_duration", lockout_duration)
        if max_incorrect_attempts is not None:
            pulumi.set(__self__, "max_incorrect_attempts", max_incorrect_attempts)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)

    @property
    @pulumi.getter(name="accountRecoverySettingId")
    def account_recovery_setting_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the resource
        """
        return pulumi.get(self, "account_recovery_setting_id")

    @account_recovery_setting_id.setter
    def account_recovery_setting_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_recovery_setting_id", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def factors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The account recovery factor used (for example, email, mobile number (SMS), security questions, mobile application push or TOTP) to verify the identity of the user and reset the user's password.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "factors")

    @factors.setter
    def factors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "factors", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="lockoutDuration")
    def lockout_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Indicates how many minutes to disable account recovery for the user. The default value is 30 metric minutes.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: integer
        * uniqueness: none
        * idcsMinValue: 5
        * idcsMaxValue: 9999
        """
        return pulumi.get(self, "lockout_duration")

    @lockout_duration.setter
    def lockout_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "lockout_duration", value)

    @property
    @pulumi.getter(name="maxIncorrectAttempts")
    def max_incorrect_attempts(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Indicates the maximum number of failed account recovery attempts allowed for the user.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: integer
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 99
        """
        return pulumi.get(self, "max_incorrect_attempts")

    @max_incorrect_attempts.setter
    def max_incorrect_attempts(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_incorrect_attempts", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAccountRecoverySettingTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_ocid", value)


class DomainsAccountRecoverySetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_recovery_setting_id: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 factors: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 lockout_duration: Optional[pulumi.Input[builtins.int]] = None,
                 max_incorrect_attempts: Optional[pulumi.Input[builtins.int]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingTagArgs', 'DomainsAccountRecoverySettingTagArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Account Recovery Setting resource in Oracle Cloud Infrastructure Identity Domains service.

        Replace an account recovery setting.

        ## Import

        AccountRecoverySettings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsAccountRecoverySetting:DomainsAccountRecoverySetting test_account_recovery_setting "idcsEndpoint/{idcsEndpoint}/accountRecoverySettings/{accountRecoverySettingId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_recovery_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] factors: (Updatable) The account recovery factor used (for example, email, mobile number (SMS), security questions, mobile application push or TOTP) to verify the identity of the user and reset the user's password.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[builtins.int] lockout_duration: (Updatable) Indicates how many minutes to disable account recovery for the user. The default value is 30 metric minutes.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
               * idcsMinValue: 5
               * idcsMaxValue: 9999
        :param pulumi.Input[builtins.int] max_incorrect_attempts: (Updatable) Indicates the maximum number of failed account recovery attempts allowed for the user.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 99
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingTagArgs', 'DomainsAccountRecoverySettingTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsAccountRecoverySettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Account Recovery Setting resource in Oracle Cloud Infrastructure Identity Domains service.

        Replace an account recovery setting.

        ## Import

        AccountRecoverySettings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsAccountRecoverySetting:DomainsAccountRecoverySetting test_account_recovery_setting "idcsEndpoint/{idcsEndpoint}/accountRecoverySettings/{accountRecoverySettingId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsAccountRecoverySettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsAccountRecoverySettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_recovery_setting_id: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 factors: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 lockout_duration: Optional[pulumi.Input[builtins.int]] = None,
                 max_incorrect_attempts: Optional[pulumi.Input[builtins.int]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingTagArgs', 'DomainsAccountRecoverySettingTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsAccountRecoverySettingArgs.__new__(DomainsAccountRecoverySettingArgs)

            if account_recovery_setting_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_recovery_setting_id'")
            __props__.__dict__["account_recovery_setting_id"] = account_recovery_setting_id
            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["external_id"] = external_id
            if factors is None and not opts.urn:
                raise TypeError("Missing required property 'factors'")
            __props__.__dict__["factors"] = factors
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            if lockout_duration is None and not opts.urn:
                raise TypeError("Missing required property 'lockout_duration'")
            __props__.__dict__["lockout_duration"] = lockout_duration
            if max_incorrect_attempts is None and not opts.urn:
                raise TypeError("Missing required property 'max_incorrect_attempts'")
            __props__.__dict__["max_incorrect_attempts"] = max_incorrect_attempts
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["tags"] = tags
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsAccountRecoverySetting, __self__).__init__(
            'oci:Identity/domainsAccountRecoverySetting:DomainsAccountRecoverySetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_recovery_setting_id: Optional[pulumi.Input[builtins.str]] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            attributes: Optional[pulumi.Input[builtins.str]] = None,
            authorization: Optional[pulumi.Input[builtins.str]] = None,
            compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
            delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
            domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
            external_id: Optional[pulumi.Input[builtins.str]] = None,
            factors: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingIdcsCreatedByArgs', 'DomainsAccountRecoverySettingIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingIdcsLastModifiedByArgs', 'DomainsAccountRecoverySettingIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            lockout_duration: Optional[pulumi.Input[builtins.int]] = None,
            max_incorrect_attempts: Optional[pulumi.Input[builtins.int]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingMetaArgs', 'DomainsAccountRecoverySettingMetaArgsDict']]]]] = None,
            ocid: Optional[pulumi.Input[builtins.str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingTagArgs', 'DomainsAccountRecoverySettingTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None) -> 'DomainsAccountRecoverySetting':
        """
        Get an existing DomainsAccountRecoverySetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_recovery_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] factors: (Updatable) The account recovery factor used (for example, email, mobile number (SMS), security questions, mobile application push or TOTP) to verify the identity of the user and reset the user's password.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingIdcsCreatedByArgs', 'DomainsAccountRecoverySettingIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingIdcsLastModifiedByArgs', 'DomainsAccountRecoverySettingIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.int] lockout_duration: (Updatable) Indicates how many minutes to disable account recovery for the user. The default value is 30 metric minutes.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
               * idcsMinValue: 5
               * idcsMaxValue: 9999
        :param pulumi.Input[builtins.int] max_incorrect_attempts: (Updatable) Indicates the maximum number of failed account recovery attempts allowed for the user.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 99
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingMetaArgs', 'DomainsAccountRecoverySettingMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAccountRecoverySettingTagArgs', 'DomainsAccountRecoverySettingTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsAccountRecoverySettingState.__new__(_DomainsAccountRecoverySettingState)

        __props__.__dict__["account_recovery_setting_id"] = account_recovery_setting_id
        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["factors"] = factors
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["lockout_duration"] = lockout_duration
        __props__.__dict__["max_incorrect_attempts"] = max_incorrect_attempts
        __props__.__dict__["metas"] = metas
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        return DomainsAccountRecoverySetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountRecoverySettingId")
    def account_recovery_setting_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "account_recovery_setting_id")

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def factors(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) The account recovery factor used (for example, email, mobile number (SMS), security questions, mobile application push or TOTP) to verify the identity of the user and reset the user's password.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "factors")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsAccountRecoverySettingIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsAccountRecoverySettingIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="lockoutDuration")
    def lockout_duration(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) Indicates how many minutes to disable account recovery for the user. The default value is 30 metric minutes.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: integer
        * uniqueness: none
        * idcsMinValue: 5
        * idcsMaxValue: 9999
        """
        return pulumi.get(self, "lockout_duration")

    @property
    @pulumi.getter(name="maxIncorrectAttempts")
    def max_incorrect_attempts(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) Indicates the maximum number of failed account recovery attempts allowed for the user.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: integer
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 99
        """
        return pulumi.get(self, "max_incorrect_attempts")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsAccountRecoverySettingMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsAccountRecoverySettingTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_ocid")

