# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLogsResult',
    'AwaitableGetLogsResult',
    'get_logs',
    'get_logs_output',
]

@pulumi.output_type
class GetLogsResult:
    """
    A collection of values returned by getLogs.
    """
    def __init__(__self__, display_name=None, filters=None, id=None, log_group_id=None, log_type=None, logs=None, source_resource=None, source_service=None, state=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_group_id and not isinstance(log_group_id, str):
            raise TypeError("Expected argument 'log_group_id' to be a str")
        pulumi.set(__self__, "log_group_id", log_group_id)
        if log_type and not isinstance(log_type, str):
            raise TypeError("Expected argument 'log_type' to be a str")
        pulumi.set(__self__, "log_type", log_type)
        if logs and not isinstance(logs, list):
            raise TypeError("Expected argument 'logs' to be a list")
        pulumi.set(__self__, "logs", logs)
        if source_resource and not isinstance(source_resource, str):
            raise TypeError("Expected argument 'source_resource' to be a str")
        pulumi.set(__self__, "source_resource", source_resource)
        if source_service and not isinstance(source_service, str):
            raise TypeError("Expected argument 'source_service' to be a str")
        pulumi.set(__self__, "source_service", source_service)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLogsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> builtins.str:
        """
        Log group OCID.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[builtins.str]:
        """
        The logType that the log object is for, whether custom or service.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter
    def logs(self) -> Sequence['outputs.GetLogsLogResult']:
        """
        The list of logs.
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter(name="sourceResource")
    def source_resource(self) -> Optional[builtins.str]:
        return pulumi.get(self, "source_resource")

    @property
    @pulumi.getter(name="sourceService")
    def source_service(self) -> Optional[builtins.str]:
        return pulumi.get(self, "source_service")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The pipeline state.
        """
        return pulumi.get(self, "state")


class AwaitableGetLogsResult(GetLogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogsResult(
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            log_group_id=self.log_group_id,
            log_type=self.log_type,
            logs=self.logs,
            source_resource=self.source_resource,
            source_service=self.source_service,
            state=self.state)


def get_logs(display_name: Optional[builtins.str] = None,
             filters: Optional[Sequence[Union['GetLogsFilterArgs', 'GetLogsFilterArgsDict']]] = None,
             log_group_id: Optional[builtins.str] = None,
             log_type: Optional[builtins.str] = None,
             source_resource: Optional[builtins.str] = None,
             source_service: Optional[builtins.str] = None,
             state: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogsResult:
    """
    This data source provides the list of Logs in Oracle Cloud Infrastructure Logging service.

    Lists the specified log group's log objects.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_logs = oci.Logging.get_logs(log_group_id=test_log_group["id"],
        display_name=log_display_name,
        log_type=log_log_type,
        source_resource=log_source_resource,
        source_service=log_source_service,
        state=log_state)
    ```


    :param builtins.str display_name: Resource name.
    :param builtins.str log_group_id: OCID of a log group to work with.
    :param builtins.str log_type: The logType that the log object is for, whether custom or service.
    :param builtins.str source_resource: Log object resource, which is a field of LogSummary.Configuration.Source.
    :param builtins.str source_service: Service that created the log object, which is a field of LogSummary.Configuration.Source.
    :param builtins.str state: Lifecycle state of the log object
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['logGroupId'] = log_group_id
    __args__['logType'] = log_type
    __args__['sourceResource'] = source_resource
    __args__['sourceService'] = source_service
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Logging/getLogs:getLogs', __args__, opts=opts, typ=GetLogsResult).value

    return AwaitableGetLogsResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        log_group_id=pulumi.get(__ret__, 'log_group_id'),
        log_type=pulumi.get(__ret__, 'log_type'),
        logs=pulumi.get(__ret__, 'logs'),
        source_resource=pulumi.get(__ret__, 'source_resource'),
        source_service=pulumi.get(__ret__, 'source_service'),
        state=pulumi.get(__ret__, 'state'))
def get_logs_output(display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLogsFilterArgs', 'GetLogsFilterArgsDict']]]]] = None,
                    log_group_id: Optional[pulumi.Input[builtins.str]] = None,
                    log_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    source_resource: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    source_service: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogsResult]:
    """
    This data source provides the list of Logs in Oracle Cloud Infrastructure Logging service.

    Lists the specified log group's log objects.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_logs = oci.Logging.get_logs(log_group_id=test_log_group["id"],
        display_name=log_display_name,
        log_type=log_log_type,
        source_resource=log_source_resource,
        source_service=log_source_service,
        state=log_state)
    ```


    :param builtins.str display_name: Resource name.
    :param builtins.str log_group_id: OCID of a log group to work with.
    :param builtins.str log_type: The logType that the log object is for, whether custom or service.
    :param builtins.str source_resource: Log object resource, which is a field of LogSummary.Configuration.Source.
    :param builtins.str source_service: Service that created the log object, which is a field of LogSummary.Configuration.Source.
    :param builtins.str state: Lifecycle state of the log object
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['logGroupId'] = log_group_id
    __args__['logType'] = log_type
    __args__['sourceResource'] = source_resource
    __args__['sourceService'] = source_service
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Logging/getLogs:getLogs', __args__, opts=opts, typ=GetLogsResult)
    return __ret__.apply(lambda __response__: GetLogsResult(
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        log_group_id=pulumi.get(__response__, 'log_group_id'),
        log_type=pulumi.get(__response__, 'log_type'),
        logs=pulumi.get(__response__, 'logs'),
        source_resource=pulumi.get(__response__, 'source_resource'),
        source_service=pulumi.get(__response__, 'source_service'),
        state=pulumi.get(__response__, 'state')))
