# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAcceptedAgreementResult',
    'AwaitableGetAcceptedAgreementResult',
    'get_accepted_agreement',
    'get_accepted_agreement_output',
]

@pulumi.output_type
class GetAcceptedAgreementResult:
    """
    A collection of values returned by getAcceptedAgreement.
    """
    def __init__(__self__, accepted_agreement_id=None, agreement_id=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, listing_id=None, package_version=None, signature=None, time_accepted=None):
        if accepted_agreement_id and not isinstance(accepted_agreement_id, str):
            raise TypeError("Expected argument 'accepted_agreement_id' to be a str")
        pulumi.set(__self__, "accepted_agreement_id", accepted_agreement_id)
        if agreement_id and not isinstance(agreement_id, str):
            raise TypeError("Expected argument 'agreement_id' to be a str")
        pulumi.set(__self__, "agreement_id", agreement_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listing_id and not isinstance(listing_id, str):
            raise TypeError("Expected argument 'listing_id' to be a str")
        pulumi.set(__self__, "listing_id", listing_id)
        if package_version and not isinstance(package_version, str):
            raise TypeError("Expected argument 'package_version' to be a str")
        pulumi.set(__self__, "package_version", package_version)
        if signature and not isinstance(signature, str):
            raise TypeError("Expected argument 'signature' to be a str")
        pulumi.set(__self__, "signature", signature)
        if time_accepted and not isinstance(time_accepted, str):
            raise TypeError("Expected argument 'time_accepted' to be a str")
        pulumi.set(__self__, "time_accepted", time_accepted)

    @property
    @pulumi.getter(name="acceptedAgreementId")
    def accepted_agreement_id(self) -> builtins.str:
        return pulumi.get(self, "accepted_agreement_id")

    @property
    @pulumi.getter(name="agreementId")
    def agreement_id(self) -> builtins.str:
        """
        The unique identifier for the terms of use agreement itself.
        """
        return pulumi.get(self, "agreement_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The unique identifier for the compartment where the agreement was accepted.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A display name for the accepted agreement.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The unique identifier for the acceptance of the agreement within a specific compartment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> builtins.str:
        """
        The unique identifier for the listing associated with the agreement.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> builtins.str:
        """
        The package version associated with the agreement.
        """
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter
    def signature(self) -> builtins.str:
        return pulumi.get(self, "signature")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> builtins.str:
        """
        The time the agreement was accepted.
        """
        return pulumi.get(self, "time_accepted")


class AwaitableGetAcceptedAgreementResult(GetAcceptedAgreementResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAcceptedAgreementResult(
            accepted_agreement_id=self.accepted_agreement_id,
            agreement_id=self.agreement_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            listing_id=self.listing_id,
            package_version=self.package_version,
            signature=self.signature,
            time_accepted=self.time_accepted)


def get_accepted_agreement(accepted_agreement_id: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAcceptedAgreementResult:
    """
    This data source provides details about a specific Accepted Agreement resource in Oracle Cloud Infrastructure Marketplace service.

    Gets the details of a specific, previously accepted terms of use agreement.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_accepted_agreement = oci.Marketplace.get_accepted_agreement(accepted_agreement_id=test_accepted_agreement_oci_marketplace_accepted_agreement["id"])
    ```


    :param builtins.str accepted_agreement_id: The unique identifier for the accepted terms of use agreement.
    """
    __args__ = dict()
    __args__['acceptedAgreementId'] = accepted_agreement_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Marketplace/getAcceptedAgreement:getAcceptedAgreement', __args__, opts=opts, typ=GetAcceptedAgreementResult).value

    return AwaitableGetAcceptedAgreementResult(
        accepted_agreement_id=pulumi.get(__ret__, 'accepted_agreement_id'),
        agreement_id=pulumi.get(__ret__, 'agreement_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        listing_id=pulumi.get(__ret__, 'listing_id'),
        package_version=pulumi.get(__ret__, 'package_version'),
        signature=pulumi.get(__ret__, 'signature'),
        time_accepted=pulumi.get(__ret__, 'time_accepted'))
def get_accepted_agreement_output(accepted_agreement_id: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAcceptedAgreementResult]:
    """
    This data source provides details about a specific Accepted Agreement resource in Oracle Cloud Infrastructure Marketplace service.

    Gets the details of a specific, previously accepted terms of use agreement.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_accepted_agreement = oci.Marketplace.get_accepted_agreement(accepted_agreement_id=test_accepted_agreement_oci_marketplace_accepted_agreement["id"])
    ```


    :param builtins.str accepted_agreement_id: The unique identifier for the accepted terms of use agreement.
    """
    __args__ = dict()
    __args__['acceptedAgreementId'] = accepted_agreement_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Marketplace/getAcceptedAgreement:getAcceptedAgreement', __args__, opts=opts, typ=GetAcceptedAgreementResult)
    return __ret__.apply(lambda __response__: GetAcceptedAgreementResult(
        accepted_agreement_id=pulumi.get(__response__, 'accepted_agreement_id'),
        agreement_id=pulumi.get(__response__, 'agreement_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        listing_id=pulumi.get(__response__, 'listing_id'),
        package_version=pulumi.get(__response__, 'package_version'),
        signature=pulumi.get(__response__, 'signature'),
        time_accepted=pulumi.get(__response__, 'time_accepted')))
