# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMediaWorkflowsResult',
    'AwaitableGetMediaWorkflowsResult',
    'get_media_workflows',
    'get_media_workflows_output',
]

@pulumi.output_type
class GetMediaWorkflowsResult:
    """
    A collection of values returned by getMediaWorkflows.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, media_workflow_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if media_workflow_collections and not isinstance(media_workflow_collections, list):
            raise TypeError("Expected argument 'media_workflow_collections' to be a list")
        pulumi.set(__self__, "media_workflow_collections", media_workflow_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Name of the Media Workflow. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMediaWorkflowsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mediaWorkflowCollections")
    def media_workflow_collections(self) -> Sequence['outputs.GetMediaWorkflowsMediaWorkflowCollectionResult']:
        """
        The list of media_workflow_collection.
        """
        return pulumi.get(self, "media_workflow_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the MediaWorkflow.
        """
        return pulumi.get(self, "state")


class AwaitableGetMediaWorkflowsResult(GetMediaWorkflowsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMediaWorkflowsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            media_workflow_collections=self.media_workflow_collections,
            state=self.state)


def get_media_workflows(compartment_id: Optional[builtins.str] = None,
                        display_name: Optional[builtins.str] = None,
                        filters: Optional[Sequence[Union['GetMediaWorkflowsFilterArgs', 'GetMediaWorkflowsFilterArgsDict']]] = None,
                        id: Optional[builtins.str] = None,
                        state: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMediaWorkflowsResult:
    """
    This data source provides the list of Media Workflows in Oracle Cloud Infrastructure Media Services service.

    Lists the MediaWorkflows.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_workflows = oci.MediaServices.get_media_workflows(compartment_id=compartment_id,
        display_name=media_workflow_display_name,
        id=media_workflow_id,
        state=media_workflow_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only the resources that match the entire display name given.
    :param builtins.str id: Unique MediaWorkflow identifier.
    :param builtins.str state: A filter to return only the resources with lifecycleState matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getMediaWorkflows:getMediaWorkflows', __args__, opts=opts, typ=GetMediaWorkflowsResult).value

    return AwaitableGetMediaWorkflowsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        media_workflow_collections=pulumi.get(__ret__, 'media_workflow_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_media_workflows_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMediaWorkflowsFilterArgs', 'GetMediaWorkflowsFilterArgsDict']]]]] = None,
                               id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMediaWorkflowsResult]:
    """
    This data source provides the list of Media Workflows in Oracle Cloud Infrastructure Media Services service.

    Lists the MediaWorkflows.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_workflows = oci.MediaServices.get_media_workflows(compartment_id=compartment_id,
        display_name=media_workflow_display_name,
        id=media_workflow_id,
        state=media_workflow_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only the resources that match the entire display name given.
    :param builtins.str id: Unique MediaWorkflow identifier.
    :param builtins.str state: A filter to return only the resources with lifecycleState matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MediaServices/getMediaWorkflows:getMediaWorkflows', __args__, opts=opts, typ=GetMediaWorkflowsResult)
    return __ret__.apply(lambda __response__: GetMediaWorkflowsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        media_workflow_collections=pulumi.get(__response__, 'media_workflow_collections'),
        state=pulumi.get(__response__, 'state')))
