# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkFirewallPolicyServiceListArgs', 'NetworkFirewallPolicyServiceList']

@pulumi.input_type
class NetworkFirewallPolicyServiceListArgs:
    def __init__(__self__, *,
                 network_firewall_policy_id: pulumi.Input[builtins.str],
                 services: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicyServiceList resource.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] services: (Updatable) Collection of service names. The services referenced in the service list must already be present in the policy before being used in the service list. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] name: Name of the service Group.
        """
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        pulumi.set(__self__, "services", services)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter
    def services(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) Collection of service names. The services referenced in the service list must already be present in the policy before being used in the service list. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the service Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkFirewallPolicyServiceListState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 parent_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 total_services: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicyServiceList resources.
        :param pulumi.Input[builtins.str] name: Name of the service Group.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[builtins.str] parent_resource_id: OCID of the Network Firewall Policy this serviceList belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] services: (Updatable) Collection of service names. The services referenced in the service list must already be present in the policy before being used in the service list. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.int] total_services: Count of total services in the given service List.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_id is not None:
            pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id is not None:
            pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if total_services is not None:
            pulumi.set(__self__, "total_services", total_services)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the service Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the Network Firewall Policy this serviceList belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @parent_resource_id.setter
    def parent_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_resource_id", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Collection of service names. The services referenced in the service list must already be present in the policy before being used in the service list. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter(name="totalServices")
    def total_services(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count of total services in the given service List.
        """
        return pulumi.get(self, "total_services")

    @total_services.setter
    def total_services(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_services", value)


class NetworkFirewallPolicyServiceList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Network Firewall Policy Service List resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new ServiceList for the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_service_list = oci.network_firewall.NetworkFirewallPolicyServiceList("test_network_firewall_policy_service_list",
            name=network_firewall_policy_service_list_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            services=network_firewall_policy_service_list_services)
        ```

        ## Import

        NetworkFirewallPolicyServiceLists can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyServiceList:NetworkFirewallPolicyServiceList test_network_firewall_policy_service_list "networkFirewallPolicies/{networkFirewallPolicyId}/serviceLists/{serviceListName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Name of the service Group.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] services: (Updatable) Collection of service names. The services referenced in the service list must already be present in the policy before being used in the service list. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyServiceListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Firewall Policy Service List resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new ServiceList for the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_service_list = oci.network_firewall.NetworkFirewallPolicyServiceList("test_network_firewall_policy_service_list",
            name=network_firewall_policy_service_list_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            services=network_firewall_policy_service_list_services)
        ```

        ## Import

        NetworkFirewallPolicyServiceLists can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyServiceList:NetworkFirewallPolicyServiceList test_network_firewall_policy_service_list "networkFirewallPolicies/{networkFirewallPolicyId}/serviceLists/{serviceListName}"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyServiceListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyServiceListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyServiceListArgs.__new__(NetworkFirewallPolicyServiceListArgs)

            __props__.__dict__["name"] = name
            if network_firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_firewall_policy_id'")
            __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
            if services is None and not opts.urn:
                raise TypeError("Missing required property 'services'")
            __props__.__dict__["services"] = services
            __props__.__dict__["parent_resource_id"] = None
            __props__.__dict__["total_services"] = None
        super(NetworkFirewallPolicyServiceList, __self__).__init__(
            'oci:NetworkFirewall/networkFirewallPolicyServiceList:NetworkFirewallPolicyServiceList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            parent_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            total_services: Optional[pulumi.Input[builtins.int]] = None) -> 'NetworkFirewallPolicyServiceList':
        """
        Get an existing NetworkFirewallPolicyServiceList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Name of the service Group.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[builtins.str] parent_resource_id: OCID of the Network Firewall Policy this serviceList belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] services: (Updatable) Collection of service names. The services referenced in the service list must already be present in the policy before being used in the service list. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.int] total_services: Count of total services in the given service List.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyServiceListState.__new__(_NetworkFirewallPolicyServiceListState)

        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
        __props__.__dict__["parent_resource_id"] = parent_resource_id
        __props__.__dict__["services"] = services
        __props__.__dict__["total_services"] = total_services
        return NetworkFirewallPolicyServiceList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the service Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        OCID of the Network Firewall Policy this serviceList belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def services(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Collection of service names. The services referenced in the service list must already be present in the policy before being used in the service list. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="totalServices")
    def total_services(self) -> pulumi.Output[builtins.int]:
        """
        Count of total services in the given service List.
        """
        return pulumi.get(self, "total_services")

