# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LustreFileStorageLustreFileSystemArgs', 'LustreFileStorageLustreFileSystem']

@pulumi.input_type
class LustreFileStorageLustreFileSystemArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[builtins.str],
                 capacity_in_gbs: pulumi.Input[builtins.int],
                 compartment_id: pulumi.Input[builtins.str],
                 file_system_name: pulumi.Input[builtins.str],
                 performance_tier: pulumi.Input[builtins.str],
                 root_squash_configuration: pulumi.Input['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs'],
                 subnet_id: pulumi.Input[builtins.str],
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a LustreFileStorageLustreFileSystem resource.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.int] capacity_in_gbs: (Updatable) Capacity of the Lustre file system in GB. You can increase capacity only in multiples of 5 TB.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        :param pulumi.Input[builtins.str] file_system_name: The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'. If you have multiple Lustre file systems mounted on the same clients, this name can help distinguish them.
        :param pulumi.Input[builtins.str] performance_tier: The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        :param pulumi.Input['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs'] root_squash_configuration: (Updatable) An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        :param pulumi.Input[builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Lustre file system`
        :param pulumi.Input[builtins.str] file_system_description: (Updatable) Short description of the Lustre file system. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "capacity_in_gbs", capacity_in_gbs)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "performance_tier", performance_tier)
        pulumi.set(__self__, "root_squash_configuration", root_squash_configuration)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_system_description is not None:
            pulumi.set(__self__, "file_system_description", file_system_description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[builtins.str]:
        """
        The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="capacityInGbs")
    def capacity_in_gbs(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) Capacity of the Lustre file system in GB. You can increase capacity only in multiples of 5 TB.
        """
        return pulumi.get(self, "capacity_in_gbs")

    @capacity_in_gbs.setter
    def capacity_in_gbs(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "capacity_in_gbs", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> pulumi.Input[builtins.str]:
        """
        The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'. If you have multiple Lustre file systems mounted on the same clients, this name can help distinguish them.
        """
        return pulumi.get(self, "file_system_name")

    @file_system_name.setter
    def file_system_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "file_system_name", value)

    @property
    @pulumi.getter(name="performanceTier")
    def performance_tier(self) -> pulumi.Input[builtins.str]:
        """
        The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        """
        return pulumi.get(self, "performance_tier")

    @performance_tier.setter
    def performance_tier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "performance_tier", value)

    @property
    @pulumi.getter(name="rootSquashConfiguration")
    def root_squash_configuration(self) -> pulumi.Input['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs']:
        """
        (Updatable) An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        """
        return pulumi.get(self, "root_squash_configuration")

    @root_squash_configuration.setter
    def root_squash_configuration(self, value: pulumi.Input['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs']):
        pulumi.set(self, "root_squash_configuration", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Lustre file system`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fileSystemDescription")
    def file_system_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Short description of the Lustre file system. Avoid entering confidential information.
        """
        return pulumi.get(self, "file_system_description")

    @file_system_description.setter
    def file_system_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_system_description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class _LustreFileStorageLustreFileSystemState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_description: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 lnet: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['LustreFileStorageLustreFileSystemMaintenanceWindowArgs']]]] = None,
                 major_version: Optional[pulumi.Input[builtins.str]] = None,
                 management_service_address: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 performance_tier: Optional[pulumi.Input[builtins.str]] = None,
                 root_squash_configuration: Optional[pulumi.Input['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_billing_cycle_end: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LustreFileStorageLustreFileSystem resources.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.int] capacity_in_gbs: (Updatable) Capacity of the Lustre file system in GB. You can increase capacity only in multiples of 5 TB.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Lustre file system`
        :param pulumi.Input[builtins.str] file_system_description: (Updatable) Short description of the Lustre file system. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] file_system_name: The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'. If you have multiple Lustre file systems mounted on the same clients, this name can help distinguish them.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        :param pulumi.Input[builtins.str] lifecycle_details: A message that describes the current state of the Lustre file system in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[builtins.str] lnet: Type of network used by clients to mount the file system.   Example: `tcp`
        :param pulumi.Input[Sequence[pulumi.Input['LustreFileStorageLustreFileSystemMaintenanceWindowArgs']]] maintenance_windows: The preferred day and time to perform maintenance.
        :param pulumi.Input[builtins.str] major_version: Major version of Lustre running in the Lustre file system.  Example: `2.15`
        :param pulumi.Input[builtins.str] management_service_address: The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system. For example '10.0.0.4'.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param pulumi.Input[builtins.str] performance_tier: The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        :param pulumi.Input['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs'] root_squash_configuration: (Updatable) An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        :param pulumi.Input[builtins.str] state: The current state of the Lustre file system.
        :param pulumi.Input[builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_billing_cycle_end: The date and time that the current billing cycle for the file system will end, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. After the current cycle ends, this date is updated automatically to the next timestamp, which is 30 days later. File systems deleted earlier than this time will still incur charges until the billing cycle ends.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_created: The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the Lustre file system was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if capacity_in_gbs is not None:
            pulumi.set(__self__, "capacity_in_gbs", capacity_in_gbs)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_system_description is not None:
            pulumi.set(__self__, "file_system_description", file_system_description)
        if file_system_name is not None:
            pulumi.set(__self__, "file_system_name", file_system_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lnet is not None:
            pulumi.set(__self__, "lnet", lnet)
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if major_version is not None:
            pulumi.set(__self__, "major_version", major_version)
        if management_service_address is not None:
            pulumi.set(__self__, "management_service_address", management_service_address)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if performance_tier is not None:
            pulumi.set(__self__, "performance_tier", performance_tier)
        if root_squash_configuration is not None:
            pulumi.set(__self__, "root_squash_configuration", root_squash_configuration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_billing_cycle_end is not None:
            pulumi.set(__self__, "time_billing_cycle_end", time_billing_cycle_end)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="capacityInGbs")
    def capacity_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Capacity of the Lustre file system in GB. You can increase capacity only in multiples of 5 TB.
        """
        return pulumi.get(self, "capacity_in_gbs")

    @capacity_in_gbs.setter
    def capacity_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "capacity_in_gbs", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Lustre file system`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fileSystemDescription")
    def file_system_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Short description of the Lustre file system. Avoid entering confidential information.
        """
        return pulumi.get(self, "file_system_description")

    @file_system_description.setter
    def file_system_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_system_description", value)

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'. If you have multiple Lustre file systems mounted on the same clients, this name can help distinguish them.
        """
        return pulumi.get(self, "file_system_name")

    @file_system_name.setter
    def file_system_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_system_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message that describes the current state of the Lustre file system in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def lnet(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of network used by clients to mount the file system.   Example: `tcp`
        """
        return pulumi.get(self, "lnet")

    @lnet.setter
    def lnet(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lnet", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LustreFileStorageLustreFileSystemMaintenanceWindowArgs']]]]:
        """
        The preferred day and time to perform maintenance.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LustreFileStorageLustreFileSystemMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Major version of Lustre running in the Lustre file system.  Example: `2.15`
        """
        return pulumi.get(self, "major_version")

    @major_version.setter
    def major_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "major_version", value)

    @property
    @pulumi.getter(name="managementServiceAddress")
    def management_service_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system. For example '10.0.0.4'.
        """
        return pulumi.get(self, "management_service_address")

    @management_service_address.setter
    def management_service_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "management_service_address", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="performanceTier")
    def performance_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        """
        return pulumi.get(self, "performance_tier")

    @performance_tier.setter
    def performance_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "performance_tier", value)

    @property
    @pulumi.getter(name="rootSquashConfiguration")
    def root_squash_configuration(self) -> Optional[pulumi.Input['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs']]:
        """
        (Updatable) An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        """
        return pulumi.get(self, "root_squash_configuration")

    @root_squash_configuration.setter
    def root_squash_configuration(self, value: Optional[pulumi.Input['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs']]):
        pulumi.set(self, "root_squash_configuration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Lustre file system.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeBillingCycleEnd")
    def time_billing_cycle_end(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time that the current billing cycle for the file system will end, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. After the current cycle ends, this date is updated automatically to the next timestamp, which is 30 days later. File systems deleted earlier than this time will still incur charges until the billing cycle ends.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_billing_cycle_end")

    @time_billing_cycle_end.setter
    def time_billing_cycle_end(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_billing_cycle_end", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Lustre file system was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


warnings.warn("""oci.oci/lustrefilestoragelustrefilesystem.LustreFileStorageLustreFileSystem has been deprecated in favor of oci.lustre/filestoragelustrefilesystem.FileStorageLustreFileSystem""", DeprecationWarning)


class LustreFileStorageLustreFileSystem(pulumi.CustomResource):
    warnings.warn("""oci.oci/lustrefilestoragelustrefilesystem.LustreFileStorageLustreFileSystem has been deprecated in favor of oci.lustre/filestoragelustrefilesystem.FileStorageLustreFileSystem""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_description: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 performance_tier: Optional[pulumi.Input[builtins.str]] = None,
                 root_squash_configuration: Optional[pulumi.Input[Union['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs', 'LustreFileStorageLustreFileSystemRootSquashConfigurationArgsDict']]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Lustre File System resource in Oracle Cloud Infrastructure Lustre File Storage service.

        Creates a Lustre file system.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_lustre_file_system = oci.lustre.FileStorageLustreFileSystem("test_lustre_file_system",
            availability_domain=lustre_file_system_availability_domain,
            capacity_in_gbs=lustre_file_system_capacity_in_gbs,
            compartment_id=compartment_id,
            file_system_name=test_file_system["name"],
            performance_tier=lustre_file_system_performance_tier,
            root_squash_configuration={
                "client_exceptions": lustre_file_system_root_squash_configuration_client_exceptions,
                "identity_squash": lustre_file_system_root_squash_configuration_identity_squash,
                "squash_gid": lustre_file_system_root_squash_configuration_squash_gid,
                "squash_uid": lustre_file_system_root_squash_configuration_squash_uid,
            },
            subnet_id=test_subnet["id"],
            cluster_placement_group_id=test_cluster_placement_group["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=lustre_file_system_display_name,
            file_system_description=lustre_file_system_file_system_description,
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=test_key["id"],
            nsg_ids=lustre_file_system_nsg_ids)
        ```

        ## Import

        LustreFileSystems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/lustreFileStorageLustreFileSystem:LustreFileStorageLustreFileSystem test_lustre_file_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.int] capacity_in_gbs: (Updatable) Capacity of the Lustre file system in GB. You can increase capacity only in multiples of 5 TB.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Lustre file system`
        :param pulumi.Input[builtins.str] file_system_description: (Updatable) Short description of the Lustre file system. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] file_system_name: The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'. If you have multiple Lustre file systems mounted on the same clients, this name can help distinguish them.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param pulumi.Input[builtins.str] performance_tier: The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        :param pulumi.Input[Union['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs', 'LustreFileStorageLustreFileSystemRootSquashConfigurationArgsDict']] root_squash_configuration: (Updatable) An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        :param pulumi.Input[builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LustreFileStorageLustreFileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Lustre File System resource in Oracle Cloud Infrastructure Lustre File Storage service.

        Creates a Lustre file system.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_lustre_file_system = oci.lustre.FileStorageLustreFileSystem("test_lustre_file_system",
            availability_domain=lustre_file_system_availability_domain,
            capacity_in_gbs=lustre_file_system_capacity_in_gbs,
            compartment_id=compartment_id,
            file_system_name=test_file_system["name"],
            performance_tier=lustre_file_system_performance_tier,
            root_squash_configuration={
                "client_exceptions": lustre_file_system_root_squash_configuration_client_exceptions,
                "identity_squash": lustre_file_system_root_squash_configuration_identity_squash,
                "squash_gid": lustre_file_system_root_squash_configuration_squash_gid,
                "squash_uid": lustre_file_system_root_squash_configuration_squash_uid,
            },
            subnet_id=test_subnet["id"],
            cluster_placement_group_id=test_cluster_placement_group["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=lustre_file_system_display_name,
            file_system_description=lustre_file_system_file_system_description,
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=test_key["id"],
            nsg_ids=lustre_file_system_nsg_ids)
        ```

        ## Import

        LustreFileSystems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/lustreFileStorageLustreFileSystem:LustreFileStorageLustreFileSystem test_lustre_file_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param LustreFileStorageLustreFileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LustreFileStorageLustreFileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_description: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 performance_tier: Optional[pulumi.Input[builtins.str]] = None,
                 root_squash_configuration: Optional[pulumi.Input[Union['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs', 'LustreFileStorageLustreFileSystemRootSquashConfigurationArgsDict']]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        pulumi.log.warn("""LustreFileStorageLustreFileSystem is deprecated: oci.oci/lustrefilestoragelustrefilesystem.LustreFileStorageLustreFileSystem has been deprecated in favor of oci.lustre/filestoragelustrefilesystem.FileStorageLustreFileSystem""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LustreFileStorageLustreFileSystemArgs.__new__(LustreFileStorageLustreFileSystemArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            if capacity_in_gbs is None and not opts.urn:
                raise TypeError("Missing required property 'capacity_in_gbs'")
            __props__.__dict__["capacity_in_gbs"] = capacity_in_gbs
            __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["file_system_description"] = file_system_description
            if file_system_name is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_name'")
            __props__.__dict__["file_system_name"] = file_system_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["nsg_ids"] = nsg_ids
            if performance_tier is None and not opts.urn:
                raise TypeError("Missing required property 'performance_tier'")
            __props__.__dict__["performance_tier"] = performance_tier
            if root_squash_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'root_squash_configuration'")
            __props__.__dict__["root_squash_configuration"] = root_squash_configuration
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["system_tags"] = system_tags
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["lnet"] = None
            __props__.__dict__["maintenance_windows"] = None
            __props__.__dict__["major_version"] = None
            __props__.__dict__["management_service_address"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_billing_cycle_end"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(LustreFileStorageLustreFileSystem, __self__).__init__(
            'oci:oci/lustreFileStorageLustreFileSystem:LustreFileStorageLustreFileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            capacity_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
            cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            file_system_description: Optional[pulumi.Input[builtins.str]] = None,
            file_system_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            lnet: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LustreFileStorageLustreFileSystemMaintenanceWindowArgs', 'LustreFileStorageLustreFileSystemMaintenanceWindowArgsDict']]]]] = None,
            major_version: Optional[pulumi.Input[builtins.str]] = None,
            management_service_address: Optional[pulumi.Input[builtins.str]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            performance_tier: Optional[pulumi.Input[builtins.str]] = None,
            root_squash_configuration: Optional[pulumi.Input[Union['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs', 'LustreFileStorageLustreFileSystemRootSquashConfigurationArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_billing_cycle_end: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'LustreFileStorageLustreFileSystem':
        """
        Get an existing LustreFileStorageLustreFileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.int] capacity_in_gbs: (Updatable) Capacity of the Lustre file system in GB. You can increase capacity only in multiples of 5 TB.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Lustre file system`
        :param pulumi.Input[builtins.str] file_system_description: (Updatable) Short description of the Lustre file system. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] file_system_name: The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'. If you have multiple Lustre file systems mounted on the same clients, this name can help distinguish them.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        :param pulumi.Input[builtins.str] lifecycle_details: A message that describes the current state of the Lustre file system in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[builtins.str] lnet: Type of network used by clients to mount the file system.   Example: `tcp`
        :param pulumi.Input[Sequence[pulumi.Input[Union['LustreFileStorageLustreFileSystemMaintenanceWindowArgs', 'LustreFileStorageLustreFileSystemMaintenanceWindowArgsDict']]]] maintenance_windows: The preferred day and time to perform maintenance.
        :param pulumi.Input[builtins.str] major_version: Major version of Lustre running in the Lustre file system.  Example: `2.15`
        :param pulumi.Input[builtins.str] management_service_address: The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system. For example '10.0.0.4'.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param pulumi.Input[builtins.str] performance_tier: The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        :param pulumi.Input[Union['LustreFileStorageLustreFileSystemRootSquashConfigurationArgs', 'LustreFileStorageLustreFileSystemRootSquashConfigurationArgsDict']] root_squash_configuration: (Updatable) An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        :param pulumi.Input[builtins.str] state: The current state of the Lustre file system.
        :param pulumi.Input[builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_billing_cycle_end: The date and time that the current billing cycle for the file system will end, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. After the current cycle ends, this date is updated automatically to the next timestamp, which is 30 days later. File systems deleted earlier than this time will still incur charges until the billing cycle ends.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_created: The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the Lustre file system was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LustreFileStorageLustreFileSystemState.__new__(_LustreFileStorageLustreFileSystemState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["capacity_in_gbs"] = capacity_in_gbs
        __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["file_system_description"] = file_system_description
        __props__.__dict__["file_system_name"] = file_system_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lnet"] = lnet
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["major_version"] = major_version
        __props__.__dict__["management_service_address"] = management_service_address
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["performance_tier"] = performance_tier
        __props__.__dict__["root_squash_configuration"] = root_squash_configuration
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_billing_cycle_end"] = time_billing_cycle_end
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return LustreFileStorageLustreFileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="capacityInGbs")
    def capacity_in_gbs(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) Capacity of the Lustre file system in GB. You can increase capacity only in multiples of 5 TB.
        """
        return pulumi.get(self, "capacity_in_gbs")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Lustre file system`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileSystemDescription")
    def file_system_description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Short description of the Lustre file system. Avoid entering confidential information.
        """
        return pulumi.get(self, "file_system_description")

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> pulumi.Output[builtins.str]:
        """
        The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'. If you have multiple Lustre file systems mounted on the same clients, this name can help distinguish them.
        """
        return pulumi.get(self, "file_system_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message that describes the current state of the Lustre file system in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def lnet(self) -> pulumi.Output[builtins.str]:
        """
        Type of network used by clients to mount the file system.   Example: `tcp`
        """
        return pulumi.get(self, "lnet")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Sequence['outputs.LustreFileStorageLustreFileSystemMaintenanceWindow']]:
        """
        The preferred day and time to perform maintenance.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> pulumi.Output[builtins.str]:
        """
        Major version of Lustre running in the Lustre file system.  Example: `2.15`
        """
        return pulumi.get(self, "major_version")

    @property
    @pulumi.getter(name="managementServiceAddress")
    def management_service_address(self) -> pulumi.Output[builtins.str]:
        """
        The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system. For example '10.0.0.4'.
        """
        return pulumi.get(self, "management_service_address")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="performanceTier")
    def performance_tier(self) -> pulumi.Output[builtins.str]:
        """
        The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        """
        return pulumi.get(self, "performance_tier")

    @property
    @pulumi.getter(name="rootSquashConfiguration")
    def root_squash_configuration(self) -> pulumi.Output['outputs.LustreFileStorageLustreFileSystemRootSquashConfiguration']:
        """
        (Updatable) An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        """
        return pulumi.get(self, "root_squash_configuration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Lustre file system.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeBillingCycleEnd")
    def time_billing_cycle_end(self) -> pulumi.Output[builtins.str]:
        """
        The date and time that the current billing cycle for the file system will end, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. After the current cycle ends, this date is updated automatically to the next timestamp, which is 30 days later. File systems deleted earlier than this time will still incur charges until the billing cycle ends.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_billing_cycle_end")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Lustre file system was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

