# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterDatastore',
    'ClusterNetworkConfiguration',
    'ClusterUpgradeLicense',
    'ClusterVsphereUpgradeObject',
    'SddcDatastore',
    'SddcHcxOnPremLicense',
    'SddcInitialConfiguration',
    'SddcInitialConfigurationInitialClusterConfiguration',
    'SddcInitialConfigurationInitialClusterConfigurationDatastore',
    'SddcInitialConfigurationInitialClusterConfigurationNetworkConfiguration',
    'SddcUpgradeLicense',
    'SddcVsphereUpgradeObject',
    'GetClusterDatastoreResult',
    'GetClusterNetworkConfigurationResult',
    'GetClusterUpgradeLicenseResult',
    'GetClusterVsphereUpgradeObjectResult',
    'GetClustersClusterCollectionResult',
    'GetClustersClusterCollectionItemResult',
    'GetClustersClusterCollectionItemDatastoreResult',
    'GetClustersClusterCollectionItemNetworkConfigurationResult',
    'GetClustersClusterCollectionItemUpgradeLicenseResult',
    'GetClustersClusterCollectionItemVsphereUpgradeObjectResult',
    'GetClustersFilterResult',
    'GetExsiHostsEsxiHostCollectionResult',
    'GetExsiHostsFilterResult',
    'GetSddcDatastoreResult',
    'GetSddcHcxOnPremLicenseResult',
    'GetSddcInitialConfigurationResult',
    'GetSddcInitialConfigurationInitialClusterConfigurationResult',
    'GetSddcInitialConfigurationInitialClusterConfigurationDatastoreResult',
    'GetSddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationResult',
    'GetSddcUpgradeLicenseResult',
    'GetSddcVsphereUpgradeObjectResult',
    'GetSddcsFilterResult',
    'GetSddcsSddcCollectionResult',
    'GetSddcsSddcCollectionDatastoreResult',
    'GetSddcsSddcCollectionHcxOnPremLicenseResult',
    'GetSddcsSddcCollectionInitialConfigurationResult',
    'GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationResult',
    'GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationDatastoreResult',
    'GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationNetworkConfigurationResult',
    'GetSddcsSddcCollectionUpgradeLicenseResult',
    'GetSddcsSddcCollectionVsphereUpgradeObjectResult',
    'GetSupportedCommitmentsFilterResult',
    'GetSupportedCommitmentsItemResult',
    'GetSupportedHostShapesFilterResult',
    'GetSupportedHostShapesItemResult',
    'GetSupportedSkusFilterResult',
    'GetSupportedSkusItemResult',
    'GetSupportedVmwareSoftwareVersionsFilterResult',
    'GetSupportedVmwareSoftwareVersionsItemResult',
    'GetSupportedVmwareSoftwareVersionsItemEsxiSoftwareVersionResult',
]

@pulumi.output_type
class ClusterDatastore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockVolumeIds":
            suggest = "block_volume_ids"
        elif key == "datastoreType":
            suggest = "datastore_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDatastore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDatastore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDatastore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_volume_ids: Sequence[builtins.str],
                 datastore_type: builtins.str,
                 capacity: Optional[builtins.float] = None):
        """
        :param Sequence[builtins.str] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param builtins.str datastore_type: Type of the datastore.
        :param builtins.float capacity: Size of the Block Storage Volume in GB.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "datastore_type", datastore_type)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[builtins.str]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> builtins.str:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[builtins.float]:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class ClusterNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nsxEdgeVtepVlanId":
            suggest = "nsx_edge_vtep_vlan_id"
        elif key == "nsxVtepVlanId":
            suggest = "nsx_vtep_vlan_id"
        elif key == "provisioningSubnetId":
            suggest = "provisioning_subnet_id"
        elif key == "vmotionVlanId":
            suggest = "vmotion_vlan_id"
        elif key == "vsanVlanId":
            suggest = "vsan_vlan_id"
        elif key == "hcxVlanId":
            suggest = "hcx_vlan_id"
        elif key == "nsxEdgeUplink1vlanId":
            suggest = "nsx_edge_uplink1vlan_id"
        elif key == "nsxEdgeUplink2vlanId":
            suggest = "nsx_edge_uplink2vlan_id"
        elif key == "provisioningVlanId":
            suggest = "provisioning_vlan_id"
        elif key == "replicationVlanId":
            suggest = "replication_vlan_id"
        elif key == "vsphereVlanId":
            suggest = "vsphere_vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nsx_edge_vtep_vlan_id: builtins.str,
                 nsx_vtep_vlan_id: builtins.str,
                 provisioning_subnet_id: builtins.str,
                 vmotion_vlan_id: builtins.str,
                 vsan_vlan_id: builtins.str,
                 hcx_vlan_id: Optional[builtins.str] = None,
                 nsx_edge_uplink1vlan_id: Optional[builtins.str] = None,
                 nsx_edge_uplink2vlan_id: Optional[builtins.str] = None,
                 provisioning_vlan_id: Optional[builtins.str] = None,
                 replication_vlan_id: Optional[builtins.str] = None,
                 vsphere_vlan_id: Optional[builtins.str] = None):
        """
        :param builtins.str nsx_edge_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.
               
               This attribute is not guaranteed to reflect the NSX Edge VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeVTepVlanId` with that new VLAN's OCID.
        :param builtins.str nsx_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.
               
               This attribute is not guaranteed to reflect the NSX VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxVTepVlanId` with that new VLAN's OCID.
        :param builtins.str provisioning_subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        :param builtins.str vmotion_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.
               
               This attribute is not guaranteed to reflect the vMotion VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vMotion VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vMotion component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateCluster) to update the Cluster's `vmotionVlanId` with that new VLAN's OCID.
        :param builtins.str vsan_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.
               
               This attribute is not guaranteed to reflect the vSAN VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSAN VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSAN component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `vsanVlanId` with that new VLAN's OCID.
        :param builtins.str hcx_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.
               
               This attribute is not guaranteed to reflect the HCX VLAN currently used by the ESXi hosts in the SDDC. The purpose of this attribute is to show the HCX VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this SDDC in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the SDDC to use a different VLAN for the HCX component of the VMware environment, you should use [UpdateSddc](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/UpdateSddc) to update the SDDC's `hcxVlanId` with that new VLAN's OCID.
        :param builtins.str nsx_edge_uplink1vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the NSX Edge Uplink 1 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 1 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 1 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink1VlanId` with that new VLAN's OCID.
        :param builtins.str nsx_edge_uplink2vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the NSX Edge Uplink 2 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 2 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 2 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink2VlanId` with that new VLAN's OCID.
        :param builtins.str provisioning_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        :param builtins.str replication_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        :param builtins.str vsphere_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the vSphere VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSphere VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSphere component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateSddc) to update the Cluster's `vsphereVlanId` with that new VLAN's OCID.
        """
        pulumi.set(__self__, "nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        pulumi.set(__self__, "nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        pulumi.set(__self__, "provisioning_subnet_id", provisioning_subnet_id)
        pulumi.set(__self__, "vmotion_vlan_id", vmotion_vlan_id)
        pulumi.set(__self__, "vsan_vlan_id", vsan_vlan_id)
        if hcx_vlan_id is not None:
            pulumi.set(__self__, "hcx_vlan_id", hcx_vlan_id)
        if nsx_edge_uplink1vlan_id is not None:
            pulumi.set(__self__, "nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        if nsx_edge_uplink2vlan_id is not None:
            pulumi.set(__self__, "nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        if provisioning_vlan_id is not None:
            pulumi.set(__self__, "provisioning_vlan_id", provisioning_vlan_id)
        if replication_vlan_id is not None:
            pulumi.set(__self__, "replication_vlan_id", replication_vlan_id)
        if vsphere_vlan_id is not None:
            pulumi.set(__self__, "vsphere_vlan_id", vsphere_vlan_id)

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> builtins.str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.

        This attribute is not guaranteed to reflect the NSX Edge VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeVTepVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> builtins.str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.

        This attribute is not guaranteed to reflect the NSX VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxVTepVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> builtins.str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> builtins.str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.

        This attribute is not guaranteed to reflect the vMotion VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vMotion VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vMotion component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateCluster) to update the Cluster's `vmotionVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> builtins.str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.

        This attribute is not guaranteed to reflect the vSAN VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSAN VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSAN component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `vsanVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.

        This attribute is not guaranteed to reflect the HCX VLAN currently used by the ESXi hosts in the SDDC. The purpose of this attribute is to show the HCX VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this SDDC in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the SDDC to use a different VLAN for the HCX component of the VMware environment, you should use [UpdateSddc](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/UpdateSddc) to update the SDDC's `hcxVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the NSX Edge Uplink 1 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 1 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 1 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink1VlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the NSX Edge Uplink 2 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 2 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 2 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink2VlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        """
        return pulumi.get(self, "replication_vlan_id")

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the vSphere VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSphere VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSphere component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateSddc) to update the Cluster's `vsphereVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vsphere_vlan_id")


@pulumi.output_type
class ClusterUpgradeLicense(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "licenseKey":
            suggest = "license_key"
        elif key == "licenseType":
            suggest = "license_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradeLicense. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradeLicense.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradeLicense.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 license_key: Optional[builtins.str] = None,
                 license_type: Optional[builtins.str] = None):
        """
        :param builtins.str license_key: vSphere license key value.
        :param builtins.str license_type: vSphere license type.
        """
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[builtins.str]:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[builtins.str]:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")


@pulumi.output_type
class ClusterVsphereUpgradeObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadLink":
            suggest = "download_link"
        elif key == "linkDescription":
            suggest = "link_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVsphereUpgradeObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVsphereUpgradeObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVsphereUpgradeObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_link: Optional[builtins.str] = None,
                 link_description: Optional[builtins.str] = None):
        """
        :param builtins.str download_link: Binary object download link.
        :param builtins.str link_description: Binary object description.
        """
        if download_link is not None:
            pulumi.set(__self__, "download_link", download_link)
        if link_description is not None:
            pulumi.set(__self__, "link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> Optional[builtins.str]:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> Optional[builtins.str]:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")


@pulumi.output_type
class SddcDatastore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockVolumeIds":
            suggest = "block_volume_ids"
        elif key == "datastoreType":
            suggest = "datastore_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcDatastore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcDatastore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcDatastore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_volume_ids: Sequence[builtins.str],
                 datastore_type: builtins.str,
                 capacity: Optional[builtins.float] = None):
        """
        :param Sequence[builtins.str] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param builtins.str datastore_type: Type of the datastore.
        :param builtins.float capacity: Size of the Block Storage Volume in GB.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "datastore_type", datastore_type)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[builtins.str]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> builtins.str:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[builtins.float]:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class SddcHcxOnPremLicense(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationKey":
            suggest = "activation_key"
        elif key == "systemName":
            suggest = "system_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcHcxOnPremLicense. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcHcxOnPremLicense.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcHcxOnPremLicense.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activation_key: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 system_name: Optional[builtins.str] = None):
        """
        :param builtins.str activation_key: HCX on-premise license key value.
        :param builtins.str status: status of HCX on-premise license.
        :param builtins.str system_name: Name of the system that consumed the HCX on-premise license
        """
        if activation_key is not None:
            pulumi.set(__self__, "activation_key", activation_key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_name is not None:
            pulumi.set(__self__, "system_name", system_name)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> Optional[builtins.str]:
        """
        HCX on-premise license key value.
        """
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        status of HCX on-premise license.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> Optional[builtins.str]:
        """
        Name of the system that consumed the HCX on-premise license
        """
        return pulumi.get(self, "system_name")


@pulumi.output_type
class SddcInitialConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialClusterConfigurations":
            suggest = "initial_cluster_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcInitialConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcInitialConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcInitialConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_cluster_configurations: Sequence['outputs.SddcInitialConfigurationInitialClusterConfiguration']):
        """
        :param Sequence['SddcInitialConfigurationInitialClusterConfigurationArgs'] initial_cluster_configurations: The configurations for Clusters initially created in the SDDC.
        """
        pulumi.set(__self__, "initial_cluster_configurations", initial_cluster_configurations)

    @property
    @pulumi.getter(name="initialClusterConfigurations")
    def initial_cluster_configurations(self) -> Sequence['outputs.SddcInitialConfigurationInitialClusterConfiguration']:
        """
        The configurations for Clusters initially created in the SDDC.
        """
        return pulumi.get(self, "initial_cluster_configurations")


@pulumi.output_type
class SddcInitialConfigurationInitialClusterConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeAvailabilityDomain":
            suggest = "compute_availability_domain"
        elif key == "esxiHostsCount":
            suggest = "esxi_hosts_count"
        elif key == "vsphereType":
            suggest = "vsphere_type"
        elif key == "actualEsxiHostsCount":
            suggest = "actual_esxi_hosts_count"
        elif key == "capacityReservationId":
            suggest = "capacity_reservation_id"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "initialCommitment":
            suggest = "initial_commitment"
        elif key == "initialHostOcpuCount":
            suggest = "initial_host_ocpu_count"
        elif key == "initialHostShapeName":
            suggest = "initial_host_shape_name"
        elif key == "instanceDisplayNamePrefix":
            suggest = "instance_display_name_prefix"
        elif key == "isShieldedInstanceEnabled":
            suggest = "is_shielded_instance_enabled"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "workloadNetworkCidr":
            suggest = "workload_network_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcInitialConfigurationInitialClusterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcInitialConfigurationInitialClusterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcInitialConfigurationInitialClusterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_availability_domain: builtins.str,
                 esxi_hosts_count: builtins.int,
                 vsphere_type: builtins.str,
                 actual_esxi_hosts_count: Optional[builtins.int] = None,
                 capacity_reservation_id: Optional[builtins.str] = None,
                 datastores: Optional[Sequence['outputs.SddcInitialConfigurationInitialClusterConfigurationDatastore']] = None,
                 display_name: Optional[builtins.str] = None,
                 initial_commitment: Optional[builtins.str] = None,
                 initial_host_ocpu_count: Optional[builtins.float] = None,
                 initial_host_shape_name: Optional[builtins.str] = None,
                 instance_display_name_prefix: Optional[builtins.str] = None,
                 is_shielded_instance_enabled: Optional[builtins.bool] = None,
                 network_configuration: Optional['outputs.SddcInitialConfigurationInitialClusterConfigurationNetworkConfiguration'] = None,
                 workload_network_cidr: Optional[builtins.str] = None):
        """
        :param builtins.str compute_availability_domain: The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        :param builtins.int esxi_hosts_count: The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a Cluster with a ESXi host count of 1 will be considered a single ESXi host Cluster.
               
               **Note:** If you later delete EXSi hosts from a production Cluster to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until it again has at least 3 ESXi hosts.
        :param builtins.str vsphere_type: vSphere Cluster types.
        :param builtins.int actual_esxi_hosts_count: The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC. **Deprecated**.
        :param builtins.str capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param Sequence['SddcInitialConfigurationInitialClusterConfigurationDatastoreArgs'] datastores: A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        :param builtins.str display_name: A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param builtins.str initial_commitment: The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        :param builtins.float initial_host_ocpu_count: The initial OCPU count of the Cluster's ESXi hosts.
        :param builtins.str initial_host_shape_name: The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param builtins.str instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.
               
               For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        :param builtins.bool is_shielded_instance_enabled: Indicates whether shielded instance is enabled for this Cluster.
        :param 'SddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationArgs' network_configuration: The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        :param builtins.str workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads.
        """
        pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        pulumi.set(__self__, "esxi_hosts_count", esxi_hosts_count)
        pulumi.set(__self__, "vsphere_type", vsphere_type)
        if actual_esxi_hosts_count is not None:
            pulumi.set(__self__, "actual_esxi_hosts_count", actual_esxi_hosts_count)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if datastores is not None:
            pulumi.set(__self__, "datastores", datastores)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if initial_commitment is not None:
            pulumi.set(__self__, "initial_commitment", initial_commitment)
        if initial_host_ocpu_count is not None:
            pulumi.set(__self__, "initial_host_ocpu_count", initial_host_ocpu_count)
        if initial_host_shape_name is not None:
            pulumi.set(__self__, "initial_host_shape_name", initial_host_shape_name)
        if instance_display_name_prefix is not None:
            pulumi.set(__self__, "instance_display_name_prefix", instance_display_name_prefix)
        if is_shielded_instance_enabled is not None:
            pulumi.set(__self__, "is_shielded_instance_enabled", is_shielded_instance_enabled)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if workload_network_cidr is not None:
            pulumi.set(__self__, "workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> builtins.str:
        """
        The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> builtins.int:
        """
        The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a Cluster with a ESXi host count of 1 will be considered a single ESXi host Cluster.

        **Note:** If you later delete EXSi hosts from a production Cluster to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until it again has at least 3 ESXi hosts.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @property
    @pulumi.getter(name="vsphereType")
    def vsphere_type(self) -> builtins.str:
        """
        vSphere Cluster types.
        """
        return pulumi.get(self, "vsphere_type")

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> Optional[builtins.int]:
        """
        The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC. **Deprecated**.
        """
        return pulumi.get(self, "actual_esxi_hosts_count")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter
    def datastores(self) -> Optional[Sequence['outputs.SddcInitialConfigurationInitialClusterConfigurationDatastore']]:
        """
        A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="initialCommitment")
    def initial_commitment(self) -> Optional[builtins.str]:
        """
        The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "initial_commitment")

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> Optional[builtins.float]:
        """
        The initial OCPU count of the Cluster's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> Optional[builtins.str]:
        """
        The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> Optional[builtins.str]:
        """
        A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.

        For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether shielded instance is enabled for this Cluster.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.SddcInitialConfigurationInitialClusterConfigurationNetworkConfiguration']:
        """
        The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> Optional[builtins.str]:
        """
        The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads.
        """
        return pulumi.get(self, "workload_network_cidr")


@pulumi.output_type
class SddcInitialConfigurationInitialClusterConfigurationDatastore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockVolumeIds":
            suggest = "block_volume_ids"
        elif key == "datastoreType":
            suggest = "datastore_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcInitialConfigurationInitialClusterConfigurationDatastore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcInitialConfigurationInitialClusterConfigurationDatastore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcInitialConfigurationInitialClusterConfigurationDatastore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_volume_ids: Sequence[builtins.str],
                 datastore_type: builtins.str):
        """
        :param Sequence[builtins.str] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param builtins.str datastore_type: Type of the datastore.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "datastore_type", datastore_type)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[builtins.str]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> builtins.str:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")


@pulumi.output_type
class SddcInitialConfigurationInitialClusterConfigurationNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nsxEdgeVtepVlanId":
            suggest = "nsx_edge_vtep_vlan_id"
        elif key == "nsxVtepVlanId":
            suggest = "nsx_vtep_vlan_id"
        elif key == "provisioningSubnetId":
            suggest = "provisioning_subnet_id"
        elif key == "vmotionVlanId":
            suggest = "vmotion_vlan_id"
        elif key == "vsanVlanId":
            suggest = "vsan_vlan_id"
        elif key == "hcxVlanId":
            suggest = "hcx_vlan_id"
        elif key == "nsxEdgeUplink1vlanId":
            suggest = "nsx_edge_uplink1vlan_id"
        elif key == "nsxEdgeUplink2vlanId":
            suggest = "nsx_edge_uplink2vlan_id"
        elif key == "provisioningVlanId":
            suggest = "provisioning_vlan_id"
        elif key == "replicationVlanId":
            suggest = "replication_vlan_id"
        elif key == "vsphereVlanId":
            suggest = "vsphere_vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcInitialConfigurationInitialClusterConfigurationNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcInitialConfigurationInitialClusterConfigurationNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcInitialConfigurationInitialClusterConfigurationNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nsx_edge_vtep_vlan_id: builtins.str,
                 nsx_vtep_vlan_id: builtins.str,
                 provisioning_subnet_id: builtins.str,
                 vmotion_vlan_id: builtins.str,
                 vsan_vlan_id: builtins.str,
                 hcx_vlan_id: Optional[builtins.str] = None,
                 nsx_edge_uplink1vlan_id: Optional[builtins.str] = None,
                 nsx_edge_uplink2vlan_id: Optional[builtins.str] = None,
                 provisioning_vlan_id: Optional[builtins.str] = None,
                 replication_vlan_id: Optional[builtins.str] = None,
                 vsphere_vlan_id: Optional[builtins.str] = None):
        """
        :param builtins.str nsx_edge_vtep_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.
               
               This attribute is not guaranteed to reflect the NSX Edge VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeVTepVlanId` with that new VLAN's OCID.
        :param builtins.str nsx_vtep_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.
               
               This attribute is not guaranteed to reflect the NSX VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxVTepVlanId` with that new VLAN's OCID.
        :param builtins.str provisioning_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        :param builtins.str vmotion_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.
               
               This attribute is not guaranteed to reflect the vMotion VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vMotion VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vMotion component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateCluster) to update the Cluster's `vmotionVlanId` with that new VLAN's OCID.
        :param builtins.str vsan_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.
               
               This attribute is not guaranteed to reflect the vSAN VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSAN VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSAN component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `vsanVlanId` with that new VLAN's OCID.
        :param builtins.str hcx_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.
               
               This attribute is not guaranteed to reflect the HCX VLAN currently used by the ESXi hosts in the SDDC. The purpose of this attribute is to show the HCX VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this SDDC in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the SDDC to use a different VLAN for the HCX component of the VMware environment, you should use [UpdateSddc](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/UpdateSddc) to update the SDDC's `hcxVlanId` with that new VLAN's OCID.
        :param builtins.str nsx_edge_uplink1vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the NSX Edge Uplink 1 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 1 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 1 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink1VlanId` with that new VLAN's OCID.
        :param builtins.str nsx_edge_uplink2vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the NSX Edge Uplink 2 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 2 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 2 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink2VlanId` with that new VLAN's OCID.
        :param builtins.str provisioning_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        :param builtins.str replication_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        :param builtins.str vsphere_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the vSphere VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSphere VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSphere component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateSddc) to update the Cluster's `vsphereVlanId` with that new VLAN's OCID.
        """
        pulumi.set(__self__, "nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        pulumi.set(__self__, "nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        pulumi.set(__self__, "provisioning_subnet_id", provisioning_subnet_id)
        pulumi.set(__self__, "vmotion_vlan_id", vmotion_vlan_id)
        pulumi.set(__self__, "vsan_vlan_id", vsan_vlan_id)
        if hcx_vlan_id is not None:
            pulumi.set(__self__, "hcx_vlan_id", hcx_vlan_id)
        if nsx_edge_uplink1vlan_id is not None:
            pulumi.set(__self__, "nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        if nsx_edge_uplink2vlan_id is not None:
            pulumi.set(__self__, "nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        if provisioning_vlan_id is not None:
            pulumi.set(__self__, "provisioning_vlan_id", provisioning_vlan_id)
        if replication_vlan_id is not None:
            pulumi.set(__self__, "replication_vlan_id", replication_vlan_id)
        if vsphere_vlan_id is not None:
            pulumi.set(__self__, "vsphere_vlan_id", vsphere_vlan_id)

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.

        This attribute is not guaranteed to reflect the NSX Edge VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeVTepVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.

        This attribute is not guaranteed to reflect the NSX VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxVTepVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.

        This attribute is not guaranteed to reflect the vMotion VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vMotion VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vMotion component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateCluster) to update the Cluster's `vmotionVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.

        This attribute is not guaranteed to reflect the vSAN VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSAN VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSAN component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `vsanVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.

        This attribute is not guaranteed to reflect the HCX VLAN currently used by the ESXi hosts in the SDDC. The purpose of this attribute is to show the HCX VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this SDDC in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the SDDC to use a different VLAN for the HCX component of the VMware environment, you should use [UpdateSddc](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/UpdateSddc) to update the SDDC's `hcxVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the NSX Edge Uplink 1 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 1 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 1 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink1VlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the NSX Edge Uplink 2 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 2 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 2 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink2VlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        """
        return pulumi.get(self, "replication_vlan_id")

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the vSphere VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSphere VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSphere component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateSddc) to update the Cluster's `vsphereVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vsphere_vlan_id")


@pulumi.output_type
class SddcUpgradeLicense(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "licenseKey":
            suggest = "license_key"
        elif key == "licenseType":
            suggest = "license_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcUpgradeLicense. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcUpgradeLicense.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcUpgradeLicense.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 license_key: Optional[builtins.str] = None,
                 license_type: Optional[builtins.str] = None):
        """
        :param builtins.str license_key: vSphere license key value.
        :param builtins.str license_type: vSphere license type.
        """
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[builtins.str]:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[builtins.str]:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")


@pulumi.output_type
class SddcVsphereUpgradeObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadLink":
            suggest = "download_link"
        elif key == "linkDescription":
            suggest = "link_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcVsphereUpgradeObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcVsphereUpgradeObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcVsphereUpgradeObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_link: Optional[builtins.str] = None,
                 link_description: Optional[builtins.str] = None):
        """
        :param builtins.str download_link: Binary object download link.
        :param builtins.str link_description: Binary object description.
        """
        if download_link is not None:
            pulumi.set(__self__, "download_link", download_link)
        if link_description is not None:
            pulumi.set(__self__, "link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> Optional[builtins.str]:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> Optional[builtins.str]:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")


@pulumi.output_type
class GetClusterDatastoreResult(dict):
    def __init__(__self__, *,
                 block_volume_ids: Sequence[builtins.str],
                 capacity: builtins.float,
                 datastore_type: builtins.str):
        """
        :param Sequence[builtins.str] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param builtins.float capacity: Size of the Block Storage Volume in GB.
        :param builtins.str datastore_type: Type of the datastore.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "datastore_type", datastore_type)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[builtins.str]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter
    def capacity(self) -> builtins.float:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> builtins.str:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")


@pulumi.output_type
class GetClusterNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 hcx_vlan_id: builtins.str,
                 nsx_edge_uplink1vlan_id: builtins.str,
                 nsx_edge_uplink2vlan_id: builtins.str,
                 nsx_edge_vtep_vlan_id: builtins.str,
                 nsx_vtep_vlan_id: builtins.str,
                 provisioning_subnet_id: builtins.str,
                 provisioning_vlan_id: builtins.str,
                 replication_vlan_id: builtins.str,
                 vmotion_vlan_id: builtins.str,
                 vsan_vlan_id: builtins.str,
                 vsphere_vlan_id: builtins.str):
        """
        :param builtins.str hcx_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.
        :param builtins.str nsx_edge_uplink1vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        :param builtins.str nsx_edge_uplink2vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        :param builtins.str nsx_edge_vtep_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.
        :param builtins.str nsx_vtep_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.
        :param builtins.str provisioning_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        :param builtins.str provisioning_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        :param builtins.str replication_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        :param builtins.str vmotion_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.
        :param builtins.str vsan_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.
        :param builtins.str vsphere_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        """
        pulumi.set(__self__, "hcx_vlan_id", hcx_vlan_id)
        pulumi.set(__self__, "nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        pulumi.set(__self__, "nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        pulumi.set(__self__, "nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        pulumi.set(__self__, "nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        pulumi.set(__self__, "provisioning_subnet_id", provisioning_subnet_id)
        pulumi.set(__self__, "provisioning_vlan_id", provisioning_vlan_id)
        pulumi.set(__self__, "replication_vlan_id", replication_vlan_id)
        pulumi.set(__self__, "vmotion_vlan_id", vmotion_vlan_id)
        pulumi.set(__self__, "vsan_vlan_id", vsan_vlan_id)
        pulumi.set(__self__, "vsphere_vlan_id", vsphere_vlan_id)

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        """
        return pulumi.get(self, "replication_vlan_id")

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        """
        return pulumi.get(self, "vsphere_vlan_id")


@pulumi.output_type
class GetClusterUpgradeLicenseResult(dict):
    def __init__(__self__, *,
                 license_key: builtins.str,
                 license_type: builtins.str):
        """
        :param builtins.str license_key: vSphere license key value.
        :param builtins.str license_type: vSphere license type.
        """
        pulumi.set(__self__, "license_key", license_key)
        pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> builtins.str:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> builtins.str:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")


@pulumi.output_type
class GetClusterVsphereUpgradeObjectResult(dict):
    def __init__(__self__, *,
                 download_link: builtins.str,
                 link_description: builtins.str):
        """
        :param builtins.str download_link: Binary object download link.
        :param builtins.str link_description: Binary object description.
        """
        pulumi.set(__self__, "download_link", download_link)
        pulumi.set(__self__, "link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> builtins.str:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> builtins.str:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")


@pulumi.output_type
class GetClustersClusterCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetClustersClusterCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetClustersClusterCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetClustersClusterCollectionItemResult(dict):
    def __init__(__self__, *,
                 actual_esxi_hosts_count: builtins.int,
                 capacity_reservation_id: builtins.str,
                 compartment_id: builtins.str,
                 compute_availability_domain: builtins.str,
                 datastores: Sequence['outputs.GetClustersClusterCollectionItemDatastoreResult'],
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 esxi_hosts_count: builtins.int,
                 esxi_software_version: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 initial_commitment: builtins.str,
                 initial_host_ocpu_count: builtins.float,
                 initial_host_shape_name: builtins.str,
                 instance_display_name_prefix: builtins.str,
                 is_shielded_instance_enabled: builtins.bool,
                 network_configurations: Sequence['outputs.GetClustersClusterCollectionItemNetworkConfigurationResult'],
                 sddc_id: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 upgrade_licenses: Sequence['outputs.GetClustersClusterCollectionItemUpgradeLicenseResult'],
                 vmware_software_version: builtins.str,
                 vsphere_type: builtins.str,
                 vsphere_upgrade_objects: Sequence['outputs.GetClustersClusterCollectionItemVsphereUpgradeObjectResult'],
                 workload_network_cidr: builtins.str):
        """
        :param builtins.str capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment as optional parameter.
        :param builtins.str compute_availability_domain: The availability domain the ESXi hosts are running in. For Multi-AD Cluster, it is `multi-AD`.  Example: `Uocm:PHX-AD-1`, `multi-AD`
        :param Sequence['GetClustersClusterCollectionItemDatastoreArgs'] datastores: Datastores used for the Cluster.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param builtins.int esxi_hosts_count: The number of ESXi hosts in the Cluster.
        :param builtins.str esxi_software_version: In general, this is a specific version of bundled ESXi software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster.
        :param builtins.str initial_commitment: The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        :param builtins.float initial_host_ocpu_count: The initial OCPU count of the Cluster's ESXi hosts.
        :param builtins.str initial_host_shape_name: The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param builtins.str instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.
        :param builtins.bool is_shielded_instance_enabled: Indicates whether shielded instance is enabled at the Cluster level.
        :param Sequence['GetClustersClusterCollectionItemNetworkConfigurationArgs'] network_configurations: The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        :param builtins.str sddc_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
        :param builtins.str state: The lifecycle state of the resource.
        :param builtins.str time_created: The date and time the Cluster was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_updated: The date and time the Cluster was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param Sequence['GetClustersClusterCollectionItemUpgradeLicenseArgs'] upgrade_licenses: The vSphere licenses to use when upgrading the Cluster.
        :param builtins.str vmware_software_version: In general, this is a specific version of bundled VMware software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        :param builtins.str vsphere_type: vSphere Cluster types.
        :param Sequence['GetClustersClusterCollectionItemVsphereUpgradeObjectArgs'] vsphere_upgrade_objects: The links to binary objects needed to upgrade vSphere.
        :param builtins.str workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads.
        """
        pulumi.set(__self__, "actual_esxi_hosts_count", actual_esxi_hosts_count)
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        pulumi.set(__self__, "datastores", datastores)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "esxi_hosts_count", esxi_hosts_count)
        pulumi.set(__self__, "esxi_software_version", esxi_software_version)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "initial_commitment", initial_commitment)
        pulumi.set(__self__, "initial_host_ocpu_count", initial_host_ocpu_count)
        pulumi.set(__self__, "initial_host_shape_name", initial_host_shape_name)
        pulumi.set(__self__, "instance_display_name_prefix", instance_display_name_prefix)
        pulumi.set(__self__, "is_shielded_instance_enabled", is_shielded_instance_enabled)
        pulumi.set(__self__, "network_configurations", network_configurations)
        pulumi.set(__self__, "sddc_id", sddc_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "upgrade_licenses", upgrade_licenses)
        pulumi.set(__self__, "vmware_software_version", vmware_software_version)
        pulumi.set(__self__, "vsphere_type", vsphere_type)
        pulumi.set(__self__, "vsphere_upgrade_objects", vsphere_upgrade_objects)
        pulumi.set(__self__, "workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> builtins.int:
        return pulumi.get(self, "actual_esxi_hosts_count")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment as optional parameter.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> builtins.str:
        """
        The availability domain the ESXi hosts are running in. For Multi-AD Cluster, it is `multi-AD`.  Example: `Uocm:PHX-AD-1`, `multi-AD`
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetClustersClusterCollectionItemDatastoreResult']:
        """
        Datastores used for the Cluster.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> builtins.int:
        """
        The number of ESXi hosts in the Cluster.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @property
    @pulumi.getter(name="esxiSoftwareVersion")
    def esxi_software_version(self) -> builtins.str:
        """
        In general, this is a specific version of bundled ESXi software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        """
        return pulumi.get(self, "esxi_software_version")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialCommitment")
    def initial_commitment(self) -> builtins.str:
        """
        The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "initial_commitment")

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> builtins.float:
        """
        The initial OCPU count of the Cluster's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> builtins.str:
        """
        The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> builtins.str:
        """
        A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> builtins.bool:
        """
        Indicates whether shielded instance is enabled at the Cluster level.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetClustersClusterCollectionItemNetworkConfigurationResult']:
        """
        The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        """
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter(name="sddcId")
    def sddc_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
        """
        return pulumi.get(self, "sddc_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the Cluster was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the Cluster was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradeLicenses")
    def upgrade_licenses(self) -> Sequence['outputs.GetClustersClusterCollectionItemUpgradeLicenseResult']:
        """
        The vSphere licenses to use when upgrading the Cluster.
        """
        return pulumi.get(self, "upgrade_licenses")

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> builtins.str:
        """
        In general, this is a specific version of bundled VMware software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        """
        return pulumi.get(self, "vmware_software_version")

    @property
    @pulumi.getter(name="vsphereType")
    def vsphere_type(self) -> builtins.str:
        """
        vSphere Cluster types.
        """
        return pulumi.get(self, "vsphere_type")

    @property
    @pulumi.getter(name="vsphereUpgradeObjects")
    def vsphere_upgrade_objects(self) -> Sequence['outputs.GetClustersClusterCollectionItemVsphereUpgradeObjectResult']:
        """
        The links to binary objects needed to upgrade vSphere.
        """
        return pulumi.get(self, "vsphere_upgrade_objects")

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> builtins.str:
        """
        The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads.
        """
        return pulumi.get(self, "workload_network_cidr")


@pulumi.output_type
class GetClustersClusterCollectionItemDatastoreResult(dict):
    def __init__(__self__, *,
                 block_volume_ids: Sequence[builtins.str],
                 capacity: builtins.float,
                 datastore_type: builtins.str):
        """
        :param Sequence[builtins.str] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param builtins.float capacity: Size of the Block Storage Volume in GB.
        :param builtins.str datastore_type: Type of the datastore.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "datastore_type", datastore_type)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[builtins.str]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter
    def capacity(self) -> builtins.float:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> builtins.str:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")


@pulumi.output_type
class GetClustersClusterCollectionItemNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 hcx_vlan_id: builtins.str,
                 nsx_edge_uplink1vlan_id: builtins.str,
                 nsx_edge_uplink2vlan_id: builtins.str,
                 nsx_edge_vtep_vlan_id: builtins.str,
                 nsx_vtep_vlan_id: builtins.str,
                 provisioning_subnet_id: builtins.str,
                 provisioning_vlan_id: builtins.str,
                 replication_vlan_id: builtins.str,
                 vmotion_vlan_id: builtins.str,
                 vsan_vlan_id: builtins.str,
                 vsphere_vlan_id: builtins.str):
        """
        :param builtins.str hcx_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.
        :param builtins.str nsx_edge_uplink1vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        :param builtins.str nsx_edge_uplink2vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        :param builtins.str nsx_edge_vtep_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.
        :param builtins.str nsx_vtep_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.
        :param builtins.str provisioning_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        :param builtins.str provisioning_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        :param builtins.str replication_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        :param builtins.str vmotion_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.
        :param builtins.str vsan_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.
        :param builtins.str vsphere_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        """
        pulumi.set(__self__, "hcx_vlan_id", hcx_vlan_id)
        pulumi.set(__self__, "nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        pulumi.set(__self__, "nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        pulumi.set(__self__, "nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        pulumi.set(__self__, "nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        pulumi.set(__self__, "provisioning_subnet_id", provisioning_subnet_id)
        pulumi.set(__self__, "provisioning_vlan_id", provisioning_vlan_id)
        pulumi.set(__self__, "replication_vlan_id", replication_vlan_id)
        pulumi.set(__self__, "vmotion_vlan_id", vmotion_vlan_id)
        pulumi.set(__self__, "vsan_vlan_id", vsan_vlan_id)
        pulumi.set(__self__, "vsphere_vlan_id", vsphere_vlan_id)

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        """
        return pulumi.get(self, "replication_vlan_id")

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
        """
        return pulumi.get(self, "vsphere_vlan_id")


@pulumi.output_type
class GetClustersClusterCollectionItemUpgradeLicenseResult(dict):
    def __init__(__self__, *,
                 license_key: builtins.str,
                 license_type: builtins.str):
        """
        :param builtins.str license_key: vSphere license key value.
        :param builtins.str license_type: vSphere license type.
        """
        pulumi.set(__self__, "license_key", license_key)
        pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> builtins.str:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> builtins.str:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")


@pulumi.output_type
class GetClustersClusterCollectionItemVsphereUpgradeObjectResult(dict):
    def __init__(__self__, *,
                 download_link: builtins.str,
                 link_description: builtins.str):
        """
        :param builtins.str download_link: Binary object download link.
        :param builtins.str link_description: Binary object description.
        """
        pulumi.set(__self__, "download_link", download_link)
        pulumi.set(__self__, "link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> builtins.str:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> builtins.str:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")


@pulumi.output_type
class GetClustersFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetExsiHostsEsxiHostCollectionResult(dict):
    def __init__(__self__, *,
                 billing_contract_end_date: builtins.str,
                 billing_donor_host_id: builtins.str,
                 capacity_reservation_id: builtins.str,
                 cluster_id: builtins.str,
                 compartment_id: builtins.str,
                 compute_availability_domain: builtins.str,
                 compute_instance_id: builtins.str,
                 current_commitment: builtins.str,
                 current_sku: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 esxi_software_version: builtins.str,
                 failed_esxi_host_id: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 grace_period_end_date: builtins.str,
                 host_ocpu_count: builtins.float,
                 host_shape_name: builtins.str,
                 id: builtins.str,
                 is_billing_continuation_in_progress: builtins.bool,
                 is_billing_swapping_in_progress: builtins.bool,
                 next_commitment: builtins.str,
                 next_sku: builtins.str,
                 non_upgraded_esxi_host_id: builtins.str,
                 replacement_esxi_host_id: builtins.str,
                 sddc_id: builtins.str,
                 state: builtins.str,
                 swap_billing_host_id: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 upgraded_replacement_esxi_host_id: builtins.str,
                 vmware_software_version: builtins.str):
        """
        :param builtins.str billing_contract_end_date: Current billing cycle end date. If the value in `currentCommitment` and `nextCommitment` are different, the value specified in `nextCommitment` becomes the new `currentCommitment` when the `contractEndDate` is reached. Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str billing_donor_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        :param builtins.str capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param builtins.str cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC Cluster.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment as optional parameter.
        :param builtins.str compute_availability_domain: The availability domain of the ESXi host.
        :param builtins.str compute_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute instance.
        :param builtins.str current_commitment: The billing option currently used by the ESXi host. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        :param builtins.str current_sku: (**Deprecated**) The billing option currently used by the ESXi host. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).  **Deprecated**. Please use `current_commitment` instead.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param builtins.str esxi_software_version: The version of ESXi software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        :param builtins.str failed_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that failed.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str grace_period_end_date: The date and time when the new esxi host should start billing cycle. [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2021-07-25T21:10:29.600Z`
        :param builtins.float host_ocpu_count: The OCPU count of the ESXi host.
        :param builtins.str host_shape_name: The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedHostShapes/ListSupportedHostShapes).
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host.
        :param builtins.bool is_billing_continuation_in_progress: Indicates whether this host is in the progress of billing continuation.
        :param builtins.bool is_billing_swapping_in_progress: Indicates whether this host is in the progress of swapping billing.
        :param builtins.str next_commitment: The billing option to switch to after the current billing cycle ends. If `nextCommitment` is null or empty, `currentCommitment` continues to the next billing cycle. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        :param builtins.str next_sku: (**Deprecated**) The billing option to switch to after the current billing cycle ends. If `nextSku` is null or empty, `currentSku` continues to the next billing cycle. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).  **Deprecated**. Please use `next_commitment` instead.
        :param builtins.str non_upgraded_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded.
        :param builtins.str replacement_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the esxi host that is newly created to replace the failed node.
        :param builtins.str sddc_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
        :param builtins.str state: The lifecycle state of the resource.
        :param builtins.str swap_billing_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the active ESXi Host to swap billing with current host.
        :param builtins.str time_created: The date and time the ESXi host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_updated: The date and time the ESXi host was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param builtins.str upgraded_replacement_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is newly created to upgrade the original host.
        :param builtins.str vmware_software_version: The version of VMware software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        """
        pulumi.set(__self__, "billing_contract_end_date", billing_contract_end_date)
        pulumi.set(__self__, "billing_donor_host_id", billing_donor_host_id)
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        pulumi.set(__self__, "compute_instance_id", compute_instance_id)
        pulumi.set(__self__, "current_commitment", current_commitment)
        pulumi.set(__self__, "current_sku", current_sku)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "esxi_software_version", esxi_software_version)
        pulumi.set(__self__, "failed_esxi_host_id", failed_esxi_host_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "grace_period_end_date", grace_period_end_date)
        pulumi.set(__self__, "host_ocpu_count", host_ocpu_count)
        pulumi.set(__self__, "host_shape_name", host_shape_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_billing_continuation_in_progress", is_billing_continuation_in_progress)
        pulumi.set(__self__, "is_billing_swapping_in_progress", is_billing_swapping_in_progress)
        pulumi.set(__self__, "next_commitment", next_commitment)
        pulumi.set(__self__, "next_sku", next_sku)
        pulumi.set(__self__, "non_upgraded_esxi_host_id", non_upgraded_esxi_host_id)
        pulumi.set(__self__, "replacement_esxi_host_id", replacement_esxi_host_id)
        pulumi.set(__self__, "sddc_id", sddc_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "swap_billing_host_id", swap_billing_host_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "upgraded_replacement_esxi_host_id", upgraded_replacement_esxi_host_id)
        pulumi.set(__self__, "vmware_software_version", vmware_software_version)

    @property
    @pulumi.getter(name="billingContractEndDate")
    def billing_contract_end_date(self) -> builtins.str:
        """
        Current billing cycle end date. If the value in `currentCommitment` and `nextCommitment` are different, the value specified in `nextCommitment` becomes the new `currentCommitment` when the `contractEndDate` is reached. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "billing_contract_end_date")

    @property
    @pulumi.getter(name="billingDonorHostId")
    @_utilities.deprecated("""This 'billing_donor_host_id' argument has been deprecated and will be computed only.""")
    def billing_donor_host_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        """
        return pulumi.get(self, "billing_donor_host_id")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC Cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment as optional parameter.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> builtins.str:
        """
        The availability domain of the ESXi host.
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter(name="computeInstanceId")
    def compute_instance_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute instance.
        """
        return pulumi.get(self, "compute_instance_id")

    @property
    @pulumi.getter(name="currentCommitment")
    def current_commitment(self) -> builtins.str:
        """
        The billing option currently used by the ESXi host. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "current_commitment")

    @property
    @pulumi.getter(name="currentSku")
    @_utilities.deprecated("""The 'current_sku' field has been deprecated. It is no longer supported.""")
    def current_sku(self) -> builtins.str:
        """
        (**Deprecated**) The billing option currently used by the ESXi host. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).  **Deprecated**. Please use `current_commitment` instead.
        """
        return pulumi.get(self, "current_sku")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiSoftwareVersion")
    def esxi_software_version(self) -> builtins.str:
        """
        The version of ESXi software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        """
        return pulumi.get(self, "esxi_software_version")

    @property
    @pulumi.getter(name="failedEsxiHostId")
    @_utilities.deprecated("""This 'failed_esxi_host_id' argument has been deprecated and will be computed only.""")
    def failed_esxi_host_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that failed.
        """
        return pulumi.get(self, "failed_esxi_host_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gracePeriodEndDate")
    def grace_period_end_date(self) -> builtins.str:
        """
        The date and time when the new esxi host should start billing cycle. [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2021-07-25T21:10:29.600Z`
        """
        return pulumi.get(self, "grace_period_end_date")

    @property
    @pulumi.getter(name="hostOcpuCount")
    def host_ocpu_count(self) -> builtins.float:
        """
        The OCPU count of the ESXi host.
        """
        return pulumi.get(self, "host_ocpu_count")

    @property
    @pulumi.getter(name="hostShapeName")
    def host_shape_name(self) -> builtins.str:
        """
        The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "host_shape_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBillingContinuationInProgress")
    def is_billing_continuation_in_progress(self) -> builtins.bool:
        """
        Indicates whether this host is in the progress of billing continuation.
        """
        return pulumi.get(self, "is_billing_continuation_in_progress")

    @property
    @pulumi.getter(name="isBillingSwappingInProgress")
    def is_billing_swapping_in_progress(self) -> builtins.bool:
        """
        Indicates whether this host is in the progress of swapping billing.
        """
        return pulumi.get(self, "is_billing_swapping_in_progress")

    @property
    @pulumi.getter(name="nextCommitment")
    def next_commitment(self) -> builtins.str:
        """
        The billing option to switch to after the current billing cycle ends. If `nextCommitment` is null or empty, `currentCommitment` continues to the next billing cycle. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "next_commitment")

    @property
    @pulumi.getter(name="nextSku")
    @_utilities.deprecated("""The 'next_sku' field has been deprecated. It is no longer supported.""")
    def next_sku(self) -> builtins.str:
        """
        (**Deprecated**) The billing option to switch to after the current billing cycle ends. If `nextSku` is null or empty, `currentSku` continues to the next billing cycle. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).  **Deprecated**. Please use `next_commitment` instead.
        """
        return pulumi.get(self, "next_sku")

    @property
    @pulumi.getter(name="nonUpgradedEsxiHostId")
    @_utilities.deprecated("""This 'non_upgraded_esxi_host_id' argument has been deprecated and will be computed only.""")
    def non_upgraded_esxi_host_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded.
        """
        return pulumi.get(self, "non_upgraded_esxi_host_id")

    @property
    @pulumi.getter(name="replacementEsxiHostId")
    def replacement_esxi_host_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the esxi host that is newly created to replace the failed node.
        """
        return pulumi.get(self, "replacement_esxi_host_id")

    @property
    @pulumi.getter(name="sddcId")
    @_utilities.deprecated("""The 'sddc_id' field has been deprecated. Please use 'cluster_id' instead.""")
    def sddc_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
        """
        return pulumi.get(self, "sddc_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="swapBillingHostId")
    def swap_billing_host_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the active ESXi Host to swap billing with current host.
        """
        return pulumi.get(self, "swap_billing_host_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the ESXi host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the ESXi host was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradedReplacementEsxiHostId")
    def upgraded_replacement_esxi_host_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is newly created to upgrade the original host.
        """
        return pulumi.get(self, "upgraded_replacement_esxi_host_id")

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> builtins.str:
        """
        The version of VMware software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        """
        return pulumi.get(self, "vmware_software_version")


@pulumi.output_type
class GetExsiHostsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSddcDatastoreResult(dict):
    def __init__(__self__, *,
                 block_volume_ids: Sequence[builtins.str],
                 capacity: builtins.float,
                 datastore_type: builtins.str):
        """
        :param Sequence[builtins.str] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param builtins.float capacity: Size of the Block Storage Volume in GB.
        :param builtins.str datastore_type: Type of the datastore.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "datastore_type", datastore_type)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[builtins.str]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter
    def capacity(self) -> builtins.float:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> builtins.str:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")


@pulumi.output_type
class GetSddcHcxOnPremLicenseResult(dict):
    def __init__(__self__, *,
                 activation_key: builtins.str,
                 status: builtins.str,
                 system_name: builtins.str):
        """
        :param builtins.str activation_key: HCX on-premise license key value.
        :param builtins.str status: status of HCX on-premise license.
        :param builtins.str system_name: Name of the system that consumed the HCX on-premise license
        """
        pulumi.set(__self__, "activation_key", activation_key)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "system_name", system_name)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> builtins.str:
        """
        HCX on-premise license key value.
        """
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        status of HCX on-premise license.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> builtins.str:
        """
        Name of the system that consumed the HCX on-premise license
        """
        return pulumi.get(self, "system_name")


@pulumi.output_type
class GetSddcInitialConfigurationResult(dict):
    def __init__(__self__, *,
                 initial_cluster_configurations: Sequence['outputs.GetSddcInitialConfigurationInitialClusterConfigurationResult']):
        """
        :param Sequence['GetSddcInitialConfigurationInitialClusterConfigurationArgs'] initial_cluster_configurations: The configurations for Clusters initially created in the SDDC.
        """
        pulumi.set(__self__, "initial_cluster_configurations", initial_cluster_configurations)

    @property
    @pulumi.getter(name="initialClusterConfigurations")
    def initial_cluster_configurations(self) -> Sequence['outputs.GetSddcInitialConfigurationInitialClusterConfigurationResult']:
        """
        The configurations for Clusters initially created in the SDDC.
        """
        return pulumi.get(self, "initial_cluster_configurations")


@pulumi.output_type
class GetSddcInitialConfigurationInitialClusterConfigurationResult(dict):
    def __init__(__self__, *,
                 actual_esxi_hosts_count: builtins.int,
                 capacity_reservation_id: builtins.str,
                 compute_availability_domain: builtins.str,
                 datastores: Sequence['outputs.GetSddcInitialConfigurationInitialClusterConfigurationDatastoreResult'],
                 display_name: builtins.str,
                 esxi_hosts_count: builtins.int,
                 initial_commitment: builtins.str,
                 initial_host_ocpu_count: builtins.float,
                 initial_host_shape_name: builtins.str,
                 instance_display_name_prefix: builtins.str,
                 is_shielded_instance_enabled: builtins.bool,
                 network_configurations: Sequence['outputs.GetSddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationResult'],
                 vsphere_type: builtins.str,
                 workload_network_cidr: builtins.str):
        """
        :param builtins.int actual_esxi_hosts_count: (**Deprecated**) The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC. **Deprecated**. Please use `actual_esxi_hosts_count` of `initial_cluster_configurations` instead.
        :param builtins.str capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param builtins.str compute_availability_domain: The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        :param Sequence['GetSddcInitialConfigurationInitialClusterConfigurationDatastoreArgs'] datastores: A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        :param builtins.str display_name: A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param builtins.int esxi_hosts_count: The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a Cluster with a ESXi host count of 1 will be considered a single ESXi host Cluster.
        :param builtins.str initial_commitment: The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        :param builtins.float initial_host_ocpu_count: (**Deprecated**) The initial OCPU count of the SDDC's ESXi hosts. **Deprecated**. Please use `initial_host_ocpu_count` of `initial_cluster_configurations` instead.
        :param builtins.str initial_host_shape_name: (**Deprecated**) The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes). **Deprecated**. Please use `initial_host_shape_name` of `initial_cluster_configurations` instead.
        :param builtins.str instance_display_name_prefix: (**Deprecated**) A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.
        :param builtins.bool is_shielded_instance_enabled: (**Deprecated**) Indicates whether shielded instance is enabled at the SDDC level. **Deprecated**. Please use `is_shielded_instance_enabled` of `initial_cluster_configurations` instead.
        :param Sequence['GetSddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationArgs'] network_configurations: The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        :param builtins.str vsphere_type: vSphere Cluster types.
        :param builtins.str workload_network_cidr: (**Deprecated**) The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads. **Deprecated**. Please use `workload_network_cidr` of `initial_cluster_configurations` instead.
        """
        pulumi.set(__self__, "actual_esxi_hosts_count", actual_esxi_hosts_count)
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        pulumi.set(__self__, "datastores", datastores)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "esxi_hosts_count", esxi_hosts_count)
        pulumi.set(__self__, "initial_commitment", initial_commitment)
        pulumi.set(__self__, "initial_host_ocpu_count", initial_host_ocpu_count)
        pulumi.set(__self__, "initial_host_shape_name", initial_host_shape_name)
        pulumi.set(__self__, "instance_display_name_prefix", instance_display_name_prefix)
        pulumi.set(__self__, "is_shielded_instance_enabled", is_shielded_instance_enabled)
        pulumi.set(__self__, "network_configurations", network_configurations)
        pulumi.set(__self__, "vsphere_type", vsphere_type)
        pulumi.set(__self__, "workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> builtins.int:
        """
        (**Deprecated**) The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC. **Deprecated**. Please use `actual_esxi_hosts_count` of `initial_cluster_configurations` instead.
        """
        return pulumi.get(self, "actual_esxi_hosts_count")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> builtins.str:
        """
        The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetSddcInitialConfigurationInitialClusterConfigurationDatastoreResult']:
        """
        A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> builtins.int:
        """
        The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a Cluster with a ESXi host count of 1 will be considered a single ESXi host Cluster.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @property
    @pulumi.getter(name="initialCommitment")
    def initial_commitment(self) -> builtins.str:
        """
        The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "initial_commitment")

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> builtins.float:
        """
        (**Deprecated**) The initial OCPU count of the SDDC's ESXi hosts. **Deprecated**. Please use `initial_host_ocpu_count` of `initial_cluster_configurations` instead.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> builtins.str:
        """
        (**Deprecated**) The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes). **Deprecated**. Please use `initial_host_shape_name` of `initial_cluster_configurations` instead.
        """
        return pulumi.get(self, "initial_host_shape_name")

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> builtins.str:
        """
        (**Deprecated**) A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> builtins.bool:
        """
        (**Deprecated**) Indicates whether shielded instance is enabled at the SDDC level. **Deprecated**. Please use `is_shielded_instance_enabled` of `initial_cluster_configurations` instead.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetSddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationResult']:
        """
        The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        """
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter(name="vsphereType")
    def vsphere_type(self) -> builtins.str:
        """
        vSphere Cluster types.
        """
        return pulumi.get(self, "vsphere_type")

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> builtins.str:
        """
        (**Deprecated**) The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads. **Deprecated**. Please use `workload_network_cidr` of `initial_cluster_configurations` instead.
        """
        return pulumi.get(self, "workload_network_cidr")


@pulumi.output_type
class GetSddcInitialConfigurationInitialClusterConfigurationDatastoreResult(dict):
    def __init__(__self__, *,
                 block_volume_ids: Sequence[builtins.str],
                 datastore_type: builtins.str):
        """
        :param Sequence[builtins.str] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param builtins.str datastore_type: Type of the datastore.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "datastore_type", datastore_type)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[builtins.str]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> builtins.str:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")


@pulumi.output_type
class GetSddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 hcx_vlan_id: builtins.str,
                 nsx_edge_uplink1vlan_id: builtins.str,
                 nsx_edge_uplink2vlan_id: builtins.str,
                 nsx_edge_vtep_vlan_id: builtins.str,
                 nsx_vtep_vlan_id: builtins.str,
                 provisioning_subnet_id: builtins.str,
                 provisioning_vlan_id: builtins.str,
                 replication_vlan_id: builtins.str,
                 vmotion_vlan_id: builtins.str,
                 vsan_vlan_id: builtins.str,
                 vsphere_vlan_id: builtins.str):
        """
        :param builtins.str hcx_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.
        :param builtins.str nsx_edge_uplink1vlan_id: (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment.
        :param builtins.str nsx_edge_uplink2vlan_id: (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 2 component of the VMware environment.
        :param builtins.str nsx_edge_vtep_vlan_id: (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge VTEP component of the VMware environment.
        :param builtins.str nsx_vtep_vlan_id: (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX VTEP component of the VMware environment.
        :param builtins.str provisioning_subnet_id: (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the SDDC. **Deprecated**. Please use `provisioning_subnet_id` of `network_configuration` instead.
        :param builtins.str provisioning_vlan_id: (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment. **Deprecated**. Please use `provisioning_vlan_id` of `network_configuration` instead.
        :param builtins.str replication_vlan_id: (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment. **Deprecated**. Please use `replication_vlan_id` of `network_configuration` instead.
        :param builtins.str vmotion_vlan_id: (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vMotion component of the VMware environment.
        :param builtins.str vsan_vlan_id: (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSAN component of the VMware environment.
        :param builtins.str vsphere_vlan_id: (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment.
        """
        pulumi.set(__self__, "hcx_vlan_id", hcx_vlan_id)
        pulumi.set(__self__, "nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        pulumi.set(__self__, "nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        pulumi.set(__self__, "nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        pulumi.set(__self__, "nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        pulumi.set(__self__, "provisioning_subnet_id", provisioning_subnet_id)
        pulumi.set(__self__, "provisioning_vlan_id", provisioning_vlan_id)
        pulumi.set(__self__, "replication_vlan_id", replication_vlan_id)
        pulumi.set(__self__, "vmotion_vlan_id", vmotion_vlan_id)
        pulumi.set(__self__, "vsan_vlan_id", vsan_vlan_id)
        pulumi.set(__self__, "vsphere_vlan_id", vsphere_vlan_id)

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> builtins.str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> builtins.str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 2 component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> builtins.str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> builtins.str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> builtins.str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the SDDC. **Deprecated**. Please use `provisioning_subnet_id` of `network_configuration` instead.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> builtins.str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment. **Deprecated**. Please use `provisioning_vlan_id` of `network_configuration` instead.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> builtins.str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment. **Deprecated**. Please use `replication_vlan_id` of `network_configuration` instead.
        """
        return pulumi.get(self, "replication_vlan_id")

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> builtins.str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vMotion component of the VMware environment.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> builtins.str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSAN component of the VMware environment.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> builtins.str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment.
        """
        return pulumi.get(self, "vsphere_vlan_id")


@pulumi.output_type
class GetSddcUpgradeLicenseResult(dict):
    def __init__(__self__, *,
                 license_key: builtins.str,
                 license_type: builtins.str):
        """
        :param builtins.str license_key: vSphere license key value.
        :param builtins.str license_type: vSphere license type.
        """
        pulumi.set(__self__, "license_key", license_key)
        pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> builtins.str:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> builtins.str:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")


@pulumi.output_type
class GetSddcVsphereUpgradeObjectResult(dict):
    def __init__(__self__, *,
                 download_link: builtins.str,
                 link_description: builtins.str):
        """
        :param builtins.str download_link: Binary object download link.
        :param builtins.str link_description: Binary object description.
        """
        pulumi.set(__self__, "download_link", download_link)
        pulumi.set(__self__, "link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> builtins.str:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> builtins.str:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")


@pulumi.output_type
class GetSddcsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSddcsSddcCollectionResult(dict):
    def __init__(__self__, *,
                 actual_esxi_hosts_count: builtins.int,
                 capacity_reservation_id: builtins.str,
                 clusters_count: builtins.int,
                 compartment_id: builtins.str,
                 compute_availability_domain: builtins.str,
                 datastores: Sequence['outputs.GetSddcsSddcCollectionDatastoreResult'],
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 esxi_hosts_count: builtins.int,
                 esxi_software_version: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 hcx_action: builtins.str,
                 hcx_fqdn: builtins.str,
                 hcx_initial_password: builtins.str,
                 hcx_mode: builtins.str,
                 hcx_on_prem_key: builtins.str,
                 hcx_on_prem_licenses: Sequence['outputs.GetSddcsSddcCollectionHcxOnPremLicenseResult'],
                 hcx_private_ip_id: builtins.str,
                 hcx_vlan_id: builtins.str,
                 id: builtins.str,
                 initial_configurations: Sequence['outputs.GetSddcsSddcCollectionInitialConfigurationResult'],
                 initial_host_ocpu_count: builtins.float,
                 initial_host_shape_name: builtins.str,
                 initial_sku: builtins.str,
                 instance_display_name_prefix: builtins.str,
                 is_hcx_enabled: builtins.bool,
                 is_hcx_enterprise_enabled: builtins.bool,
                 is_hcx_pending_downgrade: builtins.bool,
                 is_shielded_instance_enabled: builtins.bool,
                 is_single_host_sddc: builtins.bool,
                 nsx_edge_uplink1vlan_id: builtins.str,
                 nsx_edge_uplink2vlan_id: builtins.str,
                 nsx_edge_uplink_ip_id: builtins.str,
                 nsx_edge_vtep_vlan_id: builtins.str,
                 nsx_manager_fqdn: builtins.str,
                 nsx_manager_initial_password: builtins.str,
                 nsx_manager_private_ip_id: builtins.str,
                 nsx_manager_username: builtins.str,
                 nsx_overlay_segment_name: builtins.str,
                 nsx_vtep_vlan_id: builtins.str,
                 provisioning_subnet_id: builtins.str,
                 provisioning_vlan_id: builtins.str,
                 refresh_hcx_license_status: builtins.bool,
                 replication_vlan_id: builtins.str,
                 reserving_hcx_on_premise_license_keys: Sequence[builtins.str],
                 ssh_authorized_keys: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_hcx_billing_cycle_end: builtins.str,
                 time_hcx_license_status_updated: builtins.str,
                 time_updated: builtins.str,
                 upgrade_licenses: Sequence['outputs.GetSddcsSddcCollectionUpgradeLicenseResult'],
                 vcenter_fqdn: builtins.str,
                 vcenter_initial_password: builtins.str,
                 vcenter_private_ip_id: builtins.str,
                 vcenter_username: builtins.str,
                 vmotion_vlan_id: builtins.str,
                 vmware_software_version: builtins.str,
                 vsan_vlan_id: builtins.str,
                 vsphere_upgrade_guide: builtins.str,
                 vsphere_upgrade_objects: Sequence['outputs.GetSddcsSddcCollectionVsphereUpgradeObjectResult'],
                 vsphere_vlan_id: builtins.str,
                 workload_network_cidr: builtins.str):
        """
        :param builtins.int actual_esxi_hosts_count: (**Deprecated**) The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC.
        :param builtins.int clusters_count: The number of Clusters in the SDDC.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param builtins.str compute_availability_domain: The name of the availability domain that the Compute instances are running in.  Example: `Uocm:PHX-AD-1`
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param builtins.int esxi_hosts_count: (**Deprecated**) The number of ESXi hosts in the SDDC.
        :param builtins.str esxi_software_version: In general, this is a specific version of bundled ESXi software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str hcx_fqdn: The FQDN for HCX Manager.  Example: `hcx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param builtins.str hcx_mode: HCX configuration of the SDDC.
        :param Sequence['GetSddcsSddcCollectionHcxOnPremLicenseArgs'] hcx_on_prem_licenses: The activation licenses to use on the on-premises HCX Enterprise appliance you site pair with HCX Manager in your VMware Solution.
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
        :param builtins.float initial_host_ocpu_count: (**Deprecated**) The initial OCPU count of the SDDC's ESXi hosts.
        :param builtins.str initial_host_shape_name: (**Deprecated**) The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param builtins.bool is_hcx_enabled: (**Deprecated**) Indicates whether HCX is enabled for this SDDC. **Deprecated**. Please use `hcx_mode` instead.
        :param builtins.bool is_hcx_enterprise_enabled: (**Deprecated**) Indicates whether HCX Enterprise is enabled for this SDDC.  **Deprecated**. Please use `hcx_mode` instead.
        :param builtins.bool is_hcx_pending_downgrade: Indicates whether SDDC is pending downgrade from HCX Enterprise to HCX Advanced.
        :param builtins.bool is_shielded_instance_enabled: (**Deprecated**) Indicates whether shielded instance is enabled at the SDDC level.
        :param builtins.bool is_single_host_sddc: Indicates whether this SDDC is designated for only single ESXi host.
        :param builtins.str nsx_manager_fqdn: The FQDN for NSX Manager.  Example: `nsx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param builtins.str nsx_manager_username: The SDDC includes an administrator username and initial password for NSX Manager. You can change this initial username to a different value in NSX Manager.
        :param builtins.str state: The lifecycle state of the resource.
        :param builtins.str time_created: The date and time the SDDC was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_updated: The date and time the SDDC was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param builtins.str vcenter_fqdn: The FQDN for vCenter.  Example: `vcenter-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param builtins.str vmware_software_version: In general, this is a specific version of bundled VMware software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        """
        pulumi.set(__self__, "actual_esxi_hosts_count", actual_esxi_hosts_count)
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        pulumi.set(__self__, "clusters_count", clusters_count)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        pulumi.set(__self__, "datastores", datastores)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "esxi_hosts_count", esxi_hosts_count)
        pulumi.set(__self__, "esxi_software_version", esxi_software_version)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "hcx_action", hcx_action)
        pulumi.set(__self__, "hcx_fqdn", hcx_fqdn)
        pulumi.set(__self__, "hcx_initial_password", hcx_initial_password)
        pulumi.set(__self__, "hcx_mode", hcx_mode)
        pulumi.set(__self__, "hcx_on_prem_key", hcx_on_prem_key)
        pulumi.set(__self__, "hcx_on_prem_licenses", hcx_on_prem_licenses)
        pulumi.set(__self__, "hcx_private_ip_id", hcx_private_ip_id)
        pulumi.set(__self__, "hcx_vlan_id", hcx_vlan_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "initial_configurations", initial_configurations)
        pulumi.set(__self__, "initial_host_ocpu_count", initial_host_ocpu_count)
        pulumi.set(__self__, "initial_host_shape_name", initial_host_shape_name)
        pulumi.set(__self__, "initial_sku", initial_sku)
        pulumi.set(__self__, "instance_display_name_prefix", instance_display_name_prefix)
        pulumi.set(__self__, "is_hcx_enabled", is_hcx_enabled)
        pulumi.set(__self__, "is_hcx_enterprise_enabled", is_hcx_enterprise_enabled)
        pulumi.set(__self__, "is_hcx_pending_downgrade", is_hcx_pending_downgrade)
        pulumi.set(__self__, "is_shielded_instance_enabled", is_shielded_instance_enabled)
        pulumi.set(__self__, "is_single_host_sddc", is_single_host_sddc)
        pulumi.set(__self__, "nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        pulumi.set(__self__, "nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        pulumi.set(__self__, "nsx_edge_uplink_ip_id", nsx_edge_uplink_ip_id)
        pulumi.set(__self__, "nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        pulumi.set(__self__, "nsx_manager_fqdn", nsx_manager_fqdn)
        pulumi.set(__self__, "nsx_manager_initial_password", nsx_manager_initial_password)
        pulumi.set(__self__, "nsx_manager_private_ip_id", nsx_manager_private_ip_id)
        pulumi.set(__self__, "nsx_manager_username", nsx_manager_username)
        pulumi.set(__self__, "nsx_overlay_segment_name", nsx_overlay_segment_name)
        pulumi.set(__self__, "nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        pulumi.set(__self__, "provisioning_subnet_id", provisioning_subnet_id)
        pulumi.set(__self__, "provisioning_vlan_id", provisioning_vlan_id)
        pulumi.set(__self__, "refresh_hcx_license_status", refresh_hcx_license_status)
        pulumi.set(__self__, "replication_vlan_id", replication_vlan_id)
        pulumi.set(__self__, "reserving_hcx_on_premise_license_keys", reserving_hcx_on_premise_license_keys)
        pulumi.set(__self__, "ssh_authorized_keys", ssh_authorized_keys)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_hcx_billing_cycle_end", time_hcx_billing_cycle_end)
        pulumi.set(__self__, "time_hcx_license_status_updated", time_hcx_license_status_updated)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "upgrade_licenses", upgrade_licenses)
        pulumi.set(__self__, "vcenter_fqdn", vcenter_fqdn)
        pulumi.set(__self__, "vcenter_initial_password", vcenter_initial_password)
        pulumi.set(__self__, "vcenter_private_ip_id", vcenter_private_ip_id)
        pulumi.set(__self__, "vcenter_username", vcenter_username)
        pulumi.set(__self__, "vmotion_vlan_id", vmotion_vlan_id)
        pulumi.set(__self__, "vmware_software_version", vmware_software_version)
        pulumi.set(__self__, "vsan_vlan_id", vsan_vlan_id)
        pulumi.set(__self__, "vsphere_upgrade_guide", vsphere_upgrade_guide)
        pulumi.set(__self__, "vsphere_upgrade_objects", vsphere_upgrade_objects)
        pulumi.set(__self__, "vsphere_vlan_id", vsphere_vlan_id)
        pulumi.set(__self__, "workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    @_utilities.deprecated("""The 'actual_esxi_hosts_count' field has been deprecated. Please use 'initial_configuration' instead.""")
    def actual_esxi_hosts_count(self) -> builtins.int:
        """
        (**Deprecated**) The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC.
        """
        return pulumi.get(self, "actual_esxi_hosts_count")

    @property
    @pulumi.getter(name="capacityReservationId")
    @_utilities.deprecated("""The 'capacity_reservation_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def capacity_reservation_id(self) -> builtins.str:
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="clustersCount")
    def clusters_count(self) -> builtins.int:
        """
        The number of Clusters in the SDDC.
        """
        return pulumi.get(self, "clusters_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    @_utilities.deprecated("""The 'compute_availability_domain' field has been deprecated. Please use 'initial_configuration' instead.""")
    def compute_availability_domain(self) -> builtins.str:
        """
        The name of the availability domain that the Compute instances are running in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'datastores' field has been deprecated. Please use 'initial_configuration' instead.""")
    def datastores(self) -> Sequence['outputs.GetSddcsSddcCollectionDatastoreResult']:
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiHostsCount")
    @_utilities.deprecated("""The 'esxi_hosts_count' field has been deprecated. Please use 'initial_configuration' instead.""")
    def esxi_hosts_count(self) -> builtins.int:
        """
        (**Deprecated**) The number of ESXi hosts in the SDDC.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @property
    @pulumi.getter(name="esxiSoftwareVersion")
    def esxi_software_version(self) -> builtins.str:
        """
        In general, this is a specific version of bundled ESXi software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        """
        return pulumi.get(self, "esxi_software_version")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hcxAction")
    def hcx_action(self) -> builtins.str:
        return pulumi.get(self, "hcx_action")

    @property
    @pulumi.getter(name="hcxFqdn")
    def hcx_fqdn(self) -> builtins.str:
        """
        The FQDN for HCX Manager.  Example: `hcx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "hcx_fqdn")

    @property
    @pulumi.getter(name="hcxInitialPassword")
    @_utilities.deprecated("""The 'hcx_initial_password' field has been deprecated. Please use the 'oci_ocvp_retrieve_password' data source instead.""")
    def hcx_initial_password(self) -> builtins.str:
        return pulumi.get(self, "hcx_initial_password")

    @property
    @pulumi.getter(name="hcxMode")
    def hcx_mode(self) -> builtins.str:
        """
        HCX configuration of the SDDC.
        """
        return pulumi.get(self, "hcx_mode")

    @property
    @pulumi.getter(name="hcxOnPremKey")
    @_utilities.deprecated("""The 'hcx_on_prem_key' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def hcx_on_prem_key(self) -> builtins.str:
        return pulumi.get(self, "hcx_on_prem_key")

    @property
    @pulumi.getter(name="hcxOnPremLicenses")
    def hcx_on_prem_licenses(self) -> Sequence['outputs.GetSddcsSddcCollectionHcxOnPremLicenseResult']:
        """
        The activation licenses to use on the on-premises HCX Enterprise appliance you site pair with HCX Manager in your VMware Solution.
        """
        return pulumi.get(self, "hcx_on_prem_licenses")

    @property
    @pulumi.getter(name="hcxPrivateIpId")
    def hcx_private_ip_id(self) -> builtins.str:
        return pulumi.get(self, "hcx_private_ip_id")

    @property
    @pulumi.getter(name="hcxVlanId")
    @_utilities.deprecated("""The 'hcx_vlan_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def hcx_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "hcx_vlan_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialConfigurations")
    def initial_configurations(self) -> Sequence['outputs.GetSddcsSddcCollectionInitialConfigurationResult']:
        return pulumi.get(self, "initial_configurations")

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    @_utilities.deprecated("""The 'initial_host_ocpu_count' field has been deprecated. Please use 'initial_configuration' instead.""")
    def initial_host_ocpu_count(self) -> builtins.float:
        """
        (**Deprecated**) The initial OCPU count of the SDDC's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @property
    @pulumi.getter(name="initialHostShapeName")
    @_utilities.deprecated("""The 'initial_host_shape_name' field has been deprecated. Please use 'initial_configuration' instead.""")
    def initial_host_shape_name(self) -> builtins.str:
        """
        (**Deprecated**) The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @property
    @pulumi.getter(name="initialSku")
    @_utilities.deprecated("""The 'initial_sku' field has been deprecated. Please use 'initial_configuration' instead.""")
    def initial_sku(self) -> builtins.str:
        return pulumi.get(self, "initial_sku")

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    @_utilities.deprecated("""The 'instance_display_name_prefix' field has been deprecated. Please use 'initial_configuration' instead.""")
    def instance_display_name_prefix(self) -> builtins.str:
        return pulumi.get(self, "instance_display_name_prefix")

    @property
    @pulumi.getter(name="isHcxEnabled")
    def is_hcx_enabled(self) -> builtins.bool:
        """
        (**Deprecated**) Indicates whether HCX is enabled for this SDDC. **Deprecated**. Please use `hcx_mode` instead.
        """
        return pulumi.get(self, "is_hcx_enabled")

    @property
    @pulumi.getter(name="isHcxEnterpriseEnabled")
    @_utilities.deprecated("""The 'is_hcx_enterprise_enabled' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def is_hcx_enterprise_enabled(self) -> builtins.bool:
        """
        (**Deprecated**) Indicates whether HCX Enterprise is enabled for this SDDC.  **Deprecated**. Please use `hcx_mode` instead.
        """
        return pulumi.get(self, "is_hcx_enterprise_enabled")

    @property
    @pulumi.getter(name="isHcxPendingDowngrade")
    def is_hcx_pending_downgrade(self) -> builtins.bool:
        """
        Indicates whether SDDC is pending downgrade from HCX Enterprise to HCX Advanced.
        """
        return pulumi.get(self, "is_hcx_pending_downgrade")

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    @_utilities.deprecated("""The 'is_shielded_instance_enabled' field has been deprecated. Please use 'initial_configuration' instead.""")
    def is_shielded_instance_enabled(self) -> builtins.bool:
        """
        (**Deprecated**) Indicates whether shielded instance is enabled at the SDDC level.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @property
    @pulumi.getter(name="isSingleHostSddc")
    def is_single_host_sddc(self) -> builtins.bool:
        """
        Indicates whether this SDDC is designated for only single ESXi host.
        """
        return pulumi.get(self, "is_single_host_sddc")

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    @_utilities.deprecated("""The 'nsx_edge_uplink1vlan_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def nsx_edge_uplink1vlan_id(self) -> builtins.str:
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    @_utilities.deprecated("""The 'nsx_edge_uplink2vlan_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def nsx_edge_uplink2vlan_id(self) -> builtins.str:
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplinkIpId")
    def nsx_edge_uplink_ip_id(self) -> builtins.str:
        return pulumi.get(self, "nsx_edge_uplink_ip_id")

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    @_utilities.deprecated("""The 'nsx_edge_vtep_vlan_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def nsx_edge_vtep_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @property
    @pulumi.getter(name="nsxManagerFqdn")
    def nsx_manager_fqdn(self) -> builtins.str:
        """
        The FQDN for NSX Manager.  Example: `nsx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "nsx_manager_fqdn")

    @property
    @pulumi.getter(name="nsxManagerInitialPassword")
    @_utilities.deprecated("""The 'nsx_manager_initial_password' field has been deprecated. Please use the 'oci_ocvp_retrieve_password' data source instead.""")
    def nsx_manager_initial_password(self) -> builtins.str:
        return pulumi.get(self, "nsx_manager_initial_password")

    @property
    @pulumi.getter(name="nsxManagerPrivateIpId")
    def nsx_manager_private_ip_id(self) -> builtins.str:
        return pulumi.get(self, "nsx_manager_private_ip_id")

    @property
    @pulumi.getter(name="nsxManagerUsername")
    def nsx_manager_username(self) -> builtins.str:
        """
        The SDDC includes an administrator username and initial password for NSX Manager. You can change this initial username to a different value in NSX Manager.
        """
        return pulumi.get(self, "nsx_manager_username")

    @property
    @pulumi.getter(name="nsxOverlaySegmentName")
    @_utilities.deprecated("""The 'nsx_overlay_segment_name' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def nsx_overlay_segment_name(self) -> builtins.str:
        return pulumi.get(self, "nsx_overlay_segment_name")

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    @_utilities.deprecated("""The 'nsx_vtep_vlan_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def nsx_vtep_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @property
    @pulumi.getter(name="provisioningSubnetId")
    @_utilities.deprecated("""The 'provisioning_subnet_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def provisioning_subnet_id(self) -> builtins.str:
        return pulumi.get(self, "provisioning_subnet_id")

    @property
    @pulumi.getter(name="provisioningVlanId")
    @_utilities.deprecated("""The 'provisioning_vlan_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def provisioning_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "provisioning_vlan_id")

    @property
    @pulumi.getter(name="refreshHcxLicenseStatus")
    def refresh_hcx_license_status(self) -> builtins.bool:
        return pulumi.get(self, "refresh_hcx_license_status")

    @property
    @pulumi.getter(name="replicationVlanId")
    @_utilities.deprecated("""The 'replication_vlan_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def replication_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "replication_vlan_id")

    @property
    @pulumi.getter(name="reservingHcxOnPremiseLicenseKeys")
    def reserving_hcx_on_premise_license_keys(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "reserving_hcx_on_premise_license_keys")

    @property
    @pulumi.getter(name="sshAuthorizedKeys")
    def ssh_authorized_keys(self) -> builtins.str:
        return pulumi.get(self, "ssh_authorized_keys")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the SDDC was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeHcxBillingCycleEnd")
    def time_hcx_billing_cycle_end(self) -> builtins.str:
        return pulumi.get(self, "time_hcx_billing_cycle_end")

    @property
    @pulumi.getter(name="timeHcxLicenseStatusUpdated")
    def time_hcx_license_status_updated(self) -> builtins.str:
        return pulumi.get(self, "time_hcx_license_status_updated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the SDDC was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradeLicenses")
    @_utilities.deprecated("""The 'upgrade_licenses' field has been deprecated. Please use the 'ocvp_cluster_resource' resource instead.""")
    def upgrade_licenses(self) -> Sequence['outputs.GetSddcsSddcCollectionUpgradeLicenseResult']:
        return pulumi.get(self, "upgrade_licenses")

    @property
    @pulumi.getter(name="vcenterFqdn")
    def vcenter_fqdn(self) -> builtins.str:
        """
        The FQDN for vCenter.  Example: `vcenter-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "vcenter_fqdn")

    @property
    @pulumi.getter(name="vcenterInitialPassword")
    @_utilities.deprecated("""The 'vcenter_initial_password' field has been deprecated. Please use the 'oci_ocvp_retrieve_password' data source instead.""")
    def vcenter_initial_password(self) -> builtins.str:
        return pulumi.get(self, "vcenter_initial_password")

    @property
    @pulumi.getter(name="vcenterPrivateIpId")
    def vcenter_private_ip_id(self) -> builtins.str:
        return pulumi.get(self, "vcenter_private_ip_id")

    @property
    @pulumi.getter(name="vcenterUsername")
    def vcenter_username(self) -> builtins.str:
        return pulumi.get(self, "vcenter_username")

    @property
    @pulumi.getter(name="vmotionVlanId")
    @_utilities.deprecated("""The 'vmotion_vlan_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def vmotion_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "vmotion_vlan_id")

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> builtins.str:
        """
        In general, this is a specific version of bundled VMware software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        """
        return pulumi.get(self, "vmware_software_version")

    @property
    @pulumi.getter(name="vsanVlanId")
    @_utilities.deprecated("""The 'vsan_vlan_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def vsan_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "vsan_vlan_id")

    @property
    @pulumi.getter(name="vsphereUpgradeGuide")
    @_utilities.deprecated("""The 'vsphere_upgrade_guide' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def vsphere_upgrade_guide(self) -> builtins.str:
        return pulumi.get(self, "vsphere_upgrade_guide")

    @property
    @pulumi.getter(name="vsphereUpgradeObjects")
    @_utilities.deprecated("""The 'vsphere_upgrade_objects' field has been deprecated. Please use the 'ocvp_cluster_resource' resource instead.""")
    def vsphere_upgrade_objects(self) -> Sequence['outputs.GetSddcsSddcCollectionVsphereUpgradeObjectResult']:
        return pulumi.get(self, "vsphere_upgrade_objects")

    @property
    @pulumi.getter(name="vsphereVlanId")
    @_utilities.deprecated("""The 'vsphere_vlan_id' field has been deprecated. Please use 'initial_configuration' instead.""")
    def vsphere_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "vsphere_vlan_id")

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    @_utilities.deprecated("""The 'workload_network_cidr' field has been deprecated. Please use 'initial_configuration' instead.""")
    def workload_network_cidr(self) -> builtins.str:
        return pulumi.get(self, "workload_network_cidr")


@pulumi.output_type
class GetSddcsSddcCollectionDatastoreResult(dict):
    def __init__(__self__, *,
                 block_volume_ids: Sequence[builtins.str],
                 capacity: builtins.float,
                 datastore_type: builtins.str):
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "datastore_type", datastore_type)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter
    def capacity(self) -> builtins.float:
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> builtins.str:
        return pulumi.get(self, "datastore_type")


@pulumi.output_type
class GetSddcsSddcCollectionHcxOnPremLicenseResult(dict):
    def __init__(__self__, *,
                 activation_key: builtins.str,
                 status: builtins.str,
                 system_name: builtins.str):
        """
        :param builtins.str activation_key: HCX on-premise license key value.
        :param builtins.str status: status of HCX on-premise license.
        :param builtins.str system_name: Name of the system that consumed the HCX on-premise license
        """
        pulumi.set(__self__, "activation_key", activation_key)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "system_name", system_name)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> builtins.str:
        """
        HCX on-premise license key value.
        """
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        status of HCX on-premise license.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> builtins.str:
        """
        Name of the system that consumed the HCX on-premise license
        """
        return pulumi.get(self, "system_name")


@pulumi.output_type
class GetSddcsSddcCollectionInitialConfigurationResult(dict):
    def __init__(__self__, *,
                 initial_cluster_configurations: Sequence['outputs.GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationResult']):
        pulumi.set(__self__, "initial_cluster_configurations", initial_cluster_configurations)

    @property
    @pulumi.getter(name="initialClusterConfigurations")
    def initial_cluster_configurations(self) -> Sequence['outputs.GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationResult']:
        return pulumi.get(self, "initial_cluster_configurations")


@pulumi.output_type
class GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationResult(dict):
    def __init__(__self__, *,
                 actual_esxi_hosts_count: builtins.int,
                 capacity_reservation_id: builtins.str,
                 compute_availability_domain: builtins.str,
                 datastores: Sequence['outputs.GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationDatastoreResult'],
                 display_name: builtins.str,
                 esxi_hosts_count: builtins.int,
                 initial_commitment: builtins.str,
                 initial_host_ocpu_count: builtins.float,
                 initial_host_shape_name: builtins.str,
                 instance_display_name_prefix: builtins.str,
                 is_shielded_instance_enabled: builtins.bool,
                 network_configurations: Sequence['outputs.GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationNetworkConfigurationResult'],
                 vsphere_type: builtins.str,
                 workload_network_cidr: builtins.str):
        """
        :param builtins.int actual_esxi_hosts_count: (**Deprecated**) The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC.
        :param builtins.str compute_availability_domain: The name of the availability domain that the Compute instances are running in.  Example: `Uocm:PHX-AD-1`
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param builtins.int esxi_hosts_count: (**Deprecated**) The number of ESXi hosts in the SDDC.
        :param builtins.float initial_host_ocpu_count: (**Deprecated**) The initial OCPU count of the SDDC's ESXi hosts.
        :param builtins.str initial_host_shape_name: (**Deprecated**) The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param builtins.bool is_shielded_instance_enabled: (**Deprecated**) Indicates whether shielded instance is enabled at the SDDC level.
        """
        pulumi.set(__self__, "actual_esxi_hosts_count", actual_esxi_hosts_count)
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        pulumi.set(__self__, "datastores", datastores)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "esxi_hosts_count", esxi_hosts_count)
        pulumi.set(__self__, "initial_commitment", initial_commitment)
        pulumi.set(__self__, "initial_host_ocpu_count", initial_host_ocpu_count)
        pulumi.set(__self__, "initial_host_shape_name", initial_host_shape_name)
        pulumi.set(__self__, "instance_display_name_prefix", instance_display_name_prefix)
        pulumi.set(__self__, "is_shielded_instance_enabled", is_shielded_instance_enabled)
        pulumi.set(__self__, "network_configurations", network_configurations)
        pulumi.set(__self__, "vsphere_type", vsphere_type)
        pulumi.set(__self__, "workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> builtins.int:
        """
        (**Deprecated**) The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC.
        """
        return pulumi.get(self, "actual_esxi_hosts_count")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> builtins.str:
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> builtins.str:
        """
        The name of the availability domain that the Compute instances are running in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationDatastoreResult']:
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> builtins.int:
        """
        (**Deprecated**) The number of ESXi hosts in the SDDC.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @property
    @pulumi.getter(name="initialCommitment")
    def initial_commitment(self) -> builtins.str:
        return pulumi.get(self, "initial_commitment")

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> builtins.float:
        """
        (**Deprecated**) The initial OCPU count of the SDDC's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> builtins.str:
        """
        (**Deprecated**) The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> builtins.str:
        return pulumi.get(self, "instance_display_name_prefix")

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> builtins.bool:
        """
        (**Deprecated**) Indicates whether shielded instance is enabled at the SDDC level.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationNetworkConfigurationResult']:
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter(name="vsphereType")
    def vsphere_type(self) -> builtins.str:
        return pulumi.get(self, "vsphere_type")

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> builtins.str:
        return pulumi.get(self, "workload_network_cidr")


@pulumi.output_type
class GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationDatastoreResult(dict):
    def __init__(__self__, *,
                 block_volume_ids: Sequence[builtins.str],
                 datastore_type: builtins.str):
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "datastore_type", datastore_type)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> builtins.str:
        return pulumi.get(self, "datastore_type")


@pulumi.output_type
class GetSddcsSddcCollectionInitialConfigurationInitialClusterConfigurationNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 hcx_vlan_id: builtins.str,
                 nsx_edge_uplink1vlan_id: builtins.str,
                 nsx_edge_uplink2vlan_id: builtins.str,
                 nsx_edge_vtep_vlan_id: builtins.str,
                 nsx_vtep_vlan_id: builtins.str,
                 provisioning_subnet_id: builtins.str,
                 provisioning_vlan_id: builtins.str,
                 replication_vlan_id: builtins.str,
                 vmotion_vlan_id: builtins.str,
                 vsan_vlan_id: builtins.str,
                 vsphere_vlan_id: builtins.str):
        pulumi.set(__self__, "hcx_vlan_id", hcx_vlan_id)
        pulumi.set(__self__, "nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        pulumi.set(__self__, "nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        pulumi.set(__self__, "nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        pulumi.set(__self__, "nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        pulumi.set(__self__, "provisioning_subnet_id", provisioning_subnet_id)
        pulumi.set(__self__, "provisioning_vlan_id", provisioning_vlan_id)
        pulumi.set(__self__, "replication_vlan_id", replication_vlan_id)
        pulumi.set(__self__, "vmotion_vlan_id", vmotion_vlan_id)
        pulumi.set(__self__, "vsan_vlan_id", vsan_vlan_id)
        pulumi.set(__self__, "vsphere_vlan_id", vsphere_vlan_id)

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "hcx_vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> builtins.str:
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> builtins.str:
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> builtins.str:
        return pulumi.get(self, "provisioning_subnet_id")

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "provisioning_vlan_id")

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "replication_vlan_id")

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "vmotion_vlan_id")

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "vsan_vlan_id")

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> builtins.str:
        return pulumi.get(self, "vsphere_vlan_id")


@pulumi.output_type
class GetSddcsSddcCollectionUpgradeLicenseResult(dict):
    def __init__(__self__, *,
                 license_key: builtins.str,
                 license_type: builtins.str):
        pulumi.set(__self__, "license_key", license_key)
        pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> builtins.str:
        return pulumi.get(self, "license_key")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> builtins.str:
        return pulumi.get(self, "license_type")


@pulumi.output_type
class GetSddcsSddcCollectionVsphereUpgradeObjectResult(dict):
    def __init__(__self__, *,
                 download_link: builtins.str,
                 link_description: builtins.str):
        pulumi.set(__self__, "download_link", download_link)
        pulumi.set(__self__, "link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> builtins.str:
        return pulumi.get(self, "download_link")

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> builtins.str:
        return pulumi.get(self, "link_description")


@pulumi.output_type
class GetSupportedCommitmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: name of Commitment
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        name of Commitment
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSupportedCommitmentsItemResult(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: name of Commitment
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        name of Commitment
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSupportedHostShapesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A filter to return only resources that match the given name exactly.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSupportedHostShapesItemResult(dict):
    def __init__(__self__, *,
                 default_ocpu_count: builtins.float,
                 description: builtins.str,
                 is_single_host_sddc_supported: builtins.bool,
                 is_support_monthly_commitment: builtins.bool,
                 is_support_monthly_sku: builtins.bool,
                 is_support_shielded_instances: builtins.bool,
                 name: builtins.str,
                 shape_family: builtins.str,
                 supported_ocpu_counts: Sequence[builtins.float],
                 supported_operations: Sequence[builtins.str],
                 supported_sddc_types: Sequence[builtins.str],
                 supported_vmware_software_versions: Sequence[builtins.str]):
        """
        :param builtins.float default_ocpu_count: The default OCPU count of the shape.
        :param builtins.str description: Description of the shape.
        :param builtins.bool is_single_host_sddc_supported: A filter to return only resources that support single host SDDC.
        :param builtins.bool is_support_monthly_commitment: Whether the shape supports "MONTH" Commitment.
        :param builtins.bool is_support_monthly_sku: (**Deprecated**) Whether the shape supports "MONTH" SKU.
        :param builtins.bool is_support_shielded_instances: Indicates whether the shape supports shielded instances.
        :param builtins.str name: A filter to return only resources that match the given name exactly.
        :param builtins.str shape_family: The family of the shape. ESXi hosts of one SDDC must have the same shape family.
        :param Sequence[builtins.float] supported_ocpu_counts: Support OCPU count of the shape.
        :param Sequence[builtins.str] supported_operations: The operations where you can use the shape. The operations can be CREATE_SDDC or CREATE_ESXI_HOST.
        :param Sequence[builtins.str] supported_sddc_types: (**Deprecated**) The supported SDDC types for the shape.
        :param Sequence[builtins.str] supported_vmware_software_versions: The VMware software versions supported by the shape.
        """
        pulumi.set(__self__, "default_ocpu_count", default_ocpu_count)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_single_host_sddc_supported", is_single_host_sddc_supported)
        pulumi.set(__self__, "is_support_monthly_commitment", is_support_monthly_commitment)
        pulumi.set(__self__, "is_support_monthly_sku", is_support_monthly_sku)
        pulumi.set(__self__, "is_support_shielded_instances", is_support_shielded_instances)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "shape_family", shape_family)
        pulumi.set(__self__, "supported_ocpu_counts", supported_ocpu_counts)
        pulumi.set(__self__, "supported_operations", supported_operations)
        pulumi.set(__self__, "supported_sddc_types", supported_sddc_types)
        pulumi.set(__self__, "supported_vmware_software_versions", supported_vmware_software_versions)

    @property
    @pulumi.getter(name="defaultOcpuCount")
    def default_ocpu_count(self) -> builtins.float:
        """
        The default OCPU count of the shape.
        """
        return pulumi.get(self, "default_ocpu_count")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the shape.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isSingleHostSddcSupported")
    def is_single_host_sddc_supported(self) -> builtins.bool:
        """
        A filter to return only resources that support single host SDDC.
        """
        return pulumi.get(self, "is_single_host_sddc_supported")

    @property
    @pulumi.getter(name="isSupportMonthlyCommitment")
    def is_support_monthly_commitment(self) -> builtins.bool:
        """
        Whether the shape supports "MONTH" Commitment.
        """
        return pulumi.get(self, "is_support_monthly_commitment")

    @property
    @pulumi.getter(name="isSupportMonthlySku")
    @_utilities.deprecated("""The 'is_support_monthly_sku' field has been deprecated. Please use 'is_support_monthly_commitment' instead.""")
    def is_support_monthly_sku(self) -> builtins.bool:
        """
        (**Deprecated**) Whether the shape supports "MONTH" SKU.
        """
        return pulumi.get(self, "is_support_monthly_sku")

    @property
    @pulumi.getter(name="isSupportShieldedInstances")
    def is_support_shielded_instances(self) -> builtins.bool:
        """
        Indicates whether the shape supports shielded instances.
        """
        return pulumi.get(self, "is_support_shielded_instances")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="shapeFamily")
    def shape_family(self) -> builtins.str:
        """
        The family of the shape. ESXi hosts of one SDDC must have the same shape family.
        """
        return pulumi.get(self, "shape_family")

    @property
    @pulumi.getter(name="supportedOcpuCounts")
    def supported_ocpu_counts(self) -> Sequence[builtins.float]:
        """
        Support OCPU count of the shape.
        """
        return pulumi.get(self, "supported_ocpu_counts")

    @property
    @pulumi.getter(name="supportedOperations")
    def supported_operations(self) -> Sequence[builtins.str]:
        """
        The operations where you can use the shape. The operations can be CREATE_SDDC or CREATE_ESXI_HOST.
        """
        return pulumi.get(self, "supported_operations")

    @property
    @pulumi.getter(name="supportedSddcTypes")
    @_utilities.deprecated("""The 'supported_sddc_types' field has been deprecated. Please use 'is_single_host_sddc_supported' instead.""")
    def supported_sddc_types(self) -> Sequence[builtins.str]:
        """
        (**Deprecated**) The supported SDDC types for the shape.
        """
        return pulumi.get(self, "supported_sddc_types")

    @property
    @pulumi.getter(name="supportedVmwareSoftwareVersions")
    def supported_vmware_software_versions(self) -> Sequence[builtins.str]:
        """
        The VMware software versions supported by the shape.
        """
        return pulumi.get(self, "supported_vmware_software_versions")


@pulumi.output_type
class GetSupportedSkusFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: name of SKU
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        name of SKU
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSupportedSkusItemResult(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: name of SKU
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        name of SKU
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSupportedVmwareSoftwareVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSupportedVmwareSoftwareVersionsItemResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 esxi_software_versions: Sequence['outputs.GetSupportedVmwareSoftwareVersionsItemEsxiSoftwareVersionResult'],
                 version: builtins.str):
        """
        :param builtins.str description: A description of the software in the bundle.
        :param Sequence['GetSupportedVmwareSoftwareVersionsItemEsxiSoftwareVersionArgs'] esxi_software_versions: A list of supported ESXi software versions.
        :param builtins.str version: A filter to return only resources that match the given VMware software version exactly.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "esxi_software_versions", esxi_software_versions)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description of the software in the bundle.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="esxiSoftwareVersions")
    def esxi_software_versions(self) -> Sequence['outputs.GetSupportedVmwareSoftwareVersionsItemEsxiSoftwareVersionResult']:
        """
        A list of supported ESXi software versions.
        """
        return pulumi.get(self, "esxi_software_versions")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        A filter to return only resources that match the given VMware software version exactly.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetSupportedVmwareSoftwareVersionsItemEsxiSoftwareVersionResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 supported_host_shape_names: Sequence[builtins.str],
                 version: builtins.str):
        """
        :param builtins.str description: A description of the software in the bundle.
        :param Sequence[builtins.str] supported_host_shape_names: A list of ESXi host shapes supported by the version of bundled software.
        :param builtins.str version: A filter to return only resources that match the given VMware software version exactly.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "supported_host_shape_names", supported_host_shape_names)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description of the software in the bundle.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="supportedHostShapeNames")
    def supported_host_shape_names(self) -> Sequence[builtins.str]:
        """
        A list of ESXi host shapes supported by the version of bundled software.
        """
        return pulumi.get(self, "supported_host_shape_names")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        A filter to return only resources that match the given VMware software version exactly.
        """
        return pulumi.get(self, "version")


