# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEnrollmentStatusResult',
    'AwaitableGetEnrollmentStatusResult',
    'get_enrollment_status',
    'get_enrollment_status_output',
]

@pulumi.output_type
class GetEnrollmentStatusResult:
    """
    A collection of values returned by getEnrollmentStatus.
    """
    def __init__(__self__, compartment_id=None, enrollment_status_id=None, id=None, state=None, status=None, status_reason=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if enrollment_status_id and not isinstance(enrollment_status_id, str):
            raise TypeError("Expected argument 'enrollment_status_id' to be a str")
        pulumi.set(__self__, "enrollment_status_id", enrollment_status_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="enrollmentStatusId")
    def enrollment_status_id(self) -> builtins.str:
        return pulumi.get(self, "enrollment_status_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the enrollment status.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The enrollment status' current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The current Cloud Advisor enrollment status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> builtins.str:
        """
        The reason for the enrollment status of the tenancy.
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the enrollment status was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the enrollment status was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetEnrollmentStatusResult(GetEnrollmentStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnrollmentStatusResult(
            compartment_id=self.compartment_id,
            enrollment_status_id=self.enrollment_status_id,
            id=self.id,
            state=self.state,
            status=self.status,
            status_reason=self.status_reason,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_enrollment_status(enrollment_status_id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnrollmentStatusResult:
    """
    This data source provides details about a specific Enrollment Status resource in Oracle Cloud Infrastructure Optimizer service.

    Gets the Cloud Advisor enrollment status.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_enrollment_status = oci.Optimizer.get_enrollment_status(enrollment_status_id=test_enrollment_status_oci_optimizer_enrollment_status["id"])
    ```


    :param builtins.str enrollment_status_id: The unique OCID associated with the enrollment status.
    """
    __args__ = dict()
    __args__['enrollmentStatusId'] = enrollment_status_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Optimizer/getEnrollmentStatus:getEnrollmentStatus', __args__, opts=opts, typ=GetEnrollmentStatusResult).value

    return AwaitableGetEnrollmentStatusResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        enrollment_status_id=pulumi.get(__ret__, 'enrollment_status_id'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_enrollment_status_output(enrollment_status_id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnrollmentStatusResult]:
    """
    This data source provides details about a specific Enrollment Status resource in Oracle Cloud Infrastructure Optimizer service.

    Gets the Cloud Advisor enrollment status.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_enrollment_status = oci.Optimizer.get_enrollment_status(enrollment_status_id=test_enrollment_status_oci_optimizer_enrollment_status["id"])
    ```


    :param builtins.str enrollment_status_id: The unique OCID associated with the enrollment status.
    """
    __args__ = dict()
    __args__['enrollmentStatusId'] = enrollment_status_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Optimizer/getEnrollmentStatus:getEnrollmentStatus', __args__, opts=opts, typ=GetEnrollmentStatusResult)
    return __ret__.apply(lambda __response__: GetEnrollmentStatusResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        enrollment_status_id=pulumi.get(__response__, 'enrollment_status_id'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
