# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProfileArgs', 'Profile']

@pulumi.input_type
class ProfileArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 description: pulumi.Input[builtins.str],
                 levels_configuration: pulumi.Input['ProfileLevelsConfigurationArgs'],
                 aggregation_interval_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_compartments: Optional[pulumi.Input['ProfileTargetCompartmentsArgs']] = None,
                 target_tags: Optional[pulumi.Input['ProfileTargetTagsArgs']] = None):
        """
        The set of arguments for constructing a Profile resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the tenancy. The tenancy is the root compartment.
        :param pulumi.Input[builtins.str] description: (Updatable) Text describing the profile. Avoid entering confidential information.
        :param pulumi.Input['ProfileLevelsConfigurationArgs'] levels_configuration: (Updatable) A list of configuration levels for each recommendation.
        :param pulumi.Input[builtins.int] aggregation_interval_in_days: (Updatable) The time period over which to collect data for the recommendations, measured in number of days.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] name: (Updatable) The name assigned to the profile. Avoid entering confidential information.
        :param pulumi.Input['ProfileTargetCompartmentsArgs'] target_compartments: (Updatable) Optional. The compartments specified in the profile override for a recommendation.
        :param pulumi.Input['ProfileTargetTagsArgs'] target_tags: (Updatable) Optional. The tags specified in the profile override for a recommendation.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "levels_configuration", levels_configuration)
        if aggregation_interval_in_days is not None:
            pulumi.set(__self__, "aggregation_interval_in_days", aggregation_interval_in_days)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_compartments is not None:
            pulumi.set(__self__, "target_compartments", target_compartments)
        if target_tags is not None:
            pulumi.set(__self__, "target_tags", target_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the tenancy. The tenancy is the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Text describing the profile. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="levelsConfiguration")
    def levels_configuration(self) -> pulumi.Input['ProfileLevelsConfigurationArgs']:
        """
        (Updatable) A list of configuration levels for each recommendation.
        """
        return pulumi.get(self, "levels_configuration")

    @levels_configuration.setter
    def levels_configuration(self, value: pulumi.Input['ProfileLevelsConfigurationArgs']):
        pulumi.set(self, "levels_configuration", value)

    @property
    @pulumi.getter(name="aggregationIntervalInDays")
    def aggregation_interval_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The time period over which to collect data for the recommendations, measured in number of days.
        """
        return pulumi.get(self, "aggregation_interval_in_days")

    @aggregation_interval_in_days.setter
    def aggregation_interval_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "aggregation_interval_in_days", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name assigned to the profile. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetCompartments")
    def target_compartments(self) -> Optional[pulumi.Input['ProfileTargetCompartmentsArgs']]:
        """
        (Updatable) Optional. The compartments specified in the profile override for a recommendation.
        """
        return pulumi.get(self, "target_compartments")

    @target_compartments.setter
    def target_compartments(self, value: Optional[pulumi.Input['ProfileTargetCompartmentsArgs']]):
        pulumi.set(self, "target_compartments", value)

    @property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> Optional[pulumi.Input['ProfileTargetTagsArgs']]:
        """
        (Updatable) Optional. The tags specified in the profile override for a recommendation.
        """
        return pulumi.get(self, "target_tags")

    @target_tags.setter
    def target_tags(self, value: Optional[pulumi.Input['ProfileTargetTagsArgs']]):
        pulumi.set(self, "target_tags", value)


@pulumi.input_type
class _ProfileState:
    def __init__(__self__, *,
                 aggregation_interval_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 levels_configuration: Optional[pulumi.Input['ProfileLevelsConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_compartments: Optional[pulumi.Input['ProfileTargetCompartmentsArgs']] = None,
                 target_tags: Optional[pulumi.Input['ProfileTargetTagsArgs']] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Profile resources.
        :param pulumi.Input[builtins.int] aggregation_interval_in_days: (Updatable) The time period over which to collect data for the recommendations, measured in number of days.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the tenancy. The tenancy is the root compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Text describing the profile. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input['ProfileLevelsConfigurationArgs'] levels_configuration: (Updatable) A list of configuration levels for each recommendation.
        :param pulumi.Input[builtins.str] name: (Updatable) The name assigned to the profile. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] state: The profile's current state.
        :param pulumi.Input['ProfileTargetCompartmentsArgs'] target_compartments: (Updatable) Optional. The compartments specified in the profile override for a recommendation.
        :param pulumi.Input['ProfileTargetTagsArgs'] target_tags: (Updatable) Optional. The tags specified in the profile override for a recommendation.
        :param pulumi.Input[builtins.str] time_created: The date and time the profile was created, in the format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the profile was last updated, in the format defined by RFC3339.
        """
        if aggregation_interval_in_days is not None:
            pulumi.set(__self__, "aggregation_interval_in_days", aggregation_interval_in_days)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if levels_configuration is not None:
            pulumi.set(__self__, "levels_configuration", levels_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_compartments is not None:
            pulumi.set(__self__, "target_compartments", target_compartments)
        if target_tags is not None:
            pulumi.set(__self__, "target_tags", target_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="aggregationIntervalInDays")
    def aggregation_interval_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The time period over which to collect data for the recommendations, measured in number of days.
        """
        return pulumi.get(self, "aggregation_interval_in_days")

    @aggregation_interval_in_days.setter
    def aggregation_interval_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "aggregation_interval_in_days", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the tenancy. The tenancy is the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Text describing the profile. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="levelsConfiguration")
    def levels_configuration(self) -> Optional[pulumi.Input['ProfileLevelsConfigurationArgs']]:
        """
        (Updatable) A list of configuration levels for each recommendation.
        """
        return pulumi.get(self, "levels_configuration")

    @levels_configuration.setter
    def levels_configuration(self, value: Optional[pulumi.Input['ProfileLevelsConfigurationArgs']]):
        pulumi.set(self, "levels_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name assigned to the profile. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The profile's current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetCompartments")
    def target_compartments(self) -> Optional[pulumi.Input['ProfileTargetCompartmentsArgs']]:
        """
        (Updatable) Optional. The compartments specified in the profile override for a recommendation.
        """
        return pulumi.get(self, "target_compartments")

    @target_compartments.setter
    def target_compartments(self, value: Optional[pulumi.Input['ProfileTargetCompartmentsArgs']]):
        pulumi.set(self, "target_compartments", value)

    @property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> Optional[pulumi.Input['ProfileTargetTagsArgs']]:
        """
        (Updatable) Optional. The tags specified in the profile override for a recommendation.
        """
        return pulumi.get(self, "target_tags")

    @target_tags.setter
    def target_tags(self, value: Optional[pulumi.Input['ProfileTargetTagsArgs']]):
        pulumi.set(self, "target_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the profile was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the profile was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class Profile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_interval_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 levels_configuration: Optional[pulumi.Input[Union['ProfileLevelsConfigurationArgs', 'ProfileLevelsConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_compartments: Optional[pulumi.Input[Union['ProfileTargetCompartmentsArgs', 'ProfileTargetCompartmentsArgsDict']]] = None,
                 target_tags: Optional[pulumi.Input[Union['ProfileTargetTagsArgs', 'ProfileTargetTagsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Profile resource in Oracle Cloud Infrastructure Optimizer service.

        Creates a new profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_profile = oci.optimizer.Profile("test_profile",
            compartment_id=compartment_id,
            description=profile_description,
            levels_configuration={
                "items": [{
                    "level": profile_levels_configuration_items_level,
                    "recommendation_id": test_recommendation["id"],
                }],
            },
            name=profile_name,
            aggregation_interval_in_days=profile_aggregation_interval_in_days,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            target_compartments={
                "items": profile_target_compartments_items,
            },
            target_tags={
                "items": [{
                    "tag_definition_name": profile_target_tags_items_tag_definition_name,
                    "tag_namespace_name": test_tag_namespace["name"],
                    "tag_value_type": profile_target_tags_items_tag_value_type,
                    "tag_values": profile_target_tags_items_tag_values,
                }],
            })
        ```

        ## Import

        Profiles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Optimizer/profile:Profile test_profile "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] aggregation_interval_in_days: (Updatable) The time period over which to collect data for the recommendations, measured in number of days.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the tenancy. The tenancy is the root compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Text describing the profile. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['ProfileLevelsConfigurationArgs', 'ProfileLevelsConfigurationArgsDict']] levels_configuration: (Updatable) A list of configuration levels for each recommendation.
        :param pulumi.Input[builtins.str] name: (Updatable) The name assigned to the profile. Avoid entering confidential information.
        :param pulumi.Input[Union['ProfileTargetCompartmentsArgs', 'ProfileTargetCompartmentsArgsDict']] target_compartments: (Updatable) Optional. The compartments specified in the profile override for a recommendation.
        :param pulumi.Input[Union['ProfileTargetTagsArgs', 'ProfileTargetTagsArgsDict']] target_tags: (Updatable) Optional. The tags specified in the profile override for a recommendation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Profile resource in Oracle Cloud Infrastructure Optimizer service.

        Creates a new profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_profile = oci.optimizer.Profile("test_profile",
            compartment_id=compartment_id,
            description=profile_description,
            levels_configuration={
                "items": [{
                    "level": profile_levels_configuration_items_level,
                    "recommendation_id": test_recommendation["id"],
                }],
            },
            name=profile_name,
            aggregation_interval_in_days=profile_aggregation_interval_in_days,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            target_compartments={
                "items": profile_target_compartments_items,
            },
            target_tags={
                "items": [{
                    "tag_definition_name": profile_target_tags_items_tag_definition_name,
                    "tag_namespace_name": test_tag_namespace["name"],
                    "tag_value_type": profile_target_tags_items_tag_value_type,
                    "tag_values": profile_target_tags_items_tag_values,
                }],
            })
        ```

        ## Import

        Profiles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Optimizer/profile:Profile test_profile "id"
        ```

        :param str resource_name: The name of the resource.
        :param ProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_interval_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 levels_configuration: Optional[pulumi.Input[Union['ProfileLevelsConfigurationArgs', 'ProfileLevelsConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_compartments: Optional[pulumi.Input[Union['ProfileTargetCompartmentsArgs', 'ProfileTargetCompartmentsArgsDict']]] = None,
                 target_tags: Optional[pulumi.Input[Union['ProfileTargetTagsArgs', 'ProfileTargetTagsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileArgs.__new__(ProfileArgs)

            __props__.__dict__["aggregation_interval_in_days"] = aggregation_interval_in_days
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            if levels_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'levels_configuration'")
            __props__.__dict__["levels_configuration"] = levels_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["target_compartments"] = target_compartments
            __props__.__dict__["target_tags"] = target_tags
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Profile, __self__).__init__(
            'oci:Optimizer/profile:Profile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregation_interval_in_days: Optional[pulumi.Input[builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            levels_configuration: Optional[pulumi.Input[Union['ProfileLevelsConfigurationArgs', 'ProfileLevelsConfigurationArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_compartments: Optional[pulumi.Input[Union['ProfileTargetCompartmentsArgs', 'ProfileTargetCompartmentsArgsDict']]] = None,
            target_tags: Optional[pulumi.Input[Union['ProfileTargetTagsArgs', 'ProfileTargetTagsArgsDict']]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'Profile':
        """
        Get an existing Profile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] aggregation_interval_in_days: (Updatable) The time period over which to collect data for the recommendations, measured in number of days.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the tenancy. The tenancy is the root compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Text describing the profile. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['ProfileLevelsConfigurationArgs', 'ProfileLevelsConfigurationArgsDict']] levels_configuration: (Updatable) A list of configuration levels for each recommendation.
        :param pulumi.Input[builtins.str] name: (Updatable) The name assigned to the profile. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] state: The profile's current state.
        :param pulumi.Input[Union['ProfileTargetCompartmentsArgs', 'ProfileTargetCompartmentsArgsDict']] target_compartments: (Updatable) Optional. The compartments specified in the profile override for a recommendation.
        :param pulumi.Input[Union['ProfileTargetTagsArgs', 'ProfileTargetTagsArgsDict']] target_tags: (Updatable) Optional. The tags specified in the profile override for a recommendation.
        :param pulumi.Input[builtins.str] time_created: The date and time the profile was created, in the format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the profile was last updated, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileState.__new__(_ProfileState)

        __props__.__dict__["aggregation_interval_in_days"] = aggregation_interval_in_days
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["levels_configuration"] = levels_configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_compartments"] = target_compartments
        __props__.__dict__["target_tags"] = target_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Profile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aggregationIntervalInDays")
    def aggregation_interval_in_days(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The time period over which to collect data for the recommendations, measured in number of days.
        """
        return pulumi.get(self, "aggregation_interval_in_days")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the tenancy. The tenancy is the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Text describing the profile. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="levelsConfiguration")
    def levels_configuration(self) -> pulumi.Output['outputs.ProfileLevelsConfiguration']:
        """
        (Updatable) A list of configuration levels for each recommendation.
        """
        return pulumi.get(self, "levels_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The name assigned to the profile. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The profile's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetCompartments")
    def target_compartments(self) -> pulumi.Output['outputs.ProfileTargetCompartments']:
        """
        (Updatable) Optional. The compartments specified in the profile override for a recommendation.
        """
        return pulumi.get(self, "target_compartments")

    @property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> pulumi.Output['outputs.ProfileTargetTags']:
        """
        (Updatable) Optional. The tags specified in the profile override for a recommendation.
        """
        return pulumi.get(self, "target_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the profile was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the profile was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

