# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetErratumResult',
    'AwaitableGetErratumResult',
    'get_erratum',
    'get_erratum_output',
]

@pulumi.output_type
class GetErratumResult:
    """
    A collection of values returned by getErratum.
    """
    def __init__(__self__, advisory_severity=None, advisory_type=None, classification_type=None, compartment_id=None, description=None, from_=None, id=None, name=None, os_families=None, packages=None, references=None, related_cves=None, repositories=None, solution=None, synopsis=None, time_issued=None, time_updated=None):
        if advisory_severity and not isinstance(advisory_severity, str):
            raise TypeError("Expected argument 'advisory_severity' to be a str")
        pulumi.set(__self__, "advisory_severity", advisory_severity)
        if advisory_type and not isinstance(advisory_type, str):
            raise TypeError("Expected argument 'advisory_type' to be a str")
        pulumi.set(__self__, "advisory_type", advisory_type)
        if classification_type and not isinstance(classification_type, str):
            raise TypeError("Expected argument 'classification_type' to be a str")
        pulumi.set(__self__, "classification_type", classification_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if from_ and not isinstance(from_, str):
            raise TypeError("Expected argument 'from_' to be a str")
        pulumi.set(__self__, "from_", from_)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_families and not isinstance(os_families, list):
            raise TypeError("Expected argument 'os_families' to be a list")
        pulumi.set(__self__, "os_families", os_families)
        if packages and not isinstance(packages, list):
            raise TypeError("Expected argument 'packages' to be a list")
        pulumi.set(__self__, "packages", packages)
        if references and not isinstance(references, str):
            raise TypeError("Expected argument 'references' to be a str")
        pulumi.set(__self__, "references", references)
        if related_cves and not isinstance(related_cves, list):
            raise TypeError("Expected argument 'related_cves' to be a list")
        pulumi.set(__self__, "related_cves", related_cves)
        if repositories and not isinstance(repositories, list):
            raise TypeError("Expected argument 'repositories' to be a list")
        pulumi.set(__self__, "repositories", repositories)
        if solution and not isinstance(solution, str):
            raise TypeError("Expected argument 'solution' to be a str")
        pulumi.set(__self__, "solution", solution)
        if synopsis and not isinstance(synopsis, str):
            raise TypeError("Expected argument 'synopsis' to be a str")
        pulumi.set(__self__, "synopsis", synopsis)
        if time_issued and not isinstance(time_issued, str):
            raise TypeError("Expected argument 'time_issued' to be a str")
        pulumi.set(__self__, "time_issued", time_issued)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="advisorySeverity")
    def advisory_severity(self) -> builtins.str:
        """
        The severity for a security advisory, otherwise, null.
        """
        return pulumi.get(self, "advisory_severity")

    @property
    @pulumi.getter(name="advisoryType")
    def advisory_type(self) -> builtins.str:
        """
        The advisory type of the erratum.
        """
        return pulumi.get(self, "advisory_type")

    @property
    @pulumi.getter(name="classificationType")
    def classification_type(self) -> builtins.str:
        """
        Type of the erratum. This property is deprecated and it will be removed in a future API release. Please refer to the advisoryType property instead.
        """
        return pulumi.get(self, "classification_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Software source description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> builtins.str:
        """
        Information specifying from where the erratum was release.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique identifier for the package. Note that this is not an OCID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osFamilies")
    def os_families(self) -> Sequence[builtins.str]:
        """
        The OS families the package belongs to.
        """
        return pulumi.get(self, "os_families")

    @property
    @pulumi.getter
    def packages(self) -> Sequence['outputs.GetErratumPackageResult']:
        """
        List of packages affected by this erratum.
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter
    def references(self) -> builtins.str:
        """
        Information describing how to find more information about. the erratum.
        """
        return pulumi.get(self, "references")

    @property
    @pulumi.getter(name="relatedCves")
    def related_cves(self) -> Sequence[builtins.str]:
        """
        List of CVEs applicable to this erratum.
        """
        return pulumi.get(self, "related_cves")

    @property
    @pulumi.getter
    def repositories(self) -> Sequence[builtins.str]:
        """
        List of repository identifiers.
        """
        return pulumi.get(self, "repositories")

    @property
    @pulumi.getter
    def solution(self) -> builtins.str:
        """
        Information describing how the erratum can be resolved.
        """
        return pulumi.get(self, "solution")

    @property
    @pulumi.getter
    def synopsis(self) -> builtins.str:
        """
        Summary description of the erratum.
        """
        return pulumi.get(self, "synopsis")

    @property
    @pulumi.getter(name="timeIssued")
    def time_issued(self) -> builtins.str:
        """
        The date and time the erratum was issued (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_issued")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the erratum was updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetErratumResult(GetErratumResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetErratumResult(
            advisory_severity=self.advisory_severity,
            advisory_type=self.advisory_type,
            classification_type=self.classification_type,
            compartment_id=self.compartment_id,
            description=self.description,
            from_=self.from_,
            id=self.id,
            name=self.name,
            os_families=self.os_families,
            packages=self.packages,
            references=self.references,
            related_cves=self.related_cves,
            repositories=self.repositories,
            solution=self.solution,
            synopsis=self.synopsis,
            time_issued=self.time_issued,
            time_updated=self.time_updated)


def get_erratum(compartment_id: Optional[builtins.str] = None,
                name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetErratumResult:
    """
    This data source provides details about a specific Erratum resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the specified erratum based on its advisory name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_erratum = oci.OsManagementHub.get_erratum(compartment_id=compartment_id,
        name=erratum_name)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This parameter is required and returns only resources contained within the specified compartment.
    :param builtins.str name: The erratum name (such as ELSA-2023-34678).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getErratum:getErratum', __args__, opts=opts, typ=GetErratumResult).value

    return AwaitableGetErratumResult(
        advisory_severity=pulumi.get(__ret__, 'advisory_severity'),
        advisory_type=pulumi.get(__ret__, 'advisory_type'),
        classification_type=pulumi.get(__ret__, 'classification_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        description=pulumi.get(__ret__, 'description'),
        from_=pulumi.get(__ret__, 'from_'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        os_families=pulumi.get(__ret__, 'os_families'),
        packages=pulumi.get(__ret__, 'packages'),
        references=pulumi.get(__ret__, 'references'),
        related_cves=pulumi.get(__ret__, 'related_cves'),
        repositories=pulumi.get(__ret__, 'repositories'),
        solution=pulumi.get(__ret__, 'solution'),
        synopsis=pulumi.get(__ret__, 'synopsis'),
        time_issued=pulumi.get(__ret__, 'time_issued'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_erratum_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                       name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetErratumResult]:
    """
    This data source provides details about a specific Erratum resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the specified erratum based on its advisory name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_erratum = oci.OsManagementHub.get_erratum(compartment_id=compartment_id,
        name=erratum_name)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This parameter is required and returns only resources contained within the specified compartment.
    :param builtins.str name: The erratum name (such as ELSA-2023-34678).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getErratum:getErratum', __args__, opts=opts, typ=GetErratumResult)
    return __ret__.apply(lambda __response__: GetErratumResult(
        advisory_severity=pulumi.get(__response__, 'advisory_severity'),
        advisory_type=pulumi.get(__response__, 'advisory_type'),
        classification_type=pulumi.get(__response__, 'classification_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        description=pulumi.get(__response__, 'description'),
        from_=pulumi.get(__response__, 'from_'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        os_families=pulumi.get(__response__, 'os_families'),
        packages=pulumi.get(__response__, 'packages'),
        references=pulumi.get(__response__, 'references'),
        related_cves=pulumi.get(__response__, 'related_cves'),
        repositories=pulumi.get(__response__, 'repositories'),
        solution=pulumi.get(__response__, 'solution'),
        synopsis=pulumi.get(__response__, 'synopsis'),
        time_issued=pulumi.get(__response__, 'time_issued'),
        time_updated=pulumi.get(__response__, 'time_updated')))
