# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduledJobArgs', 'ScheduledJob']

@pulumi.input_type
class ScheduledJobArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 operations: pulumi.Input[Sequence[pulumi.Input['ScheduledJobOperationArgs']]],
                 schedule_type: pulumi.Input[builtins.str],
                 time_next_execution: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_managed_by_autonomous_linux: Optional[pulumi.Input[builtins.bool]] = None,
                 is_subcompartment_included: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_stage_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_compartment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_instance_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 recurring_rule: Optional[pulumi.Input[builtins.str]] = None,
                 retry_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 work_request_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ScheduledJob resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the scheduled job.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledJobOperationArgs']]] operations: (Updatable) The list of operations this scheduled job needs to perform. A scheduled job supports only one operation type, unless it is one of the following:
               * UPDATE_PACKAGES
               * UPDATE_ALL
               * UPDATE_SECURITY
               * UPDATE_BUGFIX
               * UPDATE_ENHANCEMENT
               * UPDATE_OTHER
               * UPDATE_KSPLICE_USERSPACE
               * UPDATE_KSPLICE_KERNEL
        :param pulumi.Input[builtins.str] schedule_type: (Updatable) The type of scheduling frequency for the scheduled job.
        :param pulumi.Input[builtins.str] time_next_execution: (Updatable) The desired time of the next execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the scheduled job. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friendly name for the scheduled job. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_managed_by_autonomous_linux: Indicates whether this scheduled job is managed by the Autonomous Linux service.
        :param pulumi.Input[builtins.bool] is_subcompartment_included: Indicates whether to apply the scheduled job to all compartments in the tenancy when managedCompartmentIds specifies  the tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (root compartment).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lifecycle_stage_ids: The lifecycle stage [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds,  or managedInstanceGroupIds, or managedCompartmentIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] locations: The list of locations this scheduled job should operate on for a job targeting on compartments. (Empty list means apply to all locations). This can only be set when managedCompartmentIds is not empty.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_compartment_ids: The compartment [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  To apply the job to all compartments in the tenancy, set this to the tenancy OCID (root compartment) and set  isSubcompartmentIncluded to true. A scheduled job can only operate on one type of target, therefore you must  supply either this or managedInstanceIds, or managedInstanceGroupIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_group_ids: The managed instance group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds, or managedCompartmentIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or  managedInstanceGroupIds, or managedCompartmentIds, or lifecycleStageIds.
        :param pulumi.Input[builtins.str] recurring_rule: (Updatable) The frequency schedule for a recurring scheduled job.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] retry_intervals: (Updatable) The amount of time in minutes to wait until retrying the scheduled job. If set, the service will automatically  retry a failed scheduled job after the interval. For example, you could set the interval to [2,5,10]. If the initial execution of the job fails, the service waits 2 minutes and then retries. If that fails, the service  waits 5 minutes and then retries. If that fails, the service waits 10 minutes and then retries.
        :param pulumi.Input[builtins.str] work_request_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the work request that will be rerun.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "operations", operations)
        pulumi.set(__self__, "schedule_type", schedule_type)
        pulumi.set(__self__, "time_next_execution", time_next_execution)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_managed_by_autonomous_linux is not None:
            pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if is_subcompartment_included is not None:
            pulumi.set(__self__, "is_subcompartment_included", is_subcompartment_included)
        if lifecycle_stage_ids is not None:
            pulumi.set(__self__, "lifecycle_stage_ids", lifecycle_stage_ids)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if managed_compartment_ids is not None:
            pulumi.set(__self__, "managed_compartment_ids", managed_compartment_ids)
        if managed_instance_group_ids is not None:
            pulumi.set(__self__, "managed_instance_group_ids", managed_instance_group_ids)
        if managed_instance_ids is not None:
            pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if recurring_rule is not None:
            pulumi.set(__self__, "recurring_rule", recurring_rule)
        if retry_intervals is not None:
            pulumi.set(__self__, "retry_intervals", retry_intervals)
        if work_request_id is not None:
            pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the scheduled job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def operations(self) -> pulumi.Input[Sequence[pulumi.Input['ScheduledJobOperationArgs']]]:
        """
        (Updatable) The list of operations this scheduled job needs to perform. A scheduled job supports only one operation type, unless it is one of the following:
        * UPDATE_PACKAGES
        * UPDATE_ALL
        * UPDATE_SECURITY
        * UPDATE_BUGFIX
        * UPDATE_ENHANCEMENT
        * UPDATE_OTHER
        * UPDATE_KSPLICE_USERSPACE
        * UPDATE_KSPLICE_KERNEL
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: pulumi.Input[Sequence[pulumi.Input['ScheduledJobOperationArgs']]]):
        pulumi.set(self, "operations", value)

    @property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The type of scheduling frequency for the scheduled job.
        """
        return pulumi.get(self, "schedule_type")

    @schedule_type.setter
    def schedule_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schedule_type", value)

    @property
    @pulumi.getter(name="timeNextExecution")
    def time_next_execution(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The desired time of the next execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_next_execution")

    @time_next_execution.setter
    def time_next_execution(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "time_next_execution", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-specified description of the scheduled job. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-friendly name for the scheduled job. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether this scheduled job is managed by the Autonomous Linux service.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @is_managed_by_autonomous_linux.setter
    def is_managed_by_autonomous_linux(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_managed_by_autonomous_linux", value)

    @property
    @pulumi.getter(name="isSubcompartmentIncluded")
    def is_subcompartment_included(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to apply the scheduled job to all compartments in the tenancy when managedCompartmentIds specifies  the tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (root compartment).
        """
        return pulumi.get(self, "is_subcompartment_included")

    @is_subcompartment_included.setter
    def is_subcompartment_included(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_subcompartment_included", value)

    @property
    @pulumi.getter(name="lifecycleStageIds")
    def lifecycle_stage_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The lifecycle stage [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds,  or managedInstanceGroupIds, or managedCompartmentIds.
        """
        return pulumi.get(self, "lifecycle_stage_ids")

    @lifecycle_stage_ids.setter
    def lifecycle_stage_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "lifecycle_stage_ids", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of locations this scheduled job should operate on for a job targeting on compartments. (Empty list means apply to all locations). This can only be set when managedCompartmentIds is not empty.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="managedCompartmentIds")
    def managed_compartment_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The compartment [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  To apply the job to all compartments in the tenancy, set this to the tenancy OCID (root compartment) and set  isSubcompartmentIncluded to true. A scheduled job can only operate on one type of target, therefore you must  supply either this or managedInstanceIds, or managedInstanceGroupIds, or lifecycleStageIds.
        """
        return pulumi.get(self, "managed_compartment_ids")

    @managed_compartment_ids.setter
    def managed_compartment_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_compartment_ids", value)

    @property
    @pulumi.getter(name="managedInstanceGroupIds")
    def managed_instance_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The managed instance group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds, or managedCompartmentIds, or lifecycleStageIds.
        """
        return pulumi.get(self, "managed_instance_group_ids")

    @managed_instance_group_ids.setter
    def managed_instance_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instance_group_ids", value)

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or  managedInstanceGroupIds, or managedCompartmentIds, or lifecycleStageIds.
        """
        return pulumi.get(self, "managed_instance_ids")

    @managed_instance_ids.setter
    def managed_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instance_ids", value)

    @property
    @pulumi.getter(name="recurringRule")
    def recurring_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The frequency schedule for a recurring scheduled job.
        """
        return pulumi.get(self, "recurring_rule")

    @recurring_rule.setter
    def recurring_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recurring_rule", value)

    @property
    @pulumi.getter(name="retryIntervals")
    def retry_intervals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        (Updatable) The amount of time in minutes to wait until retrying the scheduled job. If set, the service will automatically  retry a failed scheduled job after the interval. For example, you could set the interval to [2,5,10]. If the initial execution of the job fails, the service waits 2 minutes and then retries. If that fails, the service  waits 5 minutes and then retries. If that fails, the service waits 10 minutes and then retries.
        """
        return pulumi.get(self, "retry_intervals")

    @retry_intervals.setter
    def retry_intervals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "retry_intervals", value)

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the work request that will be rerun.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "work_request_id")

    @work_request_id.setter
    def work_request_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "work_request_id", value)


@pulumi.input_type
class _ScheduledJobState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_managed_by_autonomous_linux: Optional[pulumi.Input[builtins.bool]] = None,
                 is_restricted: Optional[pulumi.Input[builtins.bool]] = None,
                 is_subcompartment_included: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_stage_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_compartment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_instance_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledJobOperationArgs']]]] = None,
                 recurring_rule: Optional[pulumi.Input[builtins.str]] = None,
                 retry_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 schedule_type: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_last_execution: Optional[pulumi.Input[builtins.str]] = None,
                 time_next_execution: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 work_request_id: Optional[pulumi.Input[builtins.str]] = None,
                 work_request_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ScheduledJob resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the scheduled job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the scheduled job. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friendly name for the scheduled job. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_managed_by_autonomous_linux: Indicates whether this scheduled job is managed by the Autonomous Linux service.
        :param pulumi.Input[builtins.bool] is_restricted: Indicates if the schedule job has restricted update and deletion capabilities. For restricted scheduled jobs,  you can update only the timeNextExecution, recurringRule, and tags.
        :param pulumi.Input[builtins.bool] is_subcompartment_included: Indicates whether to apply the scheduled job to all compartments in the tenancy when managedCompartmentIds specifies  the tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (root compartment).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lifecycle_stage_ids: The lifecycle stage [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds,  or managedInstanceGroupIds, or managedCompartmentIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] locations: The list of locations this scheduled job should operate on for a job targeting on compartments. (Empty list means apply to all locations). This can only be set when managedCompartmentIds is not empty.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_compartment_ids: The compartment [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  To apply the job to all compartments in the tenancy, set this to the tenancy OCID (root compartment) and set  isSubcompartmentIncluded to true. A scheduled job can only operate on one type of target, therefore you must  supply either this or managedInstanceIds, or managedInstanceGroupIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_group_ids: The managed instance group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds, or managedCompartmentIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or  managedInstanceGroupIds, or managedCompartmentIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledJobOperationArgs']]] operations: (Updatable) The list of operations this scheduled job needs to perform. A scheduled job supports only one operation type, unless it is one of the following:
               * UPDATE_PACKAGES
               * UPDATE_ALL
               * UPDATE_SECURITY
               * UPDATE_BUGFIX
               * UPDATE_ENHANCEMENT
               * UPDATE_OTHER
               * UPDATE_KSPLICE_USERSPACE
               * UPDATE_KSPLICE_KERNEL
        :param pulumi.Input[builtins.str] recurring_rule: (Updatable) The frequency schedule for a recurring scheduled job.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] retry_intervals: (Updatable) The amount of time in minutes to wait until retrying the scheduled job. If set, the service will automatically  retry a failed scheduled job after the interval. For example, you could set the interval to [2,5,10]. If the initial execution of the job fails, the service waits 2 minutes and then retries. If that fails, the service  waits 5 minutes and then retries. If that fails, the service waits 10 minutes and then retries.
        :param pulumi.Input[builtins.str] schedule_type: (Updatable) The type of scheduling frequency for the scheduled job.
        :param pulumi.Input[builtins.str] state: The current state of the scheduled job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time this scheduled job was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_last_execution: The time of the last execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_next_execution: (Updatable) The desired time of the next execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_updated: The time this scheduled job was updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] work_request_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the work request that will be rerun.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] work_request_ids: The list of work request [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this scheduled job.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_managed_by_autonomous_linux is not None:
            pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if is_restricted is not None:
            pulumi.set(__self__, "is_restricted", is_restricted)
        if is_subcompartment_included is not None:
            pulumi.set(__self__, "is_subcompartment_included", is_subcompartment_included)
        if lifecycle_stage_ids is not None:
            pulumi.set(__self__, "lifecycle_stage_ids", lifecycle_stage_ids)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if managed_compartment_ids is not None:
            pulumi.set(__self__, "managed_compartment_ids", managed_compartment_ids)
        if managed_instance_group_ids is not None:
            pulumi.set(__self__, "managed_instance_group_ids", managed_instance_group_ids)
        if managed_instance_ids is not None:
            pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if recurring_rule is not None:
            pulumi.set(__self__, "recurring_rule", recurring_rule)
        if retry_intervals is not None:
            pulumi.set(__self__, "retry_intervals", retry_intervals)
        if schedule_type is not None:
            pulumi.set(__self__, "schedule_type", schedule_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_execution is not None:
            pulumi.set(__self__, "time_last_execution", time_last_execution)
        if time_next_execution is not None:
            pulumi.set(__self__, "time_next_execution", time_next_execution)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if work_request_id is not None:
            pulumi.set(__self__, "work_request_id", work_request_id)
        if work_request_ids is not None:
            pulumi.set(__self__, "work_request_ids", work_request_ids)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the scheduled job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-specified description of the scheduled job. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-friendly name for the scheduled job. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether this scheduled job is managed by the Autonomous Linux service.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @is_managed_by_autonomous_linux.setter
    def is_managed_by_autonomous_linux(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_managed_by_autonomous_linux", value)

    @property
    @pulumi.getter(name="isRestricted")
    def is_restricted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if the schedule job has restricted update and deletion capabilities. For restricted scheduled jobs,  you can update only the timeNextExecution, recurringRule, and tags.
        """
        return pulumi.get(self, "is_restricted")

    @is_restricted.setter
    def is_restricted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_restricted", value)

    @property
    @pulumi.getter(name="isSubcompartmentIncluded")
    def is_subcompartment_included(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to apply the scheduled job to all compartments in the tenancy when managedCompartmentIds specifies  the tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (root compartment).
        """
        return pulumi.get(self, "is_subcompartment_included")

    @is_subcompartment_included.setter
    def is_subcompartment_included(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_subcompartment_included", value)

    @property
    @pulumi.getter(name="lifecycleStageIds")
    def lifecycle_stage_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The lifecycle stage [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds,  or managedInstanceGroupIds, or managedCompartmentIds.
        """
        return pulumi.get(self, "lifecycle_stage_ids")

    @lifecycle_stage_ids.setter
    def lifecycle_stage_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "lifecycle_stage_ids", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of locations this scheduled job should operate on for a job targeting on compartments. (Empty list means apply to all locations). This can only be set when managedCompartmentIds is not empty.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="managedCompartmentIds")
    def managed_compartment_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The compartment [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  To apply the job to all compartments in the tenancy, set this to the tenancy OCID (root compartment) and set  isSubcompartmentIncluded to true. A scheduled job can only operate on one type of target, therefore you must  supply either this or managedInstanceIds, or managedInstanceGroupIds, or lifecycleStageIds.
        """
        return pulumi.get(self, "managed_compartment_ids")

    @managed_compartment_ids.setter
    def managed_compartment_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_compartment_ids", value)

    @property
    @pulumi.getter(name="managedInstanceGroupIds")
    def managed_instance_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The managed instance group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds, or managedCompartmentIds, or lifecycleStageIds.
        """
        return pulumi.get(self, "managed_instance_group_ids")

    @managed_instance_group_ids.setter
    def managed_instance_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instance_group_ids", value)

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or  managedInstanceGroupIds, or managedCompartmentIds, or lifecycleStageIds.
        """
        return pulumi.get(self, "managed_instance_ids")

    @managed_instance_ids.setter
    def managed_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instance_ids", value)

    @property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledJobOperationArgs']]]]:
        """
        (Updatable) The list of operations this scheduled job needs to perform. A scheduled job supports only one operation type, unless it is one of the following:
        * UPDATE_PACKAGES
        * UPDATE_ALL
        * UPDATE_SECURITY
        * UPDATE_BUGFIX
        * UPDATE_ENHANCEMENT
        * UPDATE_OTHER
        * UPDATE_KSPLICE_USERSPACE
        * UPDATE_KSPLICE_KERNEL
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledJobOperationArgs']]]]):
        pulumi.set(self, "operations", value)

    @property
    @pulumi.getter(name="recurringRule")
    def recurring_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The frequency schedule for a recurring scheduled job.
        """
        return pulumi.get(self, "recurring_rule")

    @recurring_rule.setter
    def recurring_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recurring_rule", value)

    @property
    @pulumi.getter(name="retryIntervals")
    def retry_intervals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        (Updatable) The amount of time in minutes to wait until retrying the scheduled job. If set, the service will automatically  retry a failed scheduled job after the interval. For example, you could set the interval to [2,5,10]. If the initial execution of the job fails, the service waits 2 minutes and then retries. If that fails, the service  waits 5 minutes and then retries. If that fails, the service waits 10 minutes and then retries.
        """
        return pulumi.get(self, "retry_intervals")

    @retry_intervals.setter
    def retry_intervals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "retry_intervals", value)

    @property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type of scheduling frequency for the scheduled job.
        """
        return pulumi.get(self, "schedule_type")

    @schedule_type.setter
    def schedule_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the scheduled job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time this scheduled job was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastExecution")
    def time_last_execution(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time of the last execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_last_execution")

    @time_last_execution.setter
    def time_last_execution(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_last_execution", value)

    @property
    @pulumi.getter(name="timeNextExecution")
    def time_next_execution(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The desired time of the next execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_next_execution")

    @time_next_execution.setter
    def time_next_execution(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_next_execution", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time this scheduled job was updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the work request that will be rerun.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "work_request_id")

    @work_request_id.setter
    def work_request_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "work_request_id", value)

    @property
    @pulumi.getter(name="workRequestIds")
    def work_request_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of work request [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this scheduled job.
        """
        return pulumi.get(self, "work_request_ids")

    @work_request_ids.setter
    def work_request_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "work_request_ids", value)


class ScheduledJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_managed_by_autonomous_linux: Optional[pulumi.Input[builtins.bool]] = None,
                 is_subcompartment_included: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_stage_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_compartment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_instance_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledJobOperationArgs', 'ScheduledJobOperationArgsDict']]]]] = None,
                 recurring_rule: Optional[pulumi.Input[builtins.str]] = None,
                 retry_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 schedule_type: Optional[pulumi.Input[builtins.str]] = None,
                 time_next_execution: Optional[pulumi.Input[builtins.str]] = None,
                 work_request_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Scheduled Job resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a new scheduled job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_scheduled_job = oci.os_management_hub.ScheduledJob("test_scheduled_job",
            compartment_id=compartment_id,
            operations=[{
                "operation_type": scheduled_job_operations_operation_type,
                "manage_module_streams_details": {
                    "disables": [{
                        "module_name": scheduled_job_operations_manage_module_streams_details_disable_module_name,
                        "stream_name": test_stream["name"],
                        "software_source_id": test_software_source["id"],
                    }],
                    "enables": [{
                        "module_name": scheduled_job_operations_manage_module_streams_details_enable_module_name,
                        "stream_name": test_stream["name"],
                        "software_source_id": test_software_source["id"],
                    }],
                    "installs": [{
                        "module_name": scheduled_job_operations_manage_module_streams_details_install_module_name,
                        "profile_name": test_profile["name"],
                        "stream_name": test_stream["name"],
                        "software_source_id": test_software_source["id"],
                    }],
                    "removes": [{
                        "module_name": scheduled_job_operations_manage_module_streams_details_remove_module_name,
                        "profile_name": test_profile["name"],
                        "stream_name": test_stream["name"],
                        "software_source_id": test_software_source["id"],
                    }],
                },
                "package_names": scheduled_job_operations_package_names,
                "reboot_timeout_in_mins": scheduled_job_operations_reboot_timeout_in_mins,
                "software_source_ids": scheduled_job_operations_software_source_ids,
                "switch_module_streams_details": {
                    "module_name": scheduled_job_operations_switch_module_streams_details_module_name,
                    "stream_name": test_stream["name"],
                    "software_source_id": test_software_source["id"],
                },
                "windows_update_names": scheduled_job_operations_windows_update_names,
            }],
            schedule_type=scheduled_job_schedule_type,
            time_next_execution=scheduled_job_time_next_execution,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=scheduled_job_description,
            display_name=scheduled_job_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_managed_by_autonomous_linux=scheduled_job_is_managed_by_autonomous_linux,
            is_subcompartment_included=scheduled_job_is_subcompartment_included,
            lifecycle_stage_ids=scheduled_job_lifecycle_stage_ids,
            locations=scheduled_job_locations,
            managed_compartment_ids=scheduled_job_managed_compartment_ids,
            managed_instance_group_ids=scheduled_job_managed_instance_group_ids,
            managed_instance_ids=scheduled_job_managed_instance_ids,
            recurring_rule=scheduled_job_recurring_rule,
            retry_intervals=scheduled_job_retry_intervals,
            work_request_id=test_work_request["id"])
        ```

        ## Import

        ScheduledJobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/scheduledJob:ScheduledJob test_scheduled_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the scheduled job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the scheduled job. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friendly name for the scheduled job. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_managed_by_autonomous_linux: Indicates whether this scheduled job is managed by the Autonomous Linux service.
        :param pulumi.Input[builtins.bool] is_subcompartment_included: Indicates whether to apply the scheduled job to all compartments in the tenancy when managedCompartmentIds specifies  the tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (root compartment).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lifecycle_stage_ids: The lifecycle stage [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds,  or managedInstanceGroupIds, or managedCompartmentIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] locations: The list of locations this scheduled job should operate on for a job targeting on compartments. (Empty list means apply to all locations). This can only be set when managedCompartmentIds is not empty.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_compartment_ids: The compartment [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  To apply the job to all compartments in the tenancy, set this to the tenancy OCID (root compartment) and set  isSubcompartmentIncluded to true. A scheduled job can only operate on one type of target, therefore you must  supply either this or managedInstanceIds, or managedInstanceGroupIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_group_ids: The managed instance group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds, or managedCompartmentIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or  managedInstanceGroupIds, or managedCompartmentIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScheduledJobOperationArgs', 'ScheduledJobOperationArgsDict']]]] operations: (Updatable) The list of operations this scheduled job needs to perform. A scheduled job supports only one operation type, unless it is one of the following:
               * UPDATE_PACKAGES
               * UPDATE_ALL
               * UPDATE_SECURITY
               * UPDATE_BUGFIX
               * UPDATE_ENHANCEMENT
               * UPDATE_OTHER
               * UPDATE_KSPLICE_USERSPACE
               * UPDATE_KSPLICE_KERNEL
        :param pulumi.Input[builtins.str] recurring_rule: (Updatable) The frequency schedule for a recurring scheduled job.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] retry_intervals: (Updatable) The amount of time in minutes to wait until retrying the scheduled job. If set, the service will automatically  retry a failed scheduled job after the interval. For example, you could set the interval to [2,5,10]. If the initial execution of the job fails, the service waits 2 minutes and then retries. If that fails, the service  waits 5 minutes and then retries. If that fails, the service waits 10 minutes and then retries.
        :param pulumi.Input[builtins.str] schedule_type: (Updatable) The type of scheduling frequency for the scheduled job.
        :param pulumi.Input[builtins.str] time_next_execution: (Updatable) The desired time of the next execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] work_request_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the work request that will be rerun.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Scheduled Job resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a new scheduled job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_scheduled_job = oci.os_management_hub.ScheduledJob("test_scheduled_job",
            compartment_id=compartment_id,
            operations=[{
                "operation_type": scheduled_job_operations_operation_type,
                "manage_module_streams_details": {
                    "disables": [{
                        "module_name": scheduled_job_operations_manage_module_streams_details_disable_module_name,
                        "stream_name": test_stream["name"],
                        "software_source_id": test_software_source["id"],
                    }],
                    "enables": [{
                        "module_name": scheduled_job_operations_manage_module_streams_details_enable_module_name,
                        "stream_name": test_stream["name"],
                        "software_source_id": test_software_source["id"],
                    }],
                    "installs": [{
                        "module_name": scheduled_job_operations_manage_module_streams_details_install_module_name,
                        "profile_name": test_profile["name"],
                        "stream_name": test_stream["name"],
                        "software_source_id": test_software_source["id"],
                    }],
                    "removes": [{
                        "module_name": scheduled_job_operations_manage_module_streams_details_remove_module_name,
                        "profile_name": test_profile["name"],
                        "stream_name": test_stream["name"],
                        "software_source_id": test_software_source["id"],
                    }],
                },
                "package_names": scheduled_job_operations_package_names,
                "reboot_timeout_in_mins": scheduled_job_operations_reboot_timeout_in_mins,
                "software_source_ids": scheduled_job_operations_software_source_ids,
                "switch_module_streams_details": {
                    "module_name": scheduled_job_operations_switch_module_streams_details_module_name,
                    "stream_name": test_stream["name"],
                    "software_source_id": test_software_source["id"],
                },
                "windows_update_names": scheduled_job_operations_windows_update_names,
            }],
            schedule_type=scheduled_job_schedule_type,
            time_next_execution=scheduled_job_time_next_execution,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=scheduled_job_description,
            display_name=scheduled_job_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_managed_by_autonomous_linux=scheduled_job_is_managed_by_autonomous_linux,
            is_subcompartment_included=scheduled_job_is_subcompartment_included,
            lifecycle_stage_ids=scheduled_job_lifecycle_stage_ids,
            locations=scheduled_job_locations,
            managed_compartment_ids=scheduled_job_managed_compartment_ids,
            managed_instance_group_ids=scheduled_job_managed_instance_group_ids,
            managed_instance_ids=scheduled_job_managed_instance_ids,
            recurring_rule=scheduled_job_recurring_rule,
            retry_intervals=scheduled_job_retry_intervals,
            work_request_id=test_work_request["id"])
        ```

        ## Import

        ScheduledJobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/scheduledJob:ScheduledJob test_scheduled_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param ScheduledJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_managed_by_autonomous_linux: Optional[pulumi.Input[builtins.bool]] = None,
                 is_subcompartment_included: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_stage_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_compartment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_instance_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledJobOperationArgs', 'ScheduledJobOperationArgsDict']]]]] = None,
                 recurring_rule: Optional[pulumi.Input[builtins.str]] = None,
                 retry_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 schedule_type: Optional[pulumi.Input[builtins.str]] = None,
                 time_next_execution: Optional[pulumi.Input[builtins.str]] = None,
                 work_request_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledJobArgs.__new__(ScheduledJobArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_managed_by_autonomous_linux"] = is_managed_by_autonomous_linux
            __props__.__dict__["is_subcompartment_included"] = is_subcompartment_included
            __props__.__dict__["lifecycle_stage_ids"] = lifecycle_stage_ids
            __props__.__dict__["locations"] = locations
            __props__.__dict__["managed_compartment_ids"] = managed_compartment_ids
            __props__.__dict__["managed_instance_group_ids"] = managed_instance_group_ids
            __props__.__dict__["managed_instance_ids"] = managed_instance_ids
            if operations is None and not opts.urn:
                raise TypeError("Missing required property 'operations'")
            __props__.__dict__["operations"] = operations
            __props__.__dict__["recurring_rule"] = recurring_rule
            __props__.__dict__["retry_intervals"] = retry_intervals
            if schedule_type is None and not opts.urn:
                raise TypeError("Missing required property 'schedule_type'")
            __props__.__dict__["schedule_type"] = schedule_type
            if time_next_execution is None and not opts.urn:
                raise TypeError("Missing required property 'time_next_execution'")
            __props__.__dict__["time_next_execution"] = time_next_execution
            __props__.__dict__["work_request_id"] = work_request_id
            __props__.__dict__["is_restricted"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_execution"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["work_request_ids"] = None
        super(ScheduledJob, __self__).__init__(
            'oci:OsManagementHub/scheduledJob:ScheduledJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_managed_by_autonomous_linux: Optional[pulumi.Input[builtins.bool]] = None,
            is_restricted: Optional[pulumi.Input[builtins.bool]] = None,
            is_subcompartment_included: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_stage_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            managed_compartment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            managed_instance_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledJobOperationArgs', 'ScheduledJobOperationArgsDict']]]]] = None,
            recurring_rule: Optional[pulumi.Input[builtins.str]] = None,
            retry_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            schedule_type: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_last_execution: Optional[pulumi.Input[builtins.str]] = None,
            time_next_execution: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            work_request_id: Optional[pulumi.Input[builtins.str]] = None,
            work_request_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'ScheduledJob':
        """
        Get an existing ScheduledJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the scheduled job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the scheduled job. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friendly name for the scheduled job. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_managed_by_autonomous_linux: Indicates whether this scheduled job is managed by the Autonomous Linux service.
        :param pulumi.Input[builtins.bool] is_restricted: Indicates if the schedule job has restricted update and deletion capabilities. For restricted scheduled jobs,  you can update only the timeNextExecution, recurringRule, and tags.
        :param pulumi.Input[builtins.bool] is_subcompartment_included: Indicates whether to apply the scheduled job to all compartments in the tenancy when managedCompartmentIds specifies  the tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (root compartment).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lifecycle_stage_ids: The lifecycle stage [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds,  or managedInstanceGroupIds, or managedCompartmentIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] locations: The list of locations this scheduled job should operate on for a job targeting on compartments. (Empty list means apply to all locations). This can only be set when managedCompartmentIds is not empty.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_compartment_ids: The compartment [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  To apply the job to all compartments in the tenancy, set this to the tenancy OCID (root compartment) and set  isSubcompartmentIncluded to true. A scheduled job can only operate on one type of target, therefore you must  supply either this or managedInstanceIds, or managedInstanceGroupIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_group_ids: The managed instance group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds, or managedCompartmentIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or  managedInstanceGroupIds, or managedCompartmentIds, or lifecycleStageIds.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScheduledJobOperationArgs', 'ScheduledJobOperationArgsDict']]]] operations: (Updatable) The list of operations this scheduled job needs to perform. A scheduled job supports only one operation type, unless it is one of the following:
               * UPDATE_PACKAGES
               * UPDATE_ALL
               * UPDATE_SECURITY
               * UPDATE_BUGFIX
               * UPDATE_ENHANCEMENT
               * UPDATE_OTHER
               * UPDATE_KSPLICE_USERSPACE
               * UPDATE_KSPLICE_KERNEL
        :param pulumi.Input[builtins.str] recurring_rule: (Updatable) The frequency schedule for a recurring scheduled job.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] retry_intervals: (Updatable) The amount of time in minutes to wait until retrying the scheduled job. If set, the service will automatically  retry a failed scheduled job after the interval. For example, you could set the interval to [2,5,10]. If the initial execution of the job fails, the service waits 2 minutes and then retries. If that fails, the service  waits 5 minutes and then retries. If that fails, the service waits 10 minutes and then retries.
        :param pulumi.Input[builtins.str] schedule_type: (Updatable) The type of scheduling frequency for the scheduled job.
        :param pulumi.Input[builtins.str] state: The current state of the scheduled job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time this scheduled job was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_last_execution: The time of the last execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_next_execution: (Updatable) The desired time of the next execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_updated: The time this scheduled job was updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] work_request_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the work request that will be rerun.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] work_request_ids: The list of work request [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this scheduled job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduledJobState.__new__(_ScheduledJobState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_managed_by_autonomous_linux"] = is_managed_by_autonomous_linux
        __props__.__dict__["is_restricted"] = is_restricted
        __props__.__dict__["is_subcompartment_included"] = is_subcompartment_included
        __props__.__dict__["lifecycle_stage_ids"] = lifecycle_stage_ids
        __props__.__dict__["locations"] = locations
        __props__.__dict__["managed_compartment_ids"] = managed_compartment_ids
        __props__.__dict__["managed_instance_group_ids"] = managed_instance_group_ids
        __props__.__dict__["managed_instance_ids"] = managed_instance_ids
        __props__.__dict__["operations"] = operations
        __props__.__dict__["recurring_rule"] = recurring_rule
        __props__.__dict__["retry_intervals"] = retry_intervals
        __props__.__dict__["schedule_type"] = schedule_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_execution"] = time_last_execution
        __props__.__dict__["time_next_execution"] = time_next_execution
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["work_request_id"] = work_request_id
        __props__.__dict__["work_request_ids"] = work_request_ids
        return ScheduledJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the scheduled job.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) User-specified description of the scheduled job. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) User-friendly name for the scheduled job. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether this scheduled job is managed by the Autonomous Linux service.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @property
    @pulumi.getter(name="isRestricted")
    def is_restricted(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates if the schedule job has restricted update and deletion capabilities. For restricted scheduled jobs,  you can update only the timeNextExecution, recurringRule, and tags.
        """
        return pulumi.get(self, "is_restricted")

    @property
    @pulumi.getter(name="isSubcompartmentIncluded")
    def is_subcompartment_included(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether to apply the scheduled job to all compartments in the tenancy when managedCompartmentIds specifies  the tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (root compartment).
        """
        return pulumi.get(self, "is_subcompartment_included")

    @property
    @pulumi.getter(name="lifecycleStageIds")
    def lifecycle_stage_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The lifecycle stage [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds,  or managedInstanceGroupIds, or managedCompartmentIds.
        """
        return pulumi.get(self, "lifecycle_stage_ids")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of locations this scheduled job should operate on for a job targeting on compartments. (Empty list means apply to all locations). This can only be set when managedCompartmentIds is not empty.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="managedCompartmentIds")
    def managed_compartment_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The compartment [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  To apply the job to all compartments in the tenancy, set this to the tenancy OCID (root compartment) and set  isSubcompartmentIncluded to true. A scheduled job can only operate on one type of target, therefore you must  supply either this or managedInstanceIds, or managedInstanceGroupIds, or lifecycleStageIds.
        """
        return pulumi.get(self, "managed_compartment_ids")

    @property
    @pulumi.getter(name="managedInstanceGroupIds")
    def managed_instance_group_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The managed instance group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or managedInstanceIds, or managedCompartmentIds, or lifecycleStageIds.
        """
        return pulumi.get(self, "managed_instance_group_ids")

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore you must supply either this or  managedInstanceGroupIds, or managedCompartmentIds, or lifecycleStageIds.
        """
        return pulumi.get(self, "managed_instance_ids")

    @property
    @pulumi.getter
    def operations(self) -> pulumi.Output[Sequence['outputs.ScheduledJobOperation']]:
        """
        (Updatable) The list of operations this scheduled job needs to perform. A scheduled job supports only one operation type, unless it is one of the following:
        * UPDATE_PACKAGES
        * UPDATE_ALL
        * UPDATE_SECURITY
        * UPDATE_BUGFIX
        * UPDATE_ENHANCEMENT
        * UPDATE_OTHER
        * UPDATE_KSPLICE_USERSPACE
        * UPDATE_KSPLICE_KERNEL
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter(name="recurringRule")
    def recurring_rule(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The frequency schedule for a recurring scheduled job.
        """
        return pulumi.get(self, "recurring_rule")

    @property
    @pulumi.getter(name="retryIntervals")
    def retry_intervals(self) -> pulumi.Output[Sequence[builtins.int]]:
        """
        (Updatable) The amount of time in minutes to wait until retrying the scheduled job. If set, the service will automatically  retry a failed scheduled job after the interval. For example, you could set the interval to [2,5,10]. If the initial execution of the job fails, the service waits 2 minutes and then retries. If that fails, the service  waits 5 minutes and then retries. If that fails, the service waits 10 minutes and then retries.
        """
        return pulumi.get(self, "retry_intervals")

    @property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The type of scheduling frequency for the scheduled job.
        """
        return pulumi.get(self, "schedule_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the scheduled job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time this scheduled job was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastExecution")
    def time_last_execution(self) -> pulumi.Output[builtins.str]:
        """
        The time of the last execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_last_execution")

    @property
    @pulumi.getter(name="timeNextExecution")
    def time_next_execution(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The desired time of the next execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_next_execution")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time this scheduled job was updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the work request that will be rerun.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "work_request_id")

    @property
    @pulumi.getter(name="workRequestIds")
    def work_request_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of work request [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this scheduled job.
        """
        return pulumi.get(self, "work_request_ids")

