# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 auth: Optional[pulumi.Input[builtins.str]] = None,
                 config_file_profile: Optional[pulumi.Input[builtins.str]] = None,
                 disable_auto_retries: Optional[pulumi.Input[builtins.bool]] = None,
                 fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_defined_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_password: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[builtins.str]] = None,
                 realm_specific_service_endpoint_template_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retry_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 test_time_maintenance_reboot_due: Optional[pulumi.Input[builtins.str]] = None,
                 user_ocid: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[builtins.str] auth: (Optional) The type of auth to use. Options are 'ApiKey', 'SecurityToken', 'InstancePrincipal', 'ResourcePrincipal' and
               'OKEWorkloadIdentity'. By default, 'ApiKey' will be used.
        :param pulumi.Input[builtins.str] config_file_profile: (Optional) The profile name to be used from config file, if not set it will be DEFAULT.
        :param pulumi.Input[builtins.bool] disable_auto_retries: (Optional) Disable automatic retries for retriable errors. Automatic retries were introduced to solve some eventual
               consistency problems but it also introduced performance issues on destroy operations.
        :param pulumi.Input[builtins.str] fingerprint: (Optional) The fingerprint for the user's RSA key. This can be found in user settings in the Oracle Cloud Infrastructure
               console. Required if auth is set to 'ApiKey', ignored otherwise.
        :param pulumi.Input[builtins.str] private_key: (Optional) A PEM formatted RSA private key for the user. A private_key or a private_key_path must be provided if auth is
               set to 'ApiKey', ignored otherwise.
        :param pulumi.Input[builtins.str] private_key_password: (Optional) The password used to secure the private key.
        :param pulumi.Input[builtins.str] private_key_path: (Optional) The path to the user's PEM formatted private key. A private_key or a private_key_path must be provided if
               auth is set to 'ApiKey', ignored otherwise.
        :param pulumi.Input[builtins.bool] realm_specific_service_endpoint_template_enabled: (Optional) flags to enable realm specific service endpoint.
        :param pulumi.Input[builtins.str] region: (Required) The region for API connections (e.g. us-ashburn-1).
        :param pulumi.Input[builtins.int] retry_duration_seconds: (Optional) The minimum duration (in seconds) to retry a resource operation in response to an error. The actual retry
               duration may be longer due to jittering of retry operations. This value is ignored if the `disable_auto_retries` field
               is set to true.
        :param pulumi.Input[builtins.str] tenancy_ocid: (Optional) The tenancy OCID for a user. The tenancy OCID can be found at the bottom of user settings in the Oracle Cloud
               Infrastructure console. Required if auth is set to 'ApiKey', ignored otherwise.
        :param pulumi.Input[builtins.str] user_ocid: (Optional) The user OCID. This can be found in user settings in the Oracle Cloud Infrastructure console. Required if
               auth is set to 'ApiKey', ignored otherwise.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if config_file_profile is not None:
            pulumi.set(__self__, "config_file_profile", config_file_profile)
        if disable_auto_retries is not None:
            pulumi.set(__self__, "disable_auto_retries", disable_auto_retries)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if ignore_defined_tags is not None:
            pulumi.set(__self__, "ignore_defined_tags", ignore_defined_tags)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_password is not None:
            pulumi.set(__self__, "private_key_password", private_key_password)
        if private_key_path is not None:
            pulumi.set(__self__, "private_key_path", private_key_path)
        if realm_specific_service_endpoint_template_enabled is not None:
            pulumi.set(__self__, "realm_specific_service_endpoint_template_enabled", realm_specific_service_endpoint_template_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retry_duration_seconds is not None:
            pulumi.set(__self__, "retry_duration_seconds", retry_duration_seconds)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if test_time_maintenance_reboot_due is not None:
            pulumi.set(__self__, "test_time_maintenance_reboot_due", test_time_maintenance_reboot_due)
        if user_ocid is not None:
            pulumi.set(__self__, "user_ocid", user_ocid)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The type of auth to use. Options are 'ApiKey', 'SecurityToken', 'InstancePrincipal', 'ResourcePrincipal' and
        'OKEWorkloadIdentity'. By default, 'ApiKey' will be used.
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter(name="configFileProfile")
    def config_file_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The profile name to be used from config file, if not set it will be DEFAULT.
        """
        return pulumi.get(self, "config_file_profile")

    @config_file_profile.setter
    def config_file_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_file_profile", value)

    @property
    @pulumi.getter(name="disableAutoRetries")
    def disable_auto_retries(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Optional) Disable automatic retries for retriable errors. Automatic retries were introduced to solve some eventual
        consistency problems but it also introduced performance issues on destroy operations.
        """
        return pulumi.get(self, "disable_auto_retries")

    @disable_auto_retries.setter
    def disable_auto_retries(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_auto_retries", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The fingerprint for the user's RSA key. This can be found in user settings in the Oracle Cloud Infrastructure
        console. Required if auth is set to 'ApiKey', ignored otherwise.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="ignoreDefinedTags")
    def ignore_defined_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "ignore_defined_tags")

    @ignore_defined_tags.setter
    def ignore_defined_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ignore_defined_tags", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) A PEM formatted RSA private key for the user. A private_key or a private_key_path must be provided if auth is
        set to 'ApiKey', ignored otherwise.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="privateKeyPassword")
    def private_key_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The password used to secure the private key.
        """
        return pulumi.get(self, "private_key_password")

    @private_key_password.setter
    def private_key_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key_password", value)

    @property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The path to the user's PEM formatted private key. A private_key or a private_key_path must be provided if
        auth is set to 'ApiKey', ignored otherwise.
        """
        return pulumi.get(self, "private_key_path")

    @private_key_path.setter
    def private_key_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key_path", value)

    @property
    @pulumi.getter(name="realmSpecificServiceEndpointTemplateEnabled")
    def realm_specific_service_endpoint_template_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Optional) flags to enable realm specific service endpoint.
        """
        return pulumi.get(self, "realm_specific_service_endpoint_template_enabled")

    @realm_specific_service_endpoint_template_enabled.setter
    def realm_specific_service_endpoint_template_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "realm_specific_service_endpoint_template_enabled", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Required) The region for API connections (e.g. us-ashburn-1).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="retryDurationSeconds")
    def retry_duration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Optional) The minimum duration (in seconds) to retry a resource operation in response to an error. The actual retry
        duration may be longer due to jittering of retry operations. This value is ignored if the `disable_auto_retries` field
        is set to true.
        """
        return pulumi.get(self, "retry_duration_seconds")

    @retry_duration_seconds.setter
    def retry_duration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retry_duration_seconds", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The tenancy OCID for a user. The tenancy OCID can be found at the bottom of user settings in the Oracle Cloud
        Infrastructure console. Required if auth is set to 'ApiKey', ignored otherwise.
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter(name="testTimeMaintenanceRebootDue")
    def test_time_maintenance_reboot_due(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "test_time_maintenance_reboot_due")

    @test_time_maintenance_reboot_due.setter
    def test_time_maintenance_reboot_due(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "test_time_maintenance_reboot_due", value)

    @property
    @pulumi.getter(name="userOcid")
    def user_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The user OCID. This can be found in user settings in the Oracle Cloud Infrastructure console. Required if
        auth is set to 'ApiKey', ignored otherwise.
        """
        return pulumi.get(self, "user_ocid")

    @user_ocid.setter
    def user_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_ocid", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth: Optional[pulumi.Input[builtins.str]] = None,
                 config_file_profile: Optional[pulumi.Input[builtins.str]] = None,
                 disable_auto_retries: Optional[pulumi.Input[builtins.bool]] = None,
                 fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_defined_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_password: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[builtins.str]] = None,
                 realm_specific_service_endpoint_template_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retry_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 test_time_maintenance_reboot_due: Optional[pulumi.Input[builtins.str]] = None,
                 user_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the oci package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auth: (Optional) The type of auth to use. Options are 'ApiKey', 'SecurityToken', 'InstancePrincipal', 'ResourcePrincipal' and
               'OKEWorkloadIdentity'. By default, 'ApiKey' will be used.
        :param pulumi.Input[builtins.str] config_file_profile: (Optional) The profile name to be used from config file, if not set it will be DEFAULT.
        :param pulumi.Input[builtins.bool] disable_auto_retries: (Optional) Disable automatic retries for retriable errors. Automatic retries were introduced to solve some eventual
               consistency problems but it also introduced performance issues on destroy operations.
        :param pulumi.Input[builtins.str] fingerprint: (Optional) The fingerprint for the user's RSA key. This can be found in user settings in the Oracle Cloud Infrastructure
               console. Required if auth is set to 'ApiKey', ignored otherwise.
        :param pulumi.Input[builtins.str] private_key: (Optional) A PEM formatted RSA private key for the user. A private_key or a private_key_path must be provided if auth is
               set to 'ApiKey', ignored otherwise.
        :param pulumi.Input[builtins.str] private_key_password: (Optional) The password used to secure the private key.
        :param pulumi.Input[builtins.str] private_key_path: (Optional) The path to the user's PEM formatted private key. A private_key or a private_key_path must be provided if
               auth is set to 'ApiKey', ignored otherwise.
        :param pulumi.Input[builtins.bool] realm_specific_service_endpoint_template_enabled: (Optional) flags to enable realm specific service endpoint.
        :param pulumi.Input[builtins.str] region: (Required) The region for API connections (e.g. us-ashburn-1).
        :param pulumi.Input[builtins.int] retry_duration_seconds: (Optional) The minimum duration (in seconds) to retry a resource operation in response to an error. The actual retry
               duration may be longer due to jittering of retry operations. This value is ignored if the `disable_auto_retries` field
               is set to true.
        :param pulumi.Input[builtins.str] tenancy_ocid: (Optional) The tenancy OCID for a user. The tenancy OCID can be found at the bottom of user settings in the Oracle Cloud
               Infrastructure console. Required if auth is set to 'ApiKey', ignored otherwise.
        :param pulumi.Input[builtins.str] user_ocid: (Optional) The user OCID. This can be found in user settings in the Oracle Cloud Infrastructure console. Required if
               auth is set to 'ApiKey', ignored otherwise.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the oci package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth: Optional[pulumi.Input[builtins.str]] = None,
                 config_file_profile: Optional[pulumi.Input[builtins.str]] = None,
                 disable_auto_retries: Optional[pulumi.Input[builtins.bool]] = None,
                 fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_defined_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_password: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[builtins.str]] = None,
                 realm_specific_service_endpoint_template_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retry_duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 test_time_maintenance_reboot_due: Optional[pulumi.Input[builtins.str]] = None,
                 user_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["auth"] = auth
            __props__.__dict__["config_file_profile"] = config_file_profile
            __props__.__dict__["disable_auto_retries"] = pulumi.Output.from_input(disable_auto_retries).apply(pulumi.runtime.to_json) if disable_auto_retries is not None else None
            __props__.__dict__["fingerprint"] = fingerprint
            __props__.__dict__["ignore_defined_tags"] = pulumi.Output.from_input(ignore_defined_tags).apply(pulumi.runtime.to_json) if ignore_defined_tags is not None else None
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["private_key_password"] = None if private_key_password is None else pulumi.Output.secret(private_key_password)
            __props__.__dict__["private_key_path"] = private_key_path
            __props__.__dict__["realm_specific_service_endpoint_template_enabled"] = pulumi.Output.from_input(realm_specific_service_endpoint_template_enabled).apply(pulumi.runtime.to_json) if realm_specific_service_endpoint_template_enabled is not None else None
            __props__.__dict__["region"] = region
            __props__.__dict__["retry_duration_seconds"] = pulumi.Output.from_input(retry_duration_seconds).apply(pulumi.runtime.to_json) if retry_duration_seconds is not None else None
            __props__.__dict__["tenancy_ocid"] = tenancy_ocid
            __props__.__dict__["test_time_maintenance_reboot_due"] = test_time_maintenance_reboot_due
            __props__.__dict__["user_ocid"] = user_ocid
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey", "privateKeyPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'oci',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter
    def auth(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Optional) The type of auth to use. Options are 'ApiKey', 'SecurityToken', 'InstancePrincipal', 'ResourcePrincipal' and
        'OKEWorkloadIdentity'. By default, 'ApiKey' will be used.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter(name="configFileProfile")
    def config_file_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Optional) The profile name to be used from config file, if not set it will be DEFAULT.
        """
        return pulumi.get(self, "config_file_profile")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Optional) The fingerprint for the user's RSA key. This can be found in user settings in the Oracle Cloud Infrastructure
        console. Required if auth is set to 'ApiKey', ignored otherwise.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Optional) A PEM formatted RSA private key for the user. A private_key or a private_key_path must be provided if auth is
        set to 'ApiKey', ignored otherwise.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="privateKeyPassword")
    def private_key_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Optional) The password used to secure the private key.
        """
        return pulumi.get(self, "private_key_password")

    @property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Optional) The path to the user's PEM formatted private key. A private_key or a private_key_path must be provided if
        auth is set to 'ApiKey', ignored otherwise.
        """
        return pulumi.get(self, "private_key_path")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Required) The region for API connections (e.g. us-ashburn-1).
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Optional) The tenancy OCID for a user. The tenancy OCID can be found at the bottom of user settings in the Oracle Cloud
        Infrastructure console. Required if auth is set to 'ApiKey', ignored otherwise.
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter(name="testTimeMaintenanceRebootDue")
    def test_time_maintenance_reboot_due(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "test_time_maintenance_reboot_due")

    @property
    @pulumi.getter(name="userOcid")
    def user_ocid(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Optional) The user OCID. This can be found in user settings in the Oracle Cloud Infrastructure console. Required if
        auth is set to 'ApiKey', ignored otherwise.
        """
        return pulumi.get(self, "user_ocid")

