# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoredResourceTypeArgs', 'MonitoredResourceType']

@pulumi.input_type
class MonitoredResourceTypeArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input['MonitoredResourceTypeMetadataArgs']] = None,
                 metric_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_category: Optional[pulumi.Input[builtins.str]] = None,
                 source_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MonitoredResourceType resource.
        :param pulumi.Input[builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A friendly description.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Monitored resource type display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['MonitoredResourceTypeMetadataArgs'] metadata: (Updatable) The metadata details for resource type.
        :param pulumi.Input[builtins.str] metric_namespace: (Updatable) Metric namespace for resource type.
        :param pulumi.Input[builtins.str] name: A unique monitored resource type name. The name must be unique across tenancy.  Name can not be changed.
        :param pulumi.Input[builtins.str] resource_category: (Updatable) Resource Category to indicate the kind of resource type.
        :param pulumi.Input[builtins.str] source_type: (Updatable) Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_category is not None:
            pulumi.set(__self__, "resource_category", resource_category)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A friendly description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Monitored resource type display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['MonitoredResourceTypeMetadataArgs']]:
        """
        (Updatable) The metadata details for resource type.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['MonitoredResourceTypeMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Metric namespace for resource type.
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique monitored resource type name. The name must be unique across tenancy.  Name can not be changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Resource Category to indicate the kind of resource type.
        """
        return pulumi.get(self, "resource_category")

    @resource_category.setter
    def resource_category(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_category", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_type", value)


@pulumi.input_type
class _MonitoredResourceTypeState:
    def __init__(__self__, *,
                 additional_namespace_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 availability_metrics_configs: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceTypeAvailabilityMetricsConfigArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 handler_configs: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceTypeHandlerConfigArgs']]]] = None,
                 is_system_defined: Optional[pulumi.Input[builtins.bool]] = None,
                 metadata: Optional[pulumi.Input['MonitoredResourceTypeMetadataArgs']] = None,
                 metric_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_category: Optional[pulumi.Input[builtins.str]] = None,
                 source_type: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MonitoredResourceType resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_namespace_map: Key/Value pair for additional namespaces used by stack monitoring services for SYSTEM (SMB) resource types.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceTypeAvailabilityMetricsConfigArgs']]] availability_metrics_configs: Availability metrics details.
        :param pulumi.Input[builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A friendly description.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Monitored resource type display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceTypeHandlerConfigArgs']]] handler_configs: Specific resource mapping configurations for Agent Extension Handlers.
        :param pulumi.Input[builtins.bool] is_system_defined: If boolean flag is true, then the resource type cannot be modified or deleted.
        :param pulumi.Input['MonitoredResourceTypeMetadataArgs'] metadata: (Updatable) The metadata details for resource type.
        :param pulumi.Input[builtins.str] metric_namespace: (Updatable) Metric namespace for resource type.
        :param pulumi.Input[builtins.str] name: A unique monitored resource type name. The name must be unique across tenancy.  Name can not be changed.
        :param pulumi.Input[builtins.str] resource_category: (Updatable) Resource Category to indicate the kind of resource type.
        :param pulumi.Input[builtins.str] source_type: (Updatable) Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: Lifecycle state of the monitored resource type.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] tenancy_id: Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] time_created: The date and time when the monitored resource type was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[builtins.str] time_updated: The date and time when the monitored resource was updated, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        if additional_namespace_map is not None:
            pulumi.set(__self__, "additional_namespace_map", additional_namespace_map)
        if availability_metrics_configs is not None:
            pulumi.set(__self__, "availability_metrics_configs", availability_metrics_configs)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if handler_configs is not None:
            pulumi.set(__self__, "handler_configs", handler_configs)
        if is_system_defined is not None:
            pulumi.set(__self__, "is_system_defined", is_system_defined)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_category is not None:
            pulumi.set(__self__, "resource_category", resource_category)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="additionalNamespaceMap")
    def additional_namespace_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key/Value pair for additional namespaces used by stack monitoring services for SYSTEM (SMB) resource types.
        """
        return pulumi.get(self, "additional_namespace_map")

    @additional_namespace_map.setter
    def additional_namespace_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_namespace_map", value)

    @property
    @pulumi.getter(name="availabilityMetricsConfigs")
    def availability_metrics_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceTypeAvailabilityMetricsConfigArgs']]]]:
        """
        Availability metrics details.
        """
        return pulumi.get(self, "availability_metrics_configs")

    @availability_metrics_configs.setter
    def availability_metrics_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceTypeAvailabilityMetricsConfigArgs']]]]):
        pulumi.set(self, "availability_metrics_configs", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A friendly description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Monitored resource type display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="handlerConfigs")
    def handler_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceTypeHandlerConfigArgs']]]]:
        """
        Specific resource mapping configurations for Agent Extension Handlers.
        """
        return pulumi.get(self, "handler_configs")

    @handler_configs.setter
    def handler_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceTypeHandlerConfigArgs']]]]):
        pulumi.set(self, "handler_configs", value)

    @property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If boolean flag is true, then the resource type cannot be modified or deleted.
        """
        return pulumi.get(self, "is_system_defined")

    @is_system_defined.setter
    def is_system_defined(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_system_defined", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['MonitoredResourceTypeMetadataArgs']]:
        """
        (Updatable) The metadata details for resource type.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['MonitoredResourceTypeMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Metric namespace for resource type.
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique monitored resource type name. The name must be unique across tenancy.  Name can not be changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Resource Category to indicate the kind of resource type.
        """
        return pulumi.get(self, "resource_category")

    @resource_category.setter
    def resource_category(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_category", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lifecycle state of the monitored resource type.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the monitored resource type was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the monitored resource was updated, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class MonitoredResourceType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Union['MonitoredResourceTypeMetadataArgs', 'MonitoredResourceTypeMetadataArgsDict']]] = None,
                 metric_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_category: Optional[pulumi.Input[builtins.str]] = None,
                 source_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Monitored Resource Type resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a new monitored resource type.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resource_type = oci.stack_monitoring.MonitoredResourceType("test_monitored_resource_type",
            compartment_id=compartment_id,
            name=monitored_resource_type_name,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=monitored_resource_type_description,
            display_name=monitored_resource_type_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            metadata={
                "format": monitored_resource_type_metadata_format,
                "agent_properties": monitored_resource_type_metadata_agent_properties,
                "required_properties": monitored_resource_type_metadata_required_properties,
                "unique_property_sets": [{
                    "properties": monitored_resource_type_metadata_unique_property_sets_properties,
                }],
                "valid_properties_for_creates": monitored_resource_type_metadata_valid_properties_for_create,
                "valid_properties_for_updates": monitored_resource_type_metadata_valid_properties_for_update,
                "valid_property_values": monitored_resource_type_metadata_valid_property_values,
                "valid_sub_resource_types": monitored_resource_type_metadata_valid_sub_resource_types,
            },
            metric_namespace=monitored_resource_type_metric_namespace,
            resource_category=monitored_resource_type_resource_category,
            source_type=monitored_resource_type_source_type)
        ```

        ## Import

        MonitoredResourceTypes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResourceType:MonitoredResourceType test_monitored_resource_type "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A friendly description.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Monitored resource type display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['MonitoredResourceTypeMetadataArgs', 'MonitoredResourceTypeMetadataArgsDict']] metadata: (Updatable) The metadata details for resource type.
        :param pulumi.Input[builtins.str] metric_namespace: (Updatable) Metric namespace for resource type.
        :param pulumi.Input[builtins.str] name: A unique monitored resource type name. The name must be unique across tenancy.  Name can not be changed.
        :param pulumi.Input[builtins.str] resource_category: (Updatable) Resource Category to indicate the kind of resource type.
        :param pulumi.Input[builtins.str] source_type: (Updatable) Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoredResourceTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Monitored Resource Type resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a new monitored resource type.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resource_type = oci.stack_monitoring.MonitoredResourceType("test_monitored_resource_type",
            compartment_id=compartment_id,
            name=monitored_resource_type_name,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=monitored_resource_type_description,
            display_name=monitored_resource_type_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            metadata={
                "format": monitored_resource_type_metadata_format,
                "agent_properties": monitored_resource_type_metadata_agent_properties,
                "required_properties": monitored_resource_type_metadata_required_properties,
                "unique_property_sets": [{
                    "properties": monitored_resource_type_metadata_unique_property_sets_properties,
                }],
                "valid_properties_for_creates": monitored_resource_type_metadata_valid_properties_for_create,
                "valid_properties_for_updates": monitored_resource_type_metadata_valid_properties_for_update,
                "valid_property_values": monitored_resource_type_metadata_valid_property_values,
                "valid_sub_resource_types": monitored_resource_type_metadata_valid_sub_resource_types,
            },
            metric_namespace=monitored_resource_type_metric_namespace,
            resource_category=monitored_resource_type_resource_category,
            source_type=monitored_resource_type_source_type)
        ```

        ## Import

        MonitoredResourceTypes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResourceType:MonitoredResourceType test_monitored_resource_type "id"
        ```

        :param str resource_name: The name of the resource.
        :param MonitoredResourceTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoredResourceTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Union['MonitoredResourceTypeMetadataArgs', 'MonitoredResourceTypeMetadataArgsDict']]] = None,
                 metric_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_category: Optional[pulumi.Input[builtins.str]] = None,
                 source_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoredResourceTypeArgs.__new__(MonitoredResourceTypeArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["metric_namespace"] = metric_namespace
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_category"] = resource_category
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["additional_namespace_map"] = None
            __props__.__dict__["availability_metrics_configs"] = None
            __props__.__dict__["handler_configs"] = None
            __props__.__dict__["is_system_defined"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tenancy_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MonitoredResourceType, __self__).__init__(
            'oci:StackMonitoring/monitoredResourceType:MonitoredResourceType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_namespace_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            availability_metrics_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceTypeAvailabilityMetricsConfigArgs', 'MonitoredResourceTypeAvailabilityMetricsConfigArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            handler_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceTypeHandlerConfigArgs', 'MonitoredResourceTypeHandlerConfigArgsDict']]]]] = None,
            is_system_defined: Optional[pulumi.Input[builtins.bool]] = None,
            metadata: Optional[pulumi.Input[Union['MonitoredResourceTypeMetadataArgs', 'MonitoredResourceTypeMetadataArgsDict']]] = None,
            metric_namespace: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_category: Optional[pulumi.Input[builtins.str]] = None,
            source_type: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'MonitoredResourceType':
        """
        Get an existing MonitoredResourceType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_namespace_map: Key/Value pair for additional namespaces used by stack monitoring services for SYSTEM (SMB) resource types.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceTypeAvailabilityMetricsConfigArgs', 'MonitoredResourceTypeAvailabilityMetricsConfigArgsDict']]]] availability_metrics_configs: Availability metrics details.
        :param pulumi.Input[builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A friendly description.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Monitored resource type display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceTypeHandlerConfigArgs', 'MonitoredResourceTypeHandlerConfigArgsDict']]]] handler_configs: Specific resource mapping configurations for Agent Extension Handlers.
        :param pulumi.Input[builtins.bool] is_system_defined: If boolean flag is true, then the resource type cannot be modified or deleted.
        :param pulumi.Input[Union['MonitoredResourceTypeMetadataArgs', 'MonitoredResourceTypeMetadataArgsDict']] metadata: (Updatable) The metadata details for resource type.
        :param pulumi.Input[builtins.str] metric_namespace: (Updatable) Metric namespace for resource type.
        :param pulumi.Input[builtins.str] name: A unique monitored resource type name. The name must be unique across tenancy.  Name can not be changed.
        :param pulumi.Input[builtins.str] resource_category: (Updatable) Resource Category to indicate the kind of resource type.
        :param pulumi.Input[builtins.str] source_type: (Updatable) Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: Lifecycle state of the monitored resource type.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] tenancy_id: Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] time_created: The date and time when the monitored resource type was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[builtins.str] time_updated: The date and time when the monitored resource was updated, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoredResourceTypeState.__new__(_MonitoredResourceTypeState)

        __props__.__dict__["additional_namespace_map"] = additional_namespace_map
        __props__.__dict__["availability_metrics_configs"] = availability_metrics_configs
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["handler_configs"] = handler_configs
        __props__.__dict__["is_system_defined"] = is_system_defined
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metric_namespace"] = metric_namespace
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_category"] = resource_category
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenancy_id"] = tenancy_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return MonitoredResourceType(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalNamespaceMap")
    def additional_namespace_map(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key/Value pair for additional namespaces used by stack monitoring services for SYSTEM (SMB) resource types.
        """
        return pulumi.get(self, "additional_namespace_map")

    @property
    @pulumi.getter(name="availabilityMetricsConfigs")
    def availability_metrics_configs(self) -> pulumi.Output[Sequence['outputs.MonitoredResourceTypeAvailabilityMetricsConfig']]:
        """
        Availability metrics details.
        """
        return pulumi.get(self, "availability_metrics_configs")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) A friendly description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) Monitored resource type display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="handlerConfigs")
    def handler_configs(self) -> pulumi.Output[Sequence['outputs.MonitoredResourceTypeHandlerConfig']]:
        """
        Specific resource mapping configurations for Agent Extension Handlers.
        """
        return pulumi.get(self, "handler_configs")

    @property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> pulumi.Output[builtins.bool]:
        """
        If boolean flag is true, then the resource type cannot be modified or deleted.
        """
        return pulumi.get(self, "is_system_defined")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.MonitoredResourceTypeMetadata']:
        """
        (Updatable) The metadata details for resource type.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Metric namespace for resource type.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique monitored resource type name. The name must be unique across tenancy.  Name can not be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Resource Category to indicate the kind of resource type.
        """
        return pulumi.get(self, "resource_category")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Lifecycle state of the monitored resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Output[builtins.str]:
        """
        Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the monitored resource type was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the monitored resource was updated, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")

