# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVbInstanceApplicationsResult',
    'AwaitableGetVbInstanceApplicationsResult',
    'get_vb_instance_applications',
    'get_vb_instance_applications_output',
]

@pulumi.output_type
class GetVbInstanceApplicationsResult:
    """
    A collection of values returned by getVbInstanceApplications.
    """
    def __init__(__self__, application_summary_collections=None, id=None, idcs_open_id=None, vb_instance_id=None):
        if application_summary_collections and not isinstance(application_summary_collections, list):
            raise TypeError("Expected argument 'application_summary_collections' to be a list")
        pulumi.set(__self__, "application_summary_collections", application_summary_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idcs_open_id and not isinstance(idcs_open_id, str):
            raise TypeError("Expected argument 'idcs_open_id' to be a str")
        pulumi.set(__self__, "idcs_open_id", idcs_open_id)
        if vb_instance_id and not isinstance(vb_instance_id, str):
            raise TypeError("Expected argument 'vb_instance_id' to be a str")
        pulumi.set(__self__, "vb_instance_id", vb_instance_id)

    @property
    @pulumi.getter(name="applicationSummaryCollections")
    def application_summary_collections(self) -> Sequence['outputs.GetVbInstanceApplicationsApplicationSummaryCollectionResult']:
        """
        The list of application_summary_collection.
        """
        return pulumi.get(self, "application_summary_collections")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsOpenId")
    def idcs_open_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "idcs_open_id")

    @property
    @pulumi.getter(name="vbInstanceId")
    def vb_instance_id(self) -> builtins.str:
        return pulumi.get(self, "vb_instance_id")


class AwaitableGetVbInstanceApplicationsResult(GetVbInstanceApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVbInstanceApplicationsResult(
            application_summary_collections=self.application_summary_collections,
            id=self.id,
            idcs_open_id=self.idcs_open_id,
            vb_instance_id=self.vb_instance_id)


def get_vb_instance_applications(idcs_open_id: Optional[builtins.str] = None,
                                 vb_instance_id: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVbInstanceApplicationsResult:
    """
    This data source provides the list of published and staged applications of a Visual Builder Instance in Oracle Cloud Infrastructure Visual Builder service.

    Returns a list of published and staged applications of a Visual Builder instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vb_instance_applications = oci.VisualBuilder.get_vb_instance_applications(vb_instance_id=test_vb_instance["id"],
        idcs_open_id="idcs_open_id_value")
    ```


    :param builtins.str idcs_open_id: Encrypted IDCS Open ID token which allows access to Visual Builder REST apis
    :param builtins.str vb_instance_id: Unique Vb Instance identifier.
    """
    __args__ = dict()
    __args__['idcsOpenId'] = idcs_open_id
    __args__['vbInstanceId'] = vb_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VisualBuilder/getVbInstanceApplications:getVbInstanceApplications', __args__, opts=opts, typ=GetVbInstanceApplicationsResult).value

    return AwaitableGetVbInstanceApplicationsResult(
        application_summary_collections=pulumi.get(__ret__, 'application_summary_collections'),
        id=pulumi.get(__ret__, 'id'),
        idcs_open_id=pulumi.get(__ret__, 'idcs_open_id'),
        vb_instance_id=pulumi.get(__ret__, 'vb_instance_id'))
def get_vb_instance_applications_output(idcs_open_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        vb_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVbInstanceApplicationsResult]:
    """
    This data source provides the list of published and staged applications of a Visual Builder Instance in Oracle Cloud Infrastructure Visual Builder service.

    Returns a list of published and staged applications of a Visual Builder instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vb_instance_applications = oci.VisualBuilder.get_vb_instance_applications(vb_instance_id=test_vb_instance["id"],
        idcs_open_id="idcs_open_id_value")
    ```


    :param builtins.str idcs_open_id: Encrypted IDCS Open ID token which allows access to Visual Builder REST apis
    :param builtins.str vb_instance_id: Unique Vb Instance identifier.
    """
    __args__ = dict()
    __args__['idcsOpenId'] = idcs_open_id
    __args__['vbInstanceId'] = vb_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:VisualBuilder/getVbInstanceApplications:getVbInstanceApplications', __args__, opts=opts, typ=GetVbInstanceApplicationsResult)
    return __ret__.apply(lambda __response__: GetVbInstanceApplicationsResult(
        application_summary_collections=pulumi.get(__response__, 'application_summary_collections'),
        id=pulumi.get(__response__, 'id'),
        idcs_open_id=pulumi.get(__response__, 'idcs_open_id'),
        vb_instance_id=pulumi.get(__response__, 'vb_instance_id')))
