# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetWebAppFirewallResult',
    'AwaitableGetWebAppFirewallResult',
    'get_web_app_firewall',
    'get_web_app_firewall_output',
]

@pulumi.output_type
class GetWebAppFirewallResult:
    """
    A collection of values returned by getWebAppFirewall.
    """
    def __init__(__self__, backend_type=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, load_balancer_id=None, state=None, system_tags=None, time_created=None, time_updated=None, web_app_firewall_id=None, web_app_firewall_policy_id=None):
        if backend_type and not isinstance(backend_type, str):
            raise TypeError("Expected argument 'backend_type' to be a str")
        pulumi.set(__self__, "backend_type", backend_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if web_app_firewall_id and not isinstance(web_app_firewall_id, str):
            raise TypeError("Expected argument 'web_app_firewall_id' to be a str")
        pulumi.set(__self__, "web_app_firewall_id", web_app_firewall_id)
        if web_app_firewall_policy_id and not isinstance(web_app_firewall_policy_id, str):
            raise TypeError("Expected argument 'web_app_firewall_policy_id' to be a str")
        pulumi.set(__self__, "web_app_firewall_policy_id", web_app_firewall_policy_id)

    @property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> builtins.str:
        """
        Type of the WebAppFirewall, as example LOAD_BALANCER.
        """
        return pulumi.get(self, "backend_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        WebAppFirewall display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebAppFirewall.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> builtins.str:
        """
        LoadBalancer [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to which the WebAppFirewallPolicy is attached to.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the WebAppFirewall.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the WebAppFirewall was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the WebAppFirewall was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="webAppFirewallId")
    def web_app_firewall_id(self) -> builtins.str:
        return pulumi.get(self, "web_app_firewall_id")

    @property
    @pulumi.getter(name="webAppFirewallPolicyId")
    def web_app_firewall_policy_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of WebAppFirewallPolicy, which is attached to the resource.
        """
        return pulumi.get(self, "web_app_firewall_policy_id")


class AwaitableGetWebAppFirewallResult(GetWebAppFirewallResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWebAppFirewallResult(
            backend_type=self.backend_type,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            load_balancer_id=self.load_balancer_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            web_app_firewall_id=self.web_app_firewall_id,
            web_app_firewall_policy_id=self.web_app_firewall_policy_id)


def get_web_app_firewall(web_app_firewall_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWebAppFirewallResult:
    """
    This data source provides details about a specific Web App Firewall resource in Oracle Cloud Infrastructure Waf service.

    Gets a WebAppFirewall by OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_web_app_firewall = oci.Waf.get_web_app_firewall(web_app_firewall_id=test_web_app_firewall_oci_waf_web_app_firewall["id"])
    ```


    :param builtins.str web_app_firewall_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebAppFirewall.
    """
    __args__ = dict()
    __args__['webAppFirewallId'] = web_app_firewall_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waf/getWebAppFirewall:getWebAppFirewall', __args__, opts=opts, typ=GetWebAppFirewallResult).value

    return AwaitableGetWebAppFirewallResult(
        backend_type=pulumi.get(__ret__, 'backend_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        web_app_firewall_id=pulumi.get(__ret__, 'web_app_firewall_id'),
        web_app_firewall_policy_id=pulumi.get(__ret__, 'web_app_firewall_policy_id'))
def get_web_app_firewall_output(web_app_firewall_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWebAppFirewallResult]:
    """
    This data source provides details about a specific Web App Firewall resource in Oracle Cloud Infrastructure Waf service.

    Gets a WebAppFirewall by OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_web_app_firewall = oci.Waf.get_web_app_firewall(web_app_firewall_id=test_web_app_firewall_oci_waf_web_app_firewall["id"])
    ```


    :param builtins.str web_app_firewall_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebAppFirewall.
    """
    __args__ = dict()
    __args__['webAppFirewallId'] = web_app_firewall_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Waf/getWebAppFirewall:getWebAppFirewall', __args__, opts=opts, typ=GetWebAppFirewallResult)
    return __ret__.apply(lambda __response__: GetWebAppFirewallResult(
        backend_type=pulumi.get(__response__, 'backend_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        web_app_firewall_id=pulumi.get(__response__, 'web_app_firewall_id'),
        web_app_firewall_policy_id=pulumi.get(__response__, 'web_app_firewall_policy_id')))
