"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Input = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_iotevents_1 = require("aws-cdk-lib/aws-iotevents");
class InputBase extends core_1.Resource {
    grantWrite(grantee) {
        return this.grant(grantee, 'iotevents:BatchPutMessage');
    }
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee,
            actions,
            resourceArns: [this.inputArn],
        });
    }
}
/**
 * Defines an AWS IoT Events input in this stack.
 */
class Input extends InputBase {
    /**
     * Import an existing input.
     */
    static fromInputName(scope, id, inputName) {
        return new class Import extends InputBase {
            constructor() {
                super(...arguments);
                this.inputName = inputName;
                this.inputArn = this.stack.formatArn({
                    service: 'iotevents',
                    resource: 'input',
                    resourceName: inputName,
                });
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.inputName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_InputProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Input);
            }
            throw error;
        }
        if (props.attributeJsonPaths.length === 0) {
            throw new Error('attributeJsonPaths property cannot be empty');
        }
        const resource = new aws_iotevents_1.CfnInput(this, 'Resource', {
            inputName: this.physicalName,
            inputDefinition: {
                attributes: props.attributeJsonPaths.map(path => ({ jsonPath: path })),
            },
        });
        this.inputName = this.getResourceNameAttribute(resource.ref);
        this.inputArn = this.getResourceArnAttribute(arnForInput(resource.ref), {
            service: 'iotevents',
            resource: 'input',
            resourceName: this.physicalName,
        });
    }
}
exports.Input = Input;
_a = JSII_RTTI_SYMBOL_1;
Input[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.Input", version: "2.93.0-alpha.0" };
function arnForInput(inputName) {
    return `arn:${core_1.Aws.PARTITION}:iotevents:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:input/${inputName}`;
}
//# sourceMappingURL=data:application/json;base64,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