"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg)  

    The version of the OpenAPI document: 4.7.1601
    Contact: servicedesk@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_account.api_client import ApiClient, Endpoint as _Endpoint
from vrt_lss_account.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from vrt_lss_account.model.account_audit_result import AccountAuditResult
from vrt_lss_account.model.inline_response400 import InlineResponse400
from vrt_lss_account.model.inline_response401 import InlineResponse401
from vrt_lss_account.model.inline_response402 import InlineResponse402
from vrt_lss_account.model.inline_response403 import InlineResponse403
from vrt_lss_account.model.inline_response404 import InlineResponse404
from vrt_lss_account.model.inline_response429 import InlineResponse429
from vrt_lss_account.model.inline_response500 import InlineResponse500
from vrt_lss_account.model.method_group import MethodGroup
from vrt_lss_account.model.operation_id import OperationId
from vrt_lss_account.model.service_name import ServiceName


class AuditApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.read_audit_endpoint = _Endpoint(
            settings={
                'response_type': (AccountAuditResult,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/account/audit',
                'operation_id': 'read_audit',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'offset',
                    'limit',
                    '_from',
                    'to',
                    'service_name',
                    'operation_id',
                    'method_group',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'offset',
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('offset',): {

                        'inclusive_maximum': 10000000,
                        'inclusive_minimum': 0,
                    },
                    ('limit',): {

                        'inclusive_maximum': 10000000,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                    '_from':
                        (datetime,),
                    'to':
                        (datetime,),
                    'service_name':
                        (ServiceName,),
                    'operation_id':
                        (OperationId,),
                    'method_group':
                        (MethodGroup,),
                },
                'attribute_map': {
                    'offset': 'offset',
                    'limit': 'limit',
                    '_from': 'from',
                    'to': 'to',
                    'service_name': 'service_name',
                    'operation_id': 'operation_id',
                    'method_group': 'method_group',
                },
                'location_map': {
                    'offset': 'query',
                    'limit': 'query',
                    '_from': 'query',
                    'to': 'query',
                    'service_name': 'query',
                    'operation_id': 'query',
                    'method_group': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def read_audit(
        self,
        **kwargs
    ):
        """Actions for the period  

        User actions for the period.  If the period is not specified, records for the current day are returned from the beginning of the day to the current time. If no 'from' datetime is specified, audit data are returned from the beginning of the day. If no 'to' datetime is specified, audit data are returned be the end of the current day.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_audit(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            offset (int): The number of items to skip before starting to collect the result set.. [optional] if omitted the server will use the default value of 0
            limit (int): The number of items to return.. [optional] if omitted the server will use the default value of 100
            _from (datetime): Date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. . [optional]
            to (datetime): Date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. . [optional]
            service_name (ServiceName): Service name.. [optional]
            operation_id (OperationId): Operation identifier.. [optional]
            method_group (MethodGroup): Method group name.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountAuditResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.read_audit_endpoint.call_with_http_info(**kwargs)

