"""
Documentation (Markdown, reStructuredText) specific code review checklist.
"""

CHECKLIST = """
## 文档 (Markdown, RST) 代码审查检查清单

### 内容质量
- [ ] 文档是否清晰、准确地描述了主题
- [ ] 内容是否组织有序且符合逻辑
- [ ] 是否避免了冗余和重复内容
- [ ] 技术术语是否使用一致且正确
- [ ] 是否包含了必要的示例和说明
- [ ] 是否避免了过于复杂或晦涩的语言
- [ ] 是否针对目标受众进行了适当调整
- [ ] 是否没有语法错误和拼写错误

### 文档结构
- [ ] 标题层级是否清晰合理 (h1, h2, h3等)
- [ ] 是否使用了适当的目录结构
- [ ] 是否包含了必要的元数据 (如标题、作者、日期)
- [ ] 相关内容是否适当分组
- [ ] 是否使用了适当的断落和分段
- [ ] 导航链接是否清晰且有效
- [ ] 是否有总结或结论部分
- [ ] 文档长度是否适中，避免过长或过短

### Markdown/RST 语法
- [ ] 是否正确使用了标记语法 (标题、列表、链接等)
- [ ] 代码块是否使用了正确的格式和语法高亮
- [ ] 表格是否格式良好且易于阅读
- [ ] 图片是否有替代文本和适当的说明
- [ ] 是否正确使用了强调和引用标记
- [ ] 特殊字符是否正确转义
- [ ] 是否避免了不必要的行内HTML/RST扩展语法
- [ ] 是否使用了标准兼容的Markdown/RST语法

### 技术准确性
- [ ] 代码示例是否准确且可运行
- [ ] API引用和函数名称是否正确
- [ ] 版本信息是否最新且准确
- [ ] 技术概念解释是否准确
- [ ] 链接是否指向正确的资源
- [ ] 命令行示例是否完整且可执行
- [ ] 是否包含了必要的先决条件和环境要求
- [ ] 故障排除信息是否有效且实用

### 可访问性和可用性
- [ ] 是否使用了描述性链接文本 (避免"点击这里")
- [ ] 图片和图表是否有适当的替代文本
- [ ] 颜色和对比度是否符合可访问性标准
- [ ] 内容是否可被屏幕阅读器正确解析
- [ ] 表格是否有适当的表头和描述
- [ ] 是否避免了仅依赖颜色传递信息
- [ ] 字体大小和样式是否易于阅读
- [ ] 是否考虑了国际化和本地化需求

### 文档维护
- [ ] 是否包含了"最后更新"日期
- [ ] 是否有明确的版本信息
- [ ] 是否有贡献指南
- [ ] 废弃内容是否有明确标记
- [ ] 是否有明确的维护责任人
- [ ] 是否建立了文档更新流程
- [ ] 是否包含了反馈渠道
- [ ] 是否与代码库保持同步

### SEO和发现性
- [ ] 标题是否包含关键字
- [ ] 元描述是否清晰且有信息量
- [ ] 是否使用了适当的标签和分类
- [ ] 是否有适当的内部链接
- [ ] 是否避免了死链接
- [ ] URL结构是否有意义且稳定
- [ ] 是否考虑了搜索引擎索引优化
- [ ] 是否有明确的导航路径

### 文档工具和格式
- [ ] 是否使用了一致的文档生成工具 (如Sphinx, MkDocs)
- [ ] 是否遵循了项目文档风格指南
- [ ] 是否有适当的主题和样式应用
- [ ] 导出格式是否支持目标平台 (PDF, HTML)
- [ ] 是否使用了版本控制管理文档
- [ ] 自动化构建和部署是否配置正确
- [ ] 是否有预览环境测试文档更改
- [ ] 是否集成了持续集成/持续部署流程
""" 