"""
Rust language-specific code review checklist.
"""

CHECKLIST = """
## Rust 代码审查检查清单

### 内存安全
- [ ] 是否避免了不安全代码块 (unsafe)
- [ ] 如有 unsafe 代码，是否有充分的注释和证明
- [ ] 生命周期参数是否正确标注
- [ ] 引用是否遵循借用规则

### 错误处理
- [ ] 是否正确使用 Result 和 Option 类型
- [ ] 错误传播操作符 (?) 是否合理使用
- [ ] 错误类型是否合适
- [ ] 是否有自定义错误类型

### 并发安全
- [ ] 可变状态是否受到 Mutex/RwLock 保护
- [ ] 是否避免了死锁风险
- [ ] Send/Sync trait 实现是否安全
- [ ] 是否正确使用原子类型

### 性能
- [ ] 是否避免了不必要的克隆
- [ ] 是否合理使用了引用而非所有权转移
- [ ] 数据结构选择是否高效
- [ ] 是否合理使用了迭代器

### 代码风格
- [ ] 是否遵循 Rust 官方风格指南
- [ ] 命名是否符合 Rust 约定
- [ ] 代码是否通过 clippy 静态分析
- [ ] 是否避免了过度使用宏

### API 设计
- [ ] 公共 API 是否有文档注释
- [ ] 类型和函数是否遵循最小权限原则
- [ ] trait 边界是否合理
- [ ] 泛型参数使用是否合适

### 依赖管理
- [ ] 是否有明确的版本约束
- [ ] 是否最小化了依赖数量
- [ ] 是否避免了有安全问题的依赖

### 测试
- [ ] 是否有单元测试
- [ ] 是否测试了错误路径
- [ ] 是否使用了属性测试 (property testing)
- [ ] 文档示例是否可执行

### 资源管理
- [ ] 资源是否通过 Drop trait 正确释放
- [ ] 是否避免了资源泄漏
""" 