"""
Swift language-specific code review checklist.
"""

CHECKLIST = """
## Swift 代码审查检查清单

### 代码风格和格式
- [ ] 是否遵循 Swift API 设计指南
- [ ] 命名是否清晰明确 (驼峰式命名法)
- [ ] 是否使用 SwiftLint 等工具进行代码规范检查
- [ ] 缩进和格式是否一致
- [ ] 是否避免了过长的函数和过度嵌套

### Swift 语言特性
- [ ] 是否正确使用可选类型 (Optional)
- [ ] 是否安全地解包可选值
- [ ] 是否适当使用类型推断
- [ ] 是否合理使用值类型和引用类型
- [ ] 是否正确使用协议和扩展
- [ ] 是否适当使用属性观察器 (willSet/didSet)
- [ ] 是否正确使用闭包和逃逸闭包
- [ ] 是否合理使用 guard 语句和条件提前返回

### 内存管理
- [ ] 是否避免了循环引用 (使用 weak 或 unowned)
- [ ] 闭包捕获列表是否正确设置
- [ ] 是否正确处理委托和通知的生命周期
- [ ] 是否避免了内存泄漏

### 并发和异步
- [ ] 是否正确使用 GCD 或 Operation
- [ ] 是否避免了线程竞争
- [ ] UI 更新是否在主线程进行
- [ ] 是否正确处理异步操作的取消和超时
- [ ] Swift 5.5+ 是否合理使用结构化并发 (async/await)

### 性能优化
- [ ] 是否避免不必要的计算或对象创建
- [ ] 集合操作是否高效
- [ ] 是否避免了过度使用字符串操作
- [ ] 是否考虑了缓存策略
- [ ] 是否避免了过度使用计算属性

### 用户界面 (UI)
- [ ] 约束是否正确设置 (没有冲突或歧义)
- [ ] 是否考虑了不同屏幕尺寸和方向
- [ ] 是否遵循人机界面指南 (HIG)
- [ ] 是否适当使用 SF Symbols 和系统字体
- [ ] 是否适配了深色模式

### 安全性
- [ ] 敏感数据是否使用钥匙串存储
- [ ] 网络请求是否使用 HTTPS
- [ ] 输入验证是否充分
- [ ] 是否防范 JSON 解析错误
- [ ] 是否避免硬编码凭证

### 依赖管理
- [ ] 第三方依赖是否必要
- [ ] 依赖版本是否固定
- [ ] 是否考虑了依赖的维护状态和安全性
- [ ] 是否最小化了外部依赖

### 测试
- [ ] 是否有单元测试覆盖核心功能
- [ ] 是否使用 XCTest 框架进行测试
- [ ] 是否测试了错误路径和边界条件
- [ ] UI 测试是否覆盖主要用户流程
- [ ] 测试是否独立且可重复

### 文档和注释
- [ ] 是否使用 Xcode 的标记注释 (MARK, TODO, FIXME)
- [ ] 复杂逻辑是否有注释说明
- [ ] 公开 API 是否有文档注释
- [ ] 注释是否与代码保持同步
""" 