from typing import Any, ClassVar

from typing import overload
import Boost.Python
Absolute: GJKConvergenceCriterionType
BVH_BUILD_STATE_BEGUN: BVHBuildState
BVH_BUILD_STATE_EMPTY: BVHBuildState
BVH_BUILD_STATE_PROCESSED: BVHBuildState
BVH_BUILD_STATE_REPLACE_BEGUN: BVHBuildState
BVH_BUILD_STATE_UPDATED: BVHBuildState
BVH_BUILD_STATE_UPDATE_BEGUN: BVHBuildState
BVH_MODEL_POINTCLOUD: BVHModelType
BVH_MODEL_TRIANGLES: BVHModelType
BVH_MODEL_UNKNOWN: BVHModelType
BV_AABB: NODE_TYPE
BV_KDOP16: NODE_TYPE
BV_KDOP18: NODE_TYPE
BV_KDOP24: NODE_TYPE
BV_OBB: NODE_TYPE
BV_OBBRSS: NODE_TYPE
BV_RSS: NODE_TYPE
BV_UNKNOWN: NODE_TYPE
BV_kIOS: NODE_TYPE
CONTACT: CollisionRequestFlag
DISTANCE_LOWER_BOUND: CollisionRequestFlag
DefaultGJK: GJKVariant
DualityGap: GJKConvergenceCriterion
Failed: GJKStatus
GEOM_BOX: NODE_TYPE
GEOM_CAPSULE: NODE_TYPE
GEOM_CONE: NODE_TYPE
GEOM_CONVEX: NODE_TYPE
GEOM_CYLINDER: NODE_TYPE
GEOM_ELLIPSOID: NODE_TYPE
GEOM_HALFSPACE: NODE_TYPE
GEOM_OCTREE: NODE_TYPE
GEOM_PLANE: NODE_TYPE
GEOM_SPHERE: NODE_TYPE
GEOM_TRIANGLE: NODE_TYPE
HF_AABB: NODE_TYPE
HF_OBBRSS: NODE_TYPE
HPP_FCL_MAJOR_VERSION: int
HPP_FCL_MINOR_VERSION: int
HPP_FCL_PATCH_VERSION: int
Hybrid: GJKConvergenceCriterion
Inside: GJKStatus
NO_REQUEST: CollisionRequestFlag
NesterovAcceleration: GJKVariant
OT_BVH: OBJECT_TYPE
OT_GEOM: OBJECT_TYPE
OT_HFIELD: OBJECT_TYPE
OT_OCTREE: OBJECT_TYPE
OT_UNKNOWN: OBJECT_TYPE
Relative: GJKConvergenceCriterionType
VDB: GJKConvergenceCriterion
Valid: GJKStatus

class AABB(Boost.Python.instance):
    __safe_for_unpickling__: ClassVar[bool] = ...
    max_: Any
    min_: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def center(cls, classhpp) -> Any: ...
    @classmethod
    def contain(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def depth(cls, classhpp) -> Any: ...
    @classmethod
    def distance(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def expand(cls, classhpp, double) -> Any: ...
    @classmethod
    def height(cls, classhpp) -> Any: ...
    @classmethod
    def overlap(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def size(cls, classhpp) -> Any: ...
    @classmethod
    def volume(cls, classhpp) -> Any: ...
    @classmethod
    def width(cls, classhpp) -> Any: ...
    @classmethod
    def __add__(cls, other) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __iadd__(cls, structboost, classhpp) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class AngleAxis(Boost.Python.instance):
    angle: Any
    axis: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def fromRotationMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def inverse(cls, classEigen) -> Any: ...
    @classmethod
    def isApprox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrix(cls, classEigen) -> Any: ...
    @classmethod
    def toRotationMatrix(cls, classEigen) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class BVHBuildState(Boost.Python.enum):
    BVH_BUILD_STATE_BEGUN: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_EMPTY: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_PROCESSED: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_REPLACE_BEGUN: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_UPDATED: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_UPDATE_BEGUN: ClassVar[BVHBuildState] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class BVHModelBase(CollisionGeometry):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addSubModel(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def addTriangle(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def addTriangles(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def addVertex(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def addVertices(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def beginModel(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def beginReplaceModel(cls, classhpp) -> Any: ...
    @classmethod
    def buildConvexHull(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def buildConvexRepresentation(cls, classhpp, bool) -> Any: ...
    @classmethod
    def endModel(cls, classhpp) -> Any: ...
    @classmethod
    def endReplaceModel(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def getModelType(cls, classhpp) -> Any: ...
    @classmethod
    def replaceSubModel(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def replaceTriangle(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def replaceVertex(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tri_indices(cls, classhpp, unsignedint) -> Any: ...
    @classmethod
    def vertex(cls, classhpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def vertices(cls, classhpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def vertices(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def build_state(self) -> Any: ...
    @property
    def convex(self) -> Any: ...
    @property
    def num_tris(self) -> Any: ...
    @property
    def num_vertices(self) -> Any: ...

class BVHModelOBB(BVHModelBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def getNumBVs(cls, classhpp) -> Any: ...
    @classmethod
    def makeParentRelative(cls, classhpp) -> Any: ...
    @classmethod
    def memUsage(cls, classhpp, bool) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class BVHModelOBBRSS(BVHModelBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def getNumBVs(cls, classhpp) -> Any: ...
    @classmethod
    def makeParentRelative(cls, classhpp) -> Any: ...
    @classmethod
    def memUsage(cls, classhpp, bool) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class BVHModelType(Boost.Python.enum):
    BVH_MODEL_POINTCLOUD: ClassVar[BVHModelType] = ...
    BVH_MODEL_TRIANGLES: ClassVar[BVHModelType] = ...
    BVH_MODEL_UNKNOWN: ClassVar[BVHModelType] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class Box(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfSide: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class BroadPhaseCollisionManager(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @overload
    @classmethod
    def clear(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def clear(cls, structhpp) -> Any: ...
    @classmethod
    def collide(cls, classhpp, structhpp) -> Any: ...
    @classmethod
    def distance(cls, classhpp, structhpp) -> Any: ...
    @overload
    @classmethod
    def empty(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def empty(cls, structhpp) -> Any: ...
    @overload
    @classmethod
    def getObjects(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def getObjects(cls, structhpp) -> Any: ...
    @classmethod
    def registerObject(cls, structhpp, classhpp) -> Any: ...
    @classmethod
    def registerObjects(cls, *args, **kwargs) -> Any: ...
    @overload
    @classmethod
    def setup(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def setup(cls, structhpp) -> Any: ...
    @overload
    @classmethod
    def size(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def size(cls, structhpp) -> Any: ...
    @classmethod
    def unregisterObject(cls, structhpp, classhpp) -> Any: ...
    @overload
    @classmethod
    def update(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def update(cls, structhpp) -> Any: ...
    @overload
    @classmethod
    def update(cls, structhpp, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class CPUTimes(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clear(cls, structhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def system(self) -> Any: ...
    @property
    def user(self) -> Any: ...
    @property
    def wall(self) -> Any: ...

class CachedMeshLoader(MeshLoader):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class Capsule(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfLength: Any
    radius: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class CollisionCallBackBase(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def collide(cls, *args, **kwargs) -> Any: ...
    @overload
    @classmethod
    def init(cls, structhpp) -> Any: ...
    @overload
    @classmethod
    def init(cls, structhpp) -> Any: ...
    @classmethod
    def __call__(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class CollisionCallBackCollect(CollisionCallBackBase):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def exist(cls, structhpp, structstd, classhpp) -> Any: ...
    @classmethod
    def getCollisionPairs(cls, structhpp) -> Any: ...
    @classmethod
    def numCollisionPairs(cls, structhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class CollisionCallBackDefault(CollisionCallBackBase):
    data: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class CollisionData(Boost.Python.instance):
    done: Any
    request: Any
    result: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class CollisionGeometry(Boost.Python.instance):
    aabb_center: Any
    aabb_local: Any
    aabb_radius: Any
    cost_density: Any
    threshold_free: Any
    threshold_occupied: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def computeCOM(cls, classhpp) -> Any: ...
    @classmethod
    def computeLocalAABB(cls, classhpp) -> Any: ...
    @classmethod
    def computeMomentofInertia(cls, classhpp) -> Any: ...
    @classmethod
    def computeMomentofInertiaRelatedToCOM(cls, classhpp) -> Any: ...
    @classmethod
    def computeVolume(cls, classhpp) -> Any: ...
    @classmethod
    def getNodeType(cls, classhpp) -> Any: ...
    @classmethod
    def getObjectType(cls, classhpp) -> Any: ...
    @classmethod
    def isFree(cls, classhpp) -> Any: ...
    @classmethod
    def isOccupied(cls, classhpp) -> Any: ...
    @classmethod
    def isUncertain(cls, classhpp) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class CollisionObject(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def collisionGeometry(cls, classhpp) -> Any: ...
    @classmethod
    def computeAABB(cls, classhpp) -> Any: ...
    @classmethod
    def getAABB(cls, classhpp) -> Any: ...
    @classmethod
    def getNodeType(cls, classhpp) -> Any: ...
    @classmethod
    def getObjectType(cls, classhpp) -> Any: ...
    @classmethod
    def getRotation(cls, classhpp) -> Any: ...
    @classmethod
    def getTransform(cls, classhpp) -> Any: ...
    @classmethod
    def getTranslation(cls, classhpp) -> Any: ...
    @classmethod
    def isIdentityTransform(cls, classhpp) -> Any: ...
    @classmethod
    def setCollisionGeometry(cls, classhpp, classstd, bool) -> Any: ...
    @classmethod
    def setIdentityTransform(cls, classhpp) -> Any: ...
    @classmethod
    def setRotation(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setTransform(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setTranslation(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class CollisionRequest(QueryRequest):
    break_distance: Any
    distance_upper_bound: Any
    enable_contact: Any
    enable_distance_lower_bound: Any
    num_max_contacts: Any
    security_margin: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class CollisionRequestFlag(Boost.Python.enum):
    CONTACT: ClassVar[CollisionRequestFlag] = ...
    DISTANCE_LOWER_BOUND: ClassVar[CollisionRequestFlag] = ...
    NO_REQUEST: ClassVar[CollisionRequestFlag] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class CollisionResult(QueryResult):
    distance_lower_bound: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addContact(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def clear(cls, structhpp) -> Any: ...
    @classmethod
    def getContact(cls, structhpp, unsigned__int64) -> Any: ...
    @classmethod
    def getContacts(cls, structhpp) -> Any: ...
    @classmethod
    def isCollision(cls, structhpp) -> Any: ...
    @classmethod
    def numContacts(cls, structhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class ComputeCollision(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __call__(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class ComputeDistance(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __call__(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class Cone(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfLength: Any
    radius: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class Contact(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    b1: Any
    b2: Any
    normal: Any
    penetration_depth: Any
    pos: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def o1(self) -> Any: ...
    @property
    def o2(self) -> Any: ...

class Convex(ConvexBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def polygons(cls, classhpp, unsignedint) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...
    @property
    def num_polygons(self) -> Any: ...

class ConvexBase(ShapeBase):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def convexHull(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def neighbors(cls, classhpp, unsignedint) -> Any: ...
    @classmethod
    def point(cls, classhpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def points(cls, classhpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def points(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def center(self) -> Any: ...
    @property
    def num_points(self) -> Any: ...

class Cylinder(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfLength: Any
    radius: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class DistanceCallBackBase(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def distance(cls, *args, **kwargs) -> Any: ...
    @overload
    @classmethod
    def init(cls, structhpp) -> Any: ...
    @overload
    @classmethod
    def init(cls, structhpp) -> Any: ...
    @classmethod
    def __call__(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class DistanceCallBackDefault(DistanceCallBackBase):
    data: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class DistanceData(Boost.Python.instance):
    done: Any
    request: Any
    result: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class DistanceRequest(QueryRequest):
    __instance_size__: ClassVar[int] = ...
    abs_err: Any
    enable_nearest_points: Any
    rel_err: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class DistanceResult(QueryResult):
    b1: Any
    b2: Any
    min_distance: Any
    normal: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clear(cls, structhpp) -> Any: ...
    @classmethod
    def getNearestPoint1(cls, structhpp) -> Any: ...
    @classmethod
    def getNearestPoint2(cls, structhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def o1(self) -> Any: ...
    @property
    def o2(self) -> Any: ...

class Ellipsoid(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    radii: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class GJK(Boost.Python.instance):
    convergence_criterion: Any
    convergence_criterion_type: Any
    distance: Any
    gjk_variant: Any
    ray: Any
    support_hint: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def evaluate(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def getClosestPoints(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def getGuessFromSimplex(cls, structhpp) -> Any: ...
    @classmethod
    def getIterations(cls, structhpp) -> Any: ...
    @classmethod
    def hasClosestPoints(cls, structhpp) -> Any: ...
    @classmethod
    def hasPenetrationInformation(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setDistanceEarlyBreak(cls, structhpp, double) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class GJKConvergenceCriterion(Boost.Python.enum):
    DualityGap: ClassVar[GJKConvergenceCriterion] = ...
    Hybrid: ClassVar[GJKConvergenceCriterion] = ...
    VDB: ClassVar[GJKConvergenceCriterion] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class GJKConvergenceCriterionType(Boost.Python.enum):
    Absolute: ClassVar[GJKConvergenceCriterionType] = ...
    Relative: ClassVar[GJKConvergenceCriterionType] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class GJKStatus(Boost.Python.enum):
    Failed: ClassVar[GJKStatus] = ...
    Inside: ClassVar[GJKStatus] = ...
    Valid: ClassVar[GJKStatus] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class GJKVariant(Boost.Python.enum):
    DefaultGJK: ClassVar[GJKVariant] = ...
    NesterovAcceleration: ClassVar[GJKVariant] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class Halfspace(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    d: Any
    n: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class HeightFieldAABB(CollisionGeometry):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def getBV(cls, classhpp, unsignedint) -> Any: ...
    @classmethod
    def getHeights(cls, classhpp) -> Any: ...
    @classmethod
    def getMaxHeight(cls, classhpp) -> Any: ...
    @classmethod
    def getMinHeight(cls, classhpp) -> Any: ...
    @classmethod
    def getNodeType(cls, classhpp) -> Any: ...
    @classmethod
    def getXDim(cls, classhpp) -> Any: ...
    @classmethod
    def getXGrid(cls, classhpp) -> Any: ...
    @classmethod
    def getYDim(cls, classhpp) -> Any: ...
    @classmethod
    def getYGrid(cls, classhpp) -> Any: ...
    @classmethod
    def updateHeights(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class HeightFieldOBBRSS(CollisionGeometry):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def getBV(cls, classhpp, unsignedint) -> Any: ...
    @classmethod
    def getHeights(cls, classhpp) -> Any: ...
    @classmethod
    def getMaxHeight(cls, classhpp) -> Any: ...
    @classmethod
    def getMinHeight(cls, classhpp) -> Any: ...
    @classmethod
    def getNodeType(cls, classhpp) -> Any: ...
    @classmethod
    def getXDim(cls, classhpp) -> Any: ...
    @classmethod
    def getXGrid(cls, classhpp) -> Any: ...
    @classmethod
    def getYDim(cls, classhpp) -> Any: ...
    @classmethod
    def getYGrid(cls, classhpp) -> Any: ...
    @classmethod
    def updateHeights(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class MeshLoader(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def load(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadOctree(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class MinkowskiDiff(Boost.Python.instance):
    inflation: Any
    normalize_support_direction: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def set(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def support(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def support0(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def support1(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class NODE_TYPE(Boost.Python.enum):
    BV_AABB: ClassVar[NODE_TYPE] = ...
    BV_KDOP16: ClassVar[NODE_TYPE] = ...
    BV_KDOP18: ClassVar[NODE_TYPE] = ...
    BV_KDOP24: ClassVar[NODE_TYPE] = ...
    BV_OBB: ClassVar[NODE_TYPE] = ...
    BV_OBBRSS: ClassVar[NODE_TYPE] = ...
    BV_RSS: ClassVar[NODE_TYPE] = ...
    BV_UNKNOWN: ClassVar[NODE_TYPE] = ...
    BV_kIOS: ClassVar[NODE_TYPE] = ...
    GEOM_BOX: ClassVar[NODE_TYPE] = ...
    GEOM_CAPSULE: ClassVar[NODE_TYPE] = ...
    GEOM_CONE: ClassVar[NODE_TYPE] = ...
    GEOM_CONVEX: ClassVar[NODE_TYPE] = ...
    GEOM_CYLINDER: ClassVar[NODE_TYPE] = ...
    GEOM_ELLIPSOID: ClassVar[NODE_TYPE] = ...
    GEOM_HALFSPACE: ClassVar[NODE_TYPE] = ...
    GEOM_OCTREE: ClassVar[NODE_TYPE] = ...
    GEOM_PLANE: ClassVar[NODE_TYPE] = ...
    GEOM_SPHERE: ClassVar[NODE_TYPE] = ...
    GEOM_TRIANGLE: ClassVar[NODE_TYPE] = ...
    HF_AABB: ClassVar[NODE_TYPE] = ...
    HF_OBBRSS: ClassVar[NODE_TYPE] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class OBJECT_TYPE(Boost.Python.enum):
    OT_BVH: ClassVar[OBJECT_TYPE] = ...
    OT_GEOM: ClassVar[OBJECT_TYPE] = ...
    OT_HFIELD: ClassVar[OBJECT_TYPE] = ...
    OT_OCTREE: ClassVar[OBJECT_TYPE] = ...
    OT_UNKNOWN: ClassVar[OBJECT_TYPE] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class Plane(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    d: Any
    n: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class Quaternion(Boost.Python.instance):
    w: Any
    x: Any
    y: Any
    z: Any
    @overload
    @classmethod
    def __init__(cls, classboost, classEigen) -> Any: ...
    @overload
    @classmethod
    def __init__(cls, classboost) -> Any: ...
    @classmethod
    def FromTwoVectors(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def Identity(cls) -> Any: ...
    @classmethod
    def _transformVector(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def angularDistance(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def assign(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def coeffs(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def conjugate(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def dot(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def inverse(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isApprox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def norm(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def normalize(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def normalized(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setFromTwoVectors(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIdentity(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def slerp(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def squaredNorm(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def toRotationMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def vec(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __abs__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __imul__(cls, other) -> Any: ...
    @classmethod
    def __len__(cls) -> Any: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class QueryRequest(Boost.Python.instance):
    cached_gjk_guess: Any
    cached_support_func_guess: Any
    enable_cached_gjk_guess: Any
    enable_timings: Any
    gjk_convergence_criterion: Any
    gjk_convergence_criterion_type: Any
    gjk_initial_guess: Any
    gjk_max_iterations: Any
    gjk_tolerance: Any
    gjk_variant: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def updateGuess(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class QueryResult(Boost.Python.instance):
    cached_gjk_guess: Any
    cached_support_func_guess: Any
    timings: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class ShapeBase(CollisionGeometry):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class SpatialHashingCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class Sphere(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    radius: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class StdVec_CollisionRequest(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_CollisionResult(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Contact(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_DistanceRequest(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_DistanceResult(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Triangle(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Vec3f(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class Transform3f(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def Identity(cls) -> Any: ...
    @classmethod
    def getQuatRotation(cls, classhpp) -> Any: ...
    @classmethod
    def getRotation(cls, classhpp) -> Any: ...
    @classmethod
    def getTranslation(cls, classhpp) -> Any: ...
    @classmethod
    def inverse(cls, classhpp) -> Any: ...
    @classmethod
    def inverseInPlace(cls, classhpp) -> Any: ...
    @classmethod
    def inverseTimes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isIdentity(cls, classhpp) -> Any: ...
    @classmethod
    def setIdentity(cls, classhpp) -> Any: ...
    @classmethod
    def setQuatRotation(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setRotation(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setTransform(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setTranslation(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def transform(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __imul__(cls, structboost, classhpp) -> Any: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class Triangle(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def set(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def size(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getitem__(cls, classhpp, int) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, classhpp, int, unsigned__int64) -> Any: ...

class TriangleP(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    a: Any
    b: Any
    c: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __getstate__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, classhpp, classboost) -> Any: ...

class class DynamicAABBTreeArrayCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class class DynamicAABBTreeCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class class IntervalTreeCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class class NaiveCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class class SSaPCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class class SaPCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

def checkVersionAtLeast(*args, **kwargs) -> Any: ...
def checkVersionAtMost(*args, **kwargs) -> Any: ...
def collide(*args, **kwargs) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
def distance(*args, **kwargs) -> Any: ...
@overload
def getNumpyType() -> Any: ...
@overload
def getNumpyType() -> Any: ...
def rotate(*args, **kwargs) -> Any: ...
@overload
def seed(unsignedint) -> Any: ...
@overload
def seed(unsignedint) -> Any: ...
@overload
def setNumpyType(classboost) -> Any: ...
@overload
def setNumpyType(classboost) -> Any: ...
@overload
def sharedMemory(bool) -> Any: ...
@overload
def sharedMemory() -> Any: ...
@overload
def sharedMemory(bool) -> Any: ...
@overload
def sharedMemory() -> Any: ...
@overload
def switchToNumpyArray() -> Any: ...
@overload
def switchToNumpyArray() -> Any: ...
@overload
def switchToNumpyMatrix() -> Any: ...
@overload
def switchToNumpyMatrix() -> Any: ...
def translate(*args, **kwargs) -> Any: ...
