/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers;

import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import io.ray.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.ray.shaded.com.google.common.collect.Ordering;
import io.ray.shaded.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;

public abstract class SchemaMapSyntaxChecker
extends AbstractSyntaxChecker {
    protected SchemaMapSyntaxChecker(String keyword) {
        super(keyword, NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    protected final void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        this.collectPointers(pointers, this.getNode(tree));
        this.extraChecks(report, bundle, tree);
    }

    protected abstract void extraChecks(ProcessingReport var1, MessageBundle var2, SchemaTree var3) throws ProcessingException;

    private void collectPointers(Collection<JsonPointer> pointers, JsonNode node) {
        HashSet<String> set = Sets.newHashSet(node.fieldNames());
        for (String s : Ordering.natural().sortedCopy(set)) {
            pointers.add(JsonPointer.of(this.keyword, s));
        }
    }
}

