# URL:     http://www.fiber-space.de
# Author:  Kay Schluehr <easyextend@fiber-space.de>
# Date:    10 May 2006

import EasyExtend
from   EasyExtend.parser.DFAParser import DFAParser
from   EasyExtend.eetokenizer import StdTokenizer
import EasyExtend.csttools as csttools
import EasyExtend.util.path as path
import eecommon
import marshal
import imp
import struct
import os
from   EasyExtend.parser.PyParser import PyParser
import cst2source
import cst
import sys


PyGrammarFile = ""

class EECompiler(eecommon.EEShow):
    def __init__(self, fiber):
        self.options    = fiber.options
        self.fiber      = fiber
        self.grammarObj = self.createGrammarObject(fiber.PyGrammar)

    def createGrammarObject(self, PyGrammar):
        '''
        Function used to create ext-language specific grammarObjects that contain
        dfa parser tables. These grammar objects will be created using lifted nodes of the
        the used fibers.

        @param PyGrammar: PyGrammar module that contains a grammarObj. If the object is
            not present it will be created using the languages Grammar file.

        @note: The grammarObj will be replaced by a newer version if the Grammar file
            is more recent than the PyGrammar.py module.
        '''
        global PyGrammarFile
        PyGrammarFile = path.path(PyGrammar.__file__)
        PyGrammarFile = path.path(PyGrammarFile.replace("pyc","py"))

        # is PyGrammar.py file module more recent than the Grammar file or small than return the
        # grammarObj immediately ...
        pygrammar_status = os.stat(PyGrammarFile)
        if pygrammar_status[-2] >= os.stat(PyGrammarFile.dirname()+os.sep+"Grammar")[-2]:
            return PyGrammar.grammarObj
        else:
            # otherwise access language specific grammar file and create a new grammarObj
            import EasyExtend.parser.PgenParser as PgenParser
            import EasyExtend.parser.PyPgen as PyPgen
            import EasyExtend.parser.PyToken as PyToken
            import EasyExtend.eetokenizer as tokenizer
            PyToken.FIBER_OFFSET = self.fiber.FIBER_OFFSET
            PyToken.FiberToken().gen_token(PyToken)
            grammarST  = PgenParser.Parser(self.fiber).parseFile(PyGrammarFile.dirname()+os.sep+"Grammar", tokenizer.StdTokenizer(PyToken, typ="grammar", use_comment=False))
            pgenObj    = PyPgen.PyPgen(self.fiber)
            grammarObj = pgenObj.createGrammar(grammarST)
            fPyGrammar = open(PyGrammarFile,"w")
            print "*** Modify PyGrammar.py file ***"
            print >> fPyGrammar, "# %s" % ("_" * 70)
            print >> fPyGrammar, "# This was automatically generated by PyPgen."
            print >> fPyGrammar, "# Hack at your own risk."
            print >> fPyGrammar
            # print >> fPyGrammar, "grammarST = ",
            import pprint

            # pprint.pprint(grammarST, fPyGrammar)
            accelGrammarObj = DFAParser(self.fiber, **self.options).addAccelerators(grammarObj)
            print >> fPyGrammar, "grammarObj =",
            pprint.pprint(accelGrammarObj,fPyGrammar)
            fPyGrammar.close()
            reload(PyGrammar)
            reload(PyToken)
            self.mapSymbols(grammarObj)
            reload(self.fiber.symbol)
            return PyGrammar.grammarObj


    def mapSymbols(self, grammarObj):
        '''
        A new language specific symbol.py file will be created.
        '''
        fPySymbol = open(os.sep.join([PyGrammarFile.dirname(),"fibermod","symbol.py"]),"w")
        print >> fPySymbol, "#  This file is automatically generated; please don't muck it up!"
        print >> fPySymbol
        print >> fPySymbol, "#--begin constants--"
        print >> fPySymbol
        for tok in grammarObj[0]:
            print >> fPySymbol, "%s = %s"%(tok[1],tok[0])
            #print "%s = %s"%(tok[1],tok[0])
        print >> fPySymbol
        print >> fPySymbol, "#--end constants--"
        print >> fPySymbol
        print >> fPySymbol, "sym_name = {}"
        print >> fPySymbol, "for _name, _value in globals().items():"
        print >> fPySymbol, "    if type(_value) is type(0):"
        print >> fPySymbol, "        sym_name[_value] = _name"
        fPySymbol.close()

    def eetransform(self, cst, **kwd):
        transformer  = self.fiber.FiberTransformer(self.fiber, **kwd)
        try:
            transformer.run(cst)
        finally:
            transformer.terminate()


    def eeparse_file(self, filename):
        '''
        @param filename: file to be parsed.
        @param grammarObj: language specific grammarObj read from PyGrammar.py
        '''
        tokenizer = StdTokenizer(self.fiber.token)
        tokenizer.tokenize_file(filename)
        self.maybe_show_token("", filename = filename)
        parseTree = DFAParser(self.fiber, **self.options).parsetok(tokenizer, self.grammarObj, self.fiber.symbol.file_input)
        return parseTree

    def eeparse_source(self, source, start_symbol):
        tokenizer   = StdTokenizer(self.fiber.token)
        tokenizer.tokenize_input(cst2source.SourceCode(source).readline)
        cst = DFAParser(self.fiber, **self.options).parsetok(tokenizer, self.grammarObj, start_symbol)
        return cst

    def eeparse_expr(self, source):
        return self.eeparse_source(source, self.fiber.symbol.eval_input)

    def eeparse_suite(self, source):
        return self.eeparse_source(source, self.fiber.symbol.file_input)

    def eecompile_cst(self, node, **kwd):
        if node[0] != self.fiber.symbol.file_input:
            node = cst.file_input(node)
        try:
            return PyParser.tuple2ast(node).compile()
        except PyParser.ParserError:
            csttools.projection(node)
            return self.try_compile(node, **kwd)

    def eecompile_suite(self, source, **kwd):
        '''
        @param source: source in string form
        @param grammarObj: language specific grammarObj read from PyGrammar.py
        @param fiber: module object containing language definitions
        '''
        cst = self.eeparse_suite(source)
        self.eetransform(cst, **kwd)
        csttools.projection(cst)
        return self.eecompile_cst(cst)

    def eecompile_expr(self, source, **kwd):
        '''
        @param source: source in string form
        @param grammarObj: language specific grammarObj read from PyGrammar.py
        @param fiber: module object containing language definitions
        '''
        cst = self.eeparse_expr(source)
        self.eetransform(cst, **kwd)
        csttools.projection(cst)
        return self.try_compile(cst, **kwd)


    def try_compile(self, cst, **kwd):
        ast =  PyParser.tuple2ast(cst)
        try:
            ast =  PyParser.tuple2ast(cst)
            return ast.compile()
        except PyParser.ParserError:
            #TBD: self.check_cst(cst, sys.exc_info()) <>
            self.fiber.unparse(cst)
            return compile(src,kwd.get("filename","<single>"),"exec", PyCF_DONT_IMPLY_DEDENT)

    def eecompile_file(self, filename, **kwd):
        '''
        Compile file according to a specific extension language into a Python module.

        @param filename: path to the destination file that will be compiled
        @param grammarObj: language specific grammarObj read from PyGrammar.py
        @param fiber: Python module defining the fiber semantics and transformation rules.
        @type fiber: Python module object
        '''
        parseTree = self.eeparse_file(filename)
        mod = EEModule(parseTree, filename, self.fiber)
        kwd["options"]  = self.options
        kwd["filename"] = filename
        try:
            mod.compile(**kwd)
        except SyntaxError:
            raise
        else:
            try:
                ext = self.fiber.ext
            except AttributeError:
                ext = "pyc"
            idx = filename.rfind(".")+1
            f = open(filename[:idx] + ext, "wb")
            mod.dump(f)
            f.close()
            return f


class EEModule(eecommon.EEShow):
    '''
    Class used to represent a module object of the fiber.
    '''
    def __init__(self, tree, filename, fiber):
        '''
        @param tree: parse tree of the extension language
        @param filename: filename of the compiled module
        @param fiber: Python module object containing relevant ext-language definitions.
        '''
        self.tree = tree
        self.filename = filename
        self.code = None
        self.fiber = fiber

    mode = "exec"

    def preprocess(self, **kwd):
        self.options = kwd["options"]
        ori_token = []
        transformer = self.fiber.FiberTransformer(self.fiber, **kwd)
        self.maybe_show_cst_before(self.tree)
        transformer.run(self.tree)
        transformer.general_transform(self.tree)
        self.maybe_show_cst_after(self.tree)
        transformer.terminate()
        csttools.projection(self.tree)
        self.maybe_show_python(self.tree)
        if self.options["parse_only"]:
            print "File parsed -> exit"
            sys.exit(0)

    def compile(self, **kwd):
        '''
        Create Python code object from transformed extension language parse tree.
        '''
        self.preprocess(**kwd)
        try:
            ast = PyParser.tuple2ast(self.tree)      # usual compilation process
            self.code = ast.compile(self.filename)
        except PyParser.ParserError, e:
            source = self.fiber.unparse(self.tree)          #  parser module is buggy...
            self.code = compile(source, self.filename, "exec")

    def dump(self, f):
        '''
        Dump Python code-object into a binary file
        '''
        f.write(self.getPycHeader())
        marshal.dump(self.code, f)

    MAGIC = imp.get_magic()

    def getPycHeader(self):
        # compile.c uses marshal to write a long directly, with
        # calling the interface that would also generate a 1-byte code
        # to indicate the type of the value.  simplest way to get the
        # same effect is to call marshal and then skip the code.
        mtime = os.path.getmtime(self.filename)
        mtime = struct.pack('<i', mtime)
        return self.MAGIC + mtime


