ENDPOINT_ARGUMENTS = {
    'search_instruments': {
        'projection': ['symbol-search', 'symbol-regex', 'desc-search', 'desc-regex', 'fundamental']
    },
    'get_market_hours': {
        'markets': ['EQUITY', 'OPTION', 'FUTURE', 'BOND', 'FOREX']
    },
    'get_movers': {
        'market': ['$DJI', '$COMPX', '$SPX.X'],
        'direction': ['up', 'down'],
        'change': ['value', 'percent']
    },
    'get_user_principals': {
        'fields': ['streamerSubscriptionKeys', 'streamerConnectionInfo', 'preferences', 'surrogateIds']
    }
}

VALID_CHART_VALUES = {
    'minute':{
        'day':[1, 2, 3, 4, 5, 10]
    },
    'daily':{
        'month':[1, 2, 3, 6],
        'year':[1, 2, 3, 5, 10, 15, 20],
        'ytd':[1]
    },
    'weekly':{
        'month':[1, 2, 3, 6],
        'year':[1, 2, 3, 5, 10, 15, 20],
        'ytd':[1]
    },
    'monthly':{
        'year':[1, 2, 3, 5, 10, 15, 20]
    }
}

STREAM_FIELD_IDS = {
    "account_activity": {
        "0": "subscription-key",
        "1": "account-id",
        "2": "message-type",
        "3": "message-data"
    },
    "level_one_forex": {
        "0": "symbol",
        "1": "bid-price",
        "2": "ask-price",
        "3": "last-price",
        "4": "bid-size",
        "5": "ask-size",
        "6": "total-volume",
        "7": "last-size",
        "8": "quote-time",
        "9": "trade-time",
        "10": "high-price",
        "11": "low-price",
        "12": "close-price",
        "13": "exchange-id",
        "14": "description",
        "15": "open-price",
        "16": "net-change",
        "17": "percent-change",
        "18": "exchange-name",
        "19": "digits",
        "20": "security-status",
        "21": "tick",
        "22": "tick-amount",
        "23": "product",
        "24": "trading-hours",
        "25": "is-tradable",
        "26": "market-maker",
        "27": "52-week-high",
        "28": "52-week-low",
        "29": "mark"
    },
    "level_one_futures": {
        "0": "symbol",
        "1": "bid-price",
        "2": "ask-price",
        "3": "last-price",
        "4": "bid-size",
        "5": "ask-size",
        "6": "ask-id",
        "7": "bid-id",
        "8": "total-volume",
        "9": "last-size",
        "10": "quote-time",
        "11": "trade-time",
        "12": "high-price",
        "13": "low-price",
        "14": "close-price",
        "15": "exchange-id",
        "16": "description",
        "17": "last-id",
        "18": "open-price",
        "19": "net-change",
        "20": "future-percent-change",
        "21": "exhange-name",
        "22": "security-status",
        "23": "open-interest",
        "24": "mark",
        "25": "tick",
        "26": "tick-amount",
        "27": "product",
        "28": "future-price-format",
        "29": "future-trading-hours",
        "30": "future-is-tradable",
        "31": "future-multiplier",
        "32": "future-is-active",
        "33": "future-settlement-price",
        "34": "future-active-symbol",
        "35": "future-expiration-date"
    },
    "level_one_futures_options": {
        "0": "symbol",
        "1": "bid-price",
        "2": "ask-price",
        "3": "last-price",
        "4": "bid-size",
        "5": "ask-size",
        "6": "ask-id",
        "7": "bid-id",
        "8": "total-volume",
        "9": "last-size",
        "10": "quote-time",
        "11": "trade-time",
        "12": "high-price",
        "13": "low-price",
        "14": "close-price",
        "15": "exchange-id",
        "16": "description",
        "17": "last-id",
        "18": "open-price",
        "19": "net-change",
        "20": "future-percent-change",
        "21": "exhange-name",
        "22": "security-status",
        "23": "open-interest",
        "24": "mark",
        "25": "tick",
        "26": "tick-amount",
        "27": "product",
        "28": "future-price-format",
        "29": "future-trading-hours",
        "30": "future-is-tradable",
        "31": "future-multiplier",
        "32": "future-is-active",
        "33": "future-settlement-price",
        "34": "future-active-symbol",
        "35": "future-expiration-date"
    },
    "level_one_option": {
        "0": "symbol",
        "1": "description",
        "2": "bid-price",
        "3": "ask-price",
        "4": "last-price",
        "5": "high-price",
        "6": "low-price",
        "7": "close-price",
        "8": "total-volume",
        "9": "open-interest",
        "10": "volatility",
        "11": "quote-time",
        "12": "trade-time",
        "13": "money-intrinsic-value",
        "14": "quote-day",
        "15": "trade-day",
        "16": "expiration-year",
        "17": "multiplier",
        "18": "digits",
        "19": "open-price",
        "20": "bid-size",
        "21": "ask-size",
        "22": "last-size",
        "23": "net-change",
        "24": "strike-price",
        "25": "contract-type",
        "26": "underlying",
        "27": "expiration-month",
        "28": "deliverables",
        "29": "time-value",
        "30": "expiration-day",
        "31": "days-to-expiration",
        "32": "delta",
        "33": "gamma",
        "34": "theta",
        "35": "vega",
        "36": "rho",
        "37": "security-status",
        "38": "theoretical-option-value",
        "39": "underlying-price",
        "40": "uv-expiration-type",
        "41": "mark"
    },
    "level_one_quote": {
        "0": "symbol",
        "1": "bid-price",
        "2": "ask-price",
        "3": "last-price",
        "4": "bid-size",
        "5": "ask-size",
        "6": "ask-id",
        "7": "bid-id",
        "8": "total-volume",
        "9": "last-size",
        "10": "trade-time",
        "11": "quote-time",
        "12": "high-price",
        "13": "low-price",
        "14": "bid-tick",
        "15": "close-price",
        "16": "exchange-id",
        "17": "marginable",
        "18": "shortable",
        "19": "island-bid",
        "20": "island-ask",
        "21": "island-volume",
        "22": "quote-day",
        "23": "trade-day",
        "24": "volatility",
        "25": "description",
        "26": "last-id",
        "27": "digits",
        "28": "open-price",
        "29": "net-change",
        "30": "52-week-high",
        "31": "52-week-low",
        "32": "pe-ratio",
        "33": "dividend-amount",
        "34": "dividend-yield",
        "35": "island-bid-size",
        "36": "island-ask-size",
        "37": "nav",
        "38": "fund-price",
        "39": "exchange-name",
        "40": "dividend-date",
        "41": "regular-market-quote",
        "42": "regular-market-trade",
        "43": "regular-market-last-price",
        "44": "regular-market-last-size",
        "45": "regular-market-trade-time",
        "46": "regular-market-trade-day",
        "47": "regular-market-net-change",
        "48": "security-status",
        "49": "mark",
        "50": "quote-time-in-long",
        "51": "trade-time-in-long",
        "52": "regular-market-trade-time-in-long"
    },
    "news_headline": {
        "0": "symbol",
        "1": "error-code",
        "2": "story-datetime",
        "3": "headline-id",
        "4": "status",
        "5": "headline",
        "6": "story-id",
        "7": "count-for-keyword",
        "8": "keyword-array",
        "9": "is-hot",
        "10": "story-source"
    },
    "qos_request": {
        "0": "express",
        "1": "real-time",
        "2": "fast",
        "3": "moderate",
        "4": "slow",
        "5": "delayed"
    },
    "timesale": {
        "0": "symbol",
        "1": "trade-time",
        "2": "last-price",
        "3": "last-size",
        "4": "last-sequence"
    },
    "chart_equity": {
        "seq": "chart-sequence",
        "key": "symbol",
        "1": "open-price",
        "2": "high-price",
        "3": "low-price",
        "4": "close_price",
        "5": "volume",
        "6": "sequence",
        "7": "chart_time",
        "8": "chart_day"
    },
    "chart_options": {
        "seq": "chart-sequence",
        "key": "key",
        "1": "open-price",
        "2": "high-price",
        "3": "low-price",
        "4": "close_price",
        "5": "volume",
        "6": "sequence",
        "7": "chart_time",
        "8": "chart_day"
    },
    "chart_futures": {
        "seq": "chart-sequence",
        "key": "key",
        "1": "open-price",
        "2": "high-price",
        "3": "low-price",
        "4": "close_price",
        "5": "volume",
        "6": "sequence",
        "7": "chart_time",
        "8": "chart_day"
    },
    "level_two_quotes": {
        "0": "key",
        "1": "time",
        "2": "data"
    },
    "level_two_nyse": {
        "0": "key",
        "1": "time",
        "2": "data"
    },
    "level_two_options": {
        "0": "key",
        "1": "time",
        "2": "data"
    },
    "level_two_forex": {
        "0": "key",
        "1": "time",
        "2": "data"
    },
    "level_two_nasdaq": {
        "0": "key",
        "1": "time",
        "2": "data"
    },
    "level_two_futures": {
        "0": "key",
        "1": "time",
        "2": "data"
    }
}


CSV_FIELD_KEYS = {
    "CHART_EQUITY": {
        "seq": "chart-sequence",
        "key": "symbol",
        "1": "chart-time",
        "2": "open-price",
        "3": "high-price",
        "4": "low-price",
        "5": "close-price",
        "6": "volume",
        "7": "chart-time",
        "8": "chart-day"
    },
    "CHART_FUTURES": {
        "seq": "chart-sequence",
        "key": "symbol",
        "1": "chart-time",
        "2": "open-price",
        "3": "high-price",
        "4": "low-price",
        "5": "close-price",
        "6": "volume"
    },
    "CHART_OPTIONS": {
        "seq": "chart-sequence",
        "key": "symbol",
        "1": "chart-time",
        "2": "open-price",
        "3": "high-price",
        "4": "low-price",
        "5": "close-price",
        "6": "volume"
    },
    "CHART_HISTORY": {
        "seq": "chart-sequence",
        "key": "symbol",
        "1": "chart-time",
        "2": "open-price",
        "3": "high-price",
        "4": "low-price",
        "5": "close-price",
        "6": "volume",
        "7": "chart-time",
        "8": "chart-day"
    },
    "CHART_HISTORY_FUTURES": {
        "seq": "chart-sequence",
        "key": "symbol",
        "0": "key",
        "1": "chart-time",
        "2": "open-price",
        "3": "high-price",
        "4": "low-price",
        "5": "close-price",
        "6": "volume",
        "7": "chart-time",
        "8": "chart-day"
    },
    "LEVELONE_FOREX": {
        "1": "bid-price",
        "10": "high-price",
        "11": "low-price",
        "12": "close-price",
        "13": "exchange-id",
        "14": "description",
        "15": "open-price",
        "16": "net-change",
        "17": "percent-change",
        "18": "exchange-name",
        "19": "digits",
        "2": "ask-price",
        "20": "security-status",
        "21": "tick",
        "22": "tick-amount",
        "23": "product",
        "24": "trading-hours",
        "25": "is-tradable",
        "26": "market-maker",
        "27": "52-week-high",
        "28": "52-week-low",
        "29": "mark",
        "3": "last-price",
        "4": "bid-size",
        "5": "ask-size",
        "6": "total-volume",
        "7": "last-size",
        "8": "quote-time",
        "9": "trade-time",
        "assetMainType": "asset-main-type",
        "assetSubType": "asset-sub-type",
        "cusip": "cusip",
        "delayed": "delayed",
        "key": "symbol",
    },
    "LEVELONE_FUTURES": {
        "1": "bid-price",
        "10": "quote-time",
        "11": "trade-time",
        "12": "high-price",
        "13": "low-price",
        "14": "close-price",
        "15": "exchange-id",
        "16": "description",
        "17": "last-id",
        "18": "open-price",
        "19": "net-change",
        "2": "ask-price",
        "20": "future-percent-change",
        "21": "exhange-name",
        "22": "security-status",
        "23": "open-interest",
        "24": "mark",
        "25": "tick",
        "26": "tick-amount",
        "27": "product",
        "28": "future-price-format",
        "29": "future-trading-hours",
        "3": "last-price",
        "30": "future-is-tradable",
        "31": "future-multiplier",
        "32": "future-is-active",
        "33": "future-settlement-price",
        "34": "future-active-symbol",
        "35": "future-expiration-date",
        "4": "bid-size",
        "5": "ask-size",
        "6": "ask-id",
        "7": "bid-id",
        "8": "total-volume",
        "9": "last-size",
        "assetMainType": "asset-main-type",
        "assetSubType": "asset-sub-type",
        "cusip": "cusip",
        "delayed": "delayed",
        "key": "symbol",
    },
    "LEVELONE_FUTURES_OPTIONS": {
        "1": "bid-price",
        "10": "quote-time",
        "11": "trade-time",
        "12": "high-price",
        "13": "low-price",
        "14": "close-price",
        "15": "exchange-id",
        "16": "description",
        "17": "last-id",
        "18": "open-price",
        "19": "net-change",
        "2": "ask-price",
        "20": "future-percent-change",
        "21": "exhange-name",
        "22": "security-status",
        "23": "open-interest",
        "24": "mark",
        "25": "tick",
        "26": "tick-amount",
        "27": "product",
        "28": "future-price-format",
        "29": "future-trading-hours",
        "3": "last-price",
        "30": "future-is-tradable",
        "31": "future-multiplier",
        "32": "future-is-active",
        "33": "future-settlement-price",
        "34": "future-active-symbol",
        "35": "future-expiration-date",
        "4": "bid-size",
        "5": "ask-size",
        "6": "ask-id",
        "7": "bid-id",
        "8": "total-volume",
        "9": "last-size",
        "assetMainType": "asset-main-type",
        "assetSubType": "asset-sub-type",
        "cusip": "cusip",
        "delayed": "delayed",
        "key": "symbol",
    },
    "OPTION": {
        "1": "description",
        "10": "volatility",
        "11": "quote-time",
        "12": "trade-time",
        "13": "money-intrinsic-value",
        "14": "quote-day",
        "15": "trade-day",
        "16": "expiration-year",
        "17": "multiplier",
        "18": "digits",
        "19": "open-price",
        "2": "bid-price",
        "20": "bid-size",
        "21": "ask-size",
        "22": "last-size",
        "23": "net-change",
        "24": "strike-price",
        "25": "contract-type",
        "26": "underlying",
        "27": "expiration-month",
        "28": "deliverables",
        "29": "time-value",
        "3": "ask-price",
        "30": "expiration-day",
        "31": "days-to-expiration",
        "32": "delta",
        "33": "gamma",
        "34": "theta",
        "35": "vega",
        "36": "rho",
        "37": "security-status",
        "38": "theoretical-option-value",
        "39": "underlying-price",
        "4": "last-price",
        "40": "uv-expiration-type",
        "41": "mark",
        "5": "high-price",
        "6": "low-price",
        "7": "close-price",
        "8": "total-volume",
        "9": "open-interest",
        "assetMainType": "asset-main-type",
        "assetSubType": "asset-sub-type",
        "cusip": "cusip",
        "delayed": "delayed",
        "key": "symbol",
    },
    "QUOTE": {
        "10": "trade-time",
        "11": "quote-time",
        "12": "high-price",
        "13": "low-price",
        "14": "bid-tick",
        "15": "close-price",
        "16": "exchange-id",
        "17": "marginable",
        "18": "shortable",
        "1": "bid-price",
        "19": "island-bid",
        "20": "island-ask",
        "21": "island-volume",
        "22": "quote-day",
        "23": "trade-day",
        "24": "volatility",
        "25": "description",
        "26": "last-id",
        "27": "digits",
        "28": "open-price",
        "2": "ask-price",
        "29": "net-change",
        "30": "52-week-high",
        "31": "52-week-low",
        "32": "pe-ratio",
        "33": "dividend-amount",
        "34": "dividend-yield",
        "35": "island-bid-size",
        "36": "island-ask-size",
        "37": "nav",
        "38": "fund-price",
        "3": "last-price",
        "39": "exchange-name",
        "40": "dividend-date",
        "41": "regular-market-quote",
        "42": "regular-market-trade",
        "43": "regular-market-last-price",
        "44": "regular-market-last-size",
        "45": "regular-market-trade-time",
        "46": "regular-market-trade-day",
        "47": "regular-market-net-change",
        "48": "security-status",
        "4": "bid-size",
        "49": "mark",
        "50": "quote-time-in-long",
        "51": "trade-time-in-long",
        "5": "ask-size",
        "6": "ask-id",
        "7": "bid-id",
        "8": "total-volume",
        "9": "last-size",
        "assetMainType": "asset-main-type",
        "assetSubType": "asset-sub-type",
        "cusip": "cusip",
        "delayed": "delayed",
        "key": "symbol"
    },
    "NEWS_HEADLINE": {
        "1": "error-code",
        "10": "story-source",
        "2": "story-datetime",
        "3": "headline-id",
        "4": "status",
        "5": "headline",
        "6": "story-id",
        "7": "count-for-keyword",
        "8": "keyword-array",
        "9": "is-hot",
        "key": "symbol",
        "seq": "sequence"
    },
    "TIMESALE_EQUITY": {
        "1": "trade-time",
        "2": "last-price",
        "3": "last-size",
        "4": "last-sequence",
        "key": "symbol",
        "seq": "sequence"
    },
    "TIMESALE_FUTURES": {
        "1": "trade-time",
        "2": "last-price",
        "3": "last-size",
        "4": "last-sequence",
        "key": "symbol",
        "seq": "sequence"
    },
    "TIMESALE_FOREX": {
        "1": "trade-time",
        "2": "last-price",
        "3": "last-size",
        "4": "last-sequence",
        "key": "symbol",
        "seq": "sequence"
    },
    "TIMESALE_OPTIONS": {
        "1": "trade-time",
        "2": "last-price",
        "3": "last-size",
        "4": "last-sequence",
        "key": "symbol",
        "seq": "sequence"
    },
}

CSV_FIELD_KEYS_LEVEL_2 = {
    "NASDAQ_BOOK": "nested",
    "OPTIONS_BOOK": "nested",
    "LISTED_BOOK": "nested",
    "FUTURES_BOOK":"nested"
}
