
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "esi"

@_ods_cext.register_operation(_Dialect)
class AppIDHierNodeOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.manifest.hier_node"

  _ODS_REGIONS = (1, True)

  def __init__(self, appID, moduleRef, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["appID"] = (appID if (
    isinstance(appID, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AppIDAttr')) else
      _ods_ir.AttrBuilder.get('AppIDAttr')(appID, context=_ods_context))
    attributes["moduleRef"] = (moduleRef if (
    isinstance(moduleRef, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(moduleRef, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def appID(self):
    return self.operation.attributes["appID"]

  @appID.setter
  def appID(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["appID"] = value

  @builtins.property
  def moduleRef(self):
    return self.operation.attributes["moduleRef"]

  @moduleRef.setter
  def moduleRef(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["moduleRef"] = value

  @builtins.property
  def children(self):
    return self.regions[0]

def manifest_hier_node(app_id, module_ref, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AppIDHierNodeOp(appID=app_id, moduleRef=module_ref, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AppIDHierRootOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.manifest.hier_root"

  _ODS_REGIONS = (1, True)

  def __init__(self, topModuleRef, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["topModuleRef"] = (topModuleRef if (
    isinstance(topModuleRef, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(topModuleRef, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def topModuleRef(self):
    return self.operation.attributes["topModuleRef"]

  @topModuleRef.setter
  def topModuleRef(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["topModuleRef"] = value

  @builtins.property
  def children(self):
    return self.regions[0]

def manifest_hier_root(top_module_ref, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AppIDHierRootOp(topModuleRef=top_module_ref, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CallServiceDeclOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.service.std.call"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

def service_std_call(sym_name, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CallServiceDeclOp(sym_name=sym_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ChannelBufferOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.buffer"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, clk, rst, input, *, stages=None, name=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(clk))
    operands.append(_get_op_result_or_value(rst))
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    if stages is not None: attributes["stages"] = (stages if (
        isinstance(stages, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(stages, context=_ods_context))
    if name is not None: attributes["name"] = (name if (
        isinstance(name, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def clk(self):
    return self.operation.operands[0]

  @builtins.property
  def rst(self):
    return self.operation.operands[1]

  @builtins.property
  def input(self):
    return self.operation.operands[2]

  @builtins.property
  def stages(self):
    if "stages" not in self.operation.attributes:
      return None
    return self.operation.attributes["stages"]

  @stages.setter
  def stages(self, value):
    if value is not None:
      self.operation.attributes["stages"] = value
    elif "stages" in self.operation.attributes:
      del self.operation.attributes["stages"]

  @stages.deleter
  def stages(self):
    del self.operation.attributes["stages"]

  @builtins.property
  def name(self):
    if "name" not in self.operation.attributes:
      return None
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is not None:
      self.operation.attributes["name"] = value
    elif "name" in self.operation.attributes:
      del self.operation.attributes["name"]

  @name.deleter
  def name(self):
    del self.operation.attributes["name"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def buffer(output, clk, rst, input, *, stages=None, name=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ChannelBufferOp(output=output, clk=clk, rst=rst, input=input, stages=stages, name=name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CompressedManifestOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.manifest.compressed"

  _ODS_REGIONS = (0, True)

  def __init__(self, compressedManifest, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["compressedManifest"] = (compressedManifest if (
    isinstance(compressedManifest, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BlobAttr')) else
      _ods_ir.AttrBuilder.get('BlobAttr')(compressedManifest, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def compressedManifest(self):
    return self.operation.attributes["compressedManifest"]

  @compressedManifest.setter
  def compressedManifest(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["compressedManifest"] = value

def manifest_compressed(compressed_manifest, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CompressedManifestOp(compressedManifest=compressed_manifest, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CosimFromHostEndpointOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.cosim.from_host"

  _ODS_REGIONS = (0, True)

  def __init__(self, fromHost, clk, rst, id, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(clk))
    operands.append(_get_op_result_or_value(rst))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["id"] = (id if (
    isinstance(id, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(id, context=_ods_context))
    results.append(fromHost)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def clk(self):
    return self.operation.operands[0]

  @builtins.property
  def rst(self):
    return self.operation.operands[1]

  @builtins.property
  def id(self):
    return self.operation.attributes["id"]

  @id.setter
  def id(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["id"] = value

  @builtins.property
  def fromHost(self):
    return self.operation.results[0]

def cosim_from_host(from_host, clk, rst, id, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CosimFromHostEndpointOp(fromHost=from_host, clk=clk, rst=rst, id=id, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CosimToHostEndpointOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.cosim.to_host"

  _ODS_REGIONS = (0, True)

  def __init__(self, clk, rst, toHost, id, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(clk))
    operands.append(_get_op_result_or_value(rst))
    operands.append(_get_op_result_or_value(toHost))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["id"] = (id if (
    isinstance(id, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(id, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def clk(self):
    return self.operation.operands[0]

  @builtins.property
  def rst(self):
    return self.operation.operands[1]

  @builtins.property
  def toHost(self):
    return self.operation.operands[2]

  @builtins.property
  def id(self):
    return self.operation.attributes["id"]

  @id.setter
  def id(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["id"] = value

def cosim_to_host(clk, rst, to_host, id, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CosimToHostEndpointOp(clk=clk, rst=rst, toHost=to_host, id=id, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CustomServiceDeclOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.service.decl"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def ports(self):
    return self.regions[0]

def service_decl(sym_name, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CustomServiceDeclOp(sym_name=sym_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ESIPureModuleInputOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.pure_module.input"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    results.append(value)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def value(self):
    return self.operation.results[0]

def pure_module_input(value, name, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ESIPureModuleInputOp(value=value, name=name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ESIPureModuleOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.pure_module"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def pure_module(sym_name, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ESIPureModuleOp(sym_name=sym_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ESIPureModuleOutputOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.pure_module.output"

  _ODS_REGIONS = (0, True)

  def __init__(self, name, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

def pure_module_output(name, value, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ESIPureModuleOutputOp(name=name, value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ESIPureModuleParamOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.pure_module.param"

  _ODS_REGIONS = (0, True)

  def __init__(self, name, type_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    attributes["type"] = (type_ if (
    isinstance(type_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(type_, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def type_(self):
    return self.operation.attributes["type"]

  @type_.setter
  def type_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["type"] = value

def pure_module_param(name, type_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ESIPureModuleParamOp(name=name, type_=type_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FuncServiceDeclOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.service.std.func"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

def service_std_func(sym_name, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(FuncServiceDeclOp(sym_name=sym_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MMIOServiceDeclOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.service.std.mmio"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

def service_std_mmio(sym_name, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(MMIOServiceDeclOp(sym_name=sym_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class NullSourceOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.null"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(out)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def out(self):
    return self.operation.results[0]

def null(out, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(NullSourceOp(out=out, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PackBundleOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.bundle.pack"

  _ODS_REGIONS = (0, True)

  def __init__(self, bundle, fromChannels, toChannels, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(toChannels))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(bundle)
    results.extend(fromChannels)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def toChannels(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def bundle(self):
    return self.operation.results[0]

  @builtins.property
  def fromChannels(self):
    _ods_variadic_group_length = len(self.operation.results) - 2 + 1
    return self.operation.results[1:1 + _ods_variadic_group_length]

def bundle_pack(bundle, from_channels, to_channels, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return _get_op_result_or_op_results(PackBundleOp(bundle=bundle, fromChannels=from_channels, toChannels=to_channels, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PipelineStageOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.stage"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, clk, rst, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(clk))
    operands.append(_get_op_result_or_value(rst))
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def clk(self):
    return self.operation.operands[0]

  @builtins.property
  def rst(self):
    return self.operation.operands[1]

  @builtins.property
  def input(self):
    return self.operation.operands[2]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def stage(output, clk, rst, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(PipelineStageOp(output=output, clk=clk, rst=rst, input=input, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class RandomAccessMemoryDeclOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.mem.ram"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, innerType, depth, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["innerType"] = (innerType if (
    isinstance(innerType, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(innerType, context=_ods_context))
    attributes["depth"] = (depth if (
    isinstance(depth, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(depth, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def innerType(self):
    return self.operation.attributes["innerType"]

  @innerType.setter
  def innerType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["innerType"] = value

  @builtins.property
  def depth(self):
    return self.operation.attributes["depth"]

  @depth.setter
  def depth(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["depth"] = value

def mem_ram(sym_name, inner_type, depth, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(RandomAccessMemoryDeclOp(sym_name=sym_name, innerType=inner_type, depth=depth, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class RequestConnectionOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.service.req"

  _ODS_REGIONS = (0, True)

  def __init__(self, toClient, servicePort, appID, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["servicePort"] = (servicePort if (
    isinstance(servicePort, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('InnerRefAttr')) else
      _ods_ir.AttrBuilder.get('InnerRefAttr')(servicePort, context=_ods_context))
    attributes["appID"] = (appID if (
    isinstance(appID, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AppIDAttr')) else
      _ods_ir.AttrBuilder.get('AppIDAttr')(appID, context=_ods_context))
    results.append(toClient)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def servicePort(self):
    return self.operation.attributes["servicePort"]

  @servicePort.setter
  def servicePort(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["servicePort"] = value

  @builtins.property
  def appID(self):
    return self.operation.attributes["appID"]

  @appID.setter
  def appID(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["appID"] = value

  @builtins.property
  def toClient(self):
    return self.operation.results[0]

def service_req(to_client, service_port, app_id, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(RequestConnectionOp(toClient=to_client, servicePort=service_port, appID=app_id, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ServiceDeclPortOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.service.port"

  _ODS_REGIONS = (0, True)

  def __init__(self, inner_sym, toClientType, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["inner_sym"] = (inner_sym if (
    isinstance(inner_sym, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(inner_sym, context=_ods_context))
    attributes["toClientType"] = (toClientType if (
    isinstance(toClientType, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_443')) else
      _ods_ir.AttrBuilder.get('anonymous_443')(toClientType, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inner_sym(self):
    return self.operation.attributes["inner_sym"]

  @inner_sym.setter
  def inner_sym(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["inner_sym"] = value

  @builtins.property
  def toClientType(self):
    return self.operation.attributes["toClientType"]

  @toClientType.setter
  def toClientType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["toClientType"] = value

def service_port(inner_sym, to_client_type, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ServiceDeclPortOp(inner_sym=inner_sym, toClientType=to_client_type, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ServiceImplClientRecordOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.manifest.impl_conn"

  _ODS_REGIONS = (0, True)

  def __init__(self, relAppIDPath, servicePort, bundleType, implDetails, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["relAppIDPath"] = (relAppIDPath if (
    isinstance(relAppIDPath, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AppIDArrayAttr')) else
      _ods_ir.AttrBuilder.get('AppIDArrayAttr')(relAppIDPath, context=_ods_context))
    attributes["servicePort"] = (servicePort if (
    isinstance(servicePort, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('InnerRefAttr')) else
      _ods_ir.AttrBuilder.get('InnerRefAttr')(servicePort, context=_ods_context))
    attributes["bundleType"] = (bundleType if (
    isinstance(bundleType, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_443')) else
      _ods_ir.AttrBuilder.get('anonymous_443')(bundleType, context=_ods_context))
    attributes["implDetails"] = (implDetails if (
    isinstance(implDetails, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DictionaryAttr')) else
      _ods_ir.AttrBuilder.get('DictionaryAttr')(implDetails, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def relAppIDPath(self):
    return self.operation.attributes["relAppIDPath"]

  @relAppIDPath.setter
  def relAppIDPath(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["relAppIDPath"] = value

  @builtins.property
  def servicePort(self):
    return self.operation.attributes["servicePort"]

  @servicePort.setter
  def servicePort(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["servicePort"] = value

  @builtins.property
  def bundleType(self):
    return self.operation.attributes["bundleType"]

  @bundleType.setter
  def bundleType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["bundleType"] = value

  @builtins.property
  def implDetails(self):
    return self.operation.attributes["implDetails"]

  @implDetails.setter
  def implDetails(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["implDetails"] = value

def manifest_impl_conn(rel_app_id_path, service_port, bundle_type, impl_details, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ServiceImplClientRecordOp(relAppIDPath=rel_app_id_path, servicePort=service_port, bundleType=bundle_type, implDetails=impl_details, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ServiceImplRecordOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.manifest.service_impl"

  _ODS_REGIONS = (1, True)

  def __init__(self, appID, serviceImplName, implDetails, *, service=None, stdService=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["appID"] = (appID if (
    isinstance(appID, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AppIDAttr')) else
      _ods_ir.AttrBuilder.get('AppIDAttr')(appID, context=_ods_context))
    if service is not None: attributes["service"] = (service if (
        isinstance(service, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(service, context=_ods_context))
    if stdService is not None: attributes["stdService"] = (stdService if (
        isinstance(stdService, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(stdService, context=_ods_context))
    attributes["serviceImplName"] = (serviceImplName if (
    isinstance(serviceImplName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(serviceImplName, context=_ods_context))
    attributes["implDetails"] = (implDetails if (
    isinstance(implDetails, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DictionaryAttr')) else
      _ods_ir.AttrBuilder.get('DictionaryAttr')(implDetails, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def appID(self):
    return self.operation.attributes["appID"]

  @appID.setter
  def appID(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["appID"] = value

  @builtins.property
  def service(self):
    if "service" not in self.operation.attributes:
      return None
    return self.operation.attributes["service"]

  @service.setter
  def service(self, value):
    if value is not None:
      self.operation.attributes["service"] = value
    elif "service" in self.operation.attributes:
      del self.operation.attributes["service"]

  @service.deleter
  def service(self):
    del self.operation.attributes["service"]

  @builtins.property
  def stdService(self):
    if "stdService" not in self.operation.attributes:
      return None
    return self.operation.attributes["stdService"]

  @stdService.setter
  def stdService(self, value):
    if value is not None:
      self.operation.attributes["stdService"] = value
    elif "stdService" in self.operation.attributes:
      del self.operation.attributes["stdService"]

  @stdService.deleter
  def stdService(self):
    del self.operation.attributes["stdService"]

  @builtins.property
  def serviceImplName(self):
    return self.operation.attributes["serviceImplName"]

  @serviceImplName.setter
  def serviceImplName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["serviceImplName"] = value

  @builtins.property
  def implDetails(self):
    return self.operation.attributes["implDetails"]

  @implDetails.setter
  def implDetails(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["implDetails"] = value

  @builtins.property
  def reqDetails(self):
    return self.regions[0]

def manifest_service_impl(app_id, service_impl_name, impl_details, *, service=None, std_service=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ServiceImplRecordOp(appID=app_id, serviceImplName=service_impl_name, implDetails=impl_details, service=service, stdService=std_service, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ServiceImplementConnReqOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.service.impl_req.req"

  _ODS_REGIONS = (0, True)

  def __init__(self, toClient, servicePort, relativeAppIDPath, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["servicePort"] = (servicePort if (
    isinstance(servicePort, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('InnerRefAttr')) else
      _ods_ir.AttrBuilder.get('InnerRefAttr')(servicePort, context=_ods_context))
    attributes["relativeAppIDPath"] = (relativeAppIDPath if (
    isinstance(relativeAppIDPath, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AppIDArrayAttr')) else
      _ods_ir.AttrBuilder.get('AppIDArrayAttr')(relativeAppIDPath, context=_ods_context))
    results.append(toClient)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def servicePort(self):
    return self.operation.attributes["servicePort"]

  @servicePort.setter
  def servicePort(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["servicePort"] = value

  @builtins.property
  def relativeAppIDPath(self):
    return self.operation.attributes["relativeAppIDPath"]

  @relativeAppIDPath.setter
  def relativeAppIDPath(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["relativeAppIDPath"] = value

  @builtins.property
  def toClient(self):
    return self.operation.results[0]

def service_impl_req_req(to_client, service_port, relative_app_id_path, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ServiceImplementConnReqOp(toClient=to_client, servicePort=service_port, relativeAppIDPath=relative_app_id_path, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ServiceImplementReqOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.service.impl_req"

  _ODS_REGIONS = (1, True)

  def __init__(self, outputs, appID, impl_type, inputs, *, service_symbol=None, stdService=None, impl_opts=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["appID"] = (appID if (
    isinstance(appID, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AppIDAttr')) else
      _ods_ir.AttrBuilder.get('AppIDAttr')(appID, context=_ods_context))
    if service_symbol is not None: attributes["service_symbol"] = (service_symbol if (
        isinstance(service_symbol, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(service_symbol, context=_ods_context))
    attributes["impl_type"] = (impl_type if (
    isinstance(impl_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(impl_type, context=_ods_context))
    if stdService is not None: attributes["stdService"] = (stdService if (
        isinstance(stdService, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(stdService, context=_ods_context))
    if impl_opts is not None: attributes["impl_opts"] = (impl_opts if (
        isinstance(impl_opts, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictionaryAttr')) else
          _ods_ir.AttrBuilder.get('DictionaryAttr')(impl_opts, context=_ods_context))
    results.extend(outputs)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def appID(self):
    return self.operation.attributes["appID"]

  @appID.setter
  def appID(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["appID"] = value

  @builtins.property
  def service_symbol(self):
    if "service_symbol" not in self.operation.attributes:
      return None
    return self.operation.attributes["service_symbol"]

  @service_symbol.setter
  def service_symbol(self, value):
    if value is not None:
      self.operation.attributes["service_symbol"] = value
    elif "service_symbol" in self.operation.attributes:
      del self.operation.attributes["service_symbol"]

  @service_symbol.deleter
  def service_symbol(self):
    del self.operation.attributes["service_symbol"]

  @builtins.property
  def impl_type(self):
    return self.operation.attributes["impl_type"]

  @impl_type.setter
  def impl_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["impl_type"] = value

  @builtins.property
  def stdService(self):
    if "stdService" not in self.operation.attributes:
      return None
    return self.operation.attributes["stdService"]

  @stdService.setter
  def stdService(self, value):
    if value is not None:
      self.operation.attributes["stdService"] = value
    elif "stdService" in self.operation.attributes:
      del self.operation.attributes["stdService"]

  @stdService.deleter
  def stdService(self):
    del self.operation.attributes["stdService"]

  @builtins.property
  def impl_opts(self):
    if "impl_opts" not in self.operation.attributes:
      return None
    return self.operation.attributes["impl_opts"]

  @impl_opts.setter
  def impl_opts(self, value):
    if value is not None:
      self.operation.attributes["impl_opts"] = value
    elif "impl_opts" in self.operation.attributes:
      del self.operation.attributes["impl_opts"]

  @impl_opts.deleter
  def impl_opts(self):
    del self.operation.attributes["impl_opts"]

  @builtins.property
  def outputs(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def portReqs(self):
    return self.regions[0]

def service_impl_req(outputs, app_id, impl_type, inputs, *, service_symbol=None, std_service=None, impl_opts=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ServiceImplementReqOp(outputs=outputs, appID=app_id, impl_type=impl_type, inputs=inputs, service_symbol=service_symbol, stdService=std_service, impl_opts=impl_opts, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ServiceInstanceOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.service.instance"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, appID, impl_type, inputs, *, service_symbol=None, impl_opts=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["appID"] = (appID if (
    isinstance(appID, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AppIDAttr')) else
      _ods_ir.AttrBuilder.get('AppIDAttr')(appID, context=_ods_context))
    if service_symbol is not None: attributes["service_symbol"] = (service_symbol if (
        isinstance(service_symbol, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(service_symbol, context=_ods_context))
    attributes["impl_type"] = (impl_type if (
    isinstance(impl_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(impl_type, context=_ods_context))
    if impl_opts is not None: attributes["impl_opts"] = (impl_opts if (
        isinstance(impl_opts, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictionaryAttr')) else
          _ods_ir.AttrBuilder.get('DictionaryAttr')(impl_opts, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def appID(self):
    return self.operation.attributes["appID"]

  @appID.setter
  def appID(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["appID"] = value

  @builtins.property
  def service_symbol(self):
    if "service_symbol" not in self.operation.attributes:
      return None
    return self.operation.attributes["service_symbol"]

  @service_symbol.setter
  def service_symbol(self, value):
    if value is not None:
      self.operation.attributes["service_symbol"] = value
    elif "service_symbol" in self.operation.attributes:
      del self.operation.attributes["service_symbol"]

  @service_symbol.deleter
  def service_symbol(self):
    del self.operation.attributes["service_symbol"]

  @builtins.property
  def impl_type(self):
    return self.operation.attributes["impl_type"]

  @impl_type.setter
  def impl_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["impl_type"] = value

  @builtins.property
  def impl_opts(self):
    if "impl_opts" not in self.operation.attributes:
      return None
    return self.operation.attributes["impl_opts"]

  @impl_opts.setter
  def impl_opts(self, value):
    if value is not None:
      self.operation.attributes["impl_opts"] = value
    elif "impl_opts" in self.operation.attributes:
      del self.operation.attributes["impl_opts"]

  @impl_opts.deleter
  def impl_opts(self):
    del self.operation.attributes["impl_opts"]

def service_instance(result, app_id, impl_type, inputs, *, service_symbol=None, impl_opts=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ServiceInstanceOp(result=result, appID=app_id, impl_type=impl_type, inputs=inputs, service_symbol=service_symbol, impl_opts=impl_opts, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ServiceRequestRecordOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.manifest.req"

  _ODS_REGIONS = (0, True)

  def __init__(self, requestor, servicePort, bundleType, *, stdService=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["requestor"] = (requestor if (
    isinstance(requestor, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AppIDAttr')) else
      _ods_ir.AttrBuilder.get('AppIDAttr')(requestor, context=_ods_context))
    attributes["servicePort"] = (servicePort if (
    isinstance(servicePort, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('InnerRefAttr')) else
      _ods_ir.AttrBuilder.get('InnerRefAttr')(servicePort, context=_ods_context))
    if stdService is not None: attributes["stdService"] = (stdService if (
        isinstance(stdService, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(stdService, context=_ods_context))
    attributes["bundleType"] = (bundleType if (
    isinstance(bundleType, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_443')) else
      _ods_ir.AttrBuilder.get('anonymous_443')(bundleType, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def requestor(self):
    return self.operation.attributes["requestor"]

  @requestor.setter
  def requestor(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["requestor"] = value

  @builtins.property
  def servicePort(self):
    return self.operation.attributes["servicePort"]

  @servicePort.setter
  def servicePort(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["servicePort"] = value

  @builtins.property
  def stdService(self):
    if "stdService" not in self.operation.attributes:
      return None
    return self.operation.attributes["stdService"]

  @stdService.setter
  def stdService(self, value):
    if value is not None:
      self.operation.attributes["stdService"] = value
    elif "stdService" in self.operation.attributes:
      del self.operation.attributes["stdService"]

  @stdService.deleter
  def stdService(self):
    del self.operation.attributes["stdService"]

  @builtins.property
  def bundleType(self):
    return self.operation.attributes["bundleType"]

  @bundleType.setter
  def bundleType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["bundleType"] = value

def manifest_req(requestor, service_port, bundle_type, *, std_service=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ServiceRequestRecordOp(requestor=requestor, servicePort=service_port, bundleType=bundle_type, stdService=std_service, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SymbolMetadataOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.manifest.sym"

  _ODS_REGIONS = (0, True)

  def __init__(self, symbolRef, *, name=None, repo=None, commitHash=None, version=None, summary=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["symbolRef"] = (symbolRef if (
    isinstance(symbolRef, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(symbolRef, context=_ods_context))
    if name is not None: attributes["name"] = (name if (
        isinstance(name, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    if repo is not None: attributes["repo"] = (repo if (
        isinstance(repo, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(repo, context=_ods_context))
    if commitHash is not None: attributes["commitHash"] = (commitHash if (
        isinstance(commitHash, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(commitHash, context=_ods_context))
    if version is not None: attributes["version"] = (version if (
        isinstance(version, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(version, context=_ods_context))
    if summary is not None: attributes["summary"] = (summary if (
        isinstance(summary, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(summary, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def symbolRef(self):
    return self.operation.attributes["symbolRef"]

  @symbolRef.setter
  def symbolRef(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["symbolRef"] = value

  @builtins.property
  def name(self):
    if "name" not in self.operation.attributes:
      return None
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is not None:
      self.operation.attributes["name"] = value
    elif "name" in self.operation.attributes:
      del self.operation.attributes["name"]

  @name.deleter
  def name(self):
    del self.operation.attributes["name"]

  @builtins.property
  def repo(self):
    if "repo" not in self.operation.attributes:
      return None
    return self.operation.attributes["repo"]

  @repo.setter
  def repo(self, value):
    if value is not None:
      self.operation.attributes["repo"] = value
    elif "repo" in self.operation.attributes:
      del self.operation.attributes["repo"]

  @repo.deleter
  def repo(self):
    del self.operation.attributes["repo"]

  @builtins.property
  def commitHash(self):
    if "commitHash" not in self.operation.attributes:
      return None
    return self.operation.attributes["commitHash"]

  @commitHash.setter
  def commitHash(self, value):
    if value is not None:
      self.operation.attributes["commitHash"] = value
    elif "commitHash" in self.operation.attributes:
      del self.operation.attributes["commitHash"]

  @commitHash.deleter
  def commitHash(self):
    del self.operation.attributes["commitHash"]

  @builtins.property
  def version(self):
    if "version" not in self.operation.attributes:
      return None
    return self.operation.attributes["version"]

  @version.setter
  def version(self, value):
    if value is not None:
      self.operation.attributes["version"] = value
    elif "version" in self.operation.attributes:
      del self.operation.attributes["version"]

  @version.deleter
  def version(self):
    del self.operation.attributes["version"]

  @builtins.property
  def summary(self):
    if "summary" not in self.operation.attributes:
      return None
    return self.operation.attributes["summary"]

  @summary.setter
  def summary(self, value):
    if value is not None:
      self.operation.attributes["summary"] = value
    elif "summary" in self.operation.attributes:
      del self.operation.attributes["summary"]

  @summary.deleter
  def summary(self):
    del self.operation.attributes["summary"]

def manifest_sym(symbol_ref, *, name=None, repo=None, commit_hash=None, version=None, summary=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(SymbolMetadataOp(symbolRef=symbol_ref, name=name, repo=repo, commitHash=commit_hash, version=version, summary=summary, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnpackBundleOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.bundle.unpack"

  _ODS_REGIONS = (0, True)

  def __init__(self, toChannels, bundle, fromChannels, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(bundle))
    operands.extend(_get_op_results_or_values(fromChannels))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(toChannels)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def bundle(self):
    return self.operation.operands[0]

  @builtins.property
  def fromChannels(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def toChannels(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def bundle_unpack(to_channels, bundle, from_channels, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UnpackBundleOp(toChannels=to_channels, bundle=bundle, fromChannels=from_channels, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnwrapFIFOOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.unwrap.fifo"

  _ODS_REGIONS = (0, True)

  def __init__(self, chanInput, rden, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(chanInput))
    operands.append(_get_op_result_or_value(rden))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def chanInput(self):
    return self.operation.operands[0]

  @builtins.property
  def rden(self):
    return self.operation.operands[1]

  @builtins.property
  def data(self):
    return self.operation.results[0]

  @builtins.property
  def empty(self):
    return self.operation.results[1]

def unwrap_fifo(chan_input, rden, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return _get_op_result_or_op_results(UnwrapFIFOOp(chanInput=chan_input, rden=rden, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnwrapSVInterfaceOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.unwrap.iface"

  _ODS_REGIONS = (0, True)

  def __init__(self, chanInput, interfaceSource, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(chanInput))
    operands.append(_get_op_result_or_value(interfaceSource))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def chanInput(self):
    return self.operation.operands[0]

  @builtins.property
  def interfaceSource(self):
    return self.operation.operands[1]

def unwrap_iface(chan_input, interface_source, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(UnwrapSVInterfaceOp(chanInput=chan_input, interfaceSource=interface_source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnwrapValidReadyOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.unwrap.vr"

  _ODS_REGIONS = (0, True)

  def __init__(self, rawOutput, valid, chanInput, ready, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(chanInput))
    operands.append(_get_op_result_or_value(ready))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(rawOutput)
    results.append(valid)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def chanInput(self):
    return self.operation.operands[0]

  @builtins.property
  def ready(self):
    return self.operation.operands[1]

  @builtins.property
  def rawOutput(self):
    return self.operation.results[0]

  @builtins.property
  def valid(self):
    return self.operation.results[1]

def unwrap_vr(raw_output, valid, chan_input, ready, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return _get_op_result_or_op_results(UnwrapValidReadyOp(rawOutput=raw_output, valid=valid, chanInput=chan_input, ready=ready, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnwrapWindow(_ods_ir.OpView):
  OPERATION_NAME = "esi.window.unwrap"

  _ODS_REGIONS = (0, True)

  def __init__(self, window, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(window))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def window(self):
    return self.operation.operands[0]

  @builtins.property
  def frame(self):
    return self.operation.results[0]

def window_unwrap(window, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UnwrapWindow(window=window, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class WrapFIFOOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.wrap.fifo"

  _ODS_REGIONS = (0, True)

  def __init__(self, chanOutput, rden, data, empty, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(data))
    operands.append(_get_op_result_or_value(empty))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(chanOutput)
    results.append(rden)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def data(self):
    return self.operation.operands[0]

  @builtins.property
  def empty(self):
    return self.operation.operands[1]

  @builtins.property
  def chanOutput(self):
    return self.operation.results[0]

  @builtins.property
  def rden(self):
    return self.operation.results[1]

def wrap_fifo(chan_output, rden, data, empty, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return _get_op_result_or_op_results(WrapFIFOOp(chanOutput=chan_output, rden=rden, data=data, empty=empty, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class WrapSVInterfaceOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.wrap.iface"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, interfaceSink, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(interfaceSink))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def interfaceSink(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def wrap_iface(output, interface_sink, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(WrapSVInterfaceOp(output=output, interfaceSink=interface_sink, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class WrapValidReadyOp(_ods_ir.OpView):
  OPERATION_NAME = "esi.wrap.vr"

  _ODS_REGIONS = (0, True)

  def __init__(self, chanOutput, ready, rawInput, valid, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(rawInput))
    operands.append(_get_op_result_or_value(valid))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(chanOutput)
    results.append(ready)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def rawInput(self):
    return self.operation.operands[0]

  @builtins.property
  def valid(self):
    return self.operation.operands[1]

  @builtins.property
  def chanOutput(self):
    return self.operation.results[0]

  @builtins.property
  def ready(self):
    return self.operation.results[1]

def wrap_vr(chan_output, ready, raw_input, valid, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return _get_op_result_or_op_results(WrapValidReadyOp(chanOutput=chan_output, ready=ready, rawInput=raw_input, valid=valid, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class WrapWindow(_ods_ir.OpView):
  OPERATION_NAME = "esi.window.wrap"

  _ODS_REGIONS = (0, True)

  def __init__(self, window, frame, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(frame))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(window)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def frame(self):
    return self.operation.operands[0]

  @builtins.property
  def window(self):
    return self.operation.results[0]

def window_wrap(window, frame, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(WrapWindow(window=window, frame=frame, loc=loc, ip=ip))
