"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.P6Namer = void 0;
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const lambdajs = require("@aws-cdk/aws-lambda-nodejs");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
const floyd = require("cdk-iam-floyd");
/**
 * @stability stable
 */
class P6Namer extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const policy = new floyd.Iam()
            .allow()
            .toCreateAccountAlias();
        // XXX: https://github.com/aws/aws-cdk/pull/11729
        const entry = fs.existsSync(path.join(__dirname, 'p6namer.p6namer.ts'))
            ? path.join(__dirname, 'p6namer.p6namer.ts') // local development
            : path.join(__dirname, 'p6namer.p6namer.js'); // when published in npm
        const onEvent = new lambdajs.NodejsFunction(this, 'p6namer', {
            entry,
            runtime: lambda.Runtime.NODEJS_12_X,
            timeout: cdk.Duration.seconds(2),
            tracing: lambda.Tracing.ACTIVE,
            bundling: {
                minify: true,
                externalModules: [
                    'aws-sdk',
                ],
            },
        });
        onEvent.addToRolePolicy(policy);
        const provider = new cr.Provider(this, 'P6Namer/Provider', {
            onEventHandler: onEvent,
        });
        new cdk.CustomResource(this, 'P6Namer/CR', {
            serviceToken: provider.serviceToken,
            properties: {
                AccountAlias: props.accountAlias,
            },
        });
    }
}
exports.P6Namer = P6Namer;
//# sourceMappingURL=data:application/json;base64,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