from kilojoule.units import Quantity
import numpy as np
from scipy.interpolate import interp1d


T_table = np.array([273.15, 275, 280, 285, 290, 295, 300, 305, 310,
        315, 320, 325, 330, 335, 340, 345, 350, 355,
        360, 365, 370, 373.15, 375, 380, 385, 390, 400,
        410, 420, 430, 440, 450, 460, 470, 480, 490,
        500, 510, 520, 530, 540, 550, 560, 570, 580,
        590, 600, 610, 620, 625, 630, 635, 640])
        
p_sat_table = np.array([0.00611, 0.00697, 0.00990, 0.01387, 0.01917, 0.02617,
        0.03531, 0.04712, 0.06221, 0.08132, 0.1053, 0.1351,
        0.1719, 0.2167, 0.2713, 0.3372, 0.4163, 0.5100,
        0.6209, 0.7514, 0.9040, 1.0133, 1.0815, 1.2869,
        1.5233, 1.794, 2.455, 3.302, 4.370, 5.699, 7.333,
        9.319, 11.71, 14.55, 17.90, 21.83, 26.40, 31.66,
        37.70, 44.58, 52.38, 61.19, 71.08, 82.16, 94.51,
        108.3, 123.5, 137.3, 159.1, 169.1, 179.7, 190.9,
        202.7])
p_sat_interp = interp1d(T_table, p_sat_table)
        
v_f_table = np.array([1.000, 1.000, 1.000, 1.000, 1.001, 1.002, 1.003,
        1.005, 1.007, 1.009, 1.011, 1.013, 1.016, 1.018,
        1.021, 1.024, 1.027, 1.030, 1.034, 1.038, 1.041,
        1.044, 1.045, 1.049, 1.053, 1.058, 1.067, 1.077,
        1.088, 1.099, 1.110, 1.123, 1.137, 1.152, 1.167,
        1.184, 1.203, 1.222, 1.244, 1.268, 1.294, 1.323,
        1.355, 1.392, 1.433, 1.482, 1.541, 1.612, 1.705,
        1.778, 1.856, 1.935, 2.075])*1e-3
v_f_interp = interp1d(T_table, v_f_table)
        
v_g_table = np.array([206.3, 181.7, 130.4, 99.4, 69.7, 51.94, 39.13,
        29.74, 22.93, 17.82, 13.98, 11.06, 8.82, 7.09,
        5.74, 4.683, 3.846, 3.180, 2.645, 2.212, 1.861,
        1.679, 1.574, 1.337, 1.142, 0.980, 0.731, 0.553,
        0.425, 0.331, 0.261, 0.208, 0.167, 0.136, 0.111,
        0.0922, 0.0766, 0.0631, 0.0525, 0.0445, 0.0375,
        0.0317, 0.0269, 0.0228, 0.0193, 0.0163, 0.0137,
        0.0115, 0.0094, 0.0085, 0.0075, 0.0066, 0.0057])
v_g_interp = interp1d(T_table, v_g_table)
        
h_fg_table = np.array([2502, 2497, 2485, 2473, 2461, 2449, 2438, 2426,
        2414, 2402, 2390, 2378, 2366, 2354, 2342, 2329,
        2317, 2304, 2291, 2278, 2265, 2257, 2252, 2239,
        2225, 2212, 2183, 2153, 2123, 2091, 2059, 2024,
        1989, 1951, 1912, 1870, 1825, 1779, 1730, 1679,
        1622, 1564, 1499, 1429, 1353, 1274, 1176, 1068,
        941, 858, 781, 683, 560])
h_fg_interp = interp1d(T_table, h_fg_table)        
        
c_p_f_table = np.array([4.217, 4.211, 4.198, 4.189, 4.184, 4.181, 4.179,
        4.178, 4.178, 4.179, 4.180, 4.182, 4.184, 4.186,
        4.188, 4.191, 4.195, 4.199, 4.203, 4.209, 4.214,
        4.217, 4.220, 4.226, 4.232, 4.239, 4.256, 4.278,
        4.302, 4.331, 4.36, 4.40, 4.44, 4.48, 4.53, 4.59,
        4.66, 4.74, 4.84, 4.95, 5.08, 5.24, 5.43, 5.68,
        6.00, 6.41, 7.00, 7.85, 9.35, 10.6, 12.6, 16.4,
        26])
c_p_f_interp = interp1d(T_table, c_p_f_table)        
        
c_p_g_table = np.array([1.854, 1.855, 1.858, 1.861, 1.864, 1.868, 1.872,
        1.877, 1.882, 1.888, 1.895, 1.903, 1.911, 1.920,
        1.930, 1.941, 1.954, 1.968, 1.983, 1.999, 2.017,
        2.029, 2.036, 2.057, 2.080, 2.104, 2.158, 2.221,
        2.291, 2.369, 2.46, 2.56, 2.68, 2.79, 2.94, 3.10,
        3.27, 3.47, 3.70, 3.96, 4.27, 4.64, 5.09, 5.67,
        6.40, 7.35, 8.75, 11.1, 15.4, 18.3, 22.1, 27.6,
        42])
c_p_g_interp = interp1d(T_table, c_p_g_table)        
        
mu_f_table = np.array([1750, 1652, 1422, 1225, 1080, 959, 855, 769,
        695, 631, 577, 528, 489, 453, 420, 389, 365,
        343, 324, 306, 289, 279, 274, 260, 248, 237,
        217, 200, 185, 173, 162, 152, 143, 136, 129,
        124, 118, 113, 108, 104, 101, 97, 94, 91, 88,
        84, 81, 77, 72, 70, 67, 64, 59])*1e-6
mu_f_interp = interp1d(T_table, mu_f_table)        
        
mu_g_table = np.array([8.02, 8.09, 8.29, 8.49, 8.69, 8.89, 9.09, 9.29,
        9.49, 9.69, 9.89, 10.09, 10.29, 10.49, 10.69,
        10.89, 11.09, 11.29, 11.49, 11.69, 11.89, 12.02,
        12.09, 12.29, 12.49, 12.69, 13.05, 13.42, 13.79,
        14.14, 14.50, 14.85, 15.19, 15.54, 15.88, 16.23,
        16.59, 16.95, 17.33, 17.72, 18.1, 18.6, 19.1,
        19.7, 20.4, 21.5, 22.7, 24.1, 25.9, 27.0, 28.0,
        30.0, 32.0])*1e-6
mu_g_interp = interp1d(T_table, mu_g_table)
        
k_f_table = np.array([569, 574, 582, 590, 598, 606, 613, 620, 628,
        634, 640, 645, 650, 656, 660, 664, 668, 671,
        674, 677, 679, 680, 681, 683, 685, 686, 688,
        688, 688, 685, 682, 678, 673, 667, 660, 651,
        642, 631, 621, 608, 594, 580, 563, 548, 528,
        513, 497, 467, 444, 430, 412, 392, 367])*1e-3
k_f_interp = interp1d(T_table, k_f_table)
        
k_g_table = np.array([18.2, 18.3, 18.6, 18.9, 19.3, 19.5, 19.6, 20.1,
        20.4, 20.7, 21.0, 21.3, 21.7, 22.0, 22.3, 22.6,
        23.0, 23.3, 23.7, 24.1, 24.5, 24.8, 24.9, 25.4,
        25.8, 26.3, 27.2, 28.2, 29.8, 30.4, 31.7, 33.1,
        34.6, 36.3, 38.1, 40.1, 42.3, 44.7, 47.5, 50.6,
        54.0, 58.3, 63.7, 76.7, 76.7, 84.1, 92.9, 103,
        114, 121, 130, 141, 155])*1e-3
k_g_interp = interp1d(T_table, k_g_table)
        
Pr_f_table = np.array([12.99, 12.22, 10.26, 8.81, 7.56, 6.62, 5.83,
        5.20, 4.62, 4.16, 3.77, 3.42, 3.15, 2.88, 2.66,
        2.45, 2.29, 2.14, 2.02, 1.91, 1.80, 1.76, 1.70,
        1.61, 1.53, 1.47, 1.34, 1.24, 1.16, 1.09, 1.04,
        0.99, 0.95, 0.92, 0.89, 0.87, 0.86, 0.85, 0.84,
        0.85, 0.86, 0.87, 0.90, 0.94, 0.99, 1.05, 1.14,
        1.30, 1.52, 1.65, 2.0, 2.7, 4.2])
Pr_f_interp = interp1d(T_table, Pr_f_table)
        
Pr_g_table = np.array([0.815, 0.817, 0.825, 0.833, 0.841, 0.849, 0.857,
        0.865, 0.873, 0.883, 0.894, 0.901, 0.908, 0.916,
        0.925, 0.933, 0.942, 0.951, 0.960, 0.969, 0.978,
        0.984, 0.987, 0.999, 1.004, 1.013, 1.033, 1.054,
        1.075, 1.10, 1.12, 1.14, 1.17, 1.20, 1.23, 1.25,
        1.28, 1.31, 1.35, 1.39, 1.43, 1.47, 1.52, 1.59,
        1.68, 1.84, 2.15, 2.60, 3.46, 4.20, 4.8, 6.0,
        9.6])
Pr_g_interp = interp1d(T_table, Pr_g_table)        
       
sigma_f_table = np.array([75.5, 75.3, 74.8, 74.3, 73.7, 72.7, 71.7, 70.9,
        70.0, 69.2, 68.3, 67.5, 66.6, 65.8, 64.9, 64.1,
        63.2, 62.3, 61.4, 60.5, 59.5, 58.9, 58.6, 57.6,
        56.6, 55.6, 53.6, 51.5, 49.4, 47.2, 45.1, 42.9,
        40.7, 38.5, 36.2, 33.9, 31.6, 29.3, 26.9, 24.5,
        22.1, 19.7, 17.3, 15.0, 12.8, 10.5, 8.4, 6.3,
        4.5, 3.5, 2.6, 1.5, 0.8])*1e-3
sigma_f_interp = interp1d(T_table, sigma_f_table)        
        
def p_sat(T):
    T = T.to('K')
    ret_value = Quantity(p_sat_interp(T.magnitude), 'bar')
    return ret_value
    
def v_f(T):
    T = T.to('K')
    ret_value = Quantity(v_f_interp(T.magnitude), 'm^3/kg')
    return ret_value  
    
def v_g(T):
    T = T.to('K')
    ret_value = Quantity(v_g_interp(T.magnitude), 'm^3/kg')
    return ret_value

def h_fg(T):
    T = T.to('K')
    ret_value = Quantity(h_fg_interp(T.magnitude), 'kJ/kg')
    return ret_value      

def cp_f(T):
    T = T.to('K')
    ret_value = Quantity(c_p_f_interp(T.magnitude), 'kJ/kg/K')
    return ret_value  
c_p_f = cp_f

def cp_g(T):
    T = T.to('K')
    ret_value = Quantity(c_p_g_interp(T.magnitude), 'kJ/kg/K')
    return ret_value 
c_p_g = cp_g
    
def mu_f(T):
    T = T.to('K')
    ret_value = Quantity(mu_f_interp(T.magnitude), 'N*s/m^2')
    return ret_value
    
def mu_g(T):
    T = T.to('K')
    ret_value = Quantity(mu_g_interp(T.magnitude), 'N*s/m^2')
    return ret_value
    
def k_f(T):
    T = T.to('K')
    ret_value = Quantity(k_f_interp(T.magnitude), 'W/m/K')
    return ret_value     

def k_g(T):
    T = T.to('K')
    ret_value = Quantity(k_g_interp(T.magnitude), 'W/m/K')
    return ret_value
    
def Pr_f(T):
    T = T.to('K')
    ret_value = Quantity(Pr_f_interp(T.magnitude), '')
    return ret_value

def Pr_g(T):
    T = T.to('K')
    ret_value = Quantity(Pr_g_interp(T.magnitude), '')
    return ret_value

def sigma_f(T):
    T = T.to('K')
    ret_value = Quantity(sigma_f_interp(T.magnitude), 'N/m')
    return ret_value