import * as ecr from '@aws-cdk/aws-ecr';
import { FileFingerprintOptions } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { FingerprintOptions, IAsset } from '@aws-cdk/assets';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Options for DockerImageAsset.
 *
 * @stability stable
 */
export interface DockerImageAssetOptions extends FingerprintOptions, FileFingerprintOptions {
    /**
     * (deprecated) ECR repository name.
     *
     * Specify this property if you need to statically address the image, e.g.
     * from a Kubernetes Pod. Note, this is only the repository name, without the
     * registry and the tag parts.
     *
     * @default - the default ECR repository for CDK assets
     * @deprecated to control the location of docker image assets, please override
     * `Stack.addDockerImageAsset`. this feature will be removed in future
     * releases.
     */
    readonly repositoryName?: string;
    /**
     * Build args to pass to the `docker build` command.
     *
     * Since Docker build arguments are resolved before deployment, keys and
     * values cannot refer to unresolved tokens (such as `lambda.functionArn` or
     * `queue.queueUrl`).
     *
     * @default - no build args are passed
     * @stability stable
     */
    readonly buildArgs?: {
        [key: string]: string;
    };
    /**
     * Docker target to build to.
     *
     * @default - no target
     * @stability stable
     */
    readonly target?: string;
    /**
     * Path to the Dockerfile (relative to the directory).
     *
     * @default 'Dockerfile'
     * @stability stable
     */
    readonly file?: string;
}
/**
 * Props for DockerImageAssets.
 *
 * @stability stable
 */
export interface DockerImageAssetProps extends DockerImageAssetOptions {
    /**
     * The directory where the Dockerfile is stored.
     *
     * @stability stable
     */
    readonly directory: string;
}
/**
 * An asset that represents a Docker image.
 *
 * The image will be created in build time and uploaded to an ECR repository.
 *
 * @stability stable
 */
export declare class DockerImageAsset extends CoreConstruct implements IAsset {
    /**
     * The full URI of the image (including a tag).
     *
     * Use this reference to pull
     * the asset.
     *
     * @stability stable
     */
    imageUri: string;
    /**
     * Repository where the image is stored.
     *
     * @stability stable
     */
    repository: ecr.IRepository;
    /**
     * (deprecated) A hash of the source of this asset, which is available at construction time.
     *
     * As this is a plain
     * string, it can be used in construct IDs in order to enforce creation of a new resource when
     * the content hash has changed.
     *
     * @deprecated use assetHash
     */
    readonly sourceHash: string;
    /**
     * A hash of this asset, which is available at construction time.
     *
     * As this is a plain string, it
     * can be used in construct IDs in order to enforce creation of a new resource when the content
     * hash has changed.
     *
     * @stability stable
     */
    readonly assetHash: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DockerImageAssetProps);
}
