"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.MetricsLevel = exports.LogLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Available log levels for Flink applications.
 */
var LogLevel;
(function (LogLevel) {
    /** Debug level logging */
    LogLevel["DEBUG"] = "DEBUG";
    /** Info level logging */
    LogLevel["INFO"] = "INFO";
    /** Warn level logging */
    LogLevel["WARN"] = "WARN";
    /** Error level logging */
    LogLevel["ERROR"] = "ERROR";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
/**
 * Granularity of metrics sent to CloudWatch.
 */
var MetricsLevel;
(function (MetricsLevel) {
    /** Application sends the least metrics to CloudWatch */
    MetricsLevel["APPLICATION"] = "APPLICATION";
    /** Task includes task-level metrics sent to CloudWatch */
    MetricsLevel["TASK"] = "TASK";
    /** Operator includes task-level and operator-level metrics sent to CloudWatch */
    MetricsLevel["OPERATOR"] = "OPERATOR";
    /** Send all metrics including metrics per task thread */
    MetricsLevel["PARALLELISM"] = "PARALLELISM";
})(MetricsLevel = exports.MetricsLevel || (exports.MetricsLevel = {}));
/**
 * Available Flink runtimes for Kinesis Analytics.
 */
class Runtime {
    constructor(value) {
        this.value = value;
    }
    /** Create a new Runtime with with an arbitrary Flink version string */
    static of(value) {
        return new Runtime(value);
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-kinesisanalytics-flink-alpha.Runtime", version: "2.23.0-alpha.0" };
/** Flink Version 1.6 */
Runtime.FLINK_1_6 = Runtime.of('FLINK-1_6');
/** Flink Version 1.8 */
Runtime.FLINK_1_8 = Runtime.of('FLINK-1_8');
/** Flink Version 1.11 */
Runtime.FLINK_1_11 = Runtime.of('FLINK-1_11');
/** Flink Version 1.13 */
Runtime.FLINK_1_13 = Runtime.of('FLINK-1_13');
//# sourceMappingURL=data:application/json;base64,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