SPELL_DICT_LENGTH = 2
SPELL_DICT = {
    "à": ["à", "af"],
    "ả": ["ả", "ar"],
    "ã": ["ã", "ax"],
    "á": ["á", "as"],
    "ạ": ["ạ", "aj"],
    "ă": ["ă", "aw"],
    "ắ": ["ắ", "aws"],
    "ặ": ["ặ", "awj"],
    "ằ": ["ằ", "awf"],
    "ẳ": ["ẳ", "awr"],
    "ẵ": ["ẵ", "awx"],
    "â": ["â", "aa"],
    "ầ": ["ầ", "aaf"],
    "ẩ": ["ẩ", "aar"],
    "ẫ": ["ẫ", "aax"],
    "ấ": ["ấ", "aas"],
    "ậ": ["ậ", "aaj"],
    "è": ["è", "ef"],
    "ẻ": ["ẻ", "er"],
    "ẽ": ["ẽ", "ex"],
    "é": ["é", "es"],
    "ẹ": ["ẹ", "ej"],
    "ê": ["ê", "ee"],
    "ề": ["ề", "eef"],
    "ể": ["ể", "eer"],
    "ễ": ["ễ", "eex"],
    "ế": ["ế", "ees"],
    "ệ": ["ệ", "eej"],
    "ì": ["ì", "if"],
    "ỉ": ["ỉ", "ir"],
    "ĩ": ["ĩ", "ix"],
    "í": ["í", "is"],
    "ị": ["ị", "ij"],
    "ò": ["ò", "of"],
    "ỏ": ["ỏ", "or"],
    "õ": ["õ", "ox"],
    "ó": ["ó", "os"],
    "ọ": ["ọ", "oj"],
    "ô": ["ô", "oo"],
    "ồ": ["ồ", "oof"],
    "ổ": ["ổ", "oor"],
    "ỗ": ["ỗ", "oox"],
    "ố": ["ố", "oos"],
    "ộ": ["ộ", "ooj"],
    "ơ": ["ơ", "ow"],
    "ờ": ["ờ", "owf"],
    "ở": ["ở", "owr"],
    "ỡ": ["ỡ", "owx"],
    "ớ": ["ớ", "ows"],
    "ợ": ["ợ", "owj"],
    "ù": ["ù", "uf"],
    "ủ": ["ủ", "ur"],
    "ũ": ["ũ", "ux"],
    "ú": ["ú", "us"],
    "ụ": ["ụ", "uj"],
    "ư": ["ư", "uw"],
    "ừ": ["ừ", "uwf"],
    "ử": ["ử", "uwr"],
    "ữ": ["ữ", "uwx"],
    "ứ": ["ứ", "uws"],
    "ự": ["ự", "uwj"],
    "ỳ": ["ỳ", "yf"],
    "ỷ": ["ỷ", "yr"],
    "ỹ": ["ỹ", "yx"],
    "ý": ["ý", "ys"],
    "ỵ": ["ỵ", "yj"],
    "đ": ["đ", "dd"]
}

STANDARD_WORDS = ['Hà Nội', 'Ba Đình', 'Phúc Xá', 'Trúc Bạch', 'Vĩnh Phúc', 'Cống Vị', 'Liễu Giai', 'Nguyễn Trung Trực',
                  'Quán Thánh', 'Ngọc Hà', 'Điện Biên', 'Đội Cấn', 'Ngọc Khánh', 'Kim Mã', 'Giảng Võ', 'Thành Công',
                  'Hoàn Kiếm', 'Phúc Tân', 'Đồng Xuân', 'Hàng Mã', 'Hàng Buồm', 'Hàng Đào', 'Hàng Bồ', 'Cửa Đông',
                  'Lý Thái Tổ', 'Hàng Bạc', 'Hàng Gai', 'Chương Dương', 'Hàng Trống', 'Cửa Nam', 'Hàng Bông',
                  'Tràng Tiền', 'Trần Hưng Đạo', 'Phan Chu Trinh', 'Hàng Bài', 'Tây Hồ', 'Phú Thượng', 'Nhật Tân',
                  'Tứ Liên', 'Quảng An', 'Xuân La', 'Yên Phụ', 'Bưởi', 'Thụy Khuê', 'Long Biên', 'Thượng Thanh',
                  'Ngọc Thụy', 'Giang Biên', 'Đức Giang', 'Việt Hưng', 'Gia Thụy', 'Ngọc Lâm', 'Phúc Lợi', 'Bồ Đề',
                  'Sài Đồng', 'Thạch Bàn', 'Phúc Đồng', 'Cự Khối', 'Cầu Giấy', 'Nghĩa Đô', 'Nghĩa Tân', 'Mai Dịch',
                  'Dịch Vọng', 'Dịch Vọng Hậu', 'Quan Hoa', 'Yên Hoà', 'Trung Hoà', 'Đống Đa', 'Cát Linh', 'Văn Miếu',
                  'Quốc Tử Giám', 'Láng Thượng', 'Ô Chợ Dừa', 'Văn Chương', 'Hàng Bột', 'Láng Hạ', 'Khâm Thiên',
                  'Thổ Quan', 'Nam Đồng', 'Trung Phụng', 'Quang Trung', 'Trung Liệt', 'Phương Liên', 'Thịnh Quang',
                  'Trung Tự', 'Kim Liên', 'Phương Mai', 'Ngã Tư Sở', 'Khương Thượng', 'Hai Bà Trưng', 'Nguyễn Du',
                  'Bạch Đằng', 'Phạm Đình Hổ', 'Lê Đại Hành', 'Đồng Nhân', 'Phố Huế', 'Đống Mác', 'Thanh Lương',
                  'Thanh Nhàn', 'Cầu Dền', 'Bách Khoa', 'Đồng Tâm', 'Vĩnh Tuy', 'Bạch Mai', 'Quỳnh Mai', 'Quỳnh Lôi',
                  'Minh Khai', 'Trương Định', 'Hoàng Mai', 'Thanh Trì', 'Vĩnh Hưng', 'Định Công', 'Mai Động',
                  'Tương Mai', 'Đại Kim', 'Tân Mai', 'Hoàng Văn Thụ', 'Giáp Bát', 'Lĩnh Nam', 'Thịnh Liệt', 'Trần Phú',
                  'Hoàng Liệt', 'Yên Sở', 'Thanh Xuân', 'Nhân Chính', 'Thượng Đình', 'Khương Trung', 'Khương Mai',
                  'Thanh Xuân Trung', 'Phương Liệt', 'Hạ Đình', 'Khương Đình', 'Thanh Xuân Bắc', 'Thanh Xuân Nam',
                  'Kim Giang', 'Sóc Sơn', 'Bắc Sơn', 'Minh Trí', 'Hồng Kỳ', 'Nam Sơn', 'Trung Giã', 'Tân Hưng',
                  'Minh Phú', 'Phù Linh', 'Bắc Phú', 'Tân Minh', 'Quang Tiến', 'Hiền Ninh', 'Tân Dân', 'Tiên Dược',
                  'Việt Long', 'Xuân Giang', 'Mai Đình', 'Đức Hoà', 'Đông Xuân', 'Kim Lũ', 'Phú Cường', 'Phú Minh',
                  'Phù Lỗ', 'Xuân Thu', 'Đông Anh', 'Xuân Nộn', 'Thuỵ Lâm', 'Bắc Hồng', 'Nguyên Khê', 'Nam Hồng',
                  'Tiên Dương', 'Vân Hà', 'Uy Nỗ', 'Vân Nội', 'Liên Hà', 'Việt Hùng', 'Kim Nỗ', 'Kim Chung', 'Dục Tú',
                  'Đại Mạch', 'Vĩnh Ngọc', 'Cổ Loa', 'Hải Bối', 'Xuân Canh', 'Võng La', 'Tàm Xá', 'Mai Lâm', 'Đông Hội',
                  'Gia Lâm', 'Yên Viên', 'Yên Thường', 'Ninh Hiệp', 'Đình Xuyên', 'Dương Hà', 'Phù Đổng', 'Trung Mầu',
                  'Lệ Chi', 'Cổ Bi', 'Đặng Xá', 'Phú Thị', 'Kim Sơn', 'Trâu Quỳ', 'Dương Quang', 'Dương Xá', 'Đông Dư',
                  'Đa Tốn', 'Kiêu Kỵ', 'Bát Tràng', 'Kim Lan', 'Văn Đức', 'Nam Từ Liêm', 'Cầu Diễn', 'Xuân Phương',
                  'Phương Canh', 'Mỹ Đình 1', 'Mỹ Đình 2', 'Tây Mỗ', 'Mễ Trì', 'Phú Đô', 'Đại Mỗ', 'Trung Văn',
                  'Văn Điển', 'Tân Triều', 'Thanh Liệt', 'Tả Thanh Oai', 'Hữu Hoà', 'Tam Hiệp', 'Tứ Hiệp', 'Yên Mỹ',
                  'Vĩnh Quỳnh', 'Ngũ Hiệp', 'Duyên Hà', 'Ngọc Hồi', 'Vạn Phúc', 'Đại áng', 'Liên Ninh', 'Đông Mỹ',
                  'Bắc Từ Liêm', 'Thượng Cát', 'Liên Mạc', 'Đông Ngạc', 'Đức Thắng', 'Thụy Phương', 'Tây Tựu',
                  'Xuân Đỉnh', 'Xuân Tảo', 'Cổ Nhuế 1', 'Cổ Nhuế 2', 'Phú Diễn', 'Phúc Diễn', 'Mê Linh', 'Chi Đông',
                  'Đại Thịnh', 'Kim Hoa', 'Thạch Đà', 'Tiến Thắng', 'Tự Lập', 'Quang Minh', 'Thanh Lâm', 'Tam Đồng',
                  'Vạn Yên', 'Chu Phan', 'Tiến Thịnh', 'Văn Khê', 'Hoàng Kim', 'Tiền Phong', 'Tráng Việt', 'Hà Đông',
                  'Nguyễn Trãi', 'Mộ Lao', 'Văn Quán', 'Yết Kiêu', 'La Khê', 'Phú La', 'Phúc La', 'Hà Cầu', 'Yên Nghĩa',
                  'Kiến Hưng', 'Phú Lãm', 'Phú Lương', 'Dương Nội', 'Đồng Mai', 'Biên Giang', 'Sơn Tây', 'Lê Lợi',
                  'Phú Thịnh', 'Ngô Quyền', 'Sơn Lộc', 'Xuân Khanh', 'Đường Lâm', 'Viên Sơn', 'Xuân Sơn', 'Trung Hưng',
                  'Thanh Mỹ', 'Trung Sơn Trầm', 'Sơn Đông', 'Cổ Đông', 'Ba Vì', 'Tây Đằng', 'Cổ Đô', 'Tản Hồng',
                  'Vạn Thắng', 'Châu Sơn', 'Phong Vân', 'Phú Đông', 'Phú Phương', 'Phú Châu', 'Thái Hòa', 'Đồng Thái',
                  'Phú Sơn', 'Minh Châu', 'Vật Lại', 'Chu Minh', 'Tòng Bạt', 'Cẩm Lĩnh', 'Sơn Đà', 'Đông Quang',
                  'Tiên Phong', 'Thụy An', 'Cam Thượng', 'Thuần Mỹ', 'Tản Lĩnh', 'Ba Trại', 'Minh Quang', 'Vân Hòa',
                  'Yên Bài', 'Khánh Thượng', 'Phúc Thọ', 'Vân Phúc', 'Vân Nam', 'Xuân Đình', 'Sen Phương', 'Võng Xuyên',
                  'Thọ Lộc', 'Long Xuyên', 'Thượng Cốc', 'Hát Môn', 'Tích Giang', 'Thanh Đa', 'Trạch Mỹ Lộc',
                  'Phúc Hòa', 'Ngọc Tảo', 'Phụng Thượng', 'Tam Thuấn', 'Hiệp Thuận', 'Liên Hiệp', 'Đan Phượng', 'Phùng',
                  'Trung Châu', 'Thọ An', 'Thọ Xuân', 'Hồng Hà', 'Liên Hồng', 'Hạ Mỗ', 'Liên Trung', 'Phương Đình',
                  'Thượng Mỗ', 'Tân Hội', 'Tân Lập', 'Đồng Tháp', 'Song Phượng', 'Hoài Đức', 'Trạm Trôi', 'Đức Thượng',
                  'Dương Liễu', 'Di Trạch', 'Cát Quế', 'Sơn Đồng', 'Vân Canh', 'Đắc Sở', 'Lại Yên', 'Tiền Yên',
                  'Song Phương', 'An Khánh', 'An Thượng', 'Vân Côn', 'La Phù', 'Đông La', 'Quốc Oai', 'Sài Sơn',
                  'Phượng Cách', 'Yên Sơn', 'Ngọc Liệp', 'Ngọc Mỹ', 'Liệp Tuyết', 'Thạch Thán', 'Đồng Quang', 'Phú Cát',
                  'Tuyết Nghĩa', 'Nghĩa Hương', 'Cộng Hòa', 'Tân Phú', 'Đại Thành', 'Phú Mãn', 'Cấn Hữu', 'Tân Hòa',
                  'Hòa Thạch', 'Đông Yên', 'Thạch Thất', 'Yên Trung', 'Yên Bình', 'Tiến Xuân', 'Liên Quan', 'Đại Đồng',
                  'Cẩm Yên', 'Lại Thượng', 'Phú Kim', 'Hương Ngải', 'Canh Nậu', 'Kim Quan', 'Dị Nậu', 'Bình Yên',
                  'Chàng Sơn', 'Thạch Hoà', 'Cần Kiệm', 'Hữu Bằng', 'Phùng Xá', 'Tân Xã', 'Thạch Xá', 'Bình Phú',
                  'Hạ Bằng', 'Đồng Trúc', 'Chương Mỹ', 'Chúc Sơn', 'Xuân Mai', 'Phụng Châu', 'Tiên Phương', 'Đông Sơn',
                  'Đông Phương Yên', 'Phú Nghĩa', 'Trường Yên', 'Ngọc Hòa', 'Thủy Xuân Tiên', 'Thanh Bình', 'Trung Hòa',
                  'Đại Yên', 'Thụy Hương', 'Tốt Động', 'Lam Điền', 'Tân Tiến', 'Nam Phương Tiến', 'Hợp Đồng',
                  'Hoàng Diệu', 'Hữu Văn', 'Quảng Bị', 'Mỹ Lương', 'Thượng Vực', 'Hồng Phong', 'Đồng Phú', 'Văn Võ',
                  'Đồng Lạc', 'Hòa Chính', 'Phú Nam An', 'Thanh Oai', 'Kim Bài', 'Cự Khê', 'Bích Hòa', 'Mỹ Hưng',
                  'Cao Viên', 'Bình Minh', 'Tam Hưng', 'Thanh Cao', 'Thanh Thùy', 'Thanh Mai', 'Thanh Văn', 'Đỗ Động',
                  'Kim An', 'Kim Thư', 'Phương Trung', 'Tân Ước', 'Dân Hòa', 'Liên Châu', 'Cao Dương', 'Xuân Dương',
                  'Hồng Dương', 'Thường Tín', 'Ninh Sở', 'Nhị Khê', 'Duyên Thái', 'Khánh Hà', 'Hòa Bình', 'Văn Bình',
                  'Hiền Giang', 'Hồng Vân', 'Vân Tảo', 'Liên Phương', 'Văn Phú', 'Tự Nhiên', 'Hà Hồi', 'Thư Phú',
                  'Quất Động', 'Thắng Lợi', 'Dũng Tiến', 'Thống Nhất', 'Nghiêm Xuyên', 'Tô Hiệu', 'Văn Tự', 'Vạn Điểm',
                  'Minh Cường', 'Phú Xuyên', 'Hồng Minh', 'Phượng Dực', 'Nam Tiến', 'Tri Trung', 'Đại Thắng', 'Phú Túc',
                  'Văn Hoàng', 'Hồng Thái', 'Hoàng Long', 'Nam Phong', 'Nam Triều', 'Sơn Hà', 'Chuyên Mỹ', 'Khai Thái',
                  'Phúc Tiến', 'Vân Từ', 'Tri Thủy', 'Đại Xuyên', 'Phú Yên', 'Bạch Hạ', 'Quang Lãng', 'Châu Can',
                  'Minh Tân', 'Ứng Hòa', 'Vân Đình', 'Viên An', 'Viên Nội', 'Hoa Sơn', 'Quảng Phú Cầu', 'Trường Thịnh',
                  'Cao Thành', 'Liên Bạt', 'Sơn Công', 'Đồng Tiến', 'Phương Tú', 'Trung Tú', 'Đồng Tân',
                  'Tảo Dương Văn', 'Vạn Thái', 'Minh Đức', 'Hòa Lâm', 'Hòa Xá', 'Trầm Lộng', 'Kim Đường', 'Hòa Nam',
                  'Hòa Phú', 'Đội Bình', 'Đại Hùng', 'Đông Lỗ', 'Phù Lưu', 'Đại Cường', 'Lưu Hoàng', 'Hồng Quang',
                  'Mỹ Đức', 'Đại Nghĩa', 'Thượng Lâm', 'Tuy Lai', 'Phúc Lâm', 'Mỹ Thành', 'Bột Xuyên', 'An Mỹ',
                  'Hồng Sơn', 'Lê Thanh', 'Xuy Xá', 'Phù Lưu Tế', 'Đại Hưng', 'Vạn Kim', 'Đốc Tín', 'Hương Sơn',
                  'Hùng Tiến', 'An Tiến', 'Hợp Tiến', 'Hợp Thanh', 'An Phú', 'Hà Giang', 'Ngọc Đường', 'Phương Độ',
                  'Phương Thiện', 'Đồng Văn', 'Phó Bảng', 'Lũng Cú', 'Má Lé', 'Lũng Táo', 'Phố Là', 'Thài Phìn Tủng',
                  'Sủng Là', 'Xà Phìn', 'Tả Phìn', 'Tả Lủng', 'Phố Cáo', 'Sính Lủng', 'Sảng Tủng', 'Lũng Thầu',
                  'Hố Quáng Phìn', 'Vần Chải', 'Lũng Phìn', 'Sủng Trái', 'Mèo Vạc', 'Thượng Phùng', 'Pải Lủng',
                  'Xín Cái', 'Pả Vi', 'Giàng Chu Phìn', 'Sủng Trà', 'Sủng Máng', 'Sơn Vĩ', 'Cán Chu Phìn', 'Lũng Pù',
                  'Lũng Chinh', 'Tát Ngà', 'Nậm Ban', 'Khâu Vai', 'Niêm Tòng', 'Niêm Sơn', 'Yên Minh', 'Thắng Mố',
                  'Phú Lũng', 'Sủng Tráng', 'Bạch Đích', 'Na Khê', 'Sủng Thài', 'Hữu Vinh', 'Lao Và Chải', 'Mậu Duệ',
                  'Đông Minh', 'Mậu Long', 'Ngam La', 'Ngọc Long', 'Đường Thượng', 'Lũng Hồ', 'Du Tiến', 'Du Già',
                  'Quản Bạ', 'Tam Sơn', 'Bát Đại Sơn', 'Nghĩa Thuận', 'Cán Tỷ', 'Cao Mã Pờ', 'Thanh Vân', 'Tùng Vài',
                  'Đông Hà', 'Lùng Tám', 'Quyết Tiến', 'Tả Ván', 'Thái An', 'Vị Xuyên', 'Kim Thạch', 'Phú Linh',
                  'Kim Linh', 'Nông Trường Việt Lâm', 'Thuận Hoà', 'Tùng Bá', 'Thanh Thủy', 'Thanh Đức', 'Phong Quang',
                  'Xín Chải', 'Phương Tiến', 'Lao Chải', 'Cao Bồ', 'Đạo Đức', 'Thượng Sơn', 'Linh Hồ', 'Quảng Ngần',
                  'Việt Lâm', 'Ngọc Linh', 'Ngọc Minh', 'Bạch Ngọc', 'Trung Thành', 'Bắc Mê', 'Minh Sơn', 'Giáp Trung',
                  'Yên Định', 'Yên Phú', 'Minh Ngọc', 'Yên Phong', 'Lạc Nông', 'Phú Nam', 'Yên Cường', 'Thượng Tân',
                  'Đường Âm', 'Đường Hồng', 'Phiêng Luông', 'Hoàng Su Phì', 'Vinh Quang', 'Bản Máy', 'Thàng Tín',
                  'Thèn Chu Phìn', 'Pố Lồ', 'Bản Phùng', 'Túng Sán', 'Chiến Phố', 'Đản Ván', 'Tụ Nhân', 'Nàng Đôn',
                  'Pờ Ly Ngài', 'Sán Xả Hồ', 'Bản Luốc', 'Ngàm Đăng Vài', 'Bản Nhùng', 'Tả Sử Choóng', 'Nậm Dịch',
                  'Hồ Thầu', 'Nậm Tỵ', 'Thông Nguyên', 'Nậm Khòa', 'Xín Mần', 'Cốc Pài', 'Nàn Xỉn', 'Bản Díu', 'Chí Cà',
                  'Thèn Phàng', 'Trung Thịnh', 'Pà Vầy Sủ', 'Cốc Rế', 'Thu Tà', 'Nàn Ma', 'Tả Nhìu', 'Bản Ngò',
                  'Chế Là', 'Nấm Dẩn', 'Quảng Nguyên', 'Nà Chì', 'Khuôn Lùng', 'Bắc Quang', 'Việt Quang', 'Tân Thành',
                  'Tân Quang', 'Thượng Bình', 'Hữu Sản', 'Kim Ngọc', 'Việt Vinh', 'Bằng Hành', 'Vô Điếm', 'Việt Hồng',
                  'Hùng An', 'Đức Xuân', 'Tiên Kiều', 'Vĩnh Hảo', 'Đồng Yên', 'Đông Thành', 'Quang Bình', 'Xuân Minh',
                  'Tiên Nguyên', 'Tân Nam', 'Bản Rịa', 'Yên Thành', 'Tân Trịnh', 'Tân Bắc', 'Bằng Lang', 'Yên Hà',
                  'Nà Khương', 'Tiên Yên', 'Vĩ Thượng', 'Cao Bằng', 'Sông Hiến', 'Sông Bằng', 'Hợp Giang', 'Tân Giang',
                  'Ngọc Xuân', 'Đề Thám', 'Hoà Chung', 'Duyệt Trung', 'Vĩnh Quang', 'Hưng Đạo', 'Chu Trinh', 'Bảo Lâm',
                  'Pác Miầu', 'Đức Hạnh', 'Lý Bôn', 'Nam Cao', 'Nam Quang', 'Quảng Lâm', 'Thạch Lâm', 'Vĩnh Phong',
                  'Mông Ân', 'Thái Học', 'Thái Sơn', 'Yên Thổ', 'Bảo Lạc', 'Cốc Pàng', 'Thượng Hà', 'Cô Ba', 'Bảo Toàn',
                  'Khánh Xuân', 'Xuân Trường', 'Hồng Trị', 'Kim Cúc', 'Phan Thanh', 'Hồng An', 'Hưng Thịnh', 'Huy Giáp',
                  'Đình Phùng', 'Sơn Lập', 'Sơn Lộ', 'Hà Quảng', 'Thông Nông', 'Cần Yên', 'Cần Nông', 'Lương Thông',
                  'Đa Thông', 'Ngọc Động', 'Lương Can', 'Thanh Long', 'Xuân Hòa', 'Lũng Nặm', 'Trường Hà', 'Cải Viên',
                  'Nội Thôn', 'Tổng Cọt', 'Sóc Hà', 'Thượng Thôn', 'Hồng Sỹ', 'Quý Quân', 'Mã Ba', 'Ngọc Đào',
                  'Trùng Khánh', 'Trà Lĩnh', 'Tri Phương', 'Quang Hán', 'Xuân Nội', 'Quang Vinh', 'Cao Chương',
                  'Ngọc Khê', 'Ngọc Côn', 'Phong Nậm', 'Đình Phong', 'Đàm Thuỷ', 'Khâm Thành', 'Chí Viễn', 'Lăng Hiếu',
                  'Phong Châu', 'Trung Phúc', 'Cao Thăng', 'Đức Hồng', 'Đoài Dương', 'Hạ Lang', 'Minh Long', 'Lý Quốc',
                  'Đồng Loan', 'Đức Quang', 'Kim Loan', 'Quang Long', 'An Lạc', 'Thanh Nhật', 'Vinh Quý', 'Cô Ngân',
                  'Thị Hoa', 'Quảng Hòa', 'Quốc Toản', 'Quảng Uyên', 'Phi Hải', 'Quảng Hưng', 'Độc Lập', 'Cai Bộ',
                  'Phúc Sen', 'Chí Thảo', 'Tự Do', 'Hạnh Phúc', 'Tà Lùng', 'Bế Văn Đàn', 'Cách Linh', 'Đại Sơn',
                  'Tiên Thành', 'Hoà Thuận', 'Hoà An', 'Nước Hai', 'Dân Chủ', 'Nam Tuấn', 'Đại Tiến', 'Đức Long',
                  'Ngũ Lão', 'Trương Lương', 'Hồng Việt', 'Hoàng Tung', 'Nguyễn Huệ', 'Bình Dương', 'Lê Chung',
                  'Hồng Nam', 'Nguyên Bình', 'Tĩnh Túc', 'Yên Lạc', 'Triệu Nguyên', 'Ca Thành', 'Vũ Nông', 'Minh Tâm',
                  'Thể Dục', 'Mai Long', 'Vũ Minh', 'Hoa Thám', 'Quang Thành', 'Tam Kim', 'Thịnh Vượng', 'Thạch An',
                  'Đông Khê', 'Canh Tân', 'Kim Đồng', 'Đức Thông', 'Thái Cường', 'Vân Trình', 'Thụy Hùng',
                  'Quang Trọng', 'Trọng Con', 'Lê Lai', 'Bắc Kạn', 'Nguyễn Thị Minh Khai', 'Sông Cầu', 'Phùng Chí Kiên',
                  'Huyền Tụng', 'Nông Thượng', 'Xuất Hóa', 'Pác Nặm', 'Bằng Thành', 'Nhạn Môn', 'Bộc Bố', 'Công Bằng',
                  'Giáo Hiệu', 'An Thắng', 'Cổ Linh', 'Nghiên Loan', 'Cao Tân', 'Ba Bể', 'Chợ Rã', 'Bành Trạch',
                  'Phúc Lộc', 'Hà Hiệu', 'Cao Thượng', 'Khang Ninh', 'Nam Mẫu', 'Thượng Giáo', 'Địa Linh', 'Yến Dương',
                  'Chu Hương', 'Quảng Khê', 'Mỹ Phương', 'Hoàng Trĩ', 'Đồng Phúc', 'Ngân Sơn', 'Nà Phặc', 'Thượng Ân',
                  'Bằng Vân', 'Cốc Đán', 'Đức Vân', 'Vân Tùng', 'Thượng Quan', 'Hiệp Lực', 'Thuần Mang', 'Bạch Thông',
                  'Phủ Thông', 'Vi Hương', 'Sĩ Bình', 'Vũ Muộn', 'Đôn Phong', 'Lục Bình', 'Tân Tú', 'Nguyên Phúc',
                  'Cao Sơn', 'Quân Hà', 'Cẩm Giàng', 'Mỹ Thanh', 'Dương Phong', 'Quang Thuận', 'Chợ Đồn', 'Bằng Lũng',
                  'Xuân Lạc', 'Nam Cường', 'Bản Thi', 'Quảng Bạch', 'Bằng Phúc', 'Yên Thịnh', 'Yên Thượng',
                  'Phương Viên', 'Ngọc Phái', 'Đồng Thắng', 'Lương Bằng', 'Bằng Lãng', 'Đại Sảo', 'Nghĩa Tá',
                  'Bình Trung', 'Chợ Mới', 'Tân Sơn', 'Thanh Vận', 'Mai Lạp', 'Hoà Mục', 'Cao Kỳ', 'Nông Hạ', 'Yên Cư',
                  'Thanh Thịnh', 'Yên Hân', 'Như Cố', 'Bình Văn', 'Quảng Chu', 'Na Rì', 'Văn Vũ', 'Văn Lang',
                  'Lương Thượng', 'Kim Hỷ', 'Cường Lợi', 'Yến Lạc', 'Kim Lư', 'Sơn Thành', 'Văn Minh', 'Côn Minh',
                  'Cư Lễ', 'Quang Phong', 'Dương Sơn', 'Đổng Xá', 'Liêm Thuỷ', 'Tuyên Quang', 'Phan Thiết', 'Minh Xuân',
                  'Tràng Đà', 'Nông Tiến', 'Ỷ La', 'Tân Hà', 'Hưng Thành', 'Kim Phú', 'An Khang', 'Mỹ Lâm', 'An Tường',
                  'Lưỡng Vượng', 'Thái Long', 'Lâm Bình', 'Phúc Yên', 'Xuân Lập', 'Khuôn Hà', 'Lăng Can', 'Bình An',
                  'Thổ Bình', 'Na Hang', 'Sinh Long', 'Thượng Giáp', 'Thượng Nông', 'Côn Lôn', 'Yên Hoa', 'Đà Vị',
                  'Khau Tinh', 'Sơn Phú', 'Năng Khả', 'Thanh Tương', 'Chiêm Hóa', 'Vĩnh Lộc', 'Phúc Sơn', 'Trung Hà',
                  'Tân Mỹ', 'Hà Lang', 'Hùng Mỹ', 'Yên Lập', 'Tân An', 'Xuân Quang', 'Ngọc Hội', 'Phú Bình',
                  'Phúc Thịnh', 'Kiên Đài', 'Tân Thịnh', 'Kim Bình', 'Hòa An', 'Tri Phú', 'Nhân Lý', 'Yên Nguyên',
                  'Linh Phú', 'Bình Nhân', 'Hàm Yên', 'Tân Yên', 'Yên Thuận', 'Bạch Xa', 'Minh Khương', 'Yên Lâm',
                  'Minh Dân', 'Minh Hương', 'Bình Xa', 'Nhân Mục', 'Thành Long', 'Bằng Cốc', 'Đức Ninh', 'Hùng Đức',
                  'Quí Quân', 'Lực Hành', 'Kiến Thiết', 'Trung Minh', 'Chiêu Yên', 'Trung Trực', 'Xuân Vân',
                  'Phúc Ninh', 'Hùng Lợi', 'Trung Sơn', 'Tứ Quận', 'Đạo Viện', 'Tân Long', 'Thắng Quân', 'Lang Quán',
                  'Công Đa', 'Trung Môn', 'Chân Sơn', 'Thái Bình', 'Tiến Bộ', 'Mỹ Bằng', 'Hoàng Khai', 'Nhữ Hán',
                  'Nhữ Khê', 'Sơn Dương', 'Trung Yên', 'Minh Thanh', 'Tân Trào', 'Vĩnh Lợi', 'Thượng Ấm', 'Lương Thiện',
                  'Tú Thịnh', 'Cấp Tiến', 'Hợp Thành', 'Phúc Ứng', 'Đông Thọ', 'Kháng Nhật', 'Hợp Hòa', 'Quyết Thắng',
                  'Đồng Quý', 'Tân Thanh', 'Vân Sơn', 'Chi Thiết', 'Đông Lợi', 'Thiện Kế', 'Hồng Lạc', 'Ninh Lai',
                  'Đại Phú', 'Sơn Nam', 'Hào Phú', 'Tam Đa', 'Trường Sinh', 'Lào Cai', 'Duyên Hải', 'Cốc Lếu',
                  'Kim Tân', 'Bắc Lệnh', 'Pom Hán', 'Xuân Tăng', 'Đồng Tuyển', 'Vạn Hoà', 'Bắc Cường', 'Cam Đường',
                  'Tả Phời', 'Cốc San', 'Bát Xát', 'A Mú Sung', 'Nậm Chạc', 'A Lù', 'Trịnh Tường', 'Y Tý', 'Cốc Mỳ',
                  'Dền Sáng', 'Bản Vược', 'Sàng Ma Sáo', 'Bản Qua', 'Mường Vi', 'Dền Thàng', 'Bản Xèo', 'Mường Hum',
                  'Trung Lèng Hồ', 'Quang Kim', 'Pa Cheo', 'Nậm Pung', 'Phìn Ngan', 'Tòng Sành', 'Mường Khương',
                  'Pha Long', 'Tả Ngải Chồ', 'Tung Chung Phố', 'Dìn Chin', 'Tả Gia Khâu', 'Nậm Chảy', 'Nấm Lư',
                  'Lùng Khấu Nhin', 'Lùng Vai', 'Bản Lầu', 'La Pan Tẩn', 'Tả Thàng', 'Bản Sen', 'Si Ma Cai', 'Nàn Sán',
                  'Thào Chư Phìn', 'Bản Mế', 'Sán Chải', 'Lùng Thẩn', 'Cán Cấu', 'Sín Chéng', 'Quan Hồ Thẩn', 'Nàn Xín',
                  'Bắc Hà', 'Lùng Cải', 'Lùng Phình', 'Tả Van Chư', 'Tả Củ Tỷ', 'Thải Giàng Phố', 'Hoàng Thu Phố',
                  'Bản Phố', 'Bản Liền', 'Tà Chải', 'Na Hối', 'Cốc Ly', 'Nậm Mòn', 'Nậm Đét', 'Nậm Khánh', 'Bảo Nhai',
                  'Nậm Lúc', 'Cốc Lầu', 'Bản Cái', 'Bảo Thắng', 'N.T Phong Hải', 'Phố Lu', 'Tằng Loỏng', 'Bản Phiệt',
                  'Bản Cầm', 'Thái Niên', 'Phong Niên', 'Gia Phú', 'Sơn Hải', 'Xuân Giao', 'Trì Quang', 'Phú Nhuận',
                  'Bảo Yên', 'Phố Ràng', 'Vĩnh Yên', 'Điện Quan', 'Xuân Hoà', 'Tân Dương', 'Cam Cọn', 'Xuân Thượng',
                  'Việt Tiến', 'Bảo Hà', 'Lương Sơn', 'Phúc Khánh', 'Sa Pa', 'Sa Pả', 'Ô Quý Hồ', 'Ngũ Chỉ Sơn',
                  'Phan Si Păng', 'Trung Chải', 'Hàm Rồng', 'Hoàng Liên', 'Cầu Mây', 'Mường Hoa', 'Tả Van', 'Mường Bo',
                  'Bản Hồ', 'Liên Minh', 'Văn Bàn', 'Khánh Yên', 'Võ Lao', 'Sơn Thuỷ', 'Nậm Mả', 'Tân Thượng',
                  'Nậm Rạng', 'Nậm Chầy', 'Khánh Yên Thượng', 'Nậm Xé', 'Dần Thàng', 'Chiềng Ken', 'Làng Giàng',
                  'Hoà Mạc', 'Khánh Yên Trung', 'Khánh Yên Hạ', 'Dương Quỳ', 'Nậm Tha', 'Minh Lương', 'Thẩm Dương',
                  'Liêm Phú', 'Nậm Xây', 'Điện Biên Phủ', 'Noong Bua', 'Him Lam', 'Mường Thanh', 'Nam Thanh',
                  'Thanh Trường', 'Thanh Minh', 'Nà Tấu', 'Nà Nhạn', 'Mường Phăng', 'Pá Khoang', 'Mường Lay', 'Sông Đà',
                  'Na Lay', 'Lay Nưa', 'Mường Nhé', 'Sín Thầu', 'Sen Thượng', 'Chung Chải', 'Leng Su Sìn', 'Pá Mỳ',
                  'Nậm Vì', 'Nậm Kè', 'Mường Toong', 'Huổi Lếnh', 'Mường Chà', 'Xá Tổng', 'Mường Tùng', 'Hừa Ngài',
                  'Huổi Mí', 'Pa Ham', 'Nậm Nèn', 'Huổi Lèng', 'Sa Lông', 'Ma Thì Hồ', 'Na Sang', 'Mường Mươn',
                  'Tủa Chùa', 'Huổi Só', 'Tả Sìn Thàng', 'Lao Xả Phình', 'Tủa Thàng', 'Trung Thu', 'Sính Phình',
                  'Sáng Nhè', 'Mường Đun', 'Mường Báng', 'Tuần Giáo', 'Phình Sáng', 'Rạng Đông', 'Mùn Chung', 'Nà Tòng',
                  'Ta Ma', 'Mường Mùn', 'Pú Xi', 'Pú Nhung', 'Quài Nưa', 'Mường Thín', 'Tỏa Tình', 'Nà Sáy',
                  'Mường Khong', 'Quài Cang', 'Quài Tở', 'Chiềng Sinh', 'Chiềng Đông', 'Tênh Phông', 'Mường Pồn',
                  'Thanh Nưa', 'Hua Thanh', 'Thanh Luông', 'Thanh Hưng', 'Thanh Xương', 'Thanh Chăn', 'Pa Thơm',
                  'Thanh An', 'Thanh Yên', 'Noong Luống', 'Noọng Hẹt', 'Sam Mứn', 'Pom Lót', 'Núa Ngam', 'Hẹ Muông',
                  'Na Ư', 'Mường Nhà', 'Na Tông', 'Mường Lói', 'Phu Luông', 'Điện Biên Đông', 'Na Son', 'Phì Nhừ',
                  'Chiềng Sơ', 'Mường Luân', 'Pú Nhi', 'Nong U', 'Xa Dung', 'Keo Lôm', 'Luân Giới', 'Phình Giàng',
                  'Pú Hồng', 'Tìa Dình', 'Háng Lìa', 'Mường Ảng', 'Mường Đăng', 'Ngối Cáy', 'Ẳng Tở', 'Búng Lao',
                  'Xuân Lao', 'Ẳng Nưa', 'Ẳng Cang', 'Nặm Lịch', 'Mường Lạn', 'Nậm Pồ', 'Nậm Tin', 'Pa Tần', 'Chà Cang',
                  'Na Cô Sa', 'Nà Khoa', 'Nà Hỳ', 'Nà Bủng', 'Nậm Nhừ', 'Nậm Chua', 'Nậm Khăn', 'Chà Tở', 'Vàng Đán',
                  'Chà Nưa', 'Phìn Hồ', 'Si Pa Phìn', 'Lai Châu', 'Tân Phong', 'Đoàn Kết', 'Sùng Phài', 'Đông Phong',
                  'San Thàng', 'Tam Đường', 'Thèn Sin', 'Tả Lèng', 'Giang Ma', 'Bình Lư', 'Sơn Bình', 'Nùng Nàng',
                  'Bản Giang', 'Bản Hon', 'Bản Bo', 'Nà Tăm', 'Khun Há', 'Mường Tè', 'Thu Lũm', 'Ka Lăng', 'Tá Bạ',
                  'Pa ủ', 'Pa Vệ Sử', 'Mù Cả', 'Bum Tở', 'Nậm Khao', 'Tà Tổng', 'Bum Nưa', 'Vàng San', 'Kan Hồ',
                  'Sìn Hồ', 'Chăn Nưa', 'Hồng Thu', 'Phăng Sô Lin', 'Ma Quai', 'Lùng Thàng', 'Sà Dề Phìn', 'Nậm Tăm',
                  'Tả Ngảo', 'Pu Sam Cáp', 'Nậm Cha', 'Pa Khoá', 'Làng Mô', 'Noong Hẻo', 'Nậm Mạ', 'Căn Co',
                  'Tủa Sín Chải', 'Nậm Cuổi', 'Nậm Hăn', 'Phong Thổ', 'Lả Nhì Thàng', 'Huổi Luông', 'Sì Lở Lầu',
                  'Mồ Sì San', 'Pa Vây Sử', 'Vàng Ma Chải', 'Tông Qua Lìn', 'Mù Sang', 'Dào San', 'Ma Ly Pho',
                  'Bản Lang', 'Hoang Thèn', 'Khổng Lào', 'Nậm Xe', 'Mường So', 'Sin Suối Hồ', 'Than Uyên', 'Phúc Than',
                  'Mường Than', 'Mường Mít', 'Pha Mu', 'Mường Cang', 'Hua Nà', 'Tà Hừa', 'Mường Kim', 'Tà Mung',
                  'Tà Gia', 'Khoen On', 'Tân Uyên', 'Mường Khoa', 'Phúc Khoa', 'Thân Thuộc', 'Trung Đồng', 'Hố Mít',
                  'Nậm Cần', 'Nậm Sỏ', 'Pắc Ta', 'Tà Mít', 'Nậm Nhùn', 'Hua Bun', 'Mường Mô', 'Nậm Chà', 'Nậm Manh',
                  'Nậm Hàng', 'Pú Đao', 'Nậm Pì', 'Sơn La', 'Chiềng Lề', 'Quyết Tâm', 'Chiềng Cọ', 'Chiềng Đen',
                  'Chiềng Xôm', 'Chiềng An', 'Chiềng Cơi', 'Chiềng Ngần', 'Hua La', 'Quỳnh Nhai', 'Mường Chiên',
                  'Cà Nàng', 'Chiềng Khay', 'Mường Giôn', 'Pá Ma Pha Khinh', 'Chiềng Ơn', 'Mường Giàng', 'Chiềng Bằng',
                  'Mường Sại', 'Nậm ét', 'Chiềng Khoang', 'Thuận Châu', 'Phổng Lái', 'Mường é', 'Chiềng Pha',
                  'Chiềng La', 'Chiềng Ngàm', 'Liệp Tè', 'é Tòng', 'Phổng Lập', 'Phổng Lăng', 'Chiềng Ly', 'Noong Lay',
                  'Mường Khiêng', 'Mường Bám', 'Long Hẹ', 'Chiềng Bôm', 'Thôm Mòn', 'Tông Lạnh', 'Tông Cọ', 'Bó Mười',
                  'Co Mạ', 'Púng Tra', 'Chiềng Pấc', 'Nậm Lầu', 'Bon Phặng', 'Co Tòng', 'Muổi Nọi', 'Pá Lông',
                  'Bản Lầm', 'Mường La', 'Ít Ong', 'Nậm Giôn', 'Chiềng Lao', 'Hua Trai', 'Ngọc Chiến', 'Mường Trai',
                  'Nậm Păm', 'Chiềng Muôn', 'Chiềng Ân', 'Pi Toong', 'Chiềng Công', 'Tạ Bú', 'Chiềng San', 'Mường Bú',
                  'Chiềng Hoa', 'Mường Chùm', 'Bắc Yên', 'Phiêng Ban', 'Hang Chú', 'Xím Vàng', 'Tà Xùa', 'Háng Đồng',
                  'Pắc Ngà', 'Làng Chếu', 'Chim Vàn', 'Song Pe', 'Hồng Ngài', 'Tạ Khoa', 'Hua Nhàn', 'Phiêng Côn',
                  'Chiềng Sại', 'Phù Yên', 'Suối Tọ', 'Mường Thải', 'Mường Cơi', 'Quang Huy', 'Huy Bắc', 'Huy Thượng',
                  'Tân Lang', 'Gia Phù', 'Tường Phù', 'Huy Hạ', 'Huy Tân', 'Mường Lang', 'Suối Bau', 'Huy Tường',
                  'Mường Do', 'Sập Xa', 'Tường Thượng', 'Tường Tiến', 'Tường Phong', 'Tường Hạ', 'Kim Bon',
                  'Mường Bang', 'Đá Đỏ', 'Bắc Phong', 'Mộc Châu', 'NT Mộc Châu', 'Chiềng Sơn', 'Tân Hợp', 'Qui Hướng',
                  'Nà Mường', 'Tà Lai', 'Chiềng Hắc', 'Hua Păng', 'Chiềng Khừa', 'Mường Sang', 'Đông Sang', 'Lóng Sập',
                  'Yên Châu', 'Sập Vạt', 'Chiềng Sàng', 'Chiềng Pằn', 'Viêng Lán', 'Chiềng Hặc', 'Mường Lựm',
                  'Chiềng On', 'Chiềng Khoi', 'Tú Nang', 'Lóng Phiêng', 'Phiêng Khoài', 'Chiềng Tương', 'Mai Sơn',
                  'Hát Lót', 'Chiềng Sung', 'Mường Bằng', 'Chiềng Chăn', 'Mương Chanh', 'Chiềng Ban', 'Chiềng Mung',
                  'Mường Bon', 'Chiềng Chung', 'Chiềng Mai', 'Nà Pó', 'Cò  Nòi', 'Chiềng Nơi', 'Phiêng Cằm',
                  'Chiềng Dong', 'Chiềng Kheo', 'Chiềng Ve', 'Chiềng Lương', 'Phiêng Pằn', 'Nà Ơt', 'Tà Hộc', 'Sông Mã',
                  'Bó Sinh', 'Pú Pẩu', 'Chiềng Phung', 'Chiềng En', 'Mường Lầm', 'Nậm Ty', 'Đứa Mòn', 'Yên Hưng',
                  'Nà Nghịu', 'Nậm Mằn', 'Chiềng Khoong', 'Chiềng Cang', 'Huổi Một', 'Mường Sai', 'Mường Cai',
                  'Mường Hung', 'Chiềng Khương', 'Sốp Cộp', 'Sam Kha', 'Púng Bánh', 'Dồm Cang', 'Nậm Lạnh', 'Mường Lèo',
                  'Mường Và', 'Vân Hồ', 'Suối Bàng', 'Song Khủa', 'Liên Hoà', 'Tô Múa', 'Chiềng Khoa', 'Mường Men',
                  'Lóng Luông', 'Chiềng Yên', 'Chiềng Xuân', 'Xuân Nha', 'Tân Xuân', 'Yên Bái', 'Yên Ninh',
                  'Nguyễn Thái Học', 'Nguyễn Phúc', 'Minh Bảo', 'Tuy Lộc', 'Âu Lâu', 'Giới Phiên', 'Hợp Minh',
                  'Nghĩa Lộ', 'Pú Trạng', 'Trung Tâm', 'Cầu Thia', 'Nghĩa Lợi', 'Nghĩa Phúc', 'Nghĩa An', 'Sơn A',
                  'Phù Nham', 'Hạnh Sơn', 'Thạch Lương', 'Lục Yên', 'Yên Thế', 'Tân Phượng', 'Lâm Thượng',
                  'Khánh Thiện', 'Minh Chuẩn', 'Khai Trung', 'Mường Lai', 'Tô Mậu', 'Tân Lĩnh', 'Yên Thắng',
                  'Khánh Hoà', 'Vĩnh Lạc', 'Liễu Đô', 'Động Quan', 'Minh Tiến', 'Trúc Lâu', 'Văn Yên', 'Mậu A',
                  'Lang Thíp', 'Lâm Giang', 'Châu Quế Thượng', 'Châu Quế Hạ', 'An Bình', 'Đông An', 'Đông Cuông',
                  'Phong Dụ Hạ', 'Mậu Đông', 'Ngòi A', 'Xuân Tầm', 'An Thịnh', 'Yên Thái', 'Phong Dụ Thượng', 'Yên Hợp',
                  'Đại Phác', 'Xuân Ái', 'Viễn Sơn', 'Mỏ Vàng', 'Nà Hẩu', 'Mù Căng Chải', 'Hồ Bốn', 'Nậm Có',
                  'Khao Mang', 'Mồ Dề', 'Chế Cu Nha', 'Kim Nọi', 'Cao Phạ', 'La Pán Tẩn', 'Dế Su Phình', 'Chế Tạo',
                  'Púng Luông', 'Nậm Khắt', 'Trấn Yên', 'Cổ Phúc', 'Tân Đồng', 'Báo Đáp', 'Đào Thịnh', 'Việt Thành',
                  'Hòa Cuông', 'Minh Quán', 'Quy Mông', 'Cường Thịnh', 'Kiên Thành', 'Nga Quán', 'Y Can', 'Lương Thịnh',
                  'Bảo Hưng', 'Việt Cường', 'Minh Quân', 'Hồng Ca', 'Hưng Khánh', 'Vân Hội', 'Trạm Tấu', 'Túc Đán',
                  'Pá Lau', 'Xà Hồ', 'Phình Hồ', 'Tà Si Láng', 'Pá Hu', 'Làng Nhì', 'Bản Công', 'Bản Mù', 'Hát Lìu',
                  'Văn Chấn', 'NT Liên Sơn', 'NT Trần Phú', 'Tú Lệ', 'Nậm Búng', 'Gia Hội', 'Sùng Đô', 'Nậm Mười',
                  'An Lương', 'Nậm Lành', 'Sơn Lương', 'Suối Quyền', 'Suối Giàng', 'Nghĩa Sơn', 'Suối Bu', 'Sơn Thịnh',
                  'Đại Lịch', 'Đồng Khê', 'Cát Thịnh', 'Chấn Thịnh', 'Bình Thuận', 'Thượng Bằng La', 'Minh An',
                  'Nghĩa Tâm', 'Thác Bà', 'Xuân Long', 'Cảm Nhân', 'Ngọc Chấn', 'Tân Nguyên', 'Bảo Ái', 'Mỹ Gia',
                  'Xuân Lai', 'Mông Sơn', 'Cảm Ân', 'Tân Hương', 'Phúc An', 'Bạch Hà', 'Vũ Linh', 'Vĩnh Kiên',
                  'Thịnh Hưng', 'Hán Đà', 'Đại Minh', 'Hoà Bình', 'Thịnh Lang', 'Hữu Nghị', 'Phương Lâm', 'Yên Mông',
                  'Sủ Ngòi', 'Kỳ Sơn', 'Thịnh Minh', 'Mông Hóa', 'Đà Bắc', 'Nánh Nghê', 'Giáp Đắt', 'Mường Chiềng',
                  'Tân Pheo', 'Đồng Chum', 'Đồng Ruộng', 'Tú Lý', 'Yên Hòa', 'Toàn Sơn', 'Hiền Lương', 'Vầy Nưa',
                  'Lâm Sơn', 'Hòa Sơn', 'Tân Vinh', 'Nhuận Trạch', 'Cư Yên', 'Liên Sơn', 'Thanh Sơn', 'Kim Bôi', 'Bo',
                  'Đú Sáng', 'Hùng Sơn', 'Bình Sơn', 'Tú Sơn', 'Vĩnh Tiến', 'Đông Bắc', 'Xuân Thủy', 'Vĩnh Đồng',
                  'Kim Lập', 'Nam Thượng', 'Cuối Hạ', 'Sào Báy', 'Mi Hòa', 'Nuông Dăm', 'Cao Phong', 'Bình Thanh',
                  'Thung Nai', 'Thu Phong', 'Hợp Phong', 'Tây Phong', 'Dũng Phong', 'Thạch Yên', 'Tân Lạc', 'Mãn Đức',
                  'Suối Hoa', 'Phú Vinh', 'Mỹ Hòa', 'Quyết Chiến', 'Phong Phú', 'Tử Nê', 'Thanh Hối', 'Đông Lai',
                  'Nhân Mỹ', 'Lỗ Sơn', 'Ngổ Luông', 'Gia Mô', 'Mai Châu', 'Sơn Thủy', 'Pà Cò', 'Hang Kia', 'Cun Pheo',
                  'Bao La', 'Tòng Đậu', 'Nà Phòn', 'Săm Khóe', 'Chiềng Châu', 'Mai Hạ', 'Thành Sơn', 'Mai Hịch',
                  'Vạn Mai', 'Lạc Sơn', 'Vụ Bản', 'Quý Hòa', 'Miền Đồi', 'Tuân Đạo', 'Văn Nghĩa', 'Văn Sơn',
                  'Nhân Nghĩa', 'Bình Hẻm', 'Định Cư', 'Chí Đạo', 'Ngọc Sơn', 'Hương Nhượng', 'Vũ Bình', 'Yên Nghiệp',
                  'Ân Nghĩa', 'Ngọc Lâu', 'Yên Thủy', 'Hàng Trạm', 'Lạc Sỹ', 'Lạc Lương', 'Bảo Hiệu', 'Đa Phúc',
                  'Hữu Lợi', 'Lạc Thịnh', 'Phú Lai', 'Yên Trị', 'Ngọc Lương', 'Lạc Thủy', 'Ba Hàng Đồi', 'Chi Nê',
                  'Phú Thành', 'Hưng Thi', 'Khoan Dụ', 'Yên Bồng', 'Thái Nguyên', 'Quán Triều', 'Túc Duyên',
                  'Trưng Vương', 'Phan Đình Phùng', 'Thịnh Đán', 'Gia Sàng', 'Cam Giá', 'Phú Xá', 'Phúc Hà',
                  'Phúc Xuân', 'Phúc Trìu', 'Thịnh Đức', 'Tích Lương', 'Tân Cương', 'Sơn Cẩm', 'Chùa Hang', 'Cao Ngạn',
                  'Linh Sơn', 'Đồng Bẩm', 'Huống Thượng', 'Đồng Liên', 'Sông Công', 'Mỏ Chè', 'Cải Đan', 'Phố Cò',
                  'Bách Quang', 'Bá Xuyên', 'Định Hóa', 'Chợ Chu', 'Linh Thông', 'Lam Vỹ', 'Quy Kỳ', 'Kim Phượng',
                  'Bảo Linh', 'Phúc Chu', 'Phượng Tiến', 'Bảo Cường', 'Đồng Thịnh', 'Định Biên', 'Thanh Định',
                  'Trung Hội', 'Trung Lương', 'Điềm Mặc', 'Phú Tiến', 'Bộc Nhiêu', 'Phú Đình', 'Bình Thành',
                  'Giang Tiên', 'Đu', 'Yên Trạch', 'Yên Đổ', 'Ôn Lương', 'Động Đạt', 'Phủ Lý', 'Tức Tranh', 'Phấn Mễ',
                  'Vô Tranh', 'Cổ Lũng', 'Đồng Hỷ', 'Trại Cau', 'Văn Lăng', 'Quang Sơn', 'Minh Lập', 'Văn Hán',
                  'Hóa Trung', 'Khe Mo', 'Cây Thị', 'Hóa Thượng', 'Tân Lợi', 'Nam Hòa', 'Võ Nhai', 'Đình Cả',
                  'Sảng Mộc', 'Nghinh Tường', 'Thần Xa', 'Vũ Chấn', 'Thượng Nung', 'Cúc Đường', 'La Hiên', 'Lâu Thượng',
                  'Tràng Xá', 'Phương Giao', 'Dân Tiến', 'Bình Long', 'Đại Từ', 'Quân Chu', 'Phúc Lương', 'Yên Lãng',
                  'Đức Lương', 'Na Mao', 'Phú Lạc', 'Tân Linh', 'Phục Linh', 'Bản Ngoại', 'Tiên Hội', 'Cù Vân',
                  'Hà Thượng', 'La Bằng', 'Hoàng Nông', 'Khôi Kỳ', 'Tân Thái', 'Lục Ba', 'Mỹ Yên', 'Vạn Thọ', 'Ký Phú',
                  'Cát Nê', 'Phổ Yên', 'Bãi Bông', 'Ba Hàng', 'Phúc Thuận', 'Hồng Tiến', 'Đắc Sơn', 'Vạn Phái',
                  'Đông Cao', 'Thuận Thành', 'Bàn Đạt', 'Tân Khánh', 'Tân Kim', 'Đào Xá', 'Bảo Lý', 'Nhã Lộng',
                  'Điềm Thụy', 'Tân Đức', 'Úc Kỳ', 'Lương Phú', 'Nga My', 'Kha Sơn', 'Thanh Ninh', 'Dương Thành',
                  'Hà Châu', 'Lạng Sơn', 'Tam Thanh', 'Vĩnh Trại', 'Đông Kinh', 'Chi Lăng', 'Hoàng Đồng', 'Quảng Lạc',
                  'Mai Pha', 'Tràng Định', 'Thất Khê', 'Khánh Long', 'Quốc Khánh', 'Cao Minh', 'Chí Minh', 'Đào Viên',
                  'Kháng Chiến', 'Quốc Việt', 'Hùng Việt', 'Bình Gia', 'Yên Lỗ', 'Thiện Hòa', 'Thiện Thuật',
                  'Thiện Long', 'Bình La', 'Tân Văn', 'Văn Lãng', 'Na Sầm', 'Bắc La', 'Bắc Hùng', 'Tân Tác', 'Hội Hoan',
                  'Bắc Việt', 'Hoàng Việt', 'Gia Miễn', 'Thành Hòa', ' Hoàng Văn Thụ', 'Nhạc Kỳ', 'Cao Lộc',
                  'Đồng Đăng', 'Thanh Lòa', 'Cao Lâu', 'Thạch Đạn', 'Xuất Lễ', 'Lộc Yên', 'Hải Yến', 'Hòa Cư',
                  'Công Sơn', 'Gia Cát', 'Mẫu Sơn', 'Tân Liên', 'Văn Quan', 'Trấn Ninh', 'Liên Hội', 'Tú Xuyên',
                  'Điềm He', 'An Sơn', 'Khánh Khê', 'Lương Năng', 'Đồng Giáp', 'Bình Phúc', 'Tràng Các', 'Tân Đoàn',
                  'Tri Lễ', 'Tràng Phái', 'Yên Phúc', 'Hữu Lễ', 'Long Đống', 'Vạn Thủy', 'Đồng ý', 'Tân Tri',
                  'Bắc Quỳnh', 'Hưng Vũ', 'Vũ Sơn', 'Chiêu Vũ', 'Chiến Thắng', 'Vũ Lăng', 'Vũ Lễ', 'Nhất Hòa',
                  'Nhất Tiến', 'Hữu Lũng', 'Hữu Liên', 'Thiện Tân', 'Yên Vượng', 'Nhật Tiến', 'Cai Kinh', 'Hòa Lạc',
                  'Vân Nham', 'Hồ Sơn', 'Minh Hòa', 'Hòa Thắng', 'Đồng Mỏ', 'Vân An', 'Vân Thủy', 'Gia Lộc', 'Bắc Thủy',
                  'Mai Sao', 'Bằng Hữu', 'Thượng Cường', 'Bằng Mạc', 'Vạn Linh', 'Hữu Kiên', 'Quan Sơn', 'Y Tịch',
                  'Lộc Bình', 'Na Dương', 'Yên Khoái', 'Tú Mịch', 'Hữu Khánh', 'Đồng Bục', 'Tam Gia', 'Tú Đoạn',
                  'Khuất Xá', 'Tĩnh Bắc', 'Sàn Viên', 'Đông Quan', 'Minh Hiệp', 'Hữu Lân', 'Lợi Bác', 'Nam Quan',
                  'Ái Quốc', 'Đình Lập', 'NT Thái Bình', 'Bắc Xa', 'Bính Xá', 'Kiên Mộc', 'Lâm Ca', 'Bắc Lãng',
                  'Quảng Ninh', 'Hạ Long', 'Hà Khánh', 'Hà Phong', 'Hà Khẩu', 'Cao Xanh', 'Giếng Đáy', 'Hà Tu',
                  'Hà Trung', 'Hà Lầm', 'Bãi Cháy', 'Cao Thắng', 'Hùng Thắng', 'Hồng Hải', 'Hồng Gai', 'Tuần Châu',
                  'Hoành Bồ', 'Kỳ Thượng', 'Đồng Sơn', 'Đồng Lâm', 'Vũ Oai', 'Quảng La', 'Bằng Cả', 'Móng Cái',
                  'Ka Long', 'Ninh Dương', 'Hoà Lạc', 'Trà Cổ', 'Hải Sơn', 'Hải Đông', 'Hải Tiến', 'Hải Yên',
                  'Quảng Nghĩa', 'Hải Hoà', 'Hải Xuân', 'Vạn Ninh', 'Bình Ngọc', 'Vĩnh Trung', 'Vĩnh Thực', 'Cẩm Phả',
                  'Mông Dương', 'Cửa Ông', 'Cẩm Sơn', 'Cẩm Đông', 'Cẩm Phú', 'Cẩm Tây', 'Quang Hanh', 'Cẩm Thịnh',
                  'Cẩm Thủy', 'Cẩm Thạch', 'Cẩm Thành', 'Cẩm Trung', 'Cẩm Bình', 'Cẩm Hải', 'Dương Huy', 'Uông Bí',
                  'Vàng Danh', 'Nam Khê', 'Yên Thanh', 'Thượng Yên Công', 'Phương Đông', 'Phương Nam', 'Bình Liêu',
                  'Hoành Mô', 'Vô Ngại', 'Lục Hồn', 'Húc Động', 'Hà Lâu', 'Đại Dực', 'Phong Dụ', 'Điền Xá', 'Đông Ngũ',
                  'Yên Than', 'Đông Hải', 'Hải Lạng', 'Tiên Lãng', 'Đồng Rui', 'Đầm Hà', 'Tân Bình', 'Dực Yên',
                  'Quảng Tân', 'Đại Bình', 'Hải Hà', 'Quảng Hà', 'Quảng Đức', 'Quảng Sơn', 'Quảng Thành', 'Quảng Thịnh',
                  'Quảng Minh', 'Quảng Chính', 'Quảng Long', 'Đường Hoa', 'Quảng Phong', 'Cái Chiên', 'Ba Chẽ',
                  'Đạp Thanh', 'Lương Mông', 'Đồn Đạc', 'Minh Cầm', 'Vân Đồn', 'Cái Rồng', 'Đài Xuyên', 'Bình Dân',
                  'Đông Xá', 'Quan Lạn', 'Ngọc Vừng', 'Đông Triều', 'Mạo Khê', 'An Sinh', 'Tràng Lương', 'Bình Khê',
                  'Việt Dân', 'Tân Việt', 'Đức Chính', 'Tràng An', 'Thủy An', 'Hồng Thái Tây', 'Hồng Thái Đông',
                  'Hoàng Quế', 'Yên Thọ', 'Yên Đức', 'Quảng Yên', 'Đông Mai', 'Minh Thành', 'Sông Khoai', 'Hiệp Hòa',
                  'Tiền An', 'Hoàng Tân', 'Yên Giang', 'Nam Hoà', 'Hà An', 'Cẩm La', 'Phong Hải', 'Yên Hải', 'Liên Hòa',
                  'Phong Cốc', 'Liên Vị', 'Cô Tô', 'Thanh Lân', 'Bắc Giang', 'Thọ Xương', 'Trần Nguyên Hãn', 'Mỹ Độ',
                  'Song Mai', 'Xương Giang', 'Đa Mai', 'Dĩnh Kế', 'Dĩnh Trì', 'Song Khê', 'Xuân Lương', 'Tam Tiến',
                  'Đồng Vương', 'Đồng Hưu', 'Tân Hiệp', 'Hương Vĩ', 'Đồng Kỳ', 'Phồn Xương', 'Tân Sỏi', 'Bố Hạ',
                  'Lan Giới', 'Nhã Nam', 'Tân Trung', 'Đại Hóa', 'An Dương', 'Hợp Đức', 'Lam Cốt', 'Cao Xá',
                  'Việt Ngọc', 'Song Vân', 'Ngọc Châu', 'Ngọc Vân', 'Việt Lập', 'Liên Chung', 'Ngọc Thiện', 'Ngọc Lý',
                  'Quế Nham', 'Lạng Giang', 'Vôi', 'Nghĩa Hòa', 'Nghĩa Hưng', 'Quang Thịnh', 'Đào Mỹ', 'Tiên Lục',
                  'An Hà', 'Kép', 'Mỹ Hà', 'Hương Lạc', 'Dương Đức', 'Mỹ Thái', 'Xương Lâm', 'Xuân Hương', 'Tân Dĩnh',
                  'Đại Lâm', 'Thái Đào', 'Lục Nam', 'Đồi Ngô', 'Đông Hưng', 'Đông Phú', 'Tam Dị', 'Bảo Sơn', 'Bảo Đài',
                  'Tiên Nha', 'Trường Giang', 'Phương Sơn', 'Chu Điện', 'Cương Sơn', 'Nghĩa Phương', 'Lan Mẫu',
                  'Khám Lạng', 'Huyền Sơn', 'Trường Sơn', 'Lục Sơn', 'Bắc Lũng', 'Vũ Xá', 'Cẩm Lý', 'Đan Hội',
                  'Lục Ngạn', 'Chũ', 'Cấm Sơn', 'Phong Minh', 'Xa Lý', 'Hộ Đáp', 'Thanh Hải', 'Kiên Lao', 'Biên Sơn',
                  'Hồng Giang', 'Tân Hoa', 'Giáp Sơn', 'Biển Động', 'Quý Sơn', 'Trù Hựu', 'Phì Điền', 'Đồng Cốc',
                  'Mỹ An', 'Nam Dương', 'Tân Mộc', 'Đèo Gia', 'Phượng Sơn', 'Sơn Động', 'An Châu', 'Tây Yên Tử',
                  'Giáo Liêm', 'Cẩm Đàn', 'Vĩnh An', 'Lệ Viễn', 'An Bá', 'Tuấn Đạo', 'Dương Hưu', 'Long Sơn',
                  'Thanh Luận', 'Yên Dũng', 'Nham Biền', 'Lão Hộ', 'Hương Gián', 'Quỳnh Sơn', 'Nội Hoàng', 'Xuân Phú',
                  'Tân Liễu', 'Trí Yên', 'Lãng Sơn', 'Yên Lư', 'Tiến Dũng', 'Cảnh Thụy', 'Tư Mại', 'Đồng Việt',
                  'Việt Yên', 'Thượng Lan', 'Nghĩa Trung', 'Hương Mai', 'Tự Lạn', 'Bích Động', 'Tiên Sơn', 'Tăng Tiến',
                  'Nếnh', 'Ninh Sơn', 'Vân Trung', 'Quang Châu', 'Hoàng Lương', 'Hoàng Vân', 'Hoàng Thanh', 'Hoàng An',
                  'Thắng', 'Lương Phong', 'Thường Thắng', 'Hợp Thịnh', 'Danh Thắng', 'Mai Trung', 'Đoan Bái', 'Bắc Lý',
                  'Xuân Cẩm', 'Hương Lâm', 'Châu Minh', 'Phú Thọ', 'Việt Trì', 'Dữu Lâu', 'Vân Cơ', 'Nông Trang',
                  'Gia Cẩm', 'Tiên Cát', 'Thọ Sơn', 'Thanh Miếu', 'Bạch Hạc', 'Bến Gót', 'Vân Phú', 'Phượng Lâu',
                  'Thụy Vân', 'Minh Phương', 'Minh Nông', 'Sông Lô', 'Kim Đức', 'Hùng Lô', 'Hy Cương', 'Chu Hóa',
                  'Thanh Đình', 'Hùng Vương', 'Âu Cơ', 'Hà Lộc', 'Phú Hộ', 'Văn Lung', 'Hà Thạch', 'Thanh Vinh',
                  'Đoan Hùng', 'Hùng Xuyên', 'Bằng Luân', 'Vân Du', 'Phú Lâm', 'Bằng Doãn', 'Chí Đám', 'Phúc Lai',
                  'Ngọc Quan', 'Hợp Nhất', 'Sóc Đăng', 'Tây Cốc', 'Yên Kiện', 'Hùng Long', 'Vụ Quang', 'Tiêu Sơn',
                  'Chân Mộng', 'Ca Đình', 'Hạ Hoà', 'Đại Phạm', 'Đan Thượng', 'Hà Lương', 'Gia Điền', 'Ấm Hạ',
                  'Hương Xạ', 'Xuân Áng', 'Yên Kỳ', 'Minh Hạc', 'Lang Sơn', 'Bằng Giã', 'Yên Luật', 'Minh Côi',
                  'Vĩnh Chân', 'Thanh Ba', 'Vân Lĩnh', 'Đông Lĩnh', 'Đại An', 'Hanh Cù', 'Ninh Dân', 'Khải Xuân',
                  'Mạn Lạn', 'Hoàng Cương', 'Chí Tiên', 'Sơn Cương', 'Thanh Hà', 'Đỗ Sơn', 'Đỗ Xuyên', 'Lương Lỗ',
                  'Phù Ninh', 'Phú Mỹ', 'Lệ Mỹ', 'Liên Hoa', 'Trạm Thản', 'Trị Quận', 'Trung Giáp', 'Tiên Phú',
                  'Hạ Giáp', 'Bảo Thanh', 'Phú Lộc', 'Gia Thanh', 'Tiên Du', 'Phú Nham', 'An Đạo', 'Mỹ Lung', 'Xuân An',
                  'Xuân Viên', 'Hưng Long', 'Nga Hoàng', 'Thượng Long', 'Ngọc Lập', 'Ngọc Đồng', 'Cẩm Khê',
                  'Tiên Lương', 'Ngô Xá', 'Phượng Vĩ', 'Thụy Liễu', 'Tùng Khê', 'Văn Bán', 'Cấp Dẫn', 'Xương Thịnh',
                  'Phú Khê', 'Sơn Tình', 'Yên Tập', 'Hương Lung', 'Tạ Xá', 'Chương Xá', 'Văn Khúc', 'Yên Dưỡng',
                  'Điêu Lương', 'Đồng Lương', 'Tam Nông', 'Hưng Hoá', 'Hiền Quan', 'Thanh Uyên', 'Lam Sơn', 'Vạn Xuân',
                  'Quang Húc', 'Hương Nộn', 'Tề Lễ', 'Thọ Văn', 'Dân Quyền', 'Lâm Thao', 'Tiên Kiên', 'Xuân Lũng',
                  'Xuân Huy', 'Thạch Sơn', 'Sơn Vi', 'Phùng Nguyên', 'Vĩnh Lại', 'Tứ Xã', 'Bản Nguyên', 'Sơn Hùng',
                  'Địch Quả', 'Giáp Lai', 'Thục Luyện', 'Võ Miếu', 'Thạch Khoán', 'Cự Thắng', 'Tất Thắng', 'Cự Đồng',
                  'Thắng Sơn', 'Hương Cần', 'Khả Cửu', 'Đông Cửu', 'Yên Lương', 'Thượng Cửu', 'Lương Nha', 'Tinh Nhuệ',
                  'Thanh Thuỷ', 'Thạch Đồng', 'Xuân Lộc', 'Tân Phương', 'Đoan Hạ', 'Đồng Trung', 'Hoàng Xá', 'Tu Vũ',
                  'Thu Cúc', 'Thạch Kiệt', 'Thu Ngạc', 'Kiệt Sơn', 'Lai Đồng', 'Mỹ Thuận', 'Xuân Đài', 'Minh Đài',
                  'Văn Luông', 'Long Cốc', 'Kim Thượng', 'Vinh Tiền', 'Tích Sơn', 'Liên Bảo', 'Hội Hợp', 'Định Trung',
                  'Khai Quang', 'Thanh Trù', 'Trưng Trắc', 'Trưng Nhị', 'Phúc Thắng', 'Ngọc Thanh', 'Nam Viêm',
                  'Tiền Châu', 'Lập Thạch', 'Hợp Lý', 'Bắc Bình', 'Liễn Sơn', 'Vân Trục', 'Tử Du', 'Bàn Giản',
                  'Xuân Lôi', 'Đồng Ích', 'Tiên Lữ', 'Đình Chu', 'Triệu Đề', 'Tam Dương', 'Hoàng Hoa', 'Đồng Tĩnh',
                  'Kim Long', 'Hướng Đạo', 'Đạo Tú', 'An Hòa', 'Duy Phiên', 'Hoàng Đan', 'Hoàng Lâu', 'Tam Đảo',
                  'Hợp Châu', 'Đạo Trù', 'Yên Dương', 'Bồ Lý', 'Đại Đình', 'Tam Quan', 'Bình Xuyên', 'Hương Canh',
                  'Gia Khánh', 'Trung Mỹ', 'Bá Hiến', 'Tam Hợp', 'Quất Lưu', 'Sơn Lôi', 'Thanh Lãng', 'Phú Xuân',
                  'Đồng Cương', 'Bình Định', 'Trung Nguyên', 'Tề Lỗ', 'Tam Hồng', 'Yên Đồng', 'Văn Tiến', 'Nguyệt Đức',
                  'Yên Phương', 'Hồng Phương', 'Trung Kiên', 'Đại Tự', 'Hồng Châu', 'Vĩnh Tường', 'Kim Xá', 'Chấn Hưng',
                  'Việt Xuân', 'Bồ Sao', 'Lũng Hoà', 'Cao Đại', 'Thổ Tang', 'Vĩnh Sơn', 'Thượng Trưng', 'Vũ Di',
                  'Lý Nhân', 'Tuân Chính', 'Vân Xuân', 'Tam Phúc', 'Tứ Trưng', 'Ngũ Kiên', 'Vĩnh Thịnh', 'Phú Đa',
                  'Vĩnh Ninh', 'Lãng Công', 'Quang Yên', 'Bạch Lưu', 'Hải Lựu', 'Đồng Quế', 'Nhân Đạo', 'Đôn Nhân',
                  'Phương Khoan', 'Nhạo Sơn', 'Như Thụy', 'Yên Thạch', 'Tứ Yên', 'Đức Bác', 'Bắc Ninh', 'Vũ Ninh',
                  'Đáp Cầu', 'Thị Cầu', 'Kinh Bắc', 'Vệ An', 'Đại Phúc', 'Ninh Xá', 'Võ Cường', 'Hòa Long', 'Vạn An',
                  'Khúc Xuyên', 'Phong Khê', 'Kim Chân', 'Vân Dương', 'Khắc Niệm', 'Hạp Lĩnh', 'Chờ', 'Dũng Liệt',
                  'Tam Giang', 'Thụy Hòa', 'Hòa Tiến', 'Đông Tiến', 'Trung Nghĩa', 'Long Châu', 'Văn Môn', 'Quế Võ',
                  'Phố Mới', 'Việt Thống', 'Đại Xuân', 'Nhân Hòa', 'Bằng An', 'Phương Liễu', 'Quế Tân', 'Phù Lương',
                  'Phù Lãng', 'Phượng Mao', 'Ngọc Xá', 'Châu Phong', 'Bồng Lai', 'Cách Bi', 'Yên Giả', 'Mộ Đạo',
                  'Hán Quảng', 'Lim', 'Nội Duệ', 'Liên Bão', 'Hiên Vân', 'Hoàn Sơn', 'Lạc Vệ', 'Việt Đoàn', 'Phật Tích',
                  'Tân Chi', 'Minh Đạo', 'Cảnh Hưng', 'Từ Sơn', 'Đông Ngàn', 'Hương Mạc', 'Tương Giang', 'Phù Khê',
                  'Đồng Kỵ', 'Trang Hạ', 'Đồng Nguyên', 'Châu Khê', 'Tân Hồng', 'Đình Bảng', 'Phù Chẩn', 'Hồ',
                  'Hoài Thượng', 'Đại Đồng Thành', 'Mão Điền', 'Song Hồ', 'Đình Tổ', 'Trí Quả', 'Gia Đông',
                  'Thanh Khương', 'Trạm Lộ', 'Xuân Lâm', 'Hà Mãn', 'Ngũ Thái', 'Nghĩa Đạo', 'Song Liễu', 'Gia Bình',
                  'Thái Bảo', 'Giang Sơn', 'Cao Đức', 'Đại Lai', 'Song Giang', 'Lãng Ngâm', 'Nhân Thắng', 'Đông Cứu',
                  'Đại Bái', 'Quỳnh Phú', 'Lương Tài', 'Thứa', 'Trung Kênh', 'Phú Hòa', 'Mỹ Hương', 'Tân Lãng',
                  'Quảng Phú', 'Trừng Xá', 'Lai Hạ', 'Trung Chính', 'Hải Dương', 'Cẩm Thượng', 'Bình Hàn', 'Nhị Châu',
                  'Phạm Ngũ Lão', 'Lê Thanh Nghị', 'Hải Tân', 'Tứ Minh', 'Việt Hoà', 'Tiền Tiến', 'Thạch Khôi',
                  'Gia Xuyên', 'Chí Linh', 'Phả Lại', 'Sao Đỏ', 'Bến Tắm', 'Hoàng Hoa Thám', 'Bắc An', 'Hoàng Tiến',
                  'Cộng Hoà', 'Cổ Thành', 'Văn An', 'Nhân Huệ', 'Nam Sách', 'Nam Hưng', 'Nam Tân', 'Hiệp Cát',
                  'Thanh Quang', 'Quốc Tuấn', 'Nam Chính', 'Nam Trung', 'Thái Tân', 'An Lâm', 'Phú Điền', 'Kinh Môn',
                  'An Lưu', 'Thất Hùng', 'Lê Ninh', 'Hoành Sơn', 'Phạm Thái', 'Duy Tân', 'Phú Thứ', 'Thăng Long',
                  'Lạc Long', 'Hiệp Sơn', 'Thượng Quận', 'An Phụ', 'Hiệp An', 'Thái Thịnh', 'Hiến Thành', 'Kim Thành',
                  'Phú Thái', 'Lai Vu', 'Thượng Vũ', 'Cổ Dũng', 'Tuấn Việt', 'Kim Xuyên', 'Phúc Thành A', 'Ngũ Phúc',
                  'Kim Anh', 'Kim Đính', 'Tam Kỳ', 'Đồng Cẩm', 'Đại Đức', 'Cẩm Chế', 'Thanh Lang', 'Thanh Khê',
                  'Thanh Xá', 'An Phượng', 'Thanh Hồng', 'Thanh Cường', 'Vĩnh Lập', 'Cẩm Giang', 'Lai Cách', 'Cẩm Hưng',
                  'Cẩm Hoàng', 'Cẩm Văn', 'Ngọc Liên', 'Thạch Lỗi', 'Cẩm Vũ', 'Định Sơn', 'Lương Điền', 'Cao An',
                  'Tân Trường', 'Cẩm Phúc', 'Cẩm Điền', 'Cẩm Đoài', 'Bình Giang', 'Kẻ Sặt', 'Vĩnh Hồng', 'Thúc Kháng',
                  'Hồng Khê', 'Cổ Bì', 'Nhân Quyền', 'Thái Dương', 'Gia Tân', 'Gia Lương', 'Toàn Thắng', 'Hồng Hưng',
                  'Phạm Trấn', 'Đoàn Thượng', 'Thống Kênh', 'Đức Xương', 'Tứ Kỳ', 'Ngọc Kỳ', 'Bình Lăng', 'Tái Sơn',
                  'Quang Phục', 'Tân Kỳ', 'Quang Khải', 'Đại Hợp', 'Quảng Nghiệp', 'An Thanh', 'Văn Tố', 'Phượng Kỳ',
                  'Cộng Lạc', 'Tiên Động', 'Nguyên Giáp', 'Hà Kỳ', 'Hà Thanh', 'Ninh Giang', 'Ứng Hoè', 'Hồng Đức',
                  'An Đức', 'Vĩnh Hòa', 'Đông Xuyên', 'Ninh Hải', 'Kiến Quốc', 'Hồng Dụ', 'Văn Hội', 'Hồng Phúc',
                  'Thanh Miện', 'Thanh Tùng', 'Phạm Kha', 'Đoàn Tùng', 'Lê Hồng', 'Tứ Cường', 'Ngũ Hùng',
                  'Chi Lăng Bắc', 'Chi Lăng Nam', 'Thanh Giang', 'Hải Phòng', 'Hồng Bàng', 'Quán Toan', 'Sở Dầu',
                  'Thượng Lý', 'Hạ Lý', 'Trại Chuối', 'Phan Bội Châu', 'Máy Chai', 'Máy Tơ', 'Vạn Mỹ', 'Cầu Tre',
                  'Lạc Viên', 'Gia Viên', 'Cầu Đất', 'Đằng Giang', 'Lạch Tray', 'Đổng Quốc Bình', 'Lê Chân', 'Cát Dài',
                  'An Biên', 'Hồ Nam', 'Dư Hàng', 'Hàng Kênh', 'Niệm Nghĩa', 'Nghĩa Xá', 'Dư Hàng Kênh', 'Kênh Dương',
                  'Vĩnh Niệm', 'Hải An', 'Đông Hải 1', 'Đông Hải 2', 'Đằng Lâm', 'Thành Tô', 'Đằng Hải', 'Nam Hải',
                  'Cát Bi', 'Tràng Cát', 'Kiến An', 'Quán Trữ', 'Lãm Hà', 'Đồng Hoà', 'Trần Thành Ngọ', 'Văn Đẩu',
                  'Phù Liễn', 'Tràng Minh', 'Đồ Sơn', 'Ngọc Xuyên', 'Vạn Hương', 'Bàng La', 'Dương Kinh', 'Anh Dũng',
                  'Hải Thành', 'Hoà Nghĩa', 'Thuỷ Nguyên', 'Núi Đèo', 'Lại Xuân', 'Liên Khê', 'Lưu Kiếm', 'Lưu Kỳ',
                  'Gia Minh', 'Gia Đức', 'Quảng Thanh', 'Chính Mỹ', 'Kênh Giang', 'Cao Nhân', 'Mỹ Đồng', 'An Lư',
                  'Thuỷ Triều', 'Phục Lễ', 'Phả Lễ', 'Lập Lễ', 'Kiền Bái', 'Thiên Hương', 'Thuỷ Sơn', 'Thuỷ Đường',
                  'Hoàng Động', 'Lâm Động', 'Hoa Động', 'Dương Quan', 'Lê Thiện', 'Đại Bản', 'An Hoà', 'An Hưng',
                  'An Hồng', 'Đặng Cương', 'An Đồng', 'An Lão', 'Bát Trang', 'Trường Thọ', 'Trường Thành', 'Quang Hưng',
                  'Tân Viên', 'An Thọ', 'An Thái', 'Kiến Thuỵ', 'Núi Đối', 'Đông Phương', 'Thuận Thiên', 'Du Lễ',
                  'Thuỵ Hương', 'Đại Hà', 'Ngũ Đoan', 'Đoàn Xá', 'Tiên Cường', 'Tự Cường', 'Khởi Nghĩa', 'Tiên Thanh',
                  'Đoàn Lập', 'Tiên Thắng', 'Tiên Minh', 'Bắc Hưng', 'Tây Hưng', 'Vĩnh Bảo', 'Thắng Thuỷ', 'Trung Lập',
                  'Vĩnh Long', 'Hiệp Hoà', 'Nhân Hoà', 'Hưng Nhân', 'Đồng Minh', 'Liên Am', 'Lý Học', 'Tam Cường',
                  'Cộng Hiền', 'Cổ Am', 'Trấn Dương', 'Cát Hải', 'Cát Bà', 'Đồng Bài', 'Hoàng Châu', 'Văn Phong',
                  'Phù Long', 'Gia Luận', 'Hiền Hào', 'Trân Châu', 'Việt Hải', 'Xuân Đám', 'Bạch Long Vĩ', 'Hưng Yên',
                  'Hiến Nam', 'An Tảo', 'Quảng Châu', 'Bảo Khê', 'Hùng Cường', 'Phương Chiểu', 'Hoàng Hanh', 'Văn Lâm',
                  'Như Quỳnh', 'Lạc Đạo', 'Chỉ Đạo', 'Đình Dù', 'Minh Hải', 'Lạc Hồng', 'Văn Giang', 'Xuân Quan',
                  'Cửu Cao', 'Phụng Công', 'Nghĩa Trụ', 'Long Hưng', 'Vĩnh Khúc', 'Liên Nghĩa', 'Mễ Sở', 'Giai Phạm',
                  'Nghĩa Hiệp', 'Đồng Than', 'Liêu Xá', 'Hoàn Long', 'Lý Thường Kiệt', 'Mỹ Hào', 'Bần Yên Nhân',
                  'Cẩm Xá', 'Hòa Phong', 'Dị Sử', 'Bạch Sam', 'Xuân Dục', 'Ân Thi', 'Phù Ủng', 'Bãi Sậy', 'Đào Dương',
                  'Tân Phúc', 'Xuân Trúc', 'Quảng Lãng', 'Văn Nhuệ', 'Đặng Lễ', 'Cẩm Ninh', 'Đa Lộc', 'Hồ Tùng Mậu',
                  'Hạ Lễ', 'Khoái Châu', 'Đông Tảo', 'Dạ Trạch', 'Hàm Tử', 'Ông Đình', 'Tứ Dân', 'An Vĩ', 'Đông Kết',
                  'Bình Kiều', 'Tân Châu', 'Phùng Hưng', 'Việt Hòa', 'Đông Ninh', 'Đại Tập', 'Chí Tân', 'Thuần Hưng',
                  'Nhuế Dương', 'Kim Động', 'Nghĩa Dân', 'Vĩnh Xá', 'Thọ Vinh', 'Đồng Thanh', 'Chính Nghĩa', 'Nhân La',
                  'Đức Hợp', 'Hiệp Cường', 'Vương', 'Dị Chế', 'Lệ Xá', 'An Viên', 'Trung Dũng', 'Hải Triều', 'Thủ Sỹ',
                  'Thiện Phiến', 'Thụy Lôi', 'Cương Chính', 'Minh Phượng', 'Phù Cừ', 'Trần Cao', 'Phan Sào Nam',
                  'Minh Hoàng', 'Đoàn Đào', 'Tống Phan', 'Đình Cao', 'Nhật Quang', 'Nguyên Hòa', 'Tống Trân',
                  'Lê Hồng Phong', 'Bồ Xuyên', 'Kỳ Bá', 'Phú Khánh', 'Trần Lãm', 'Đông Hòa', 'Vũ Phúc', 'Vũ Chính',
                  'Vũ Đông', 'Vũ Lạc', 'Quỳnh Phụ', 'Quỳnh Côi', 'An Khê', 'Quỳnh Hoa', 'Quỳnh Lâm', 'Quỳnh Thọ',
                  'An Hiệp', 'Quỳnh Hoàng', 'Quỳnh Giao', 'An Cầu', 'Quỳnh Hồng', 'Quỳnh Khê', 'Quỳnh Minh', 'An Ninh',
                  'Quỳnh Ngọc', 'Quỳnh Hải', 'An Bài', 'An Ấp', 'Quỳnh Hội', 'Quỳnh Mỹ', 'An Quí', 'An Vũ', 'An Lễ',
                  'Quỳnh Hưng', 'Quỳnh Bảo', 'Quỳnh Nguyên', 'An Vinh', 'Quỳnh Xá', 'An Dục', 'Quỳnh Trang', 'An Tràng',
                  'Hưng Hà', 'Điệp Nông', 'Tân Lễ', 'Hùng Dũng', 'Văn Cẩm', 'Đông Đô', 'Tây Đô', 'Tiến Đức',
                  'Thái Hưng', 'Thái Phương', 'Hồng Lĩnh', 'Chí Hòa', 'Đô Lương', 'Liên Giang', 'Đông Cường',
                  'Lô Giang', 'Nguyên Xá', 'Đông Hợp', 'Đông Các', 'Đông Tân', 'Đông Vinh', 'Đông Động', 'Hồng Bạch',
                  'Trọng Quan', 'Đông Á', 'Đông Hoàng', 'Đông Dương', 'Thái Thụy', 'Diêm Điền', 'Thụy Trường',
                  'Hồng Dũng', 'Thụy Quỳnh', 'An Tân', 'Thụy Ninh', 'Thụy Hưng', 'Thụy Việt', 'Thụy Văn', 'Thụy Xuân',
                  'Dương Phúc', 'Thụy Trình', 'Thụy Bình', 'Thụy Chính', 'Thụy Dân', 'Thụy Hải', 'Thụy Liên',
                  'Thụy Duyên', 'Thụy Thanh', 'Thụy Sơn', 'Thụy Phong', 'Thái Thượng', 'Dương Hồng  Thủy', 'Thái Giang',
                  'Thái Phúc', 'Thái Đô', 'Thái Xuyên', ' Mỹ Lộc', 'Tân Học', 'Thuần Thành', 'Thái Thọ', 'Tiền Hải',
                  'Đông Trà', 'Đông Long', 'Đông Quí', 'Tây Lương', 'Tây Ninh', 'Đông Trung', 'Đông Cơ', 'Tây Giang',
                  'Đông Lâm', 'Phương Công', 'Tây Tiến', 'Vân Trường', 'Nam Thắng', 'Bắc Hải', 'Nam Thịnh', 'Nam Hà',
                  'Nam Phú', 'Kiến Xương', 'Trà Giang', 'Tây Sơn', 'Bình Nguyên', 'Thanh Tân', 'Thượng Hiền', 'Vũ An',
                  'Quang Lịch', 'Vũ Quí', 'Vũ Trung', 'Vũ Thắng', 'Vũ Công', 'Vũ Hòa', 'Nam Bình', 'Vũ Thư', 'Hồng Lý',
                  'Phúc Thành', 'Song Lãng', 'Minh Lãng', 'Dũng Nghĩa', 'Tam Quang', 'Bách Thuận', 'Tự Tân', 'Song An',
                  'Trung An', 'Vũ Hội', 'Việt Thuận', 'Vũ Vinh', 'Vũ Đoài', 'Vũ Tiến', 'Vũ Vân', 'Duy Nhất', 'Hà Nam',
                  'Lương Khánh Thiện', 'Lam Hạ', 'Phù Vân', 'Liêm Chính', 'Liêm Chung', 'Thanh Châu', 'Tiên Tân',
                  'Tiên Hiệp', 'Tiên Hải', 'Liêm Tuyền', 'Liêm Tiết', 'Thanh Tuyền', 'Đinh Xá', 'Trịnh Xá', 'Duy Tiên',
                  'Hòa Mạc', 'Mộc Bắc', 'Châu Giang', 'Bạch Thượng', 'Duy Minh', 'Mộc Nam', 'Duy Hải', 'Chuyên Ngoại',
                  'Yên Bắc', 'Trác Văn', 'Tiên Nội', 'Hoàng Đông', 'Yên Nam', 'Tiên Ngoại', 'Kim Bảng', 'Quế',
                  'Nguyễn Úy', 'Đại Cương', 'Lê Hồ', 'Tượng Lĩnh', 'Nhật Tựu', 'Đồng Hóa', 'Hoàng Tây', 'Văn Xá',
                  'Khả Phong', 'Ba Sao', 'Thi Sơn', 'Thanh Liêm', 'Kiện Khê', 'Liêm Phong', 'Liêm Cần', 'Liêm Thuận',
                  'Thanh Phong', 'Liêm Túc', 'Liêm Sơn', 'Thanh Hương', 'Thanh Nghị', 'Thanh Tâm', 'Thanh Nguyên',
                  'Bình Lục', 'Bình Mỹ', 'Bình Nghĩa', 'Đồng Du', 'Ngọc Lũ', 'Hưng Công', 'Đồn Xá', 'Bối Cầu', 'An Nội',
                  'Vũ Bản', 'An Đổ', 'La Sơn', 'Tiêu Động', 'Nguyên Lý', 'Chính Lý', 'Chân Lý', 'Đạo Lý', 'Công Lý',
                  'Văn Lý', 'Đức Lý', 'Vĩnh Trụ', 'Nhân Thịnh', 'Nhân Khang', 'Nhân Bình', 'Phú Phúc', 'Xuân Khê',
                  'Hòa Hậu', 'Nam Định', 'Trần Tế Xương', 'Vị Hoàng', 'Cửa Bắc', 'Bà Triệu', 'Trường Thi',
                  'Trần Đăng Ninh', 'Năng Tĩnh', 'Trần Quang Khải', 'Lộc Hạ', 'Lộc Vượng', 'Lộc Hòa', 'Mỹ Xá', 'Lộc An',
                  'Nam Vân', 'Mỹ Lộc', 'Mỹ Tiến', 'Mỹ Thắng', 'Mỹ Trung', 'Mỹ Tân', 'Mỹ Phúc', 'Mỹ Thịnh', 'Gôi',
                  'Minh Thuận', 'Hiển Khánh', 'Hợp Hưng', 'Thành Lợi', 'Kim Thái', 'Vĩnh Hào', 'Ý Yên', 'Lâm',
                  'Yên Tân', 'Yên Lợi', 'Yên Chính', 'Yên Khánh', 'Yên Hồng', 'Yên Quang', 'Yên Tiến', 'Yên Lộc',
                  'Yên Bằng', 'Yên Khang', 'Yên Nhân', 'Liễu Đề', 'Nghĩa Đồng', 'Nghĩa Thịnh', 'Nghĩa Minh',
                  'Nghĩa Thái', 'Hoàng Nam', 'Nghĩa Châu', 'Nghĩa Lạc', 'Nghĩa Hồng', 'Nghĩa Phong', 'Nghĩa Phú',
                  'Nghĩa Bình', 'Quỹ Nhất', 'Nghĩa Hùng', 'Nghĩa Lâm', 'Nghĩa Thành', 'Nghĩa Hải', 'Nam Điền',
                  'Nam Trực', 'Nam Giang', 'Nam Mỹ', 'Nam Toàn', 'Nam Hùng', 'Nam Hoa', 'Nam Lợi', 'Nam Thái',
                  'Trực Ninh', 'Cổ Lễ', 'Phương Định', 'Trực Chính', 'Trung Đông', 'Liêm Hải', 'Trực Tuấn', 'Trực Đạo',
                  'Trực Hưng', 'Trực Nội', 'Cát Thành', 'Trực Thanh', 'Trực Khang', 'Trực Thuận', 'Trực Mỹ', 'Trực Đại',
                  'Trực Cường', 'Ninh Cường', 'Trực Thái', 'Trực Hùng', 'Trực Thắng', 'Xuân Châu', 'Xuân Hồng',
                  'Xuân Thành', 'Xuân Phong', 'Xuân Tân', 'Xuân Ngọc', 'Xuân Bắc', 'Thọ Nghiệp', 'Xuân Trung',
                  'Xuân Vinh', 'Xuân Kiên', 'Xuân Tiến', 'Xuân Ninh', 'Giao Thủy', 'Ngô Đồng', 'Quất Lâm', 'Giao Hương',
                  'Hồng Thuận', 'Giao Thiện', 'Giao Thanh', 'Bình Hòa', 'Giao Tiến', 'Giao Hà', 'Giao Nhân', 'Giao An',
                  'Giao Lạc', 'Giao Châu', 'Giao Tân', 'Giao Yến', 'Giao Xuân', 'Giao Thịnh', 'Giao Hải', 'Bạch Long',
                  'Giao Long', 'Giao Phong', 'Hải Hậu', 'Cồn', 'Thịnh Long', 'Hải Nam', 'Hải Trung', 'Hải Vân',
                  'Hải Minh', 'Hải Anh', 'Hải Hưng', 'Hải Bắc', 'Hải Phúc', 'Hải Thanh', 'Hải Long', 'Hải Phương',
                  'Hải Đường', 'Hải Lộc', 'Hải Quang', 'Hải Phong', 'Hải Tây', 'Hải Lý', 'Hải Phú', 'Hải Giang',
                  'Hải Cường', 'Hải Ninh', 'Hải Chính', 'Hải Châu', 'Hải Hòa', 'Ninh Bình', 'Vân Giang', 'Bích Đào',
                  'Nam Thành', 'Ninh Khánh', 'Ninh Nhất', 'Ninh Tiến', 'Ninh Phúc', 'Ninh Phong', 'Tam Điệp',
                  'Nho Quan', 'Xích Thổ', 'Gia Sơn', 'Thạch Bình', 'Gia Thủy', 'Gia Tường', 'Cúc Phương', 'Lạc Vân',
                  'Đồng Phong', 'Lạng Phong', 'Thượng Hòa', 'Văn Phương', 'Thanh Lạc', 'Sơn Lai', 'Kỳ Phú', 'Quỳnh Lưu',
                  'Phú Long', 'Gia Viễn', 'Me', 'Gia Hòa', 'Gia Hưng', 'Gia Vân', 'Gia Xuân', 'Gia Lập', 'Gia Vượng',
                  'Gia Trấn', 'Gia Thịnh', 'Gia Phương', 'Gia Thắng', 'Gia Trung', 'Gia Lạc', 'Gia Tiến', 'Gia Sinh',
                  'Gia Phong', 'Hoa Lư', 'Thiên Tôn', 'Ninh Khang', 'Ninh Mỹ', 'Ninh Hòa', 'Ninh Xuân', 'Ninh Thắng',
                  'Ninh Vân', 'Ninh An', 'Khánh Tiên', 'Khánh Phú', 'Khánh Hòa', 'Khánh Lợi', 'Khánh An', 'Khánh Cường',
                  'Khánh Cư', 'Khánh Hải', 'Khánh Trung', 'Khánh Mậu', 'Khánh Vân', 'Khánh Hội', 'Khánh Công',
                  'Khánh Thành', 'Khánh Nhạc', 'Khánh Thủy', 'Khánh Hồng', 'Phát Diệm', 'Hồi Ninh', 'Xuân Chính',
                  'Kim Định', 'Ân Hòa', 'Quang Thiện', 'Như Hòa', 'Chất Bình', 'Đồng Hướng', 'Kim Chính', 'Thượng Kiệm',
                  'Lưu Phương', 'Lai Thành', 'Văn Hải', 'Kim Mỹ', 'Cồn Thoi', 'Kim Hải', 'Kim Trung', 'Kim Đông',
                  'Yên Mô', 'Khánh Dương', 'Khánh Thịnh', 'Yên Từ', 'Yên Mạc', 'Thanh Hóa', 'Nam Ngạn', 'Ngọc Trạo',
                  'Đông Vệ', 'Đông Cương', 'Đông Hương', 'Quảng Thắng', 'Thiệu Vân', 'Thiệu Khánh', 'Thiệu Dương',
                  'Tào Xuyên', 'Long Anh', 'Hoằng Quang', 'Hoằng Đại', 'Quảng Đông', 'Quảng Cát', 'Quảng Tâm',
                  'Bỉm Sơn', 'Sầm Sơn', 'Quảng Cư', 'Quảng Tiến', 'Quảng Hùng', 'Quảng Thọ', 'Quảng Vinh', 'Quảng Đại',
                  'Mường Lát', 'Tam Chung', 'Mường Lý', 'Trung Lý', 'Quang Chiểu', 'Pù Nhi', 'Nhi Sơn', 'Mường Chanh',
                  'Quan Hóa', 'Hồi Xuân', 'Phú Thanh', 'Phú Lệ', 'Hiền Chung', 'Hiền Kiệt', 'Thiên Phủ', 'Phú Nghiêm',
                  'Nam Xuân', 'Nam Động', 'Bá Thước', 'Cành Nàng', 'Điền Thượng', 'Điền Hạ', 'Điền Quang', 'Điền Trung',
                  'Lương Ngoại', 'Ái Thượng', 'Lương Nội', 'Điền Lư', 'Lương Trung', 'Lũng Niêm', 'Lũng Cao',
                  'Hạ Trung', 'Thành Lâm', 'Ban Công', 'Kỳ Tân', 'Văn Nho', 'Thiết Ống', 'Thiết Kế', 'Trung Xuân',
                  'Trung Thượng', 'Trung Tiến', 'Trung Hạ', 'Na Mèo', 'Sơn Lư', 'Tam Lư', 'Sơn Điện', 'Mường Mìn',
                  'Lang Chánh', 'Yên Khương', 'Trí Nang', 'Tam Văn', 'Lâm Phú', 'Ngọc Lặc', 'Thúy Sơn', 'Thạch Lập',
                  'Vân Âm', 'Cao Ngọc', 'Lộc Thịnh', 'Cao Thịnh', 'Ngọc Trung', 'Phùng Giáo', 'Phùng Minh', 'Nguyệt Ấn',
                  'Kiên Thọ', 'Phong Sơn', 'Cẩm Quý', 'Cẩm Lương', 'Cẩm Liên', 'Cẩm Tú', 'Cẩm Châu', 'Cẩm Tâm',
                  'Cẩm Ngọc', 'Cẩm Long', 'Cẩm Tân', 'Cẩm Vân', 'Thạch Thành', 'Thạch Quảng', 'Thạch Tượng',
                  'Thạch Cẩm', 'Thạch Định', 'Thạch Long', 'Thành Mỹ', 'Thành Yên', 'Thành Vinh', 'Thành Minh',
                  'Thành Tân', 'Thành Trực', 'Thành Tâm', 'Thành An', 'Thành Thọ', 'Thành Tiến', 'Thành Hưng',
                  'Hà Long', 'Hà Vinh', 'Hà Bắc', 'Hoạt Giang', 'Lĩnh Toại', 'Hà Ngọc', 'Yến Sơn', 'Hà Sơn', 'Hà Lĩnh',
                  'Hà Tân', 'Hà Tiến', 'Hà Bình', 'Hà Lai', 'Hà Thái', 'Hà Hải', 'Vĩnh Hùng', 'Yên Tâm', 'Quí Lộc',
                  'Yên Trường', 'Yên Hùng', 'Định Tăng', 'Định Hòa', 'Định Thành', 'Định Tân', 'Định Tiến', 'Định Long',
                  'Định Liên', 'Quán Lào', 'Định Hưng', 'Định Hải', 'Định Bình', 'Bắc Lương', 'Thọ Hải', 'Xuân Sinh',
                  'Xuân Hưng', 'Thọ Diên', 'Thọ Lâm', 'Xuân Bái', 'Sao Vàng', 'Xuân Thiên', 'Thuận Minh', 'Thọ Lập',
                  'Xuân Tín', 'Trường Xuân', 'Thường Xuân', 'Bát Mọt', 'Xuân Lẹ', 'Xuân Cao', 'Luận Thành', 'Luận Khê',
                  'Xuân Thắng', 'Thọ Thanh', 'Ngọc Phụng', 'Xuân Chinh', 'Triệu Sơn', 'Thọ Bình', 'Thọ Tiến',
                  'Triệu Thành', 'Hợp Thắng', 'Dân Lực', 'Dân Lý', 'An Nông', 'Nưa', 'Đồng Lợi', 'Tiến Nông',
                  'Khuyến Nông', 'Xuân Thịnh', 'Thọ Dân', 'Xuân Thọ', 'Thọ Tân', 'Thọ Ngọc', 'Thọ Cường', 'Thọ Phú',
                  'Thọ Vực', 'Thọ Thế', 'Nông Trường', 'Thiệu Hóa', 'Thiệu Ngọc', 'Thiệu Vũ', 'Thiệu Phúc',
                  'Thiệu Tiến', 'Thiệu Công', 'Thiệu Phú', 'Thiệu Long', 'Thiệu Giang', 'Thiệu Duy', 'Thiệu Nguyên',
                  'Thiệu Hợp', 'Thiệu Thịnh', 'Thiệu Quang', 'Thiệu Thành', 'Thiệu Toán', 'Thiệu Chính', 'Thiệu Hòa',
                  'Thiệu Viên', 'Thiệu Lý', 'Thiệu Vận', 'Thiệu Trung', 'Thiệu Giao', 'Hoằng Hóa', 'Bút Sơn',
                  'Hoằng Giang', 'Hoằng Xuân', 'Hoằng Phượng', 'Hoằng Phú', 'Hoằng Quỳ', 'Hoằng Kim', 'Hoằng Trung',
                  'Hoằng Trinh', 'Hoằng Sơn', 'Hoằng Cát', 'Hoằng Xuyên', 'Hoằng Quý', 'Hoằng Hợp', 'Hoằng Đức',
                  'Hoằng Hà', 'Hoằng Đạt', 'Hoằng Đạo', 'Hoằng Thắng', 'Hoằng Đồng', 'Hoằng Thái', 'Hoằng Thịnh',
                  'Hoằng Thành', 'Hoằng Lộc', 'Hoằng Trạch', 'Hoằng Phong', 'Hoằng Lưu', 'Hoằng Châu', 'Hoằng Tân',
                  'Hoằng Yến', 'Hoằng Tiến', 'Hoằng Hải', 'Hoằng Ngọc', 'Hoằng Đông', 'Hoằng Thanh', 'Hoằng Phụ',
                  'Hoằng Trường', 'Hậu Lộc', 'Đồng Lộc', 'Đại Lộc', 'Triệu Lộc', 'Tiến Lộc', 'Lộc Sơn', 'Cầu Lộc',
                  'Thành Lộc', 'Phong Lộc', 'Thuần Lộc', 'Hoa Lộc', 'Liên Lộc', 'Quang Lộc', 'Hòa Lộc', 'Minh Lộc',
                  'Hưng Lộc', 'Ngư Lộc', 'Nga Sơn', 'Nga Vịnh', 'Nga Văn', 'Nga Thiện', 'Nga Tiến', 'Nga Phượng',
                  'Nga Trung', 'Nga Bạch', 'Nga Thanh', 'Nga Yên', 'Nga Giáp', 'Nga Hải', 'Nga Thành', 'Nga An',
                  'Nga Phú', 'Nga Điền', 'Nga Tân', 'Nga Thủy', 'Nga Liên', 'Nga Thái', 'Nga Thạch', 'Nga Thắng',
                  'Nga Trường', 'Như Xuân', 'Yên Cát', 'Bãi Trành', 'Xuân Bình', 'Hóa Quỳ', 'Cát Vân', 'Cát Tân',
                  'Bình Lương', 'Thanh Quân', 'Thanh Hòa', 'Thượng Ninh', 'Như Thanh', 'Bến Sung', 'Cán Khê', 'Xuân Du',
                  'Phượng Nghi', 'Mậu Lâm', 'Xuân Khang', 'Xuân Thái', 'Xuân Phúc', 'Thanh Kỳ', 'Nông Cống', 'Tân Thọ',
                  'Hoàng Sơn', 'Tân Khang', 'Hoàng Giang', 'Tế Thắng', 'Tế Lợi', 'Tế Nông', 'Minh Nghĩa', 'Minh Khôi',
                  'Vạn Hòa', 'Trường Trung', 'Vạn Thiện', 'Trường Minh', 'Thăng Bình', 'Công Liêm', 'Tượng Văn',
                  'Thăng Thọ', 'Tượng Sơn', 'Công Chính', 'Rừng Thông', 'Đông Thanh', 'Đông Thịnh', 'Đông Văn',
                  'Đông Nam', 'Quảng Xương', 'Quảng Trạch', 'Quảng Định', 'Quảng Nhân', 'Quảng Bình', 'Quảng Hợp',
                  'Quảng Văn', 'Quảng Trung', 'Quảng Ngọc', 'Quảng Trường', 'Quảng Phúc', 'Quảng Giao', 'Quảng Hải',
                  'Quảng Lưu', 'Quảng Lộc', 'Tiên Trang', 'Quảng Nham', 'Quảng Thạch', 'Quảng Thái', 'Tĩnh Gia',
                  'Anh Sơn', 'Ngọc Lĩnh', 'Các Sơn', 'Hải Lĩnh', 'Hải Nhân', 'Trúc Lâm', 'Hải Bình', 'Tùng Lâm',
                  'Tĩnh Hải', 'Trường Lâm', 'Hải Thượng', 'Nghi Sơn', 'Nghệ An', 'Vinh', 'Đông Vĩnh', 'Hà Huy Tập',
                  'Quán Bàu', 'Hưng Bình', 'Hưng Phúc', 'Hưng Dũng', 'Đội Cung', 'Lê Mao', 'Bến Thủy', 'Trung Đô',
                  'Nghi Phú', 'Hưng Đông', 'Hưng Hòa', 'Vinh Tân', 'Nghi Liên', 'Nghi Ân', 'Nghi Kim', 'Nghi Đức',
                  'Hưng Chính', 'Cửa Lò', 'Nghi Thuỷ', 'Nghi Tân', 'Thu Thuỷ', 'Nghi Hòa', 'Nghi Hải', 'Nghi Hương',
                  'Nghi Thu', 'Thái Hoà', 'Hoà Hiếu', 'Nghĩa Tiến', 'Nghĩa Mỹ', 'Tây Hiếu', 'Đông Hiếu', 'Quế Phong',
                  'Thông Thụ', 'Hạnh Dịch', 'Nậm Giải', 'Châu Kim', 'Mường Nọc', 'Châu Thôn', 'Nậm Nhoóng', 'Căm Muộn',
                  'Quỳ Châu', 'Châu Bính', 'Châu Thuận', 'Châu Hội', 'Châu Nga', 'Châu Tiến', 'Châu Hạnh', 'Châu Thắng',
                  'Châu Bình', 'Châu Hoàn', 'Diên Lãm', 'Mường Xén', 'Mỹ Lý', 'Keng Đu', 'Đoọc Mạy', 'Huồi Tụ',
                  'Mường Lống', 'Na Loi', 'Nậm Cắn', 'Bảo Nam', 'Phà Đánh', 'Hữu Lập', 'Tà Cạ', 'Chiêu Lưu',
                  'Mường Típ', 'Hữu Kiệm', 'Mường Ải', 'Na Ngoi', 'Nậm Càn', 'Tương Dương', 'Thạch Giám', 'Nhôn Mai',
                  'Hữu Khuông', 'Yên Tĩnh', 'Xiêng My', 'Lưỡng Minh', 'Yên Na', 'Lưu Kiền', 'Xá Lượng', 'Tam Thái',
                  'Tam Đình', 'Nghĩa Đàn', 'Nghĩa Mai', 'Nghĩa Yên', 'Nghĩa Thọ', 'Nghĩa Hội', 'Nghĩa Hiếu',
                  'Nghĩa Đức', 'Nghĩa Long', 'Nghĩa Lộc', 'Nghĩa Khánh', 'Quỳ Hợp', 'Châu Hồng', 'Đồng Hợp',
                  'Châu Thành', 'Liên Hợp', 'Châu Lộc', 'Châu Cường', 'Châu Quang', 'Thọ Hợp', 'Minh Hợp', 'Nghĩa Xuân',
                  'Châu Thái', 'Châu Đình', 'Văn Lợi', 'Châu Lý', 'Hạ Sơn', 'Cầu Giát', 'Quỳnh Thắng', 'Quỳnh Tân',
                  'Quỳnh Châu', 'Quỳnh Văn', 'Quỳnh Tam', 'Quỳnh Thạch', 'Quỳnh Bảng', 'Quỳnh Thanh', 'Quỳnh Hậu',
                  'Quỳnh Đôi', 'Quỳnh Lương', 'Quỳnh Yên', 'Quỳnh Bá', 'Quỳnh Diễn', 'Quỳnh Giang', 'Quỳnh Nghĩa',
                  'Tiến Thủy', 'Quỳnh Thuận', 'Quỳnh Long', 'Tân Thắng', 'Con Cuông', 'Bình Chuẩn', 'Lạng Khê',
                  'Cam Lâm', 'Thạch Ngàn', 'Đôn Phục', 'Mậu Đức', 'Chi Khê', 'Bồng Khê', 'Yên Khê', 'Lục Dạ', 'Môn Sơn',
                  'Giai Xuân', 'Nghĩa Hợp', 'Nghĩa Hoàn', 'Tiên Kỳ', 'Nghĩa Dũng', 'Nghĩa Hành', 'Đỉnh Sơn', 'Đức Sơn',
                  'Tường Sơn', 'Tào Sơn', 'Hội Sơn', 'Khai Sơn', 'Lĩnh Sơn', 'Diễn Châu', 'Diễn Lâm', 'Diễn Đoài',
                  'Diễn Trường', 'Diễn Yên', 'Diễn Hoàng', 'Diễn Hùng', 'Diễn Mỹ', 'Diễn Hồng', 'Diễn Phong',
                  'Diễn Hải', 'Diễn Tháp', 'Diễn Liên', 'Diễn Vạn', 'Diễn Kim', 'Diễn Kỷ', 'Diễn Xuân', 'Diễn Thái',
                  'Diễn Đồng', 'Diễn Bích', 'Diễn Hạnh', 'Diễn Ngọc', 'Diễn Quảng', 'Diễn Nguyên', 'Diễn Hoa',
                  'Diễn Thành', 'Diễn Phúc', 'Diễn Cát', 'Diễn Thịnh', 'Diễn Tân', 'Diễn Thọ', 'Diễn Lợi', 'Diễn Lộc',
                  'Diễn Trung', 'Diễn An', 'Diễn Phú', 'Mã Thành', 'Tiến Thành', 'Lăng Thành', 'Đức Thành', 'Hậu Thành',
                  'Hùng Thành', 'Đô Thành', 'Thọ Thành', 'Tây Thành', 'Hồng Thành', 'Đồng Thành', 'Hoa Thành',
                  'Tăng Thành', 'Văn Thành', 'Thịnh Thành', 'Bắc Thành', 'Nhân Thành', 'Long Thành', 'Vĩnh Thành',
                  'Lý Thành', 'Viên Thành', 'Liên Thành', 'Bảo Thành', 'Công Thành', 'Giang Sơn Đông', 'Giang Sơn Tây',
                  'Bồi Sơn', 'Bài Sơn', 'Tràng Sơn', 'Đặng Sơn', 'Lưu Sơn', 'Đà Sơn', 'Thịnh Sơn', 'Thuận Sơn',
                  'Nhân Sơn', 'Hiến Sơn', 'Mỹ Sơn', 'Trù Sơn', 'Thanh Chương', 'Cát Văn', 'Thanh Nho', 'Hạnh Lâm',
                  'Phong Thịnh', 'Thanh Tiên', 'Thanh Liên', 'Thanh Đồng', 'Thanh Ngọc', 'Thanh Lĩnh', 'Thanh Chi',
                  'Xuân Tường', 'Thanh Dương', 'Võ Liệt', 'Thanh Khai', 'Nghi Lộc', 'Quán Hành', 'Nghi Văn', 'Nghi Yên',
                  'Nghi Tiến', 'Nghi Hưng', 'Nghi Đồng', 'Nghi Thiết', 'Nghi Lâm', 'Nghi Quang', 'Nghi Kiều', 'Nghi Mỹ',
                  'Nghi Phương', 'Nghi Thuận', 'Nghi Long', 'Nghi Xá', 'Nghi Hoa', 'Khánh Hợp', 'Nghi Thịnh',
                  'Nghi Công Bắc', 'Nghi Công Nam', 'Nghi Thạch', 'Nghi Trung', 'Nghi Trường', 'Nghi Diên',
                  'Nghi Phong', 'Nghi Xuân', 'Nghi Vạn', 'Nghi Thái', 'Nam Đàn', 'Nam Nghĩa', 'Nam Anh', 'Nam Lĩnh',
                  'Thượng Tân Lộc', 'Hồng Long', 'Nam Cát', 'Khánh Sơn', 'Trung Phúc Cường', 'Nam Kim', 'Hưng Nguyên',
                  'Hưng Trung', 'Hưng Yên Bắc', 'Hưng Tây', 'Hưng Mỹ', 'Hưng Lĩnh', 'Hưng Thông', 'Hưng Tân',
                  'Hưng Lợi', 'Hưng Nghĩa', 'Long Xá', 'Châu Nhân', 'Xuân Lam', 'Quỳnh Vinh', 'Quỳnh Lộc',
                  'Quỳnh Thiện', 'Quỳnh Lập', 'Mai Hùng', 'Quỳnh Dị', 'Quỳnh Xuân', 'Quỳnh Phương', 'Quỳnh Liên',
                  'Hà Tĩnh', 'Đại Nài', 'Thạch Trung', 'Thạch Quý', 'Thạch Linh', 'Thạch Hạ', 'Đồng Môn', 'Thạch Hưng',
                  'Đức Thuận', 'Đậu Liêu', 'Thuận Lộc', 'Phố Châu', ' Tây Sơn', 'Sơn Hồng', 'Sơn Tiến', 'Sơn Lâm',
                  'Sơn Lễ', 'Sơn Giang', 'Sơn Lĩnh', 'An Hòa Thịnh', 'Sơn Ninh', 'Sơn Châu', 'Tân Mỹ Hà', 'Quang Diệm',
                  'Sơn Trung', 'Sơn Bằng', 'Sơn Kim 1', 'Sơn Kim 2', 'Sơn Trà', 'Sơn Long', 'Sơn Hàm', 'Sơn Trường',
                  'Đức Thọ', 'Quang Vĩnh', 'Tùng Châu', 'Yên Hồ', 'Tùng Ảnh', 'Bùi La Nhân', 'Thanh Bình Thịnh',
                  'Lâm Trung Thủy', 'An Dũng', 'Đức Đồng', 'Đức Lạng', 'Vũ Quang', 'Ân Phú', 'Đức Lĩnh', 'Thọ Điền',
                  'Đức Hương', 'Đức Bồng', 'Đức Liên', 'Hương Minh', 'Quang Thọ', 'Xuân Hội', 'Đan Trường', 'Xuân Phổ',
                  'Xuân Hải', 'Tiên Điền', 'Xuân Yên', 'Xuân Mỹ', 'Cỗ Đạm', 'Xuân Liên', 'Xuân Lĩnh', 'Cương Gián',
                  'Can Lộc', 'Nghèn', 'Thiên Lộc', 'Thuần Thiện', 'Vượng Lộc', 'Thanh Lộc', 'Kim Song Trường',
                  'Thường Nga', 'Tùng Lộc', 'Gia Hanh', 'Khánh Vĩnh Yên', 'Trung Lộc', 'Thượng Lộc', 'Hương Khê',
                  'Điền Mỹ', 'Hà Linh', 'Hương Thủy', 'Hòa Hải', 'Hương Giang', 'Hương Bình', 'Hương Long', 'Phú Gia',
                  'Gia Phố', 'Phú Phong', 'Hương Đô', 'Hương Vĩnh', 'Hương Xuân', 'Phúc Trạch', 'Hương Trà',
                  'Hương Trạch', 'Hương Liên', 'Thạch Hà', 'Thạch Hải', 'Thạch Kênh', 'Thạch Liên', 'Đỉnh Bàn',
                  'Thạch Khê', 'Thạch Trị', 'Thạch Lạc', 'Thạch Ngọc', 'Thạch Văn', 'Lưu Vĩnh Sơn', 'Thạch Thắng',
                  'Thạch Đài', 'Thạch Hội', 'Tân Lâm Hương', 'Thạch Xuân', 'Cẩm Xuyên', 'Thiên Cầm', 'Cẩm Dương',
                  'Cẩm Vĩnh', 'Cẩm Quang', 'Cẩm Nhượng', 'Nam Phúc Thăng', 'Cẩm Duệ', 'Cẩm Quan', 'Cẩm Hà', 'Cẩm Lộc',
                  'Cẩm Mỹ', 'Cẩm Lạc', 'Cẩm Minh', 'Kỳ Anh', 'Kỳ Xuân', 'Kỳ Bắc', 'Kỳ Phong', 'Kỳ Tiến', 'Kỳ Giang',
                  'Kỳ Đồng', 'Kỳ Khang', 'Kỳ Văn', 'Kỳ Trung', 'Kỳ Thọ', 'Kỳ Tây', 'Kỳ Hải', 'Kỳ Thư', 'Kỳ Châu',
                  'Lâm Hợp', 'Kỳ Lạc', 'Lộc Hà', 'Tân Lộc', 'Hồng Lộc', 'Thịnh Lộc', 'Ích Hậu', 'Thạch Mỹ', 'Thạch Kim',
                  'Thạch Châu', 'Hộ Độ', 'Mai Phụ', 'Hưng Trí', 'Kỳ Ninh', 'Kỳ Lợi', 'Kỳ Hà', 'Kỳ Trinh', 'Kỳ Thịnh',
                  'Kỳ Hoa', 'Kỳ Phương', 'Kỳ Long', 'Kỳ Liên', 'Kỳ Nam', 'Đồng Hới', 'Nam Lý', 'Đồng Hải', 'Phú Hải',
                  'Bắc Nghĩa', 'Đức Ninh Đông', 'Quang Phú', 'Lộc Ninh', 'Bảo Ninh', 'Nghĩa Ninh', 'Thuận Đức',
                  'Minh Hóa', 'Quy Đạt', 'Dân Hóa', 'Trọng Hóa', 'Hóa Phúc', 'Hồng Hóa', 'Hóa Thanh', 'Hóa Tiến',
                  'Hóa Hợp', 'Xuân Hóa', 'Yên Hóa', 'Tân Hóa', 'Hóa Sơn', 'Trung Hóa', 'Thượng Hóa', 'Tuyên Hóa',
                  'Đồng Lê', 'Hương Hóa', 'Kim Hóa', 'Thanh Thạch', 'Thuận Hóa', 'Lâm Hóa', 'Lê Hóa', 'Sơn Hóa',
                  'Ngư Hóa', 'Thạch Hóa', 'Đức Hóa', 'Phong Hóa', 'Mai Hóa', 'Tiến Hóa', 'Châu Hóa', 'Cao Quảng',
                  'Văn Hóa', 'Quảng Kim', 'Quảng Tùng', 'Cảnh Dương', 'Quảng Xuân', 'Cảnh Hóa', 'Liên Trường',
                  'Quảng Phương', 'Phù Hóa', 'Bố Trạch', 'Hoàn Lão', 'NT Việt Trung', 'Xuân Trạch', 'Mỹ Trạch',
                  'Hạ Trạch', 'Bắc Trạch', 'Lâm Trạch', 'Thanh Trạch', 'Liên Trạch', 'Cự Nẫm', 'Thượng Trạch',
                  'Hưng Trạch', 'Đồng Trạch', 'Đức Trạch', 'Phong Nha', 'Vạn Trạch', 'Phú Định', 'Trung Trạch',
                  'Tây Trạch', 'Hòa Trạch', 'Đại Trạch', 'Nhân Trạch', 'Tân Trạch', 'Nam Trạch', 'Lý Trạch', 'Quán Hàu',
                  'Lương Ninh', 'Võ Ninh', 'Hàm Ninh', 'Duy Ninh', 'Gia Ninh', 'Tân Ninh', 'Lệ Thủy', 'NT Lệ Ninh',
                  'Kiến Giang', 'Hồng Thủy', 'Ngư Thủy Bắc', 'Hoa Thủy', 'An Thủy', 'Phong Thủy', 'Cam Thủy',
                  'Ngân Thủy', 'Lộc Thủy', 'Liên Thủy', 'Hưng Thủy', 'Dương Thủy', 'Tân Thủy', 'Phú Thủy', 'Mỹ Thủy',
                  'Ngư Thủy ', 'Mai Thủy', 'Sen Thủy', 'Thái Thủy', 'Kim Thủy', 'Trường Thủy', 'Lâm Thủy', 'Ba Đồn',
                  'Quảng Tiên', 'Quảng Thuận', 'Quảng Thủy', 'Quảng Trị', 'Đông Giang', 'Phường 1', 'Đông Lễ',
                  'Phường 2', 'Phường 4', 'Phường 5', 'Đông Lương', 'Phường 3', 'An Đôn', 'Hải Lệ', 'Vĩnh Linh',
                  'Hồ Xá', 'Bến Quan', 'Vĩnh Thái', 'Vĩnh Tú', 'Vĩnh Chấp', 'Trung Nam', 'Vĩnh Khê', 'Vĩnh Thủy',
                  'Vĩnh Lâm', 'Hiền Thành', 'Cửa Tùng', 'Vĩnh Hà', 'Vĩnh Giang', 'Vĩnh Ô', 'Hướng Hóa', 'Khe Sanh',
                  'Lao Bảo', 'Hướng Lập', 'Hướng Việt', 'Hướng Phùng', 'Hướng Sơn', 'Hướng Linh', 'Hướng Tân', 'Húc',
                  'Thuận', 'Hướng Lộc', 'Ba Tầng', 'Thanh', ' A Dơi', 'Lìa', 'Xy', 'Gio Linh', 'Cửa Việt',
                  'Trung Giang', 'Trung Hải', 'Phong Bình', 'Gio Mỹ', 'Gio Hải', 'Gio An', 'Gio Châu', 'Gio Việt',
                  'Linh Trường', 'Gio Sơn', 'Gio Mai', 'Hải Thái', 'Linh Hải', 'Gio Quang', 'Đa Krông', 'Krông Klang',
                  'Mò Ó', 'Hướng Hiệp', 'Ba Lòng', 'Ba Nang', 'Tà Long', 'Húc Nghì', 'A Vao', 'Tà Rụt', 'A Bung',
                  'A Ngo', 'Cam Lộ', 'Cam Tuyền', 'Cam Thành', 'Cam Hiếu', 'Cam Chính', 'Cam Nghĩa', 'Triệu Phong',
                  'Ái Tử', 'Triệu An', 'Triệu Vân', 'Triệu Phước', 'Triệu Độ', 'Triệu Trạch', 'Triệu Thuận',
                  'Triệu Đại', 'Triệu Hòa', 'Triệu Lăng', 'Triệu Long', 'Triệu Tài', 'Triệu Trung', 'Triệu Ái',
                  'Triệu Thượng', 'Triệu Giang', 'Hải Lăng', 'Diên Sanh', 'Hải Ba', 'Hải Quy', 'Hải Quế', 'Hải Định',
                  'Hải Lâm', 'Hải Trường', 'Hải Chánh', 'Hải Khê', 'Cồn Cỏ', 'Thừa Thiên Huế', 'Huế', 'Phú Thuận',
                  'Tây Lộc', 'Phú Hiệp', 'Phú Hậu', 'Thuận Hòa', 'Vĩ Dạ', 'Phường Đúc', 'Phú Hội', 'Trường An',
                  'Phước Vĩnh', 'An Cựu', 'Hương Sơ', 'Thuỷ Biều', 'Thuỷ Xuân', 'An Đông', 'An Tây', 'Phong Điền',
                  'Điền Hương', 'Điền Môn', 'Điền Lộc', 'Điền Hòa', 'Phong Chương', 'Điền Hải', 'Phong Hòa',
                  'Phong Thu', 'Phong Hiền', 'Phong Mỹ', 'Phong An', 'Phong Xuân', 'Quảng Điền', 'Sịa', 'Quảng Ngạn',
                  'Quảng Lợi', 'Quảng Công', 'Quảng Phước', 'Phú Vang', 'Thuận An', 'Phú Dương', 'Phú Mậu', 'Phú An',
                  'Phú Diên', 'Phú Hồ', 'Vinh Xuân', 'Vinh Thanh', 'Vinh An', 'Vinh Hà', 'Phú Bài', 'Thủy Vân',
                  'Thủy Thanh', 'Thủy Dương', 'Thủy Phương', 'Thủy Châu', 'Thủy Lương', 'Thủy Bằng', 'Thủy Tân',
                  'Thủy Phù', 'Dương Hòa', 'Tứ Hạ', 'Hương Phong', 'Hương Toàn', 'Hương Vân', 'Hương Văn', 'Hương Vinh',
                  'Hương Chữ', 'Hương An', 'Hương Hồ', 'Hương Thọ', 'Bình Tiến', 'A Lưới', 'Hồng Hạ', 'Hồng Kim',
                  'Hương Nguyên', 'Hồng Bắc', 'Quảng Nhâm', 'Hồng Thượng', 'A Roằng', 'Lâm Đớt', 'Lăng Cô', 'Vinh Mỹ',
                  'Vinh Hưng', 'Giang Hải', 'Vinh Hiền', 'Lộc Bổn', 'Lộc Vĩnh', 'Lộc Điền', 'Lộc Trì', 'Lộc Tiến',
                  'Nam Đông', 'Khe Tre', 'Hương Phú', 'Hương Lộc', 'Thượng Quảng', 'Hương Hữu', 'Thượng Lộ',
                  'Thượng Nhật', 'Đà Nẵng', 'Liên Chiểu', 'Hòa Hiệp Bắc', 'Hòa Hiệp Nam', 'Hòa Khánh Bắc',
                  'Hòa Khánh Nam', 'Hòa Minh', 'Tam Thuận', 'Thanh Khê Tây', 'Thanh Khê Đông', 'Xuân Hà', 'Tân Chính',
                  'Chính Gián', 'Thạc Gián', 'Hòa Khê', 'Thuận Phước', 'Thạch Thang', 'Hải Châu  I', 'Hải Châu II',
                  'Phước Ninh', 'Hòa Thuận Tây', 'Hòa Thuận Đông', 'Bình Hiên', 'Hòa Cường Bắc', 'Hòa Cường Nam',
                  'Thọ Quang', 'Nại Hiên Đông', 'Mân Thái', 'An Hải Bắc', 'Phước Mỹ', 'An Hải Tây', 'An Hải Đông',
                  'Ngũ Hành Sơn', 'Khuê Mỹ', 'Hoà Quý', 'Hoà Hải', 'Cẩm Lệ', 'Khuê Trung', 'Hòa Phát', 'Hòa Thọ Tây',
                  'Hòa Thọ Đông', 'Hòa Xuân', 'Hòa Vang', 'Hòa Bắc', 'Hòa Liên', 'Hòa Ninh', 'Hòa Nhơn', 'Hòa Châu',
                  'Hòa Phước', 'Hòa Khương', 'Hoàng Sa', 'Quảng Nam', 'Tân Thạnh', 'Phước Hòa', 'Hòa Hương', 'An Xuân',
                  'Tam Thăng', 'Tam Phú', 'Tam Ngọc', 'Hội An', 'Cẩm Phô', 'Sơn Phong', 'Cửa Đại', 'Cẩm An', 'Cẩm Kim',
                  'Cẩm Nam', 'Cẩm Thanh', "Ch'ơm", 'Ga Ri', 'A Xan', "Tr'Hy", 'Lăng', 'A Nông', 'A Tiêng', 'Bha Lê',
                  'A Vương', 'Dang', 'P Rao', 'Tà Lu', 'Sông Kôn', 'Jơ Ngây', 'A Ting', ' Tư', 'Ba', 'A Rooi',
                  'Za Hung', 'Mà Cooi', 'Ka Dăng', 'Ái Nghĩa', 'Đại Lãnh', 'Đại Hồng', 'Đại Quang', 'Đại Hiệp',
                  'Đại Thạnh', 'Đại Chánh', 'Đại Tân', 'Đại Phong', 'Đại Hòa', 'Điện Bàn', 'Vĩnh Điện', 'Điện Tiến',
                  'Điện Hòa', 'Điện Thắng Bắc', 'Điện Thắng Trung', 'Điện Thắng Nam', 'Điện Ngọc', 'Điện Hồng',
                  'Điện Thọ', 'Điện Phước', 'Điện An', 'Điện Nam Bắc', 'Điện Nam Trung', 'Điện Nam Đông', 'Điện Dương',
                  'Điện Quang', 'Điện Trung', 'Điện Phong', 'Điện Minh', 'Điện Phương', 'Duy Xuyên', 'Nam Phước',
                  'Duy Thu', 'Duy Phú', 'Duy Hòa', 'Duy Châu', 'Duy Trinh', 'Duy Sơn', 'Duy Trung', 'Duy Phước',
                  'Duy Thành', 'Duy Vinh', 'Duy Nghĩa', 'Quế Sơn', 'Quế Xuân 1', 'Quế Xuân 2', 'Quế Phú', 'Quế Hiệp',
                  'Quế Thuận', 'Quế Mỹ', 'Quế Long', 'Quế Châu', 'Quế An', 'Quế Minh', 'Thạnh Mỹ', 'Laêê', 'Chơ Chun',
                  'Zuôich', 'Tà Pơơ', 'La Dêê', 'Đắc Tôi', 'Chà Vàl', 'Tà Bhinh', 'Cà Dy', 'Đắc Pre', 'Đắc Pring',
                  'Phước Sơn', 'Khâm Đức', 'Phước Xuân', 'Phước Hiệp', 'Phước Hoà', 'Phước Đức', 'Phước Năng',
                  'Phước Chánh', 'Phước Công', 'Phước Kim', 'Phước Lộc', 'Phước Thành', 'Hiệp Đức', 'Quế Thọ',
                  'Bình Lâm', 'Sông Trà', 'Phước Trà', 'Phước Gia', 'Quế Lưu', 'Thăng Phước', 'Hà Lam', 'Bình Phục',
                  'Bình Triều', 'Bình Đào', 'Bình Lãnh', 'Bình Trị', 'Bình Định Bắc', 'Bình Định Nam', 'Bình Quý',
                  'Bình Chánh', 'Bình Tú', 'Bình Sa', 'Bình Hải', 'Bình Quế', 'Bình Nam', 'Tiên Phước', 'Tiên Hà',
                  'Tiên Cẩm', 'Tiên Châu', 'Tiên Lãnh', 'Tiên Ngọc', 'Tiên Cảnh', 'Tiên Mỹ', 'Tiên Thọ', 'Tiên An',
                  'Tiên Lộc', 'Tiên Lập', 'Bắc Trà My', 'Trà My', 'Trà Sơn', 'Trà Kót', 'Trà Nú', 'Trà Đông',
                  'Trà Dương', 'Trà Bui', 'Trà Đốc', 'Trà Tân', 'Trà Giác', 'Trà Giáp', 'Trà Ka', 'Nam Trà My',
                  'Trà Leng', 'Trà Dơn', 'Trà Tập', 'Trà Mai', 'Trà Cang', 'Trà Linh', 'Trà Nam', 'Trà Don', 'Trà Vân',
                  'Trà Vinh', 'Núi Thành', 'Tam Xuân I', 'Tam Xuân II', 'Tam Thạnh', 'Tam Anh Bắc', 'Tam Anh Nam',
                  'Tam Hòa', 'Tam Hải', 'Tam Nghĩa', 'Tam Mỹ Tây', 'Tam Mỹ Đông', 'Tam Trà', 'Phú Ninh', 'Tam Thành',
                  'Tam An', 'Tam Đàn', 'Tam Lộc', 'Tam Phước', 'Tam Vinh', 'Tam Đại', 'Tam Dân', 'Tam Lãnh', 'Nông Sơn',
                  'Quế Trung', 'Ninh Phước', 'Quế Lộc', 'Sơn Viên', 'Quế Lâm', 'Quảng Ngãi', 'Nghĩa Chánh',
                  'Nguyễn Nghiêm', 'Chánh Lộ', 'Nghĩa Dõng', 'Trương Quang Trọng', 'Tịnh Hòa', 'Tịnh Kỳ', 'Tịnh Thiện',
                  'Tịnh Ấn Đông', 'Tịnh Châu', 'Tịnh Khê', 'Tịnh Long', 'Tịnh Ấn Tây', 'Tịnh An', 'Nghĩa Hà', 'Châu Ổ',
                  'Bình Thạnh', 'Bình Đông', 'Bình Khương', 'Bình Phước', 'Bình Thanh ', 'Bình Chương', 'Bình Hiệp',
                  'Bình Tân Phú', 'Bình Châu', 'Trà Bồng', 'Trà Xuân', 'Trà Thủy', 'Trà Hiệp', 'Trà Bình', 'Trà Phú',
                  'Trà Lâm', 'Trà Bùi', 'Trà Thanh', 'Trà Phong', 'Trà Xinh', 'Trà Tây', 'Sơn Tịnh', 'Tịnh Thọ',
                  'Tịnh Trà', 'Tịnh Phong', 'Tịnh Hiệp', 'Tịnh Bình', 'Tịnh Đông', 'Tịnh Bắc', 'Tịnh Sơn', 'Tịnh Hà',
                  'Tịnh Giang', 'Tịnh Minh', 'Tư Nghĩa', 'La Hà', 'Sông Vệ', 'Nghĩa Thắng', 'Nghĩa Kỳ', 'Nghĩa Điền',
                  'Nghĩa Thương', 'Di Lăng', 'Sơn Hạ', 'Sơn Nham', 'Sơn Bao', 'Sơn Linh', 'Sơn Thượng', 'Sơn Cao',
                  'Sơn Kỳ', 'Sơn Ba', 'Sơn Bua', 'Sơn Mùa', 'Sơn Liên', 'Sơn Tân', 'Sơn Màu', 'Sơn Dung', 'Sơn Tinh',
                  'Long Mai', 'Long Môn', 'Long Hiệp', 'Chợ Chùa', 'Hành Thuận', 'Hành Dũng', 'Hành Trung', 'Hành Nhân',
                  'Hành Đức', 'Hành Minh', 'Hành Phước', 'Hành Thiện', 'Hành Thịnh', 'Hành Tín Tây', 'Hành Tín  Đông',
                  'Mộ Đức', 'Đức Lợi', 'Đức Nhuận', 'Đức Chánh', 'Đức Hiệp', 'Đức Minh', 'Đức Thạnh', 'Đức Hòa',
                  'Đức Tân', 'Đức Phú', 'Đức Phong', 'Đức Lân', 'Đức Phổ', 'Phổ An', 'Phổ Phong', 'Phổ Thuận',
                  'Phổ Văn', 'Phổ Quang', 'Phổ Nhơn', 'Phổ Ninh', 'Phổ Minh', 'Phổ Vinh', 'Phổ Hòa', 'Phổ Cường',
                  'Phổ Khánh', 'Phổ Thạnh', 'Phổ Châu', 'Ba Tơ', 'Ba Điền', 'Ba Vinh', 'Ba Thành', 'Ba Động', 'Ba Dinh',
                  'Ba Giang', 'Ba Liên', 'Ba Ngạc', 'Ba Khâm', 'Ba Cung', 'Ba Tiêu', 'Ba Trang', 'Ba Tô', 'Ba Bích',
                  'Ba Lế', 'Ba Nam', 'Ba Xa', 'Lý Sơn', 'Qui Nhơn', 'Nhơn Bình', 'Nhơn Phú', 'Trần Quang Diệu',
                  'Hải Cảng', 'Thị Nại', 'Ngô Mây', 'Bùi Thị Xuân', 'Nguyễn Văn Cừ', 'Ghềnh Ráng', 'Nhơn Lý',
                  'Nhơn Hội', 'Nhơn Hải', 'Nhơn Châu', 'An Trung', 'An Toàn', 'An Quang', 'An Nghĩa', 'Hoài Nhơn',
                  ' Tam Quan', 'Bồng Sơn', 'Hoài Sơn', 'Hoài Châu Bắc', 'Hoài Châu', 'Hoài Phú', 'Tam Quan Bắc',
                  'Tam Quan Nam', 'Hoài Hảo', 'Hoài Thanh Tây', 'Hoài Thanh', 'Hoài Hương', 'Hoài Tân', 'Hoài Hải',
                  'Hoài Xuân', 'Hoài Mỹ', 'Hoài Ân', 'Tăng Bạt Hổ', 'Ân Hảo Tây', 'Ân Hảo Đông', 'Ân Sơn', 'Ân Mỹ',
                  'Dak Mang', 'Ân Tín', 'Ân Thạnh', 'Ân Phong', 'Ân Đức', 'Ân Hữu', 'Bok Tới', 'Ân Tường Tây',
                  'Ân Tường Đông', 'Phù Mỹ', 'Mỹ Châu', 'Mỹ Lợi', 'Mỹ Phong', 'Mỹ Trinh', 'Mỹ Thọ', 'Mỹ Chánh',
                  'Mỹ Quang', 'Mỹ Hiệp', 'Mỹ Tài', 'Mỹ Cát', 'Mỹ Chánh Tây', 'Vĩnh Thạnh', 'Vĩnh Kim', 'Vĩnh Hiệp',
                  'Vĩnh Thuận', 'Bình Tân', 'Tây Thuận', 'Tây An', 'Tây Bình', 'Bình Tường', 'Tây Vinh', 'Tây Xuân',
                  'Bình Nghi', 'Tây Phú', 'Phù Cát', 'Cát Sơn', 'Cát Minh', 'Cát Khánh', 'Cát Tài', 'Cát Lâm',
                  'Cát Hanh', 'Cát Trinh', 'Cát Hiệp', 'Cát Nhơn', 'Cát Hưng', 'Cát Tường', 'Cát Tiến', 'Cát Thắng',
                  'Cát Chánh', 'An Nhơn', 'Đập Đá', 'Nhơn Mỹ', 'Nhơn Thành', 'Nhơn Hạnh', 'Nhơn Hậu', 'Nhơn Phong',
                  'Nhơn An', 'Nhơn Phúc', 'Nhơn Hưng', 'Nhơn Khánh', 'Nhơn Lộc', 'Nhơn Hoà', 'Nhơn Tân', 'Nhơn Thọ',
                  'Tuy Phước', 'Diêu Trì', 'Phước Thắng', 'Phước Hưng', 'Phước Quang', 'Phước Nghĩa', 'Phước Thuận',
                  'Phước An', 'Canh Liên', 'Canh Hiệp', 'Canh Vinh', 'Canh Hiển', 'Canh Thuận', 'Canh Hòa', 'Tuy Hoà',
                  'Phường 8', 'Phường 9', 'Phường 7', 'Phường 6', 'Phú Thạnh', 'Hòa Kiến', 'Bình Kiến', 'Xuân Cảnh',
                  'Xuân Thọ 1', 'Xuân Thọ 2', 'La Hai', 'Phú Mỡ', 'Xuân Lãnh', 'Xuân Quang 1', 'Xuân Sơn Bắc',
                  'Xuân Quang 2', 'Xuân Sơn Nam', 'Xuân Quang 3', 'Xuân Phước', 'Tuy An', 'Chí Thạnh', 'An Dân',
                  'An Ninh Tây', 'An Ninh Đông', 'An Thạch', 'An Định', 'An Nghiệp', 'An Cư', 'An Lĩnh', 'An Hòa Hải',
                  'An Chấn', 'Sơn Hòa', 'Củng Sơn', 'Phước Tân', 'Sơn Hội', 'Sơn Định', 'Cà Lúi', 'Sơn Phước',
                  'Sơn Xuân', 'Sơn Nguyên', 'Eachà Rang', 'Krông Pa', 'Suối Bạc', 'Suối Trai', 'Sông Hinh', 'Hai Riêng',
                  'Ea Lâm', 'Đức Bình Tây', 'Ea Bá', 'Đức Bình Đông', 'EaBar', 'EaBia', 'EaTrol', 'Ealy', 'Tây Hoà',
                  'Sơn Thành Tây', 'Sơn Thành Đông', 'Hòa Bình 1', 'Hòa Tân Tây', 'Hòa Đồng', 'Hòa Mỹ Đông',
                  'Hòa Mỹ Tây', 'Hòa Thịnh', 'Phú Hoà', 'Hòa Quang Bắc', 'Hòa Quang Nam', 'Hòa Hội', 'Hòa Trị',
                  'Hòa Định Đông', 'Hòa Định Tây', 'Hòa Thành', 'Hoà Vinh', 'Hoà Hiệp Trung', 'Hòa Tân Đông',
                  'Hòa Xuân Tây', 'Hòa Xuân Đông', 'Hòa Tâm', 'Hòa Xuân Nam', 'Nha Trang', 'Vĩnh Hải', 'Vĩnh Phước',
                  'Ngọc Hiệp', 'Vĩnh Thọ', 'Xương Huân', 'Vạn Thạnh', 'Phương Sài', 'Phước Hải', 'Lộc Thọ',
                  'Phước Tiến', 'Vĩnh Nguyên', 'Phước Long', 'Vĩnh Trường', 'Vĩnh Lương', 'Vĩnh Phương', 'Phước Đồng',
                  'Cam Ranh', 'Cam Phúc Bắc', 'Cam Phúc Nam', 'Cam Lộc', 'Cam Phú', 'Ba Ngòi', 'Cam Thuận', 'Cam Lợi',
                  'Cam Linh', 'Cam Thành Nam', 'Cam Phước Đông', 'Cam Thịnh Tây', 'Cam Thịnh Đông', 'Cam Lập',
                  'Cam Bình', 'Cam Tân', 'Cam Hòa', 'Cam Hải Đông', 'Cam Hải Tây', 'Cam Hiệp Bắc', 'Cam Đức',
                  'Cam Hiệp Nam', 'Cam Phước Tây', 'Cam Thành Bắc', 'Cam An Bắc', 'Cam An Nam', 'Suối Cát', 'Suối Tân',
                  'Vạn Giã', 'Vạn Phước', 'Vạn Long', 'Vạn Bình', 'Vạn Khánh', 'Vạn Phú', 'Vạn Lương', 'Vạn Hưng',
                  'Ninh Tây', 'Ninh Thượng', 'Ninh Thọ', 'Ninh Trung', 'Ninh Sim', 'Ninh Thân', 'Ninh Diêm',
                  'Ninh Đông', 'Ninh Thủy', 'Ninh Đa', 'Ninh Phụng', 'Ninh Phú', 'Ninh Tân', 'Ninh Quang', 'Ninh Hà',
                  'Ninh Hưng', 'Ninh Lộc', 'Ninh Ích', 'Khánh Vĩnh', 'Khánh Hiệp', 'Khánh Bình', 'Khánh Đông',
                  'Khánh Nam', 'Giang Ly', 'Cầu Bà', 'Liên Sang', 'Sơn Thái', 'Diên Khánh', 'Diên Lâm', 'Diên Điền',
                  'Diên Xuân', 'Diên Sơn', 'Diên Đồng', 'Diên Phú', 'Diên Thọ', 'Diên Phước', 'Diên Lạc', 'Diên Tân',
                  'Diên Hòa', 'Diên Thạnh', 'Diên Toàn', 'Diên An', 'Bình Lộc', 'Suối Hiệp', 'Suối Tiên', 'Tô Hạp',
                  'Sơn Hiệp', 'Ba Cụm Bắc', 'Ba Cụm Nam', 'Trường Sa', 'Song Tử Tây', 'Sinh Tồn', 'Ninh Thuận',
                  'Phan Rang-Tháp Chàm', 'Đô Vinh', 'Bảo An', 'Phủ Hà', 'Tấn Tài', 'Kinh Dinh', 'Đạo Long', 'Đài Sơn',
                  'Mỹ Đông', 'Thành Hải', 'Mỹ Bình', 'Mỹ Hải', 'Bác Ái', 'Phước Bình', 'Phước Đại', 'Phước Chính',
                  'Phước Trung', 'Ma Nới', 'Nhơn Sơn', 'Phương Hải', 'Tân Hải', 'Hộ Hải', 'Tri Hải', 'Phước Dân',
                  'Phước Thái', 'Phước Hậu', 'An Hải', 'Phước Hữu', 'Phước Vinh', 'Thuận Bắc', 'Phước Chiến',
                  'Công Hải', 'Phước Kháng', 'Lợi Hải', 'Thuận Nam', 'Phước Hà', 'Phước Nam', 'Nhị Hà', 'Phước Dinh',
                  'Phước Minh', 'Phước Diêm', 'Cà Ná', 'Mũi Né', 'Hàm Tiến', 'Phú Hài', 'Phú Tài', 'Phú Trinh',
                  'Bình Hưng', 'Đức Nghĩa', 'Thiện Nghiệp', 'Phong Nẫm', 'Tiến Lợi', 'La Gi', 'Phước Hội', 'Tân Thiện',
                  'Tân Phước', 'Tuy Phong', 'Liên Hương', 'Phan Rí Cửa', 'Phan Dũng', 'Vĩnh Tân', 'Phước Thể',
                  'Chí Công', 'Chợ Lầu', 'Phan Sơn', 'Phan Lâm', 'Phan Điền', 'Sông Lũy', 'Phan Tiến', 'Sông Bình',
                  'Phan Hòa', 'Phan Hiệp', 'Phan Rí Thành', 'Hàm Thuận Bắc', 'Ma Lâm', 'La Dạ', 'Hàm Phú', 'Hồng Liêm',
                  'Hàm Trí', 'Hàm Đức', 'Hàm Liêm', 'Hàm Chính', 'Hàm Hiệp', 'Hàm Thắng', 'Đa Mi', 'Hàm Thuận Nam',
                  'Mỹ Thạnh', 'Hàm Cần', 'Mương Mán', 'Hàm Thạnh', 'Hàm Kiệm', 'Hàm Cường', 'Hàm Mỹ', 'Hàm Minh',
                  'Thuận Quí', 'Tân Thuận', 'Tánh Linh', 'Lạc Tánh', 'Bắc Ruộng', 'Nghị Đức', 'La Ngâu', 'Huy Khiêm',
                  'Măng Tố', 'Đồng Kho', 'Gia An', 'Đức Bình', 'Gia Huynh', 'Suối Kiết', 'Đức Linh', 'Võ Xu', 'Đức Tài',
                  'Đa Kai', 'Sùng Nhơn', 'Mê Pu', 'Đức Tín', 'Vũ Hoà', 'Hàm Tân', 'Tân Nghĩa', 'Sông Phan', 'Thắng Hải',
                  'Sơn Mỹ', 'Phú Quí', 'Ngũ Phụng', 'Long Hải', 'Kon Tum', 'Trường Chinh', 'Đắk Cấm', 'Kroong',
                  'Ngọk Bay', 'Đắk Blà', 'Ia Chim', 'Đăk Năng', 'Chư Hreng', 'Đắk Rơ Wa', 'Đắk Glei', 'Đắk Blô',
                  'Đắk Man', 'Đắk Nhoong', 'Đắk Pék', 'Đắk Choong', 'Xốp', 'Mường Hoong', 'Đắk Long', 'Đắk KRoong',
                  'Đắk Môn', 'Plei Kần', 'Đắk Ang', 'Đắk Dục', 'Đắk Nông', 'Đắk Xú', 'Đắk Kan', 'Bờ Y', 'Sa Loong',
                  'Đắk Tô', 'Đắk Rơ Nga', 'Ngọk Tụ', 'Đắk Trăm', 'Văn Lem', 'Kon Đào', 'Tân Cảnh', 'Diên Bình', 'Pô Kô',
                  'Kon Plông', 'Đắk Nên', 'Đắk Ring', 'Măng Buk', 'Đắk Tăng', 'Ngok Tem', 'Pờ Ê', 'Măng Cành',
                  'Măng Đen', 'Hiếu', 'Kon Rẫy', 'Đắk Rve', 'Đắk Kôi', 'Đắk Tơ Lung', 'Đắk Ruồng', 'Đắk Pne',
                  'Đắk Tờ Re', 'Đắk Hà', 'Đắk PXi', 'Đăk Long', 'Đắk HRing', 'Đắk Ui', 'Đăk Ngọk', 'Đắk Mar',
                  'Ngok Wang', 'Ngok Réo', 'Hà Mòn', 'Đắk La', 'Sa Thầy', 'Rơ Kơi', 'Sa Nhơn', 'Hơ Moong', 'Mô Rai',
                  'Sa Sơn', 'Sa Nghĩa', 'Sa Bình', 'Ya Xiêr', 'Ya Tăng', 'Ya ly', 'Tu Mơ Rông', 'Ngọc Lây', 'Đắk Na',
                  'Măng Ri', 'Ngọc Yêu', 'Đắk Sao', 'Đắk Rơ Ông', 'Đắk Tờ Kan', 'Tê Xăng', 'Văn Xuôi', "Ia H' Drai",
                  'Ia Đal', 'Ia Dom', 'Ia Tơi', 'Gia Lai', 'Pleiku', 'Yên Đỗ', 'Diên Hồng', 'Ia Kring', 'Hội Thương',
                  'Hội Phú', 'Trà Bá', 'Biển Hồ', 'Trà Đa', 'Chư Á', 'Ia Kênh', 'Gào', 'Tú An', 'Cửu An', 'An Phước',
                  'Ayun Pa', 'Cheo Reo', 'Sông Bờ', 'Ia RBol', 'Chư Băh', 'Ia RTô', 'Ia Sao', 'KBang', 'Kon Pne',
                  'Đăk Roong', 'Sơn Lang', 'KRong', 'Sơ Pai', 'Lơ Ku', 'Đông', 'Đak SMar', 'Tơ Tung', 'Kông Lơng Khơng',
                  'Kông Pla', 'Đăk HLơ', 'Đăk Đoa', 'Đăk Sơmei', 'Đăk Krong', 'Hải Yang', 'Kon Gang', 'Hà Bầu',
                  'Nam Yang', "K' Dang", "H' Neng", 'Glar', 'A Dơk', 'Trang', 'HNol', 'Ia Pết', 'Ia Băng', 'Chư Păh',
                  'Hà Tây', 'Ia Khươl', 'Ia Phí', 'Ia Ly', 'Ia Mơ Nông', 'Ia Kreng', 'Đăk Tơ Ver', 'Chư Đăng Ya',
                  'Ia Ka', 'Ia Nhin', 'Ia Grai', 'Ia Kha', 'Ia Yok', 'Ia Hrung', 'Ia Bă', 'Ia Khai', 'Ia KRai',
                  'Ia Grăng', 'Ia Tô', 'Ia O', 'Ia Dêr', 'Ia Chia', 'Ia Pếch', 'Mang Yang', 'Kon Dơng', 'Ayun',
                  'Đak Jơ Ta', 'Đak Ta Ley', 'Hra', 'Đăk Yă', 'Đăk Djrăng', 'Lơ Pang', 'Kon Thụp', 'Đê Ar',
                  'Kon Chiêng', 'Đăk Trôi', 'Kông Chro', 'Chư Krêy', 'Kông Yang', 'Đăk Tơ Pang', 'SRó', 'Đắk Kơ Ning',
                  'Đăk Song', 'Đăk Pling', 'Yang Trung', 'Đăk Pơ Pho', 'Ya Ma', 'Chơ Long', 'Yang Nam', 'Đức Cơ',
                  'Chư Ty', 'Ia Dơk', 'Ia Krêl', 'Ia Din', 'Ia Kla', 'Ia Lang', 'Ia Kriêng', 'Ia Pnôn', 'Ia Nan',
                  'Chư Prông', 'Ia Kly', 'Bình Giáo', 'Ia Drăng', 'Thăng Hưng', 'Bàu Cạn', 'Ia Phìn', 'Ia Tôr',
                  'Ia Boòng', 'Ia Púch', 'Ia Me', 'Ia Vê', 'Ia Bang', 'Ia Pia', 'Ia Ga', 'Ia Lâu', 'Ia Piơr', 'Ia Mơ',
                  'Chư Sê', 'Ia Tiêm', 'Chư Pơng', 'Bar Măih', 'Bờ Ngoong', 'Ia Glai', 'AL Bá', 'Kông HTok', 'AYun',
                  'Ia HLốp', 'Ia Blang', 'Dun', 'Ia Pal', 'H Bông', 'Ia Ko', 'Đăk Pơ', 'Hà Tam', 'An Thành', 'Đak Pơ',
                  'Yang Bắc', 'Cư An', 'Ya Hội', 'Ia Pa', 'Pờ Tó', 'Chư Răng', 'Ia KDăm', 'Chư Mố', 'Ia Tul',
                  'Ia Ma Rơn', 'Ia Broăi', 'Ia Trok', 'Ia RSai', 'Ia RSươm', 'Chư Gu', 'Đất Bằng', 'Ia Mláh',
                  'Chư Drăng', 'Phú Cần', 'Ia HDreh', 'Ia RMok', 'Chư Ngọc', 'Uar', 'Chư Rcăm', 'Krông Năng',
                  'Phú Thiện', 'Chư A Thai', 'Ayun Hạ', 'Ia Ake', 'Ia Sol', 'Ia Piar', 'Ia Peng', 'Chrôh Pơnan',
                  'Ia Hiao', 'Ia Yeng', 'Chư Pưh', 'Ia Hrú', 'Ia Rong', 'Ia Dreng', 'Ia Hla', 'Chư Don', 'Ia Phang',
                  'Ia Le', 'Ia BLứ', 'Đắk Lắk', 'Buôn Ma Thuột', 'Thành Nhất', 'Tự An', 'Ea Tam', 'Hòa Thuận',
                  'Cư ÊBur', 'Ea Tu', 'Ea Kao', 'Hòa Khánh', 'Buôn Hồ', 'Thiện An', 'Đạt Hiếu', 'Ea Blang', 'Ea Drông',
                  'Ea Siên', 'Cư Bao', "Ea H'leo", 'Ea Drăng', 'Ea Sol', 'Ea Ral', 'Ea Wy', 'Cư A Mung', 'Cư Mốt',
                  'Ea Hiao', 'Ea Khal', 'Dliê Yang', 'Ea Tir', 'Ea Nam', 'Ea Súp', 'Ia Lốp', 'Ia JLơi', 'Ea Rốk',
                  'Ya Tờ Mốt', 'Ia RVê', 'Ea Lê', 'Cư KBang', 'Ea Bung', "Cư M'Lan", 'Buôn Đôn', 'Krông Na', 'Ea Huar',
                  'Ea Wer', 'Tân Hoà', 'Cuôr KNia', 'Ea Bar', 'Ea Nuôl', "Cư M'gar", 'Ea Pốk', 'Ea Kuêh', 'Ea Kiết',
                  'Ea Tar', "Cư Dliê M'nông", "Ea H'đinh", 'Ea Tul', 'Ea KPam', "Ea M'DRóh", 'Quảng Hiệp', "Ea D'Rơng",
                  "Ea M'nang", 'Cư Suê', 'Cuor Đăng', 'Krông Búk', 'Cư Né', 'Chư KBô', 'Cư Pơng', 'Ea Sin',
                  'Pơng Drang', 'Ea Ngai', 'ĐLiê Ya', 'Ea Tóh', 'Ea Puk', 'Ea Dăh', 'Ea Hồ', 'Cư Klông', 'Ea Tân',
                  'Ea Kar', 'Ea Knốp', 'Ea Sô', 'Ea Sar', 'Cư Huê', 'Ea Tih', 'Ea Đar', 'Ea Kmút', 'Cư Ni', 'Ea Păl',
                  'Cư Prông', 'Ea Ô', 'Cư ELang', 'Cư Bông', 'Cư Jang', "M'Đrắk", 'Cư Prao', 'Ea Pil', 'Ea Lai',
                  "Ea H'MLay", 'Krông Jing', "Ea M' Doal", 'Ea Riêng', "Cư M'ta", 'Cư K Róa', 'Krông Á', 'Cư San',
                  'Ea Trang', 'Krông Bông', 'Krông Kmar', 'Dang Kang', 'Cư KTy', 'Hòa Tân', 'Hòa Lễ', 'Yang Reh',
                  'Ea Trul', 'Khuê Ngọc Điền', 'Cư Pui', 'Cư Drăm', 'Yang Mao', 'Krông Pắc', 'KRông Búk', 'Ea Kly',
                  'Ea Kênh', 'Ea Phê', 'Ea KNuec', 'Ea Yông', 'Ea Kuăng', 'Hòa Đông', 'Ea Hiu', 'Vụ Bổn', 'Ea Uy',
                  'Ea Yiêng', 'Krông A Na', 'Buôn Trấp', 'Dray Sáp', 'Ea Na', 'Ea Bông', 'Băng A Drênh', 'Dur KMăl',
                  'Lắk', 'Yang Tao', 'Bông Krang', 'Đắk Liêng', 'Buôn Triết', 'Buôn Tría', 'Đắk Phơi', 'Đắk Nuê',
                  'Krông Nô', 'Nam Ka', "Ea R'Bin", 'Cư Kuin', 'Ea Ning', 'Cư Ê Wi', 'Ea Ktur', 'Ea Tiêu', 'Ea BHốk',
                  'Ea Hu', 'Dray Bhăng', 'Hòa Hiệp', 'Gia Nghĩa', "Đăk R'Moan", 'Đắk Nia', 'Đăk Glong', 'Quảng Hoà',
                  'Đắk Ha', "Đắk R'Măng", 'Đắk Plao', 'Đắk Som', 'Cư Jút', "Ea T'Ling", 'Đắk Wil', 'Ea Pô', 'Nam Dong',
                  'Đắk DRông', 'Tâm Thắng', 'Cư Knia', 'Trúc Sơn', 'Đắk Mil', ' Đắk Lao', "Đắk R'La", 'Đắk Gằn',
                  'Đức Mạnh', "Đắk N'Drót", 'Đắk Sắk', 'Đắk Mâm', 'Đắk Sôr', 'Buôn Choah', 'Nam Đà', 'Đắk Drô',
                  'Nâm Nung', 'Đức Xuyên', 'Đắk Nang', "Nâm N'Đir", 'Đắk Song', 'Đức An', 'Đắk Môl', 'Đắk Hòa',
                  'Thuận Hà', 'Thuận Hạnh', "Đắk N'Dung", "Nâm N'Jang", "Đắk R'Lấp", 'Kiến Đức', 'Quảng Tín', 'Đắk Wer',
                  'Nhân Cơ', 'Kiến Thành', 'Đạo Nghĩa', 'Đắk Sin', 'Đắk Ru', 'Tuy Đức', 'Quảng Trực', 'Đắk Búk So',
                  "Đắk R'Tíh", 'Đắk Ngo', 'Lâm Đồng', 'Đà Lạt', 'Phường 12', 'Phường 10', 'Phường 11', 'Tà Nung',
                  'Trạm Hành', 'Bảo Lộc', 'Lộc Phát', "B'lao", 'Đạm Bri', 'Lộc Thanh', 'Lộc Nga', 'Lộc Châu', 'Đại Lào',
                  'Đam Rông', 'Đạ Tông', 'Đạ Long', "Đạ M' Rong", 'Liêng Srônh', 'Đạ Rsal', 'Rô Men', 'Phi Liêng',
                  "Đạ K' Nàng", 'Lạc Dương', 'Đạ Chais', 'Đạ Nhim', 'Đưng KNớ', 'Lát', 'Đạ Sar', 'Lâm Hà', 'Nam Ban',
                  'Đinh Văn', 'Phi Tô', 'Đạ Đờn', 'Đơn Dương', "D'Ran", 'Lạc Xuân', 'Đạ Ròn', 'Lạc Lâm', 'Ka Đô',
                  'Quảng Lập', 'Ka Đơn', 'Tu Tra', 'Pró', 'Đức Trọng', 'Hiệp Thạnh', "N'Thol Hạ", 'Ninh Gia', 'Tà Năng',
                  'Đa Quyn', 'Tà Hine', 'Đà Loan', 'Ninh Loan', 'Di Linh', 'Đinh Trang Thượng', 'Tân Lâm', 'Gia Hiệp',
                  'Đinh Lạc', 'Tam Bố', 'Đinh Trang Hòa', 'Liên Đầm', 'Gung Ré', 'Bảo Thuận', 'Hòa Trung', 'Sơn Điền',
                  'Gia Bắc', 'Lộc Thắng', 'Lộc Bảo', 'Lộc Lâm', 'Lộc Phú', 'Lộc Bắc', "B' Lá", 'Lộc Ngãi', 'Lộc Quảng',
                  'Lộc Tân', 'Lộc Đức', 'Lộc Thành', 'Lộc Nam', 'Đạ Huoai', "Đạ M'ri", 'Ma Đa Guôi', 'Hà Lâm', 'Đạ Tồn',
                  'Đạ Oai', 'Đạ Ploa', 'Đạ Tẻh', 'Đạ Lây', 'Triệu Hải', 'Đạ Kho', 'Đạ Pal', 'Cát Tiên', 'Tiên Hoàng',
                  'Phước Cát 2', 'Nam Ninh', 'Phước Cát ', 'Đồng Nai Thượng', 'Thác Mơ', 'Long Thủy', 'Long Phước',
                  'Long Giang', 'Phước Tín', 'Đồng Xoài', 'Tiến Hưng', 'Hưng Chiến', 'An Lộc', 'Phú Đức', 'Thanh Phú',
                  'Bù Gia Mập', 'Đak Ơ', 'Phú Văn', 'Đa Kia', 'Bình Thắng', 'Lộc Tấn', 'Lộc Thạnh', 'Lộc Hiệp',
                  'Lộc Thiện', 'Lộc Thuận', 'Lộc Quang', 'Lộc Thái', 'Lộc Hưng', 'Lộc Khánh', 'Bù Đốp', 'Hưng Phước',
                  'Phước Thiện', 'Thiện Hưng', 'Hớn Quản', 'An Khương', 'Tân Khai', 'Đồng Nơ', 'Tân Quan', 'Thuận Lợi',
                  'Thuận Phú', 'Bù Đăng', 'Đường 10', 'Đak Nhau', 'Bom Bo', 'Minh Hưng', 'Đồng Nai', 'Đức Liễu',
                  'Đăng Hà', 'Chơn Thành', 'Nha Bích', 'Minh Thắng', 'Phú Riềng', 'Long Bình', 'Bù Nho', 'Long Hà',
                  'Long Tân', 'Phú Trung', 'Hiệp Ninh', 'Thạnh Tân', 'Ninh Thạnh', 'Tân Biên', 'Thạnh Bắc',
                  'Thạnh Bình', 'Thạnh Tây', 'Mỏ Công', 'Trà Vong', 'Tân Đông', 'Suối Ngô', 'Suối Dây', 'Thạnh Đông',
                  'Dương Minh Châu', 'Suối Đá', 'Phan', 'Bàu Năng', 'Chà Là', 'Cầu Khởi', 'Bến Củi', 'Truông Mít',
                  'Hảo Đước', 'Đồng Khởi', 'An Cơ', 'Biên Giới', 'Hòa Thạnh', 'Trí Bình', 'Thanh Điền', 'Ninh Điền',
                  'Long Vĩnh', 'Long Hoa', 'Hiệp Tân', 'Long Thành Bắc', 'Trường Hòa', 'Trường Đông',
                  'Long Thành Trung', 'Trường Tây', 'Long Thành Nam', 'Gò Dầu', 'Thạnh Đức', 'Bàu Đồn', 'Phước Thạnh',
                  'Phước Đông', 'Phước Trạch', 'Thanh Phước', 'Bến Cầu', 'Long Chữ', 'Tiên Thuận', 'Long Khánh',
                  'Lợi Thuận', 'Long Thuận', 'An Thạnh', 'Trảng Bàng', 'Đôn Thuận', 'Hưng Thuận', 'An Tịnh',
                  'Phước Chỉ', 'Thủ Dầu Một', 'Hiệp Thành', 'Phú Lợi', 'Chánh Nghĩa', 'Định Hoà', 'Hoà Phú', 'Phú Tân',
                  'Tương Bình Hiệp', 'Chánh Mỹ', 'Bàu Bàng', 'Trừ Văn Thố', 'Cây Trường II', 'Lai Uyên', 'Long Nguyên',
                  'Lai Hưng', 'Dầu Tiếng', 'Minh Hoà', 'Minh Thạnh', 'Định An', 'Long Hoà', 'Định Hiệp', 'An Lập',
                  'Bến Cát', 'Mỹ Phước', 'Chánh Phú Hòa', 'An Điền', 'Thới Hòa', 'Hòa Lợi', 'Tân Định', 'Phú Giáo',
                  'An Linh', 'Phước Sang', 'An Long', 'Tam Lập', 'Vĩnh Hoà', 'Uyên Hưng', 'Tân Phước Khánh',
                  'Hội Nghĩa', 'Phú Chánh', 'Tân Vĩnh Hiệp', 'Thạnh Phước', 'Thạnh Hội', 'Dĩ An', 'Tân Đông Hiệp',
                  'Lái Thiêu', 'Thuận Giao', 'Hưng Định', 'Bình Nhâm', 'Vĩnh Phú', 'Bắc Tân Uyên', 'Đất Cuốc',
                  'Hiếu Liêm', 'Lạc An', 'Thường Tân', 'Biên Hòa', 'Trảng Dài', 'Hố Nai', 'Bửu Long', 'Bình Đa',
                  'Bửu Hòa', 'Long Bình Tân', 'Tân Vạn', 'Tân Hạnh', 'Hóa An', 'Xuân Thanh', 'Bảo Quang', 'Suối Tre',
                  'Bảo Vinh', 'Bàu Sen', 'Bàu Trâm', 'Hàng Gòn', 'Dak Lua', 'Nam Cát Tiên', 'Núi Tượng', 'Tà Lài',
                  'Phú Lập', 'Vĩnh Cửu', 'Phú Lý', 'Trị An', 'Bình Lợi', 'Thạnh Phú', 'Mã Đà', 'Định Quán', 'Ngọc Định',
                  'La Ngà', 'Gia Canh', 'Phú Ngọc', 'Túc Trưng', 'Suối Nho', 'Trảng Bom', 'Cây Gáo', 'Bàu Hàm',
                  'Sông Thao', 'Sông Trầu', 'Đông Hoà', 'Hố Nai 3', 'Đồi 61', 'Giang Điền', 'An Viễn', 'Gia Tân 1',
                  'Gia Tân 2', 'Gia Tân 3', 'Gia Kiệm', 'Bàu Hàm 2', 'Lộ 25', 'Xuân Thiện', 'Dầu Giây', 'Sông Nhạn',
                  'Xuân Quế', 'Xuân Đường', 'Long Giao', 'Thừa Đức', 'Bảo Bình', 'Xuân Bảo', 'Xuân Tây', 'Xuân Đông',
                  'Sông Ray', 'Lâm San', 'Long Đức', 'Cẩm Đường', 'Long An', 'Gia Ray', 'Suối Cao', 'Xuân Tâm',
                  'Xuân Hiệp', 'Xuân Định', 'Bảo Hoà', 'Lang Minh', 'Nhơn Trạch', 'Phước Thiền', 'Đại Phước',
                  'Hiệp Phước', 'Phú Hữu', 'Long Thọ', 'Vĩnh Thanh', 'Phước Khánh', 'Bà Rịa - Vũng Tàu', 'Vũng Tàu',
                  'Thắng Tam', 'Thắng Nhì', 'Nguyễn An Ninh', 'Thắng Nhất', 'Rạch Dừa', 'Bà Rịa', 'Phước Nguyên',
                  'Long Toàn', 'Long Tâm', 'Long Hương', 'Kim Dinh', 'Hoà Long', 'Châu Đức', 'Bàu Chinh', 'Ngãi Giao',
                  'Bình Ba', 'Suối Nghệ', 'Bình Giã', 'Xà Bang', 'Cù Bị', 'Láng Lớn', 'Suối Rao', 'Đá Bạc', 'Xuyên Mộc',
                  'Phước Bửu', 'Bông Trang', 'Bàu Lâm', 'Hòa Hưng', 'Bưng Riềng', 'Long Điền', 'An Ngãi', 'An Nhứt',
                  'Phước Tỉnh', 'Đất Đỏ', 'Phước Long Thọ', 'Long Mỹ', 'Láng Dài', 'Mỹ Xuân', 'Sông Xoài', 'Hắc Dịch',
                  'Châu Pha', 'Tóc Tiên', 'Côn Đảo', 'Hồ Chí Minh', 'Quận 1', 'Đa Kao', 'Bến Nghé', 'Bến Thành',
                  'Nguyễn Thái Bình', 'Cầu Ông Lãnh', 'Cô Giang', 'Nguyễn Cư Trinh', 'Cầu Kho', 'Quận 12', 'Thạnh Xuân',
                  'Thạnh Lộc', 'Thới An', 'Tân Chánh Hiệp', 'An Phú Đông', 'Tân Thới Hiệp', 'Trung Mỹ Tây',
                  'Tân Hưng Thuận', 'Đông Hưng Thuận', 'Tân Thới Nhất', 'Thủ Đức', 'Linh Xuân', 'Bình Chiểu',
                  'Linh Trung', 'Tam Bình', 'Hiệp Bình Phước', 'Hiệp Bình Chánh', 'Linh Chiểu', 'Linh Tây', 'Linh Đông',
                  'Bình Thọ', 'Quận 9', 'Long Thạnh Mỹ', 'Hiệp Phú', 'Tăng Nhơn Phú A', 'Tăng Nhơn Phú B',
                  'Phước Long B', 'Phước Long A', 'Trường Thạnh', 'Long Trường', 'Gò Vấp', 'Phường 15', 'Phường 13',
                  'Phường 17', 'Phường 16', 'Phường 14', 'Phường 05', 'Phường 07', 'Phường 04', 'Phường 01',
                  'Phường 03', 'Phường 27', 'Phường 26', 'Phường 25', 'Phường 24', 'Phường 06', 'Phường 02',
                  'Phường 21', 'Phường 22', 'Phường 19', 'Phường 28', 'Phường 08', 'Phường 09', 'Tân Sơn Nhì',
                  'Tây Thạnh', 'Tân Quý', 'Phú Thọ Hòa', 'Tân Thới Hòa', 'Quận 2', 'Thảo Điền', 'Bình Trưng Đông',
                  'Bình Trưng Tây', 'Bình Khánh', 'Cát Lái', 'Thạnh Mỹ Lợi', 'An Lợi Đông', 'Thủ Thiêm', 'Quận 3',
                  'Quận 10', 'Quận 11', 'Quận 4', 'Phường 18', 'Quận 5', 'Quận 6', 'Quận 8', 'Bình Hưng Hòa',
                  'Bình Hưng Hoà A', 'Bình Hưng Hoà B', 'Bình Trị Đông', 'Bình Trị Đông A', 'Bình Trị Đông B',
                  'Tân Tạo', 'Tân Tạo A', ' An Lạc', 'An Lạc A', 'Quận 7', 'Tân Thuận Đông', 'Tân Thuận Tây',
                  'Tân Kiểng', 'Tân Quy', 'Củ Chi', 'Phú Mỹ Hưng', 'Trung Lập Thượng', 'An Nhơn Tây', 'Nhuận Đức',
                  'Phạm Văn Cội', 'Phú Hòa Đông', 'Trung Lập Hạ', 'Tân An Hội', 'Phước Vĩnh An', 'Thái Mỹ',
                  'Tân Thạnh Tây', 'Tân Thạnh Đông', 'Tân Phú Trung', 'Tân Thông Hội', 'Hóc Môn', 'Nhị Bình',
                  'Đông Thạnh', 'Tân Thới Nhì', 'Thới Tam Thôn', 'Xuân Thới Sơn', 'Xuân Thới Đông', 'Trung Chánh',
                  'Xuân Thới Thượng', 'Bà Điểm', 'Tân Túc', 'Phạm Văn Hai', 'Vĩnh Lộc A', 'Vĩnh Lộc B', 'Lê Minh Xuân',
                  'Tân Nhựt', 'Tân Kiên', 'An Phú Tây', 'Đa Phước', 'Tân Quý Tây', 'Quy Đức', 'Nhà Bè', 'Phước Kiển',
                  'Nhơn Đức', 'Long Thới', 'Cần Giờ', 'Cần Thạnh', 'Tam Thôn Hiệp', 'An Thới Đông', 'Thạnh An',
                  'Long Hòa', 'Lý Nhơn', 'Hướng Thọ Phú', 'Nhơn Thạnh Trung', 'Lợi Bình Nhơn', 'Bình Tâm', 'Khánh Hậu',
                  'An Vĩnh Ngãi', 'Kiến Tường', 'Thạnh Trị', 'Tuyên Thạnh', 'Thạnh Hưng', 'Hưng Điền B', 'Hưng Điền',
                  'Hưng Thạnh', 'Vĩnh Châu B', 'Vĩnh Đại', 'Vĩnh Châu A', 'Vĩnh Bửu', 'Hưng Điền A', 'Khánh Hưng',
                  'Thái Trị', 'Vĩnh Trị', 'Thái Bình Trung', 'Vĩnh Bình', 'Tuyên Bình', 'Tuyên Bình Tây', 'Mộc Hóa',
                  'Bình Hòa Tây', 'Bình Hòa Trung', 'Bình Hòa Đông', 'Bình Phong Thạnh', 'Bắc Hòa', 'Hậu Thạnh Tây',
                  'Nhơn Hòa Lập', 'Hậu Thạnh Đông', 'Kiến Bình', 'Nhơn Ninh', 'Thạnh Hóa', 'Thuận Bình',
                  'Thuận Nghĩa Hòa', 'Thủy Đông', 'Thủy Tây', 'Tân Tây', 'Đức Huệ', 'Mỹ Quý Đông', 'Mỹ Thạnh Bắc',
                  'Mỹ Quý Tây', 'Mỹ Thạnh Tây', 'Mỹ Thạnh Đông', 'Bình Hòa Bắc', 'Bình Hòa Hưng', 'Bình Hòa Nam',
                  'Hậu Nghĩa', 'Lộc Giang', 'Đức Lập Thượng', 'Đức Lập Hạ', 'Mỹ Hạnh Bắc', 'Đức Hòa Thượng',
                  'Hòa Khánh Tây', 'Hòa Khánh Đông', 'Mỹ Hạnh Nam', 'Đức Hòa Đông', 'Đức Hòa Hạ', 'Hựu Thạnh',
                  'Bến Lức', 'Thạnh Lợi', 'Lương Bình', 'Thạnh Hòa', 'Lương Hòa', 'Tân Bửu', 'Bình Đức', 'Phước Lợi',
                  'Nhựt Chánh', 'Thủ Thừa', 'Long Thạnh', 'Mỹ Lạc', 'Nhị Thành', 'Mỹ Phú', 'Tân Trụ', 'Quê Mỹ Thạnh',
                  'Lạc Tấn', 'Bình Trinh Đông', 'Tân Phước Tây', 'Bình Lãng', 'Bình Tịnh', 'Nhựt Ninh', 'Cần Đước',
                  'Long Trạch', 'Long Khê', 'Long Định', 'Phước Vân', 'Long Cang', 'Mỹ Lệ', 'Tân Lân', 'Phước Tuy',
                  'Long Hựu Đông', 'Tân Ân', 'Long Hựu Tây', 'Tân Chánh', 'Cần Giuộc', 'Phước Lý', 'Long Thượng',
                  'Long Hậu', 'Phước Lại', 'Phước Lâm', 'Phước Vĩnh Tây', 'Phước Vĩnh Đông', 'Long Phụng', 'Tân Tập',
                  'Tầm Vu', 'Bình Quới', 'Phú Ngãi Trị', 'Vĩnh Công', 'Thuận Mỹ', 'Phước Tân Hưng', 'Thanh Phú Long',
                  'Dương Xuân Hội', 'An Lục Long', 'Long Trì', 'Thanh Vĩnh Đông', 'Tiền Giang', 'Mỹ Tho', 'Đạo Thạnh',
                  'Tân Mỹ Chánh', 'Thới Sơn', 'Gò Công', 'Long Chánh', 'Bình Xuân', 'Cai Lậy', 'Mỹ Phước Tây',
                  'Mỹ Hạnh Đông', 'Mỹ Hạnh Trung', 'Nhị Mỹ', 'Nhị Quý', 'Phú Quý', 'Tân Hòa Đông', 'Thạnh Hoà',
                  'Tân Hòa Thành', 'Tân Lập 1', 'Tân Hòa Tây', 'Tân Lập 2', 'Phước Lập', 'Cái Bè', 'Hậu Mỹ Bắc B',
                  'Hậu Mỹ Bắc A', 'Hậu Mỹ Trinh', 'Hậu Mỹ Phú', 'Mỹ Lợi B', 'Thiện Trung', 'Mỹ Hội', 'Mỹ Lợi A',
                  'Thiện Trí', 'Mỹ Đức Đông', 'Mỹ Đức Tây', 'Đông Hòa Hiệp', 'An Thái Đông', 'An Thái Trung', 'An Hữu',
                  'Mỹ Thành Bắc', 'Mỹ Thành Nam', 'Mỹ Long', 'Long Tiên', 'Long Trung', 'Hội Xuân', 'Tân Hội Đông',
                  'Tân Lý Đông', 'Tân Lý Tây', 'Thân Cửu Nghĩa', 'Điềm Hy', 'Dưỡng Điềm', 'Hữu Đạo', 'Bình Trưng',
                  'Bàn Long', 'Song Thuận', 'Chợ Gạo', 'Hòa Tịnh', 'Mỹ Tịnh An', 'Tân Bình Thạnh', 'Phú Kiết',
                  'Lương Hòa Lạc', 'Quơn Long', 'Bình Phục Nhứt', 'Đăng Hưng Phước', 'Tân Thuận Bình', 'Song Bình',
                  'Bình Phan', 'Long Bình Điền', 'An Thạnh Thủy', 'Hòa Định', 'Bình Ninh', 'Gò Công Tây', 'Đồng Thạnh',
                  'Bình Nhì', 'Yên Luông', 'Thạnh Nhựt', 'Vĩnh Hựu', 'Gò Công Đông', 'Tăng Hoà', 'Gia Thuận',
                  'Vàm Láng', 'Kiểng Phước', 'Bình Ân', 'Tân Điền', 'Bình Nghị', 'Tân Phú Đông', 'Tân Thới', 'Bến Tre',
                  'Phú Khương', 'An Hội', 'Phú Hưng', 'Mỹ Thạnh An', 'Nhơn Thạnh', 'Tân Thạch', 'Qưới Sơn',
                  'Phú An Hòa', 'Thành Triệu', 'Tường Đa', 'Quới Thành', 'An Hóa', 'Tiên Long', 'Hữu Định', 'Tiên Thủy',
                  'Chợ Lách', 'Phú Phụng', 'Hòa Nghĩa', 'Tân Thiềng', 'Hưng Khánh Trung B', 'Mỏ Cày Nam', 'Mỏ Cày',
                  'Định Thủy', 'Đa Phước Hội', 'Bình Khánh ', 'Thành Thới B', 'An Thới', 'Thành Thới A', 'Ngãi Đăng',
                  'Hương Mỹ', 'Giồng Trôm', 'Châu Hòa', 'Lương Quới', 'Thuận Điền', 'Bình Hoà', 'Hưng Phong', 'Tân Hào',
                  'Tân Lợi Thạnh', 'Thạnh Phú Đông', 'Hưng Nhượng', 'Hưng Lễ', 'Bình Đại', 'Vang Quới Tây',
                  'Vang Quới Đông', 'Châu Hưng', 'Thới Lai', 'Bình Thới', 'Đại Hòa Lộc', 'Thới Thuận', 'Ba Tri',
                  'Bảo Thạnh', 'An Phú Trung', 'Mỹ Nhơn', 'Phước Ngãi', 'An Ngãi Trung', 'Phú Lễ', 'An Bình Tây',
                  'An Ngãi Tây', 'An Hòa Tây', 'Đại Điền', 'Quới Điền', 'Thới Thạnh', 'An Thuận', 'An Quy', 'Thạnh Hải',
                  'Giao Thạnh', 'Thạnh Phong', 'Mỏ Cày Bắc', 'Hưng Khánh Trung A', 'Thạnh Ngãi', 'Tân Phú Tây',
                  'Phước Mỹ Trung', 'Tân Thành Bình', 'Tân Thanh Tây', 'Nhuận Phú Tân', 'Khánh Thạnh Tân', 'Càng Long',
                  'Mỹ Cẩm', 'An Trường A', 'An Trường', 'Huyền Hội', 'Phương Thạnh', 'Nhị Long Phú', 'Nhị Long',
                  'Đức Mỹ', 'Cầu Kè', 'Hòa Ân', 'Châu Điền', 'An Phú Tân', 'Hoà Tân', 'Ninh Thới', 'Phong Thạnh',
                  'Tam Ngãi', 'Thông Hòa', 'Tiểu Cần', 'Cầu Quan', 'Hiếu Tử', 'Hiếu Trung', 'Hùng Hòa', 'Tân Hùng',
                  'Tập Ngãi', 'Ngãi Hùng', 'Lương Hoà A', 'Song Lộc', 'Nguyệt Hóa', 'Phước Hảo', 'Cầu Ngang',
                  'Mỹ Long Bắc', 'Mỹ Long Nam', 'Kim Hòa', 'Nhị Trường', 'Hiệp Mỹ Đông', 'Hiệp Mỹ Tây', 'Thạnh Hòa Sơn',
                  'Trà Cú', 'Tập Sơn', 'An Quảng Hữu', 'Lưu Nghiệp Anh', 'Ngãi Xuyên', 'Hàm Giang', 'Ngọc Biên',
                  'Đôn Xuân', 'Đôn Châu', 'Ngũ Lạc', 'Long Hữu', 'Dân Thành', 'Trường Long Hòa', 'Tân Ngãi', 'Long Hồ',
                  'Bình Hòa Phước', 'Phú Quới', 'Thạnh Quới', 'Mang Thít', 'Cái Nhum', 'Chánh An', 'Tân Long Hội',
                  ' Vũng Liêm', 'Vũng Liêm', 'Tân Quới Trung', 'Quới Thiện', 'Quới An', 'Tân An Luông',
                  'Trung Thành Tây', 'Trung Hiệp', 'Hiếu Phụng', 'Trung Thành Đông', 'Trung Hiếu', 'Trung Ngãi',
                  'Hiếu Thuận', 'Hiếu Nhơn', 'Hiếu Thành', 'Hiếu Nghĩa', 'Hoà Lộc', 'Song Phú', 'Long Phú',
                  'Mỹ Thạnh Trung', 'Tường Lộc', 'Loan Mỹ', 'Ngãi Tứ', 'Cái Vồn', 'Thành Phước', 'Đông Bình',
                  'Đông Thuận', 'Trà Ôn', 'Trà Côn', 'Hựu Thành', 'Vĩnh Xuân', 'Thuận Thới', 'Thiện Mỹ', 'Lục Sỹ Thành',
                  'Tích Thiện', 'Thành Trung', 'Tân An Thạnh', 'Tân Lược', 'Nguyễn Văn Thảnh', 'Tân Quới', 'Cao Lãnh',
                  'Mỹ Ngãi', 'Mỹ Trà', 'Tịnh Thới', 'Sa Đéc', 'Tân Khánh Đông', 'Tân Quy Đông', 'Tân Quy Tây',
                  'Hồng Ngự', 'An Bình B', 'An Bình A', 'Sa Rài', 'Tân Hộ Cơ', 'Thông Bình', 'Tân Thành A',
                  'Tân Thành B', 'Tân Công Chí', 'Thường Phước 1', 'Thường Thới Hậu A', 'Thường Thới Tiền',
                  'Thường Phước 2', 'Thường Lạc', 'Long Khánh A', 'Long Khánh B', 'Phú Thuận B', 'Phú Thuận A',
                  'Tràm Chim', 'Tân Công Sính', 'Phú Thành B', 'Phú Thành A', 'Tháp Mười', 'Tân Kiều', 'Mỹ Quý',
                  'Đốc Binh Kiều', 'Láng Biển', 'Gáo Giồng', 'Phương Thịnh', 'Phương Trà', 'Tân Hội Trung',
                  'Bình Hàng Trung', 'Mỹ Xương', 'Bình Hàng Tây', 'An Phong', 'Bình Tấn', 'Tân Huề', 'Lấp Vò',
                  'Mỹ An Hưng A', 'Mỹ An Hưng B', 'Tân  Khánh Trung', 'Long Hưng A', 'Long Hưng B', 'Định Yên',
                  'Hội An Đông', 'Bình Thạnh Trung', 'Lai Vung', 'Long Thắng', 'Vĩnh Thới', 'Cái Tàu Hạ',
                  'Tân Nhuận Đông', 'An Phú Thuận', 'Phú Hựu', 'An Giang', 'Mỹ Xuyên', 'Mỹ Thới', 'Mỹ Khánh',
                  'Mỹ Hoà Hưng', 'Châu Đốc', 'Châu Phú B', 'Châu Phú A', 'Vĩnh Mỹ', 'Núi Sam', 'Vĩnh Ngươn', 'Vĩnh Tế',
                  'Vĩnh Châu', 'Quốc Thái', 'Vĩnh Hậu', 'Vĩnh Hội Đông', 'Vĩnh Xương', 'Phú Vĩnh', 'Lê Chánh',
                  'Chợ Vàm', 'Hiệp Xương', 'Bình Thạnh Đông', 'Châu Phú', 'Cái Dầu', 'Ô Long Vỹ', 'Vĩnh Thạnh Trung',
                  'Thạnh Mỹ Tây', 'Bình Thủy', 'Đào Hữu Cảnh', 'Tịnh Biên', 'Nhà Bàng', 'Núi Voi', 'Văn Giáo', 'An Hảo',
                  'Tri Tôn', 'Ba Chúc', 'Lạc Quới', 'Lê Trì', 'Vĩnh Gia', 'Châu Lăng', 'Lương Phi', 'Lương An Trà',
                  'Tà Đảnh', 'Núi Tô', 'An Tức', 'Tân Tuyến', 'Ô Lâm', 'Cần Đăng', 'Vĩnh Hanh', 'Hòa Bình Thạnh',
                  'Vĩnh Nhuận', 'Mỹ Luông', 'Mỹ Hội Đông', 'Long Điền A', 'Tấn Mỹ', 'Long Điền B', 'Long Kiến',
                  'Bình Phước Xuân', 'An Thạnh Trung', 'Thoại Sơn', 'Núi Sập', 'Óc Eo', 'Vĩnh Trạch', 'Vĩnh Chánh',
                  'Định Mỹ', 'Mỹ Phú Đông', 'Vọng Đông', 'Vĩnh Khánh', 'Thoại Giang', 'Vọng Thê', 'Kiên Giang',
                  'Rạch Giá', 'Vĩnh Thanh Vân', 'Rạch Sỏi', 'Vĩnh Thông', 'Phi Thông', 'Hà Tiên', 'Tô Châu', 'Đông Hồ',
                  'Bình San', 'Pháo Đài', 'Thuận Yên', 'Kiên Lương', 'Kiên Bình', 'Hòa Điền', 'Hòn Nghệ', 'Hòn Đất',
                  'Nam Thái Sơn', 'Mỹ Hiệp Sơn', 'Sơn Kiên', 'Lình Huỳnh', 'Thổ Sơn', 'Tân Hiệp B', 'Thạnh Đông B',
                  'Tân Hiệp A', 'Thạnh Đông A', 'Mong Thọ A', 'Mong Thọ B', 'Mong Thọ', 'Giục Tượng', 'Vĩnh Hòa Hiệp',
                  'Vĩnh Hoà Phú', 'Giồng Riềng', 'Bàn Thạch', 'Bàn Tân Định', 'Ngọc Thành', 'Ngọc Chúc', 'Ngọc Thuận',
                  'Hoà Lợi', ' Hòa Thuận', 'Ngọc Hoà', 'Gò Quao', 'Vĩnh Hòa Hưng Bắc', 'Thới Quản', 'Thủy Liễu',
                  'Vĩnh Hòa Hưng Nam', 'Vĩnh Phước A', 'Vĩnh Phước B', 'Vĩnh Thắng', 'Thứ Ba', 'Tây Yên', 'Tây Yên A',
                  'Nam Yên', 'Nam Thái A', 'Đông Thái', 'An Minh', 'Thứ Mười Một', 'Đông Hưng A', 'Đông Hưng B',
                  'Vân Khánh', 'Vân Khánh Đông', 'Vân Khánh Tây', 'Vĩnh Bình Bắc', 'Vĩnh Bình Nam', 'Phong Đông',
                  'Phú Quốc', 'Dương Đông', 'Cửa Cạn', 'Gành Dầu', 'Cửa Dương', 'Dương Tơ', 'Hòn Thơm', 'Bãi Thơm',
                  'Thổ Châu', 'Kiên Hải', 'Hòn Tre', 'Lại Sơn', 'Nam Du', 'U Minh Thượng', 'Thạnh Yên', 'Thạnh Yên A',
                  'An Minh Bắc', 'Hoà Chánh', 'Giang Thành', 'Vĩnh Điều', 'Tân Khánh Hòa', 'Cần Thơ', 'Ninh Kiều',
                  'Cái Khế', 'Thới Bình', 'Xuân Khánh', 'Ô Môn', 'Châu Văn Liêm', 'Thới Long', 'Phước Thới',
                  'Trường Lạc', 'Bình Thuỷ', 'Trà An', 'Trà Nóc', 'Thới An Đông', 'Bùi Hữu Nghĩa', 'Long Tuyền',
                  'Cái Răng', 'Lê Bình', 'Hưng Phú', 'Ba Láng', 'Thường Thạnh', 'Thốt Nốt', 'Trung Nhứt', 'Thuận Hưng',
                  'Vĩnh Trinh', 'Thạnh Tiến', 'Thạnh Thắng', 'Thạnh Qưới', 'Cờ Đỏ', 'Trung Thạnh', 'Thới Hưng',
                  'Đông Hiệp', 'Đông Thắng', 'Thới Đông', 'Thới Xuân', 'Nhơn Ái', 'Trường Long', 'Nhơn Nghĩa',
                  'Thới Tân', 'Trường Thắng', 'Định Môn', 'Trường Xuân A', 'Trường Xuân B', 'Hậu Giang', 'Vị Thanh',
                  'I', 'III', 'IV', 'V', 'VII', 'Vị Tân', 'Hoả Lựu', 'Hoả Tiến', 'Ngã Bảy', 'Lái Hiếu', 'Hiệp Lợi',
                  'Châu Thành A', 'Một Ngàn', 'Bảy Ngàn', 'Trường Long Tây', 'Trường Long A', 'Nhơn Nghĩa A',
                  'Rạch Gòi', 'Cái Tắc', 'Tân Phú Thạnh', 'Ngã Sáu', 'Mái Dầm', 'Đông Phước', 'Đông Phước A',
                  'Phụng Hiệp', 'Kinh Cùng', 'Cây Dương', 'Hòa Mỹ', 'Phương Bình', 'Hiệp Hưng', 'Tân Phước Hưng',
                  'Búng Tàu', 'Phương Phú', 'Vị Thuỷ', 'Nàng Mau', 'Vị Trung', 'Vị Thắng', 'Vĩnh Thuận Tây', 'Vị Đông',
                  'Vị Bình', 'Vĩnh Thuận Đông', 'Vĩnh Viễn', 'Vĩnh Viễn A', 'Lương Tâm', 'Lương Nghĩa', 'Xà Phiên',
                  'Trà Lồng', 'Long Trị', 'Long Trị A', 'Sóc Trăng', 'Hồ Đắc Kiện', 'Phú Tâm', 'Kế Sách', 'An Lạc Thôn',
                  'An Lạc Tây', 'Trinh Phú', 'Ba Trinh', 'Thới An Hội', 'Kế Thành', 'Kế An', 'Đại Hải', 'Mỹ Tú',
                  'Huỳnh Hữu Nghĩa', 'Cù Lao Dung', 'An Thạnh 1', 'An Thạnh Tây', 'An Thạnh Đông', 'Đại Ân 1',
                  'An Thạnh 2', 'An Thạnh 3', 'An Thạnh Nam', 'Song Phụng', 'Đại Ngãi', 'Hậu Thạnh', 'Trường Khánh',
                  'Châu Khánh', 'Đại Tâm', 'Tham Đôn', 'Ngọc Đông', 'Hòa Tú 1', 'Gia Hòa 1', 'Ngọc Tố', 'Gia Hòa 2',
                  'Hòa Tú II', 'Ngã Năm', 'Vĩnh Quới', 'Mỹ Quới', 'Lâm Tân', 'Lâm Kiết', 'Tuân Tức', 'Lạc Hòa',
                  'Lai Hòa', 'Trần Đề', 'Đại Ân  2', 'Liêu Tú', 'Lịch Hội Thượng', 'Trung Bình', 'Tài Văn',
                  'Thạnh Thới An', 'Thạnh Thới Thuận', 'Viên Bình', 'Bạc Liêu', 'Nhà Mát', 'Vĩnh Trạch Đông',
                  'Hồng Dân', 'Ngan Dừa', 'Ninh Quới', 'Ninh Quới A', 'Ninh Thạnh Lợi A', 'Ninh Thạnh Lợi',
                  'Vĩnh Phú Đông', 'Vĩnh Phú Tây', 'Phong Thạnh Tây A', 'Phong Thạnh Tây B', 'Vĩnh Hưng A',
                  'Châu Hưng A', 'Hưng Hội', 'Châu Thới', 'Giá Rai', 'Hộ Phòng', 'Phong Thạnh Đông', 'Láng Tròn',
                  'Phong Tân', 'Phong Thạnh A', 'Phong Thạnh Tây', 'Gành Hào', 'Long Điền Đông', 'Long Điền Đông A',
                  'Long Điền Tây', 'An Trạch', 'An Trạch A', 'An Phúc', 'Định Thành A', 'Minh Diệu', 'Vĩnh Mỹ B',
                  'Vĩnh Hậu A', 'Vĩnh Mỹ A', 'Cà Mau', 'Tân Xuyên', 'An Xuyên', 'Tắc Vân', 'Lý Văn Lâm', 'U Minh',
                  'Khánh Thuận', 'Khánh Tiến', 'Nguyễn Phích', 'Khánh Lâm', 'Biển Bạch', 'Tân Bằng', 'Trí Phải',
                  'Trí Lực', 'Biển Bạch Đông', 'Tân Lộc Bắc', 'Tân Lộc Đông', 'Hồ Thị Kỷ', 'Trần Văn Thời', 'Sông Đốc',
                  'Khánh Bình Tây Bắc', 'Khánh Bình Tây', 'Trần Hợi', 'Khánh Lộc', 'Khánh Bình Đông', 'Lợi An',
                  'Phong Lạc', 'Cái Nước', 'Lương Thế Trân', 'Hoà Mỹ', 'Đông Thới', 'Tân Hưng Đông', 'Trần Thới',
                  'Đầm Dơi', 'Tạ An Khương', 'Tạ An Khương  Đông', 'Trần Phán', 'Tạ An Khương  Nam', 'Tân Duyệt',
                  'Quách Phẩm Bắc', 'Quách Phẩm', 'Ngọc Chánh', 'Nguyễn Huân', 'Năm Căn', 'Hiệp Tùng', 'Đất Mới',
                  'Lâm Hải', 'Hàng Vịnh', 'Tam Giang Đông', 'Cái Đôi Vàm', 'Việt Thắng', 'Tân Hưng Tây', 'Rạch Chèo',
                  'Nguyễn Việt Khái', 'Ngọc Hiển', 'Tam Giang Tây', 'Tân Ân Tây', 'Viên An Đông', 'Rạch Gốc', 'Đất Mũi']
# result = {}
# for w in STANDARD_WORDS:
#     word_lower = w.lower()
#     new_words = []
#     for i in range(SPELL_DICT_LENGTH):
#         new_word = ""
#         for spell_key in SPELL_DICT:
#             new_word = word_lower.replace(spell_key, SPELL_DICT[spell_key][i])
#             word_lower = new_word
#         new_words.append(new_word)
#     result.update({w: new_words})
#
# from fuzzywuzzy import process, fuzz
# weight = 0
# match = ""
# for key in result:
#     # print(key)
#     name_to_check = "Namdin"
#     if name_to_check not in STANDARD_WORDS:
#         extraction = (process.extractOne(name_to_check, result[key], scorer=fuzz.ratio))
#         if extraction[1] > weight:
#             weight = extraction[1]
#             match = key
#     else:
#         match = name_to_check
#
# print(match)

# print(result)
