"""The color palette for the NES."""
import numpy as np


# NES palette
_rgb_codes = {
    '00': (116, 116, 116),
    '01': (36, 24, 140),
    '02': (0, 0, 168),
    '03': (68, 0, 156),
    '04': (140, 0, 116),
    '05': (168, 0, 16),
    '06': (164, 0, 0),
    '07': (124, 8, 0),
    '08': (64, 44, 0),
    '09': (0, 68, 0),
    '0A': (0, 80, 0),
    '0B': (0, 60, 20),
    '0C': (24, 60, 92),
    '0D': (0, 0, 0),
    '0E': (0, 0, 0),
    '0F': (0, 0, 0),
    '10': (188, 188, 188),
    '11': (0, 112, 236),
    '12': (32, 56, 236),
    '13': (128, 0, 240),
    '14': (188, 0, 188),
    '15': (228, 0, 88),
    '16': (216, 40, 0),
    '17': (200, 76, 12),
    '18': (136, 112, 0),
    '19': (0, 148, 0),
    '1A': (0, 168, 0),
    '1B': (0, 144, 56),
    '1C': (0, 128, 136),
    '1D': (0, 0, 0),
    '1E': (0, 0, 0),
    '1F': (0, 0, 0),
    '20': (252, 252, 252),
    '21': (60, 188, 252),
    '22': (92, 148, 252),
    '23': (204, 136, 252),
    '24': (244, 120, 252),
    '25': (252, 116, 180),
    '26': (252, 116, 96),
    '27': (252, 152, 56),
    '28': (240, 188, 60),
    '29': (128, 208, 16),
    '2A': (76, 220, 72),
    '2B': (88, 248, 152),
    '2C': (0, 232, 216),
    '2D': (120, 120, 120),
    '2E': (0, 0, 0),
    '2F': (0, 0, 0),
    '30': (252, 252, 252),
    '31': (168, 228, 252),
    '32': (196, 212, 252),
    '33': (212, 200, 252),
    '34': (252, 196, 252),
    '35': (252, 196, 216),
    '36': (252, 188, 176),
    '37': (252, 216, 168),
    '38': (252, 228, 160),
    '39': (224, 252, 160),
    '3A': (168, 240, 188),
    '3B': (176, 252, 204),
    '3C': (156, 252, 240),
    '3D': (196, 196, 196),
    '3E': (0, 0, 0),
    '3F': (0, 0, 0),
    '40': (87, 87, 87),
    '41': (27, 18, 105),
    '42': (0, 0, 126),
    '43': (51, 0, 117),
    '44': (105, 0, 87),
    '45': (126, 0, 12),
    '46': (123, 0, 0),
    '47': (93, 6, 0),
    '48': (48, 33, 0),
    '49': (0, 51, 0),
    '4A': (0, 60, 0),
    '4B': (0, 45, 15),
    '4C': (18, 45, 69),
    '4D': (0, 0, 0),
    '4E': (0, 0, 0),
    '4F': (0, 0, 0),
    '50': (141, 141, 141),
    '51': (0, 84, 177),
    '52': (24, 42, 177),
    '53': (96, 0, 180),
    '54': (141, 0, 141),
    '55': (171, 0, 66),
    '56': (162, 30, 0),
    '57': (150, 57, 9),
    '58': (102, 84, 0),
    '59': (0, 111, 0),
    '5A': (0, 126, 0),
    '5B': (0, 108, 42),
    '5C': (0, 96, 102),
    '5D': (0, 0, 0),
    '5E': (0, 0, 0),
    '5F': (0, 0, 0),
    '60': (189, 189, 189),
    '61': (45, 141, 189),
    '62': (69, 111, 189),
    '63': (153, 102, 189),
    '64': (183, 90, 189),
    '65': (189, 87, 135),
    '66': (189, 87, 72),
    '67': (189, 114, 42),
    '68': (180, 141, 45),
    '69': (96, 156, 12),
    '6A': (57, 165, 54),
    '6B': (66, 186, 114),
    '6C': (0, 174, 162),
    '6D': (90, 90, 90),
    '6E': (0, 0, 0),
    '6F': (0, 0, 0),
    '70': (189, 189, 189),
    '71': (126, 171, 189),
    '72': (147, 159, 189),
    '73': (159, 150, 189),
    '74': (189, 147, 189),
    '75': (189, 147, 162),
    '76': (189, 141, 132),
    '77': (189, 162, 126),
    '78': (189, 171, 120),
    '79': (168, 189, 120),
    '7A': (126, 180, 141),
    '7B': (132, 189, 153),
    '7C': (117, 189, 180),
    '7D': (147, 147, 147),
    '7E': (0, 0, 0),
    '7F': (0, 0, 0),
}


# Create an array from the palette data
PALETTE = np.array([_rgb_codes[key] for key in sorted(_rgb_codes.keys())])
