# Figure Scale's Documentation

```{centered} _Publication quality figures start here_
```

::::{grid} 1 1 2 2
:class-container: text-center
:gutter: 2

:::{grid-item-card}
:link: getting-started/about
:link-type: doc
:class-header: bg-light

Precise Figure Sizing 📐
^^^

Create publication-quality figures with exact dimensions in inches, millimeters, centimeters, points, and more.

:::

:::{grid-item-card}
:link: user-guide/figure-size
:link-type: doc
:class-header: bg-light

Easy Integration with Matplotlib 📊
^^^

Seamlessly integrates with Matplotlib's existing figure creation methods with minimal code changes.

:::

:::{grid-item-card}
:link: user-guide/unit-conversion
:link-type: doc
:class-header: bg-light

Multi-Unit Support 📏
^^^

Work with any measurement unit and easily add custom units for specialized requirements.

:::

:::{grid-item-card}
:link: getting-started/installation
:link-type: doc
:class-header: bg-light

Lightweight ⚡
^^^

Minimal dependencies - built only on top of Matplotlib.

:::

::::

This documentation is organized into a few major sections:

- **Getting Started** provides an overview of the project and how to install it.
- **User Guide** contains detailed tutorials on figure sizing and unit conversion.
- **Reference** section includes the [API references](references/api-reference.rst) and [How to Contribute](references/how-to-contribute.md) guides.
