"""
Default constant values across whole SDK
"""


# Text colors on terminal
class TerminalColor:
    BOLD = ""
    ENDC = ""
    FAIL = ""
    OK = ""
    WARN = ""


# Podonos homepage
PODONOS_HOME = "https://www.podonos.com/"

# Podonos docs API key
PODONOS_DOCS_API_KEY = "https://www.podonos.com/docs/apikey"

# API key environment variable
PODONOS_API_KEY = "PODONOS_API_KEY"

# Podonos Workspace
PODONOS_WORKSPACE = "https://workspace.podonos.com"

# Podonos API base URL
PODONOS_API_BASE_URL = "https://prod.podonosapi.com"

# Contact email
PODONOS_CONTACT_EMAIL = "hello@podonos.com"

CONTENT_TYPE_TO_EXTENSION = {
    "audio/mpeg": ".mp3",
    "audio/wav": ".wav",
    "audio/mp3": ".mp3",
    "audio/flac": ".flac",
    "audio/mp4": ".mp4",
}
