# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.16.2673
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.capacity_statistics_load import CapacityStatisticsLoad
from vrt_lss_studio.models.capacity_statistics_ratio import CapacityStatisticsRatio
from vrt_lss_studio.models.capacity_statistics_sum import CapacityStatisticsSum
from vrt_lss_studio.models.measurements import Measurements
from typing import Optional, Set
from typing_extensions import Self

class GeneralStatistics(BaseModel):
    """
    Summary statistics for one or a set of trips.
    """ # noqa: E501
    cost: Union[Annotated[float, Field(le=10000000000, strict=True, ge=0)], Annotated[int, Field(le=2147483647, strict=True, ge=0)]] = Field(description="Total cost calculated based on the performer's and transport tariffs. ")
    reward: Union[Annotated[float, Field(le=10000000000, strict=True, ge=0)], Annotated[int, Field(le=2147483647, strict=True, ge=0)]] = Field(description="The total reward for orders fulfillment.")
    profit: Union[Annotated[float, Field(le=10000000000, strict=True, ge=-10000000000)], Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]] = Field(description="The total profit is equal to the difference between the total reward (`reward`) and cost (`cost`). ")
    measurements: Measurements
    trips_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="The total number of planned trips.")
    performers_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="The total number of performers involved in orders fulfillment.")
    orders_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="The total number of planned and assigned orders.")
    plan_orders_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="The total number of planned orders.")
    waitlist_orders_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="The total number of assigned orders.")
    stops_count: Annotated[int, Field(le=15001000, strict=True, ge=0)] = Field(description="The total number of stops (non-unique locations).")
    locations_count: Annotated[int, Field(le=15001000, strict=True, ge=0)] = Field(description="The total number of unique locations within one trip. For general statistics - the sum of unique locations within each trip. ")
    cargo_capacity_sum: CapacityStatisticsSum
    cargo_capacity_ratio: CapacityStatisticsRatio
    max_transport_load: CapacityStatisticsLoad
    average_speed: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(description="Average speed is the ratio of the total distance to the total time of movement, km/h.")
    round_trips_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="Number of [roundtrips](#section/Description/Roundtrips) within a trip.")
    average_roundtrip_distance: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(description="Average mileage per roundtrip is the ratio of the total mileage per trip to the number of roundtrips, in meters.")
    average_roundtrip_time: Annotated[str, Field(min_length=3, strict=True, max_length=16)] = Field(description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).")
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Attributes. Used to add service information.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["cost", "reward", "profit", "measurements", "trips_count", "performers_count", "orders_count", "plan_orders_count", "waitlist_orders_count", "stops_count", "locations_count", "cargo_capacity_sum", "cargo_capacity_ratio", "max_transport_load", "average_speed", "round_trips_count", "average_roundtrip_distance", "average_roundtrip_time", "attributes"]

    @field_validator('average_roundtrip_time')
    def average_roundtrip_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GeneralStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of measurements
        if self.measurements:
            _dict['measurements'] = self.measurements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cargo_capacity_sum
        if self.cargo_capacity_sum:
            _dict['cargo_capacity_sum'] = self.cargo_capacity_sum.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cargo_capacity_ratio
        if self.cargo_capacity_ratio:
            _dict['cargo_capacity_ratio'] = self.cargo_capacity_ratio.to_dict()
        # override the default output from pydantic by calling `to_dict()` of max_transport_load
        if self.max_transport_load:
            _dict['max_transport_load'] = self.max_transport_load.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['attributes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GeneralStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cost": obj.get("cost"),
            "reward": obj.get("reward"),
            "profit": obj.get("profit"),
            "measurements": Measurements.from_dict(obj["measurements"]) if obj.get("measurements") is not None else None,
            "trips_count": obj.get("trips_count"),
            "performers_count": obj.get("performers_count"),
            "orders_count": obj.get("orders_count"),
            "plan_orders_count": obj.get("plan_orders_count"),
            "waitlist_orders_count": obj.get("waitlist_orders_count"),
            "stops_count": obj.get("stops_count"),
            "locations_count": obj.get("locations_count"),
            "cargo_capacity_sum": CapacityStatisticsSum.from_dict(obj["cargo_capacity_sum"]) if obj.get("cargo_capacity_sum") is not None else None,
            "cargo_capacity_ratio": CapacityStatisticsRatio.from_dict(obj["cargo_capacity_ratio"]) if obj.get("cargo_capacity_ratio") is not None else None,
            "max_transport_load": CapacityStatisticsLoad.from_dict(obj["max_transport_load"]) if obj.get("max_transport_load") is not None else None,
            "average_speed": obj.get("average_speed"),
            "round_trips_count": obj.get("round_trips_count"),
            "average_roundtrip_distance": obj.get("average_roundtrip_distance"),
            "average_roundtrip_time": obj.get("average_roundtrip_time") if obj.get("average_roundtrip_time") is not None else 'PT0S',
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


