# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBdsInstanceResourcePrincipalConfigurationsResult',
    'AwaitableGetBdsInstanceResourcePrincipalConfigurationsResult',
    'get_bds_instance_resource_principal_configurations',
    'get_bds_instance_resource_principal_configurations_output',
]

@pulumi.output_type
class GetBdsInstanceResourcePrincipalConfigurationsResult:
    """
    A collection of values returned by getBdsInstanceResourcePrincipalConfigurations.
    """
    def __init__(__self__, bds_instance_id=None, display_name=None, filters=None, id=None, resource_principal_configurations=None, state=None):
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_principal_configurations and not isinstance(resource_principal_configurations, list):
            raise TypeError("Expected argument 'resource_principal_configurations' to be a list")
        pulumi.set(__self__, "resource_principal_configurations", resource_principal_configurations)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> str:
        """
        The OCID of the bdsInstance which is the parent resource id.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBdsInstanceResourcePrincipalConfigurationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourcePrincipalConfigurations")
    def resource_principal_configurations(self) -> Sequence['outputs.GetBdsInstanceResourcePrincipalConfigurationsResourcePrincipalConfigurationResult']:
        """
        The list of resource_principal_configurations.
        """
        return pulumi.get(self, "resource_principal_configurations")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of the ResourcePrincipalConfiguration.
        """
        return pulumi.get(self, "state")


class AwaitableGetBdsInstanceResourcePrincipalConfigurationsResult(GetBdsInstanceResourcePrincipalConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceResourcePrincipalConfigurationsResult(
            bds_instance_id=self.bds_instance_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            resource_principal_configurations=self.resource_principal_configurations,
            state=self.state)


def get_bds_instance_resource_principal_configurations(bds_instance_id: Optional[str] = None,
                                                       display_name: Optional[str] = None,
                                                       filters: Optional[Sequence[Union['GetBdsInstanceResourcePrincipalConfigurationsFilterArgs', 'GetBdsInstanceResourcePrincipalConfigurationsFilterArgsDict']]] = None,
                                                       state: Optional[str] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceResourcePrincipalConfigurationsResult:
    """
    This data source provides the list of Bds Instance Resource Principal Configurations in Oracle Cloud Infrastructure Big Data Service service.

    Returns information about the ResourcePrincipalConfiguration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_resource_principal_configurations = oci.BigDataService.get_bds_instance_resource_principal_configurations(bds_instance_id=test_bds_instance["id"],
        display_name=bds_instance_resource_principal_configuration_display_name,
        state=bds_instance_resource_principal_configuration_state)
    ```


    :param str bds_instance_id: The OCID of the cluster.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: The state of the ResourcePrincipalConfiguration.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceResourcePrincipalConfigurations:getBdsInstanceResourcePrincipalConfigurations', __args__, opts=opts, typ=GetBdsInstanceResourcePrincipalConfigurationsResult).value

    return AwaitableGetBdsInstanceResourcePrincipalConfigurationsResult(
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_principal_configurations=pulumi.get(__ret__, 'resource_principal_configurations'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_bds_instance_resource_principal_configurations)
def get_bds_instance_resource_principal_configurations_output(bds_instance_id: Optional[pulumi.Input[str]] = None,
                                                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBdsInstanceResourcePrincipalConfigurationsFilterArgs', 'GetBdsInstanceResourcePrincipalConfigurationsFilterArgsDict']]]]] = None,
                                                              state: Optional[pulumi.Input[Optional[str]]] = None,
                                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBdsInstanceResourcePrincipalConfigurationsResult]:
    """
    This data source provides the list of Bds Instance Resource Principal Configurations in Oracle Cloud Infrastructure Big Data Service service.

    Returns information about the ResourcePrincipalConfiguration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_resource_principal_configurations = oci.BigDataService.get_bds_instance_resource_principal_configurations(bds_instance_id=test_bds_instance["id"],
        display_name=bds_instance_resource_principal_configuration_display_name,
        state=bds_instance_resource_principal_configuration_state)
    ```


    :param str bds_instance_id: The OCID of the cluster.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: The state of the ResourcePrincipalConfiguration.
    """
    ...
