# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OccAvailabilityCatalogArgs', 'OccAvailabilityCatalog']

@pulumi.input_type
class OccAvailabilityCatalogArgs:
    def __init__(__self__, *,
                 base64encoded_catalog_details: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 occ_customer_group_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_details: Optional[pulumi.Input['OccAvailabilityCatalogMetadataDetailsArgs']] = None):
        """
        The set of arguments for constructing a OccAvailabilityCatalog resource.
        :param pulumi.Input[str] base64encoded_catalog_details: The base 64 encoded string corresponding to the catalog file contents.
        :param pulumi.Input[str] compartment_id: Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the availability catalog.
        :param pulumi.Input[str] namespace: The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        :param pulumi.Input[str] occ_customer_group_id: The OCID of the customer group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Additional information about the availability catalog.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['OccAvailabilityCatalogMetadataDetailsArgs'] metadata_details: Used for representing the metadata of the catalog. This denotes the version and format of the CSV file for parsing.
        """
        pulumi.set(__self__, "base64encoded_catalog_details", base64encoded_catalog_details)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if metadata_details is not None:
            pulumi.set(__self__, "metadata_details", metadata_details)

    @property
    @pulumi.getter(name="base64encodedCatalogDetails")
    def base64encoded_catalog_details(self) -> pulumi.Input[str]:
        """
        The base 64 encoded string corresponding to the catalog file contents.
        """
        return pulumi.get(self, "base64encoded_catalog_details")

    @base64encoded_catalog_details.setter
    def base64encoded_catalog_details(self, value: pulumi.Input[str]):
        pulumi.set(self, "base64encoded_catalog_details", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The display name of the availability catalog.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> pulumi.Input[str]:
        """
        The OCID of the customer group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "occ_customer_group_id")

    @occ_customer_group_id.setter
    def occ_customer_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "occ_customer_group_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Additional information about the availability catalog.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="metadataDetails")
    def metadata_details(self) -> Optional[pulumi.Input['OccAvailabilityCatalogMetadataDetailsArgs']]:
        """
        Used for representing the metadata of the catalog. This denotes the version and format of the CSV file for parsing.
        """
        return pulumi.get(self, "metadata_details")

    @metadata_details.setter
    def metadata_details(self, value: Optional[pulumi.Input['OccAvailabilityCatalogMetadataDetailsArgs']]):
        pulumi.set(self, "metadata_details", value)


@pulumi.input_type
class _OccAvailabilityCatalogState:
    def __init__(__self__, *,
                 base64encoded_catalog_details: Optional[pulumi.Input[str]] = None,
                 catalog_state: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['OccAvailabilityCatalogDetailArgs']]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 metadata_details: Optional[pulumi.Input['OccAvailabilityCatalogMetadataDetailsArgs']] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 occ_customer_group_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OccAvailabilityCatalog resources.
        :param pulumi.Input[str] base64encoded_catalog_details: The base 64 encoded string corresponding to the catalog file contents.
        :param pulumi.Input[str] catalog_state: The different states associated with the availability catalog.
        :param pulumi.Input[str] compartment_id: Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Additional information about the availability catalog.
        :param pulumi.Input[Sequence[pulumi.Input['OccAvailabilityCatalogDetailArgs']]] details: Details about capacity available for different resources in catalog.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the availability catalog.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        :param pulumi.Input['OccAvailabilityCatalogMetadataDetailsArgs'] metadata_details: Used for representing the metadata of the catalog. This denotes the version and format of the CSV file for parsing.
        :param pulumi.Input[str] namespace: The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        :param pulumi.Input[str] occ_customer_group_id: The OCID of the customer group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current lifecycle state of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time when the availability catalog was created.
        :param pulumi.Input[str] time_updated: The time when the availability catalog was last updated.
        """
        if base64encoded_catalog_details is not None:
            pulumi.set(__self__, "base64encoded_catalog_details", base64encoded_catalog_details)
        if catalog_state is not None:
            pulumi.set(__self__, "catalog_state", catalog_state)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if metadata_details is not None:
            pulumi.set(__self__, "metadata_details", metadata_details)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if occ_customer_group_id is not None:
            pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="base64encodedCatalogDetails")
    def base64encoded_catalog_details(self) -> Optional[pulumi.Input[str]]:
        """
        The base 64 encoded string corresponding to the catalog file contents.
        """
        return pulumi.get(self, "base64encoded_catalog_details")

    @base64encoded_catalog_details.setter
    def base64encoded_catalog_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base64encoded_catalog_details", value)

    @property
    @pulumi.getter(name="catalogState")
    def catalog_state(self) -> Optional[pulumi.Input[str]]:
        """
        The different states associated with the availability catalog.
        """
        return pulumi.get(self, "catalog_state")

    @catalog_state.setter
    def catalog_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_state", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Additional information about the availability catalog.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OccAvailabilityCatalogDetailArgs']]]]:
        """
        Details about capacity available for different resources in catalog.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OccAvailabilityCatalogDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the availability catalog.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="metadataDetails")
    def metadata_details(self) -> Optional[pulumi.Input['OccAvailabilityCatalogMetadataDetailsArgs']]:
        """
        Used for representing the metadata of the catalog. This denotes the version and format of the CSV file for parsing.
        """
        return pulumi.get(self, "metadata_details")

    @metadata_details.setter
    def metadata_details(self, value: Optional[pulumi.Input['OccAvailabilityCatalogMetadataDetailsArgs']]):
        pulumi.set(self, "metadata_details", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the customer group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "occ_customer_group_id")

    @occ_customer_group_id.setter
    def occ_customer_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "occ_customer_group_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the availability catalog was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the availability catalog was last updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class OccAvailabilityCatalog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base64encoded_catalog_details: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_details: Optional[pulumi.Input[Union['OccAvailabilityCatalogMetadataDetailsArgs', 'OccAvailabilityCatalogMetadataDetailsArgsDict']]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 occ_customer_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Occ Availability Catalog resource in Oracle Cloud Infrastructure Capacity Management service.

        Create availability catalog

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_occ_availability_catalog = oci.capacity_management.OccAvailabilityCatalog("test_occ_availability_catalog",
            base64encoded_catalog_details=occ_availability_catalog_base64encoded_catalog_details,
            compartment_id=compartment_id,
            display_name=occ_availability_catalog_display_name,
            namespace=occ_availability_catalog_namespace,
            occ_customer_group_id=test_occ_customer_group["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=occ_availability_catalog_description,
            freeform_tags={
                "bar-key": "value",
            },
            metadata_details={
                "format_version": occ_availability_catalog_metadata_details_format_version,
            })
        ```

        ## Import

        OccAvailabilityCatalogs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CapacityManagement/occAvailabilityCatalog:OccAvailabilityCatalog test_occ_availability_catalog "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base64encoded_catalog_details: The base 64 encoded string corresponding to the catalog file contents.
        :param pulumi.Input[str] compartment_id: Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Additional information about the availability catalog.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the availability catalog.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['OccAvailabilityCatalogMetadataDetailsArgs', 'OccAvailabilityCatalogMetadataDetailsArgsDict']] metadata_details: Used for representing the metadata of the catalog. This denotes the version and format of the CSV file for parsing.
        :param pulumi.Input[str] namespace: The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        :param pulumi.Input[str] occ_customer_group_id: The OCID of the customer group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OccAvailabilityCatalogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Occ Availability Catalog resource in Oracle Cloud Infrastructure Capacity Management service.

        Create availability catalog

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_occ_availability_catalog = oci.capacity_management.OccAvailabilityCatalog("test_occ_availability_catalog",
            base64encoded_catalog_details=occ_availability_catalog_base64encoded_catalog_details,
            compartment_id=compartment_id,
            display_name=occ_availability_catalog_display_name,
            namespace=occ_availability_catalog_namespace,
            occ_customer_group_id=test_occ_customer_group["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=occ_availability_catalog_description,
            freeform_tags={
                "bar-key": "value",
            },
            metadata_details={
                "format_version": occ_availability_catalog_metadata_details_format_version,
            })
        ```

        ## Import

        OccAvailabilityCatalogs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CapacityManagement/occAvailabilityCatalog:OccAvailabilityCatalog test_occ_availability_catalog "id"
        ```

        :param str resource_name: The name of the resource.
        :param OccAvailabilityCatalogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OccAvailabilityCatalogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base64encoded_catalog_details: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_details: Optional[pulumi.Input[Union['OccAvailabilityCatalogMetadataDetailsArgs', 'OccAvailabilityCatalogMetadataDetailsArgsDict']]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 occ_customer_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OccAvailabilityCatalogArgs.__new__(OccAvailabilityCatalogArgs)

            if base64encoded_catalog_details is None and not opts.urn:
                raise TypeError("Missing required property 'base64encoded_catalog_details'")
            __props__.__dict__["base64encoded_catalog_details"] = base64encoded_catalog_details
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["metadata_details"] = metadata_details
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if occ_customer_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'occ_customer_group_id'")
            __props__.__dict__["occ_customer_group_id"] = occ_customer_group_id
            __props__.__dict__["catalog_state"] = None
            __props__.__dict__["details"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(OccAvailabilityCatalog, __self__).__init__(
            'oci:CapacityManagement/occAvailabilityCatalog:OccAvailabilityCatalog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base64encoded_catalog_details: Optional[pulumi.Input[str]] = None,
            catalog_state: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccAvailabilityCatalogDetailArgs', 'OccAvailabilityCatalogDetailArgsDict']]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            metadata_details: Optional[pulumi.Input[Union['OccAvailabilityCatalogMetadataDetailsArgs', 'OccAvailabilityCatalogMetadataDetailsArgsDict']]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            occ_customer_group_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'OccAvailabilityCatalog':
        """
        Get an existing OccAvailabilityCatalog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base64encoded_catalog_details: The base 64 encoded string corresponding to the catalog file contents.
        :param pulumi.Input[str] catalog_state: The different states associated with the availability catalog.
        :param pulumi.Input[str] compartment_id: Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Additional information about the availability catalog.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OccAvailabilityCatalogDetailArgs', 'OccAvailabilityCatalogDetailArgsDict']]]] details: Details about capacity available for different resources in catalog.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the availability catalog.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        :param pulumi.Input[Union['OccAvailabilityCatalogMetadataDetailsArgs', 'OccAvailabilityCatalogMetadataDetailsArgsDict']] metadata_details: Used for representing the metadata of the catalog. This denotes the version and format of the CSV file for parsing.
        :param pulumi.Input[str] namespace: The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        :param pulumi.Input[str] occ_customer_group_id: The OCID of the customer group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current lifecycle state of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time when the availability catalog was created.
        :param pulumi.Input[str] time_updated: The time when the availability catalog was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OccAvailabilityCatalogState.__new__(_OccAvailabilityCatalogState)

        __props__.__dict__["base64encoded_catalog_details"] = base64encoded_catalog_details
        __props__.__dict__["catalog_state"] = catalog_state
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["details"] = details
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["metadata_details"] = metadata_details
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["occ_customer_group_id"] = occ_customer_group_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return OccAvailabilityCatalog(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="base64encodedCatalogDetails")
    def base64encoded_catalog_details(self) -> pulumi.Output[str]:
        """
        The base 64 encoded string corresponding to the catalog file contents.
        """
        return pulumi.get(self, "base64encoded_catalog_details")

    @property
    @pulumi.getter(name="catalogState")
    def catalog_state(self) -> pulumi.Output[str]:
        """
        The different states associated with the availability catalog.
        """
        return pulumi.get(self, "catalog_state")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Additional information about the availability catalog.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def details(self) -> pulumi.Output[Sequence['outputs.OccAvailabilityCatalogDetail']]:
        """
        Details about capacity available for different resources in catalog.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the availability catalog.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="metadataDetails")
    def metadata_details(self) -> pulumi.Output['outputs.OccAvailabilityCatalogMetadataDetails']:
        """
        Used for representing the metadata of the catalog. This denotes the version and format of the CSV file for parsing.
        """
        return pulumi.get(self, "metadata_details")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> pulumi.Output[str]:
        """
        The OCID of the customer group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "occ_customer_group_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when the availability catalog was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time when the availability catalog was last updated.
        """
        return pulumi.get(self, "time_updated")

