# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetPathAnalyzerTestResult',
    'AwaitableGetPathAnalyzerTestResult',
    'get_path_analyzer_test',
    'get_path_analyzer_test_output',
]

@pulumi.output_type
class GetPathAnalyzerTestResult:
    """
    A collection of values returned by GetPathAnalyzerTest.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, destination_endpoints=None, display_name=None, freeform_tags=None, id=None, path_analyzer_test_id=None, protocol=None, protocol_parameters=None, query_options=None, source_endpoints=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if destination_endpoints and not isinstance(destination_endpoints, list):
            raise TypeError("Expected argument 'destination_endpoints' to be a list")
        pulumi.set(__self__, "destination_endpoints", destination_endpoints)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if path_analyzer_test_id and not isinstance(path_analyzer_test_id, str):
            raise TypeError("Expected argument 'path_analyzer_test_id' to be a str")
        pulumi.set(__self__, "path_analyzer_test_id", path_analyzer_test_id)
        if protocol and not isinstance(protocol, int):
            raise TypeError("Expected argument 'protocol' to be a int")
        pulumi.set(__self__, "protocol", protocol)
        if protocol_parameters and not isinstance(protocol_parameters, list):
            raise TypeError("Expected argument 'protocol_parameters' to be a list")
        pulumi.set(__self__, "protocol_parameters", protocol_parameters)
        if query_options and not isinstance(query_options, list):
            raise TypeError("Expected argument 'query_options' to be a list")
        pulumi.set(__self__, "query_options", query_options)
        if source_endpoints and not isinstance(source_endpoints, list):
            raise TypeError("Expected argument 'source_endpoints' to be a list")
        pulumi.set(__self__, "source_endpoints", source_endpoints)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PathAnalyzerTest` resource's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="destinationEndpoints")
    def destination_endpoints(self) -> Sequence['outputs.GetPathAnalyzerTestDestinationEndpointResult']:
        """
        Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_endpoints")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique identifier established when the resource is created. The identifier can't be changed later.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="pathAnalyzerTestId")
    def path_analyzer_test_id(self) -> str:
        return pulumi.get(self, "path_analyzer_test_id")

    @property
    @pulumi.getter
    def protocol(self) -> int:
        """
        The IP protocol to use for the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> Sequence['outputs.GetPathAnalyzerTestProtocolParameterResult']:
        """
        Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol_parameters")

    @property
    @pulumi.getter(name="queryOptions")
    def query_options(self) -> Sequence['outputs.GetPathAnalyzerTestQueryOptionResult']:
        """
        Defines the query options required for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "query_options")

    @property
    @pulumi.getter(name="sourceEndpoints")
    def source_endpoints(self) -> Sequence['outputs.GetPathAnalyzerTestSourceEndpointResult']:
        """
        Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_endpoints")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetPathAnalyzerTestResult(GetPathAnalyzerTestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPathAnalyzerTestResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            destination_endpoints=self.destination_endpoints,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            path_analyzer_test_id=self.path_analyzer_test_id,
            protocol=self.protocol,
            protocol_parameters=self.protocol_parameters,
            query_options=self.query_options,
            source_endpoints=self.source_endpoints,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_path_analyzer_test(path_analyzer_test_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPathAnalyzerTestResult:
    """
    This data source provides details about a specific Path Analyzer Test resource in Oracle Cloud Infrastructure Vn Monitoring service.

    Gets a `PathAnalyzerTest` using its identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_path_analyzer_test = oci.VnMonitoring.get_path_analyzer_test(path_analyzer_test_id=test_path_analyzer_test_oci_vn_monitoring_path_analyzer_test["id"])
    ```


    :param str path_analyzer_test_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PathAnalyzerTest` resource.
    """
    __args__ = dict()
    __args__['pathAnalyzerTestId'] = path_analyzer_test_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VnMonitoring/getPathAnalyzerTest:GetPathAnalyzerTest', __args__, opts=opts, typ=GetPathAnalyzerTestResult).value

    return AwaitableGetPathAnalyzerTestResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        destination_endpoints=pulumi.get(__ret__, 'destination_endpoints'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        path_analyzer_test_id=pulumi.get(__ret__, 'path_analyzer_test_id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        protocol_parameters=pulumi.get(__ret__, 'protocol_parameters'),
        query_options=pulumi.get(__ret__, 'query_options'),
        source_endpoints=pulumi.get(__ret__, 'source_endpoints'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_path_analyzer_test)
def get_path_analyzer_test_output(path_analyzer_test_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPathAnalyzerTestResult]:
    """
    This data source provides details about a specific Path Analyzer Test resource in Oracle Cloud Infrastructure Vn Monitoring service.

    Gets a `PathAnalyzerTest` using its identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_path_analyzer_test = oci.VnMonitoring.get_path_analyzer_test(path_analyzer_test_id=test_path_analyzer_test_oci_vn_monitoring_path_analyzer_test["id"])
    ```


    :param str path_analyzer_test_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PathAnalyzerTest` resource.
    """
    ...
